/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reference;

import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefClassImpl;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefField;
import com.intellij.codeInspection.reference.RefJavaElementImpl;
import com.intellij.codeInspection.reference.RefJavaUtil;
import com.intellij.codeInspection.reference.RefJavaVisitor;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefUtil;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefFieldImpl
extends RefJavaElementImpl
implements RefField {
    private static final int USED_FOR_READING_MASK = 65536;
    private static final int USED_FOR_WRITING_MASK = 131072;
    private static final int ASSIGNED_ONLY_IN_INITIALIZER_MASK = 262144;

    RefFieldImpl(@NotNull RefClass ownerClass, PsiField field, RefManager manager) {
        if (ownerClass == null) {
            RefFieldImpl.$$$reportNull$$$0(0);
        }
        super(field, manager);
        ((RefClassImpl)ownerClass).add(this);
        if (ownerClass.isInterface()) {
            this.setIsStatic(true);
            this.setIsFinal(true);
        }
        if (field instanceof PsiEnumConstant) {
            this.putUserData(ENUM_CONSTANT, (Object)true);
        }
    }

    @Override
    public PsiField getElement() {
        return (PsiField)super.getElement();
    }

    @Override
    protected void markReferenced(RefElementImpl refFrom, PsiElement psiFrom, PsiElement psiWhat, boolean forWriting, boolean forReading, PsiReferenceExpression expressionFrom) {
        PsiExpression qualifierExpression;
        PsiClassInitializer initializer2;
        this.addInReference(refFrom);
        boolean referencedFromClassInitializer = false;
        if (forWriting && expressionFrom != null && (initializer2 = PsiTreeUtil.getParentOfType((PsiElement)expressionFrom, PsiClassInitializer.class)) != null && initializer2.getParent() instanceof PsiClass && psiFrom == initializer2.getParent() && ((qualifierExpression = expressionFrom.getQualifierExpression()) == null || qualifierExpression instanceof PsiThisExpression && ((PsiThisExpression)qualifierExpression).getQualifier() == null)) {
            referencedFromClassInitializer = true;
        }
        if (forWriting) {
            this.setUsedForWriting(true);
        }
        if (forReading) {
            this.setUsedForReading(true);
        }
        this.setUsedQualifiedOutsidePackageFlag(refFrom, expressionFrom);
        this.getRefManager().fireNodeMarkedReferenced(this, refFrom, referencedFromClassInitializer, forReading, forWriting);
    }

    @Override
    public boolean isUsedForReading() {
        return this.checkFlag(65536L);
    }

    private void setUsedForReading(boolean usedForReading) {
        this.setFlag(usedForReading, 65536L);
    }

    @Override
    public boolean isUsedForWriting() {
        return this.checkFlag(131072L);
    }

    private void setUsedForWriting(boolean usedForWriting) {
        this.setFlag(false, 262144L);
        this.setFlag(usedForWriting, 131072L);
    }

    @Override
    public boolean isOnlyAssignedInInitializer() {
        return this.checkFlag(262144L);
    }

    @Override
    public void accept(@NotNull RefVisitor visitor2) {
        if (visitor2 == null) {
            RefFieldImpl.$$$reportNull$$$0(1);
        }
        if (visitor2 instanceof RefJavaVisitor) {
            ApplicationManager.getApplication().runReadAction(() -> {
                if (visitor2 == null) {
                    RefFieldImpl.$$$reportNull$$$0(2);
                }
                ((RefJavaVisitor)visitor2).visitField(this);
            });
        } else {
            super.accept(visitor2);
        }
    }

    @Override
    public void buildReferences() {
        PsiField psiField = this.getElement();
        if (psiField != null) {
            RefJavaUtil refUtil = RefJavaUtil.getInstance();
            refUtil.addReferences(psiField, this, psiField.getInitializer());
            refUtil.addReferences(psiField, this, psiField.getModifierList());
            if (psiField instanceof PsiEnumConstant) {
                refUtil.addReferences(psiField, this, psiField);
            }
            if ((psiField.getInitializer() != null || psiField instanceof PsiEnumConstant || RefUtil.isImplicitWrite(psiField)) && !this.checkFlag(131072L)) {
                this.setFlag(true, 262144L);
                this.setFlag(true, 131072L);
            }
            refUtil.addTypeReference(psiField, psiField.getType(), this.getRefManager(), this);
            this.getRefManager().fireBuildReferences(this);
        }
    }

    @Override
    public RefClass getOwnerClass() {
        return (RefClass)this.getOwner();
    }

    @Override
    public String getExternalName() {
        return ReadAction.compute(() -> {
            PsiField psiField = this.getElement();
            return psiField != null ? PsiFormatUtil.getExternalName(psiField) : null;
        });
    }

    @Nullable
    static RefField fieldFromExternalName(RefManager manager, String externalName) {
        return (RefField)manager.getReference(RefFieldImpl.findPsiField(PsiManager.getInstance(manager.getProject()), externalName));
    }

    @Nullable
    public static PsiField findPsiField(PsiManager manager, String externalName) {
        String className2;
        PsiClass psiClass;
        int classNameDelimiter = externalName.lastIndexOf(32);
        if (classNameDelimiter > 0 && classNameDelimiter < externalName.length() - 1 && (psiClass = ClassUtil.findPsiClass(manager, className2 = externalName.substring(0, classNameDelimiter))) != null) {
            String fieldName = externalName.substring(classNameDelimiter + 1);
            return psiClass.findFieldByName(fieldName, false);
        }
        return null;
    }

    @Override
    public boolean isSuspicious() {
        if (this.isEntry()) {
            return false;
        }
        return super.isSuspicious() || this.isUsedForReading() != this.isUsedForWriting();
    }

    @Override
    protected void initialize() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ownerClass";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/reference/RefFieldImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "accept";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$accept$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

