/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reference;

import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.deadCode.UnusedDeclarationInspectionBase;
import com.intellij.codeInspection.ex.EntryPointsManager;
import com.intellij.codeInspection.ex.EntryPointsManagerBase;
import com.intellij.codeInspection.ex.GlobalInspectionContextBase;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefClassImpl;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefField;
import com.intellij.codeInspection.reference.RefFieldImpl;
import com.intellij.codeInspection.reference.RefFile;
import com.intellij.codeInspection.reference.RefImplicitConstructor;
import com.intellij.codeInspection.reference.RefJavaFileImpl;
import com.intellij.codeInspection.reference.RefJavaManager;
import com.intellij.codeInspection.reference.RefJavaModule;
import com.intellij.codeInspection.reference.RefJavaModuleImpl;
import com.intellij.codeInspection.reference.RefJavaUtil;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefManagerImpl;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefMethodImpl;
import com.intellij.codeInspection.reference.RefPackage;
import com.intellij.codeInspection.reference.RefPackageImpl;
import com.intellij.codeInspection.reference.RefParameter;
import com.intellij.codeInspection.reference.RefParameterImpl;
import com.intellij.codeInspection.reference.RefProjectImpl;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import gnu.trove.THashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JButton;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefJavaManagerImpl
extends RefJavaManager {
    private static final Condition<PsiElement> PROBLEM_ELEMENT_CONDITION = Conditions.and(Conditions.instanceOf(PsiFile.class, PsiClass.class, PsiMethod.class, PsiField.class), Conditions.notInstanceOf(PsiTypeParameter.class));
    private static final Logger LOG = Logger.getInstance(RefJavaManagerImpl.class);
    private final PsiMethod myAppMainPattern;
    private final PsiMethod myAppPremainPattern;
    private final PsiMethod myAppAgentmainPattern;
    private final PsiClass myApplet;
    private final PsiClass myServlet;
    private volatile RefPackage myCachedDefaultPackage;
    private Map<String, RefPackage> myPackages;
    private final RefManagerImpl myRefManager;
    private PsiElementVisitor myProjectIterator;
    private EntryPointsManager myEntryPointsManager;

    public RefJavaManagerImpl(@NotNull RefManagerImpl manager) {
        if (manager == null) {
            RefJavaManagerImpl.$$$reportNull$$$0(0);
        }
        this.myRefManager = manager;
        Project project = manager.getProject();
        PsiManager psiManager = PsiManager.getInstance(project);
        PsiElementFactory factory2 = JavaPsiFacade.getInstance(psiManager.getProject()).getElementFactory();
        this.myAppMainPattern = factory2.createMethodFromText("void main(String[] args);", null);
        this.myAppPremainPattern = factory2.createMethodFromText("void premain(String[] args, java.lang.instrument.Instrumentation i);", null);
        this.myAppAgentmainPattern = factory2.createMethodFromText("void agentmain(String[] args, java.lang.instrument.Instrumentation i);", null);
        this.myApplet = JavaPsiFacade.getInstance(psiManager.getProject()).findClass("java.applet.Applet", GlobalSearchScope.allScope(project));
        this.myServlet = JavaPsiFacade.getInstance(psiManager.getProject()).findClass("javax.servlet.Servlet", GlobalSearchScope.allScope(project));
    }

    @Override
    public RefImplicitConstructor getImplicitConstructor(String classFQName) {
        RefEntity entity = this.getReference("class", classFQName);
        if (entity == null) {
            return null;
        }
        RefClass refClass = (RefClass)entity;
        return (RefImplicitConstructor)refClass.getDefaultConstructor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RefPackage getPackage(String packageName) {
        RefPackage refPackage;
        RefJavaManagerImpl refJavaManagerImpl = this;
        synchronized (refJavaManagerImpl) {
            if (this.myPackages == null) {
                this.myPackages = new THashMap<String, RefPackage>();
            }
            refPackage = this.myPackages.get(packageName);
        }
        if (refPackage == null) {
            boolean saved;
            refPackage = new RefPackageImpl(packageName, this.myRefManager);
            RefJavaManagerImpl refJavaManagerImpl2 = this;
            synchronized (refJavaManagerImpl2) {
                RefPackage oldPackage = this.myPackages.get(packageName);
                if (oldPackage == null) {
                    this.myPackages.put(packageName, refPackage);
                    saved = true;
                } else {
                    refPackage = oldPackage;
                    saved = false;
                }
            }
            if (saved) {
                int dotIndex = packageName.lastIndexOf(46);
                if (dotIndex >= 0) {
                    ((RefPackageImpl)this.getPackage(packageName.substring(0, dotIndex))).add(refPackage);
                } else {
                    ((RefProjectImpl)this.myRefManager.getRefProject()).add(refPackage);
                }
            }
        }
        return refPackage;
    }

    private boolean isEntryPoint(RefElement element) {
        UnusedDeclarationInspectionBase tool = this.getDeadCodeTool(element);
        return tool != null && tool.isEntryPoint(element) && RefJavaManagerImpl.isTestSource(tool, element);
    }

    private static boolean isTestSource(UnusedDeclarationInspectionBase tool, RefElement refElement) {
        if (tool.isTestEntryPoints()) {
            return true;
        }
        PsiElement element = refElement.getElement();
        VirtualFile file2 = PsiUtilCore.getVirtualFile(element);
        return file2 != null && !ProjectRootManager.getInstance(element.getProject()).getFileIndex().isInTestSourceContent(file2);
    }

    @Nullable
    private UnusedDeclarationInspectionBase getDeadCodeTool(RefElement element) {
        PsiFile file2 = ((RefElementImpl)element).getContainingFile();
        if (file2 == null) {
            return null;
        }
        return this.getDeadCodeTool(file2.getContainingFile());
    }

    private UnusedDeclarationInspectionBase getDeadCodeTool(PsiFile file2) {
        InspectionToolWrapper toolWrapper;
        GlobalInspectionContextBase contextBase = (GlobalInspectionContextBase)this.myRefManager.getContext();
        Tools tools = contextBase.getTools().get("unused");
        if (tools != null) {
            toolWrapper = tools.getEnabledTool(file2);
        } else {
            String singleTool = contextBase.getCurrentProfile().getSingleTool();
            if (singleTool != null && !"unused".equals(singleTool)) {
                InspectionProfileImpl currentProfile = InspectionProjectProfileManager.getInstance(this.myRefManager.getProject()).getCurrentProfile();
                tools = currentProfile.getTools("unused", this.myRefManager.getProject());
                toolWrapper = tools.getEnabledTool(file2);
            } else {
                return null;
            }
        }
        Object tool = toolWrapper == null ? null : toolWrapper.getTool();
        return tool instanceof UnusedDeclarationInspectionBase ? (UnusedDeclarationInspectionBase)tool : null;
    }

    @Override
    public RefPackage getDefaultPackage() {
        RefPackage defaultPackage = this.myCachedDefaultPackage;
        if (defaultPackage == null) {
            this.myCachedDefaultPackage = defaultPackage = this.getPackage(InspectionsBundle.message("inspection.reference.default.package", new Object[0]));
        }
        return defaultPackage;
    }

    @Override
    public PsiMethod getAppMainPattern() {
        return this.myAppMainPattern;
    }

    @Override
    public PsiMethod getAppPremainPattern() {
        return this.myAppPremainPattern;
    }

    @Override
    public PsiMethod getAppAgentmainPattern() {
        return this.myAppAgentmainPattern;
    }

    @Override
    public PsiClass getApplet() {
        return this.myApplet;
    }

    @Override
    public PsiClass getServlet() {
        return this.myServlet;
    }

    @Override
    public RefParameter getParameterReference(PsiParameter param2, int index2) {
        LOG.assertTrue(this.myRefManager.isValidPointForReference(), "References may become invalid after process is finished");
        return this.myRefManager.getFromRefTableOrCache(param2, () -> {
            RefParameterImpl ref = new RefParameterImpl(param2, index2, (RefManager)this.myRefManager);
            ref.initialize();
            return ref;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void iterate(@NotNull RefVisitor visitor2) {
        Map<String, RefPackage> packages2;
        if (visitor2 == null) {
            RefJavaManagerImpl.$$$reportNull$$$0(1);
        }
        Iterator<RefElement> iterator2 = this;
        synchronized (iterator2) {
            packages2 = this.myPackages;
        }
        if (packages2 != null) {
            for (RefPackage refPackage : packages2.values()) {
                refPackage.accept(visitor2);
            }
        }
        for (RefElement refElement : this.myRefManager.getSortedElements()) {
            RefClass refClass;
            RefMethod refDefaultConstructor;
            if (!(refElement instanceof RefClass) || !((refDefaultConstructor = (refClass = (RefClass)refElement).getDefaultConstructor()) instanceof RefImplicitConstructor)) continue;
            refClass.getDefaultConstructor().accept(visitor2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanup() {
        if (this.myEntryPointsManager != null) {
            Disposer.dispose(this.myEntryPointsManager);
            this.myEntryPointsManager = null;
        }
        RefJavaManagerImpl refJavaManagerImpl = this;
        synchronized (refJavaManagerImpl) {
            this.myPackages = null;
            this.myCachedDefaultPackage = null;
        }
        this.myProjectIterator = null;
    }

    @Override
    public void removeReference(@NotNull RefElement refElement) {
        if (refElement == null) {
            RefJavaManagerImpl.$$$reportNull$$$0(2);
        }
    }

    @Override
    @Nullable
    public RefElement createRefElement(PsiElement elem) {
        if (elem instanceof PsiClass) {
            return new RefClassImpl((PsiClass)elem, (RefManager)this.myRefManager);
        }
        if (elem instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)elem;
            RefElement ref = this.myRefManager.getReference(method.getContainingClass(), true);
            if (ref instanceof RefClass) {
                return new RefMethodImpl((RefClass)ref, method, (RefManager)this.myRefManager);
            }
        } else if (elem instanceof PsiField) {
            PsiField field = (PsiField)elem;
            RefElement ref = this.myRefManager.getReference(field.getContainingClass(), true);
            if (ref instanceof RefClass) {
                return new RefFieldImpl((RefClass)ref, field, (RefManager)this.myRefManager);
            }
        } else {
            if (elem instanceof PsiJavaFile) {
                return new RefJavaFileImpl((PsiJavaFile)elem, (RefManager)this.myRefManager);
            }
            if (elem instanceof PsiJavaModule) {
                return new RefJavaModuleImpl((PsiJavaModule)elem, this.myRefManager);
            }
        }
        return null;
    }

    @Override
    @Nullable
    public PsiNamedElement getElementContainer(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            RefJavaManagerImpl.$$$reportNull$$$0(3);
        }
        return (PsiNamedElement)PsiTreeUtil.findFirstParent(psiElement, PROBLEM_ELEMENT_CONDITION);
    }

    @Override
    @Nullable
    public RefEntity getReference(String type2, String fqName2) {
        if ("implicit.constructor".equals(type2)) {
            return this.getImplicitConstructor(fqName2);
        }
        if ("method".equals(type2)) {
            return RefMethodImpl.methodFromExternalName(this.myRefManager, fqName2);
        }
        if ("class".equals(type2)) {
            return RefClassImpl.classFromExternalName(this.myRefManager, fqName2);
        }
        if ("field".equals(type2)) {
            return RefFieldImpl.fieldFromExternalName(this.myRefManager, fqName2);
        }
        if ("parameter".equals(type2)) {
            return RefParameterImpl.parameterFromExternalName(this.myRefManager, fqName2);
        }
        if ("package".equals(type2)) {
            return RefPackageImpl.packageFromFQName(this.myRefManager, fqName2);
        }
        return null;
    }

    @Override
    @Nullable
    public String getType(RefEntity ref) {
        if (ref instanceof RefImplicitConstructor) {
            return "implicit.constructor";
        }
        if (ref instanceof RefMethod) {
            return "method";
        }
        if (ref instanceof RefClass) {
            return "class";
        }
        if (ref instanceof RefField) {
            return "field";
        }
        if (ref instanceof RefParameter) {
            return "parameter";
        }
        if (ref instanceof RefPackage) {
            return "package";
        }
        if (ref instanceof RefJavaModule) {
            return "java.module";
        }
        return null;
    }

    @Override
    @NotNull
    public RefEntity getRefinedElement(@NotNull RefEntity ref) {
        if (ref == null) {
            RefJavaManagerImpl.$$$reportNull$$$0(4);
        }
        if (ref instanceof RefImplicitConstructor) {
            RefClass refClass = ((RefImplicitConstructor)ref).getOwnerClass();
            if (refClass == null) {
                RefJavaManagerImpl.$$$reportNull$$$0(5);
            }
            return refClass;
        }
        RefEntity refEntity = ref;
        if (refEntity == null) {
            RefJavaManagerImpl.$$$reportNull$$$0(6);
        }
        return refEntity;
    }

    @Override
    public void visitElement(PsiElement element) {
        PsiElementVisitor projectIterator = this.myProjectIterator;
        if (projectIterator == null) {
            this.myProjectIterator = projectIterator = new MyJavaElementVisitor();
        }
        element.accept(projectIterator);
    }

    @Override
    @Nullable
    public String getGroupName(RefEntity entity) {
        if (entity instanceof RefFile && !(entity instanceof RefJavaFileImpl)) {
            return null;
        }
        return RefJavaUtil.getInstance().getPackageName(entity);
    }

    @Override
    public boolean belongsToScope(PsiElement psiElement) {
        return !(psiElement instanceof PsiTypeParameter);
    }

    @Override
    public void export(@NotNull RefEntity refEntity, @NotNull Element element) {
        PsiFile psiFile;
        SmartPsiElementPointer pointer;
        if (refEntity == null) {
            RefJavaManagerImpl.$$$reportNull$$$0(7);
        }
        if (element == null) {
            RefJavaManagerImpl.$$$reportNull$$$0(8);
        }
        if (refEntity instanceof RefElement && (pointer = ((RefElement)refEntity).getPointer()) != null && (psiFile = pointer.getContainingFile()) instanceof PsiJavaFile) {
            RefJavaManagerImpl.appendPackageElement(element, ((PsiJavaFile)psiFile).getPackageName());
        }
    }

    @Override
    public void onEntityInitialized(RefElement refElement, PsiElement psiElement) {
        if (this.myRefManager.isOfflineView() || !this.myRefManager.isDeclarationsFound()) {
            return;
        }
        if (this.isEntryPoint(refElement)) {
            this.getEntryPointsManager().addEntryPoint(refElement, false);
        }
    }

    private static void appendPackageElement(Element element, String packageName) {
        Element packageElement = new Element("package");
        packageElement.addContent(packageName.isEmpty() ? InspectionsBundle.message("inspection.reference.default.package", new Object[0]) : packageName);
        element.addContent(packageElement);
    }

    @Override
    public EntryPointsManager getEntryPointsManager() {
        EntryPointsManager entryPointsManager = this.myEntryPointsManager;
        if (entryPointsManager == null) {
            Project project = this.myRefManager.getProject();
            this.myEntryPointsManager = entryPointsManager = new EntryPointsManagerBase(project){

                @Override
                public void configureAnnotations() {
                }

                @Override
                public JButton createConfigureAnnotationsBtn() {
                    return null;
                }
            };
            Disposer.register(project, entryPointsManager);
            ((EntryPointsManagerBase)entryPointsManager).addAllPersistentEntries(EntryPointsManagerBase.getInstance(project));
        }
        return entryPointsManager;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/reference/RefJavaManagerImpl";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refEntity";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/reference/RefJavaManagerImpl";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefinedElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "iterate";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "removeReference";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getElementContainer";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getRefinedElement";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "export";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyJavaElementVisitor
    extends JavaElementVisitor {
        private final RefJavaUtil myRefUtil = RefJavaUtil.getInstance();
        private final ExternalAnnotationsManager myExternalAnnotationsManager = ExternalAnnotationsManager.getInstance(RefJavaManagerImpl.access$100(RefJavaManagerImpl.this).getProject());

        private MyJavaElementVisitor() {
        }

        @Override
        public void visitReferenceExpression(PsiReferenceExpression expression2) {
            this.visitElement(expression2);
        }

        @Override
        public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
        }

        @Override
        public void visitReferenceParameterList(PsiReferenceParameterList list2) {
            PsiType[] typeArguments2;
            PsiTypeParameterListOwner owner;
            super.visitReferenceParameterList(list2);
            PsiMember member = PsiTreeUtil.getParentOfType((PsiElement)list2, PsiMember.class);
            if (member instanceof PsiTypeParameter && (owner = ((PsiTypeParameter)member).getOwner()) != null) {
                for (PsiType psiType : ((PsiTypeParameter)member).getExtendsListTypes()) {
                    this.myRefUtil.addTypeReference(owner, psiType, RefJavaManagerImpl.this.myRefManager);
                }
            }
            for (PsiType psiType : typeArguments2 = list2.getTypeArguments()) {
                this.myRefUtil.addTypeReference(member, psiType, RefJavaManagerImpl.this.myRefManager);
            }
        }

        @Override
        public void visitClass(PsiClass aClass2) {
            if (!(aClass2 instanceof PsiTypeParameter)) {
                super.visitClass(aClass2);
                RefElement refClass = RefJavaManagerImpl.this.myRefManager.getReference(aClass2);
                if (refClass != null) {
                    ((RefClassImpl)refClass).buildReferences();
                }
            }
        }

        @Override
        public void visitMethod(PsiMethod method) {
            super.visitMethod(method);
            RefElement refElement = RefJavaManagerImpl.this.myRefManager.getReference(method);
            if (refElement instanceof RefMethodImpl) {
                ((RefMethodImpl)refElement).buildReferences();
            }
        }

        @Override
        public void visitField(PsiField field) {
            super.visitField(field);
            RefElement refElement = RefJavaManagerImpl.this.myRefManager.getReference(field);
            if (refElement instanceof RefFieldImpl) {
                ((RefFieldImpl)refElement).buildReferences();
            }
        }

        @Override
        public void visitDocComment(PsiDocComment comment) {
            PsiDocTag[] tags;
            super.visitDocComment(comment);
            for (PsiDocTag tag : tags = comment.getTags()) {
                RefElementImpl element;
                PsiModifierListOwner listOwner;
                PsiElement[] dataElements;
                if (!Comparing.strEqual(tag.getName(), "noinspection") || (dataElements = tag.getDataElements()).length <= 0 || (listOwner = PsiTreeUtil.getParentOfType((PsiElement)comment, PsiModifierListOwner.class)) == null || (element = (RefElementImpl)RefJavaManagerImpl.this.myRefManager.getReference(listOwner)) == null) continue;
                String suppression = StringUtil.join(dataElements, PsiElement::getText, ",");
                element.addSuppression(suppression);
            }
        }

        @Override
        public void visitAnnotation(PsiAnnotation annotation2) {
            super.visitAnnotation(annotation2);
            if (Comparing.strEqual(annotation2.getQualifiedName(), "java.lang.SuppressWarnings")) {
                this.retrieveSuppressions(annotation2, PsiTreeUtil.getParentOfType((PsiElement)annotation2, PsiModifierListOwner.class));
            }
        }

        private void retrieveSuppressions(PsiAnnotation annotation2, PsiModifierListOwner listOwner) {
            RefElementImpl element;
            if (listOwner != null && (element = (RefElementImpl)RefJavaManagerImpl.this.myRefManager.getReference(listOwner)) != null) {
                PsiNameValuePair[] nameValuePairs;
                StringBuilder buf = new StringBuilder();
                for (PsiNameValuePair nameValuePair : nameValuePairs = annotation2.getParameterList().getAttributes()) {
                    buf.append(",").append(nameValuePair.getText().replaceAll("[{}\"\"]", ""));
                }
                if (buf.length() > 0) {
                    element.addSuppression(buf.substring(1));
                }
            }
        }

        @Override
        public void visitVariable(PsiVariable variable2) {
            RefElement reference;
            super.visitVariable(variable2);
            this.myRefUtil.addTypeReference(variable2, variable2.getType(), RefJavaManagerImpl.this.myRefManager);
            if (variable2 instanceof PsiParameter && (reference = RefJavaManagerImpl.this.myRefManager.getReference(variable2)) instanceof RefParameterImpl) {
                ((RefParameterImpl)reference).buildReferences();
            }
        }

        @Override
        public void visitInstanceOfExpression(PsiInstanceOfExpression expression2) {
            super.visitInstanceOfExpression(expression2);
            PsiTypeElement typeElement = expression2.getCheckType();
            if (typeElement != null) {
                this.myRefUtil.addTypeReference(expression2, typeElement.getType(), RefJavaManagerImpl.this.myRefManager);
            }
        }

        @Override
        public void visitThisExpression(PsiThisExpression expression2) {
            super.visitThisExpression(expression2);
            PsiJavaCodeReferenceElement qualifier = expression2.getQualifier();
            if (qualifier != null) {
                RefClassImpl refClass;
                this.myRefUtil.addTypeReference(expression2, expression2.getType(), RefJavaManagerImpl.this.myRefManager);
                RefClass ownerClass = this.myRefUtil.getOwnerClass(RefJavaManagerImpl.this.myRefManager, expression2);
                if (ownerClass != null && (refClass = (RefClassImpl)RefJavaManagerImpl.this.myRefManager.getReference(qualifier.resolve())) != null) {
                    refClass.addInstanceReference(ownerClass);
                }
            }
        }

        @Override
        public void visitModule(PsiJavaModule javaModule) {
            super.visitModule(javaModule);
            RefElement refElement = RefJavaManagerImpl.this.myRefManager.getReference(javaModule);
            if (refElement != null) {
                ((RefJavaModuleImpl)refElement).buildReferences();
            }
        }

        @Override
        public void visitJavaFile(PsiJavaFile file2) {
            super.visitJavaFile(file2);
            RefElement refElement = RefJavaManagerImpl.this.myRefManager.getReference(file2);
            if (refElement != null) {
                ((RefJavaFileImpl)refElement).buildReferences();
            }
        }

        @Override
        public void visitModifierList(PsiModifierList list2) {
            PsiModifierListOwner listOwner;
            PsiAnnotation externalAnnotation;
            super.visitModifierList(list2);
            PsiElement parent2 = list2.getParent();
            if (parent2 instanceof PsiModifierListOwner && (externalAnnotation = this.myExternalAnnotationsManager.findExternalAnnotation(listOwner = (PsiModifierListOwner)parent2, "java.lang.SuppressWarnings")) != null) {
                this.retrieveSuppressions(externalAnnotation, listOwner);
            }
        }
    }
}

