/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.RegExFormatter;
import com.intellij.codeInspection.ui.RegExInputVerifier;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.DocumentAdapter;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.text.NumberFormat;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.text.Document;
import javax.swing.text.InternationalFormatter;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ConventionOptionsPanel
extends JPanel {
    private static final Logger LOG = Logger.getInstance(ConventionOptionsPanel.class);

    public ConventionOptionsPanel(@NotNull InspectionProfileEntry owner, @NonNls String minLengthProperty, @NonNls String maxLengthProperty, @NonNls String regexProperty, @NonNls String regexPatternProperty, JComponent ... extraOptions) {
        if (owner == null) {
            ConventionOptionsPanel.$$$reportNull$$$0(0);
        }
        this((Object)owner, minLengthProperty, maxLengthProperty, regexProperty, regexPatternProperty, extraOptions);
    }

    public ConventionOptionsPanel(final @NotNull Object owner, final @NonNls String minLengthProperty, final @NonNls String maxLengthProperty, final @NonNls String regexProperty, final @NonNls String regexPatternProperty, JComponent ... extraOptions) {
        if (owner == null) {
            ConventionOptionsPanel.$$$reportNull$$$0(1);
        }
        super(new GridBagLayout());
        JLabel patternLabel = new JLabel("Pattern:");
        JLabel minLengthLabel = new JLabel("Min length:");
        JLabel maxLengthLabel = new JLabel("Max length:");
        NumberFormat numberFormat = NumberFormat.getIntegerInstance();
        numberFormat.setParseIntegerOnly(true);
        numberFormat.setMinimumIntegerDigits(1);
        numberFormat.setMaximumIntegerDigits(3);
        InternationalFormatter formatter = new InternationalFormatter(numberFormat);
        formatter.setAllowsInvalid(true);
        formatter.setMinimum(Integer.valueOf(0));
        formatter.setMaximum(Integer.valueOf(999));
        final JFormattedTextField minLengthField = new JFormattedTextField(formatter);
        minLengthField.setValue(ConventionOptionsPanel.getPropertyIntegerValue(owner, minLengthProperty));
        minLengthField.setColumns(2);
        UIUtil.fixFormattedField(minLengthField);
        final JFormattedTextField maxLengthField = new JFormattedTextField(formatter);
        maxLengthField.setValue(ConventionOptionsPanel.getPropertyIntegerValue(owner, maxLengthProperty));
        maxLengthField.setColumns(2);
        UIUtil.fixFormattedField(maxLengthField);
        final JFormattedTextField regexField = new JFormattedTextField(new RegExFormatter());
        regexField.setValue(ConventionOptionsPanel.getPropertyValue(owner, regexPatternProperty));
        regexField.setColumns(25);
        regexField.setInputVerifier(new RegExInputVerifier());
        regexField.setFocusLostBehavior(0);
        UIUtil.fixFormattedField(regexField);
        DocumentAdapter listener = new DocumentAdapter(){

            @Override
            public void textChanged(DocumentEvent evt) {
                try {
                    regexField.commitEdit();
                    minLengthField.commitEdit();
                    maxLengthField.commitEdit();
                    Pattern pattern = (Pattern)regexField.getValue();
                    ConventionOptionsPanel.setPropertyValue(owner, regexPatternProperty, pattern);
                    ConventionOptionsPanel.setPropertyValue(owner, regexProperty, pattern.pattern());
                    ConventionOptionsPanel.setPropertyIntegerValue(owner, minLengthProperty, (Integer)minLengthField.getValue());
                    ConventionOptionsPanel.setPropertyIntegerValue(owner, maxLengthProperty, (Integer)maxLengthField.getValue());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        Document regexDocument = regexField.getDocument();
        regexDocument.addDocumentListener(listener);
        Document minLengthDocument = minLengthField.getDocument();
        minLengthDocument.addDocumentListener(listener);
        Document maxLengthDocument = maxLengthField.getDocument();
        maxLengthDocument.addDocumentListener(listener);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 0.0;
        constraints.insets.right = 10;
        constraints.anchor = 512;
        constraints.fill = 2;
        this.add((Component)patternLabel, constraints);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.insets.right = 0;
        this.add((Component)regexField, constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.weightx = 0.0;
        constraints.insets.right = 10;
        this.add((Component)minLengthLabel, constraints);
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.weightx = 1.0;
        constraints.insets.right = 0;
        this.add((Component)minLengthField, constraints);
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.weightx = 0.0;
        constraints.insets.right = 10;
        this.add((Component)maxLengthLabel, constraints);
        constraints.gridx = 1;
        constraints.gridy = 2;
        constraints.weightx = 1.0;
        constraints.insets.right = 0;
        this.add((Component)maxLengthField, constraints);
        constraints.gridx = 0;
        constraints.gridwidth = 2;
        for (JComponent extraOption : extraOptions) {
            ++constraints.gridy;
            this.add((Component)extraOption, constraints);
        }
        ++constraints.gridy;
        constraints.weighty = 1.0;
        this.add((Component)new JPanel(), constraints);
    }

    private static void setPropertyIntegerValue(Object owner, String property, Integer value) {
        ConventionOptionsPanel.setPropertyValue(owner, property, value);
    }

    private static Integer getPropertyIntegerValue(Object owner, String property) {
        return (Integer)ConventionOptionsPanel.getPropertyValue(owner, property);
    }

    private static void setPropertyValue(@NotNull Object owner, String property, Object value) {
        if (owner == null) {
            ConventionOptionsPanel.$$$reportNull$$$0(2);
        }
        ReflectionUtil.setField(owner.getClass(), owner, null, property, value);
    }

    private static Object getPropertyValue(Object owner, String property) {
        return ReflectionUtil.getField(owner.getClass(), owner, null, property);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "owner";
        objectArray2[1] = "com/intellij/codeInspection/ui/ConventionOptionsPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setPropertyValue";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

