/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.unusedImport;

import com.intellij.codeInspection.unusedImport.ImportStatementComparator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.util.InheritanceUtil;
import com.siyeh.ig.psiutils.ImportUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class ImportsAreUsedVisitor
extends JavaRecursiveElementWalkingVisitor {
    private final PsiJavaFile myFile;
    private final List<PsiImportStatementBase> importStatements;
    private final List<PsiImportStatementBase> usedImportStatements = new ArrayList<PsiImportStatementBase>();

    ImportsAreUsedVisitor(PsiJavaFile file2) {
        this.myFile = file2;
        PsiImportList importList = file2.getImportList();
        if (importList == null) {
            this.importStatements = Collections.emptyList();
        } else {
            PsiImportStatementBase[] importStatements = importList.getAllImportStatements();
            this.importStatements = new ArrayList<PsiImportStatementBase>(Arrays.asList(importStatements));
            Collections.sort(this.importStatements, ImportStatementComparator.getInstance());
        }
    }

    @Override
    public void visitElement(PsiElement element) {
        if (this.importStatements.isEmpty()) {
            return;
        }
        super.visitElement(element);
    }

    @Override
    public void visitReferenceElement(@NotNull PsiJavaCodeReferenceElement reference) {
        if (reference == null) {
            ImportsAreUsedVisitor.$$$reportNull$$$0(0);
        }
        this.followReferenceToImport(reference);
        super.visitReferenceElement(reference);
    }

    private void followReferenceToImport(PsiJavaCodeReferenceElement reference) {
        if (reference.getQualifier() != null) {
            return;
        }
        JavaResolveResult resolveResult = reference.advancedResolve(true);
        PsiElement element = resolveResult.getElement();
        if (!(element instanceof PsiMember)) {
            return;
        }
        PsiMember member = (PsiMember)element;
        if (this.findImport(member, this.usedImportStatements) != null) {
            return;
        }
        PsiImportStatementBase foundImport = this.findImport(member, this.importStatements);
        if (foundImport != null) {
            this.importStatements.remove(foundImport);
            this.usedImportStatements.add(foundImport);
        }
    }

    private PsiImportStatementBase findImport(PsiMember member, List<PsiImportStatementBase> importStatements) {
        String packageName;
        String qualifiedName2;
        PsiClass containingClass = member.getContainingClass();
        if (member instanceof PsiClass) {
            PsiClass referencedClass = (PsiClass)member;
            qualifiedName2 = referencedClass.getQualifiedName();
            packageName = qualifiedName2 != null ? StringUtil.getPackageName(qualifiedName2) : null;
        } else {
            if (!member.hasModifierProperty("static") || containingClass == null) {
                return null;
            }
            packageName = containingClass.getQualifiedName();
            qualifiedName2 = packageName + '.' + member.getName();
        }
        if (packageName == null) {
            return null;
        }
        boolean hasOnDemandImportConflict = ImportUtils.hasOnDemandImportConflict(qualifiedName2, this.myFile);
        for (PsiImportStatementBase importStatement : importStatements) {
            if (!importStatement.isOnDemand()) {
                JavaResolveResult[] targets;
                PsiJavaCodeReferenceElement reference = importStatement.getImportReference();
                if (reference == null) continue;
                for (JavaResolveResult target : targets = reference.multiResolve(false)) {
                    if (!member.equals(target.getElement())) continue;
                    return importStatement;
                }
                continue;
            }
            if (hasOnDemandImportConflict) continue;
            PsiElement target = importStatement.resolve();
            if (target instanceof PsiPackage) {
                PsiPackage aPackage = (PsiPackage)target;
                if (!packageName.equals(aPackage.getQualifiedName())) continue;
                return importStatement;
            }
            if (!(target instanceof PsiClass)) continue;
            PsiClass aClass2 = (PsiClass)target;
            if (!(importStatement instanceof PsiImportStaticStatement ? member.hasModifierProperty("static") && InheritanceUtil.isInheritorOrSelf(aClass2, containingClass, true) : importStatement instanceof PsiImportStatement && member instanceof PsiClass && aClass2.equals(containingClass))) continue;
            return importStatement;
        }
        return null;
    }

    @NotNull
    PsiImportStatementBase[] getUnusedImportStatements() {
        if (this.importStatements.isEmpty()) {
            if (PsiImportStatementBase.EMPTY_ARRAY == null) {
                ImportsAreUsedVisitor.$$$reportNull$$$0(1);
            }
            return PsiImportStatementBase.EMPTY_ARRAY;
        }
        PsiImportStatementBase[] psiImportStatementBaseArray = this.importStatements.toArray(new PsiImportStatementBase[this.importStatements.size()]);
        if (psiImportStatementBaseArray == null) {
            ImportsAreUsedVisitor.$$$reportNull$$$0(2);
        }
        return psiImportStatementBaseArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/unusedImport/ImportsAreUsedVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/unusedImport/ImportsAreUsedVisitor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnusedImportStatements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "visitReferenceElement";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

