/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.concurrency.JobScheduler;
import com.intellij.diagnostic.ApdexData;
import com.intellij.diagnostic.IdePerformanceListener;
import com.intellij.diagnostic.ThreadDump;
import com.intellij.diagnostic.ThreadDumper;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.AppScheduledExecutorService;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.ThreadMXBean;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.ListenerNotFoundException;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PerformanceWatcher
implements Disposable,
ApplicationComponent {
    private static final Logger LOG = Logger.getInstance("#com.intellij.diagnostic.PerformanceWatcher");
    private static final int TOLERABLE_LATENCY = 100;
    private static final String THREAD_DUMPS_PREFIX = "threadDumps-";
    private final ScheduledFuture<?> myThread;
    private final ThreadMXBean myThreadMXBean;
    private final DateFormat myDateFormat = new SimpleDateFormat("yyyyMMdd-HHmmss");
    private final File myLogDir = new File(PathManager.getLogPath());
    private List<StackTraceElement> myStacktraceCommonPart;
    private final IdePerformanceListener myPublisher;
    private volatile ApdexData mySwingApdex = ApdexData.EMPTY;
    private volatile ApdexData myGeneralApdex = ApdexData.EMPTY;
    private volatile long myLastSampling = System.currentTimeMillis();
    private long myLastDumpTime;
    private long myFreezeStart;
    private final AtomicInteger myEdtRequestsQueued = new AtomicInteger(0);
    private static final long ourIdeStart = System.currentTimeMillis();
    private long myLastEdtAlive = System.currentTimeMillis();

    public static PerformanceWatcher getInstance() {
        return ApplicationManager.getApplication().getComponent(PerformanceWatcher.class);
    }

    public PerformanceWatcher() {
        this.myPublisher = ApplicationManager.getApplication().getMessageBus().syncPublisher(IdePerformanceListener.TOPIC);
        this.myThreadMXBean = ManagementFactory.getThreadMXBean();
        this.myThread = JobScheduler.getScheduler().scheduleWithFixedDelay(() -> this.samplePerformance(), PerformanceWatcher.getSamplingInterval(), PerformanceWatcher.getSamplingInterval(), TimeUnit.MILLISECONDS);
    }

    @Override
    public void initComponent() {
        if (PerformanceWatcher.shouldWatch()) {
            final AppScheduledExecutorService service = (AppScheduledExecutorService)AppExecutorUtil.getAppScheduledExecutorService();
            service.setNewThreadListener(new Consumer<Thread>(){
                private final int ourReasonableThreadPoolSize = Registry.intValue("core.pooled.threads");

                @Override
                public void consume(Thread thread2) {
                    if (service.getBackendPoolExecutorSize() > this.ourReasonableThreadPoolSize && ApplicationInfoImpl.getShadowInstance().isEAP()) {
                        File file2 = PerformanceWatcher.this.dumpThreads("newPooledThread/", true);
                        LOG.info("Not enough pooled threads" + (file2 != null ? "; dumped threads into file '" + file2.getPath() + "'" : ""));
                    }
                }
            });
            ApplicationManager.getApplication().executeOnPooledThread(() -> PerformanceWatcher.cleanOldFiles(this.myLogDir, 0));
            for (MemoryPoolMXBean bean : ManagementFactory.getMemoryPoolMXBeans()) {
                if (!"Code Cache".equals(bean.getName())) continue;
                this.watchCodeCache(bean);
                break;
            }
        }
    }

    private static int getMaxAttempts() {
        return Registry.intValue("performance.watcher.unresponsive.max.attempts.before.log");
    }

    private void watchCodeCache(final MemoryPoolMXBean bean) {
        final long threshold = bean.getUsage().getMax() - 0x500000L;
        if (!bean.isUsageThresholdSupported() || threshold <= 0L) {
            return;
        }
        bean.setUsageThreshold(threshold);
        final NotificationEmitter emitter = (NotificationEmitter)((Object)ManagementFactory.getMemoryMXBean());
        emitter.addNotificationListener(new NotificationListener(){

            @Override
            public void handleNotification(Notification n, Object hb) {
                if (bean.getUsage().getUsed() > threshold) {
                    LOG.info("Code Cache is almost full");
                    PerformanceWatcher.this.dumpThreads("codeCacheFull", true);
                    try {
                        emitter.removeNotificationListener(this);
                    }
                    catch (ListenerNotFoundException e) {
                        LOG.error(e);
                    }
                }
            }
        }, null, null);
    }

    private static void cleanOldFiles(File dir, int level) {
        Object[] children2 = dir.listFiles((dir1, name) -> level > 0 || name.startsWith(THREAD_DUMPS_PREFIX));
        if (children2 == null) {
            return;
        }
        Arrays.sort(children2);
        for (int i2 = 0; i2 < children2.length; ++i2) {
            Object child = children2[i2];
            if (i2 < children2.length - 100 || PerformanceWatcher.ageInDays((File)child) > 10L) {
                FileUtil.delete((File)child);
                continue;
            }
            if (level >= 3) continue;
            PerformanceWatcher.cleanOldFiles((File)child, level + 1);
        }
    }

    private static long ageInDays(File file2) {
        return TimeUnit.DAYS.convert(System.currentTimeMillis() - file2.lastModified(), TimeUnit.MILLISECONDS);
    }

    @Override
    public void dispose() {
        if (this.myThread != null) {
            this.myThread.cancel(true);
        }
    }

    private static boolean shouldWatch() {
        return !ApplicationManager.getApplication().isHeadlessEnvironment() && Registry.intValue("performance.watcher.unresponsive.interval.ms") != 0 && PerformanceWatcher.getMaxAttempts() != 0;
    }

    private void samplePerformance() {
        long millis = System.currentTimeMillis();
        this.myLastSampling = millis;
        for (long diff = millis - this.myLastSampling - (long)PerformanceWatcher.getSamplingInterval(); diff >= 0L; diff -= (long)PerformanceWatcher.getSamplingInterval()) {
            this.myGeneralApdex = this.myGeneralApdex.withEvent(100L, diff);
        }
        int edtRequests = this.myEdtRequestsQueued.get();
        if (edtRequests >= PerformanceWatcher.getMaxAttempts()) {
            this.edtFrozen(millis);
        } else if (edtRequests == 0) {
            this.edtResponds(millis);
        }
        this.myEdtRequestsQueued.incrementAndGet();
        SwingUtilities.invokeLater(new SwingThreadRunnable(millis));
    }

    private static int getSamplingInterval() {
        return Registry.intValue("performance.watcher.sampling.interval.ms");
    }

    private void edtFrozen(long currentMillis) {
        if (currentMillis - this.myLastDumpTime >= (long)Registry.intValue("performance.watcher.unresponsive.interval.ms")) {
            this.myLastDumpTime = currentMillis;
            if (this.myFreezeStart == 0L) {
                this.myFreezeStart = this.myLastEdtAlive;
                this.myPublisher.uiFreezeStarted();
            }
            this.dumpThreads(this.getFreezeFolderName(this.myFreezeStart) + "/", false);
        }
    }

    @NotNull
    private String getFreezeFolderName(long freezeStartMs) {
        String string = "threadDumps-freeze-" + this.formatTime(freezeStartMs) + "-" + PerformanceWatcher.buildName();
        if (string == null) {
            PerformanceWatcher.$$$reportNull$$$0(0);
        }
        return string;
    }

    private static String buildName() {
        return ApplicationInfo.getInstance().getBuild().asString();
    }

    private String formatTime(long timeMs) {
        return this.myDateFormat.format(new Date(timeMs));
    }

    private void edtResponds(long currentMillis) {
        if (this.myFreezeStart != 0L) {
            int unresponsiveDuration = (int)(currentMillis - this.myFreezeStart) / 1000;
            File dir = new File(this.myLogDir, this.getFreezeFolderName(this.myFreezeStart));
            if (dir.exists()) {
                dir.renameTo(new File(this.myLogDir, dir.getName() + "-" + unresponsiveDuration + "sec" + this.getFreezePlaceSuffix()));
            }
            this.myPublisher.uiFreezeFinished(unresponsiveDuration);
            this.myFreezeStart = 0L;
            this.myStacktraceCommonPart = null;
        }
    }

    private String getFreezePlaceSuffix() {
        if (this.myStacktraceCommonPart != null && !this.myStacktraceCommonPart.isEmpty()) {
            StackTraceElement element = this.myStacktraceCommonPart.get(0);
            return "-" + StringUtil.getShortName(element.getClassName()) + "." + element.getMethodName();
        }
        return "";
    }

    @Nullable
    public File dumpThreads(@NotNull String pathPrefix, boolean millis) {
        if (pathPrefix == null) {
            PerformanceWatcher.$$$reportNull$$$0(1);
        }
        if (!PerformanceWatcher.shouldWatch()) {
            return null;
        }
        if (!pathPrefix.contains("/")) {
            pathPrefix = THREAD_DUMPS_PREFIX + pathPrefix + "-" + this.formatTime(ourIdeStart) + "-" + PerformanceWatcher.buildName() + "/";
        } else if (!pathPrefix.startsWith(THREAD_DUMPS_PREFIX)) {
            pathPrefix = THREAD_DUMPS_PREFIX + pathPrefix;
        }
        long now = System.currentTimeMillis();
        String suffix = millis ? "-" + now : "";
        File file2 = new File(this.myLogDir, pathPrefix + "threadDump-" + this.formatTime(now) + suffix + ".txt");
        File dir = file2.getParentFile();
        if (!dir.isDirectory() && !dir.mkdirs()) {
            return null;
        }
        PerformanceWatcher.checkMemoryUsage(file2);
        ThreadDump threadDump = ThreadDumper.getThreadDumpInfo(this.myThreadMXBean);
        try {
            FileUtil.writeToFile(file2, threadDump.getRawDump());
            StackTraceElement[] edtStack = threadDump.getEDTStackTrace();
            if (edtStack != null) {
                if (this.myStacktraceCommonPart == null) {
                    this.myStacktraceCommonPart = ContainerUtil.newArrayList(edtStack);
                } else {
                    this.updateStacktraceCommonPart(edtStack);
                }
            }
            this.myPublisher.dumpedThreads(file2, threadDump);
        }
        catch (IOException e) {
            LOG.info("failed to write thread dump file: " + e.getMessage());
        }
        return file2;
    }

    private static void checkMemoryUsage(File file2) {
        long usedMemory;
        Runtime rt2 = Runtime.getRuntime();
        long maxMemory = rt2.maxMemory();
        long freeMemory = maxMemory - (usedMemory = rt2.totalMemory() - rt2.freeMemory());
        if (freeMemory < maxMemory / 5L) {
            LOG.info("High memory usage (free " + freeMemory / 1024L / 1024L + " of " + maxMemory / 1024L / 1024L + " MB) while dumping threads to " + file2);
        }
    }

    public static void dumpThreadsToConsole(String message) {
        System.err.println(message);
        System.err.println(ThreadDumper.dumpThreadsToString());
    }

    private void updateStacktraceCommonPart(StackTraceElement[] stackTraceElements) {
        for (int i2 = 0; i2 < this.myStacktraceCommonPart.size() && i2 < stackTraceElements.length; ++i2) {
            StackTraceElement el2;
            StackTraceElement el1 = this.myStacktraceCommonPart.get(this.myStacktraceCommonPart.size() - i2 - 1);
            if (el1.equals(el2 = stackTraceElements[stackTraceElements.length - i2 - 1])) continue;
            this.myStacktraceCommonPart = this.myStacktraceCommonPart.subList(this.myStacktraceCommonPart.size() - i2, this.myStacktraceCommonPart.size());
            break;
        }
    }

    @NotNull
    public static Snapshot takeSnapshot() {
        PerformanceWatcher performanceWatcher = PerformanceWatcher.getInstance();
        performanceWatcher.getClass();
        Snapshot snapshot = performanceWatcher.new Snapshot();
        if (snapshot == null) {
            PerformanceWatcher.$$$reportNull$$$0(2);
        }
        return snapshot;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagnostic/PerformanceWatcher";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFreezeFolderName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagnostic/PerformanceWatcher";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "takeSnapshot";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "dumpThreads";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class Snapshot {
        private final ApdexData myStartGeneralSnapshot;
        private final ApdexData myStartSwingSnapshot;
        private final long myStartMillis;

        private Snapshot() {
            this.myStartGeneralSnapshot = PerformanceWatcher.this.myGeneralApdex;
            this.myStartSwingSnapshot = PerformanceWatcher.this.mySwingApdex;
            this.myStartMillis = System.currentTimeMillis();
        }

        public void logResponsivenessSinceCreation(@NotNull String activityName) {
            if (activityName == null) {
                Snapshot.$$$reportNull$$$0(0);
            }
            LOG.info(activityName + " took " + (System.currentTimeMillis() - this.myStartMillis) + "ms; general responsiveness: " + PerformanceWatcher.this.myGeneralApdex.summarizePerformanceSince(this.myStartGeneralSnapshot) + "; EDT responsiveness: " + PerformanceWatcher.this.mySwingApdex.summarizePerformanceSince(this.myStartSwingSnapshot));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "activityName", "com/intellij/diagnostic/PerformanceWatcher$Snapshot", "logResponsivenessSinceCreation"));
        }
    }

    private class SwingThreadRunnable
    implements Runnable {
        private final long myCreationMillis;

        SwingThreadRunnable(long creationMillis) {
            this.myCreationMillis = creationMillis;
        }

        @Override
        public void run() {
            PerformanceWatcher.this.myEdtRequestsQueued.decrementAndGet();
            PerformanceWatcher.this.myLastEdtAlive = System.currentTimeMillis();
            PerformanceWatcher.this.mySwingApdex = PerformanceWatcher.this.mySwingApdex.withEvent(100L, System.currentTimeMillis() - this.myCreationMillis);
        }
    }
}

