/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.highlighter;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.highlighter.XmlLikeFileType;
import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.text.XmlCharsetDetector;
import com.intellij.xml.util.HtmlUtil;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HtmlFileType
extends XmlLikeFileType {
    @NonNls
    public static final String DOT_DEFAULT_EXTENSION = ".html";
    public static final HtmlFileType INSTANCE = new HtmlFileType();

    private HtmlFileType() {
        super(HTMLLanguage.INSTANCE);
    }

    HtmlFileType(Language language) {
        super(language);
    }

    @Override
    @NotNull
    public String getName() {
        if ("HTML" == null) {
            HtmlFileType.$$$reportNull$$$0(0);
        }
        return "HTML";
    }

    @Override
    @NotNull
    public String getDescription() {
        String string = IdeBundle.message("filetype.description.html", new Object[0]);
        if (string == null) {
            HtmlFileType.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String getDefaultExtension() {
        if ("html" == null) {
            HtmlFileType.$$$reportNull$$$0(2);
        }
        return "html";
    }

    @Override
    public Icon getIcon() {
        return AllIcons.FileTypes.Html;
    }

    @Override
    public String getCharset(@NotNull VirtualFile file2, @NotNull byte[] content2) {
        String strContent;
        Trinity<Charset, CharsetToolkit.GuessedEncoding, byte[]> guessed;
        String charset;
        if (file2 == null) {
            HtmlFileType.$$$reportNull$$$0(3);
        }
        if (content2 == null) {
            HtmlFileType.$$$reportNull$$$0(4);
        }
        String string = charset = (guessed = LoadTextUtil.guessFromContent(file2, content2, content2.length)) != null && guessed.first != null ? ((Charset)guessed.first).name() : XmlCharsetDetector.extractXmlEncodingFromProlog(content2);
        if (charset != null) {
            return charset;
        }
        try {
            strContent = new String(content2, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
        Charset c = HtmlUtil.detectCharsetFromMetaTag(strContent);
        return c == null ? null : c.name();
    }

    @Override
    public Charset extractCharsetFromFileContent(@Nullable Project project, @Nullable VirtualFile file2, @NotNull CharSequence content2) {
        String name;
        Charset charset;
        if (content2 == null) {
            HtmlFileType.$$$reportNull$$$0(5);
        }
        if ((charset = CharsetToolkit.forName(name = XmlCharsetDetector.extractXmlEncodingFromProlog(content2))) != null) {
            return charset;
        }
        return HtmlUtil.detectCharsetFromMetaTag(content2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/highlighter/HtmlFileType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultExtension";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/highlighter/HtmlFileType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getCharset";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "extractCharsetFromFileContent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

