/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.highlighter.custom.tokens;

import com.intellij.ide.highlighter.custom.tokens.TokenInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.CustomHighlighterTokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.CharTrie;
import gnu.trove.THashSet;
import gnu.trove.TIntHashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class KeywordParser {
    private static final Logger LOG = Logger.getInstance("#com.intellij.ide.highlighter.custom.tokens.KeywordParser");
    private final List<Set<String>> myKeywordSets = new ArrayList<Set<String>>();
    private final CharTrie myTrie = new CharTrie();
    private final TIntHashSet myHashCodes = new TIntHashSet();
    private final boolean myIgnoreCase;

    public KeywordParser(List<Set<String>> keywordSets, boolean ignoreCase) {
        this.myIgnoreCase = ignoreCase;
        LOG.assertTrue(keywordSets.size() == 4);
        for (Set<String> keywordSet : keywordSets) {
            Set<String> normalized = this.normalizeKeywordSet(keywordSet);
            this.myKeywordSets.add(normalized);
            for (String s : normalized) {
                this.myHashCodes.add(this.myTrie.getHashCode(s));
            }
        }
    }

    private Set<String> normalizeKeywordSet(Set<String> keywordSet) {
        if (!this.myIgnoreCase) {
            return new THashSet<String>(keywordSet);
        }
        THashSet<String> result2 = new THashSet<String>();
        for (String s : keywordSet) {
            result2.add(StringUtil.toUpperCase(s));
        }
        return result2;
    }

    public boolean hasToken(int position, CharSequence myBuffer, @Nullable TokenInfo tokenInfo) {
        int index2 = 0;
        int offset2 = position;
        while (offset2 < myBuffer.length()) {
            char c = myBuffer.charAt(offset2++);
            int nextIndex = this.myTrie.findSubNode(index2, this.myIgnoreCase ? Character.toUpperCase(c) : c);
            if (nextIndex == 0) break;
            index2 = nextIndex;
            if (!this.myHashCodes.contains(index2) || !KeywordParser.isWordEnd(offset2, myBuffer)) continue;
            String keyword = myBuffer.subSequence(position, offset2).toString();
            String testKeyword = this.myIgnoreCase ? StringUtil.toUpperCase(keyword) : keyword;
            for (int i2 = 0; i2 < 4; ++i2) {
                if (!this.myKeywordSets.get(i2).contains(testKeyword)) continue;
                if (tokenInfo != null) {
                    tokenInfo.updateData(position, position + keyword.length(), KeywordParser.getToken(i2));
                }
                return true;
            }
        }
        return false;
    }

    private static boolean isWordEnd(int offset2, CharSequence sequence2) {
        if (offset2 == sequence2.length()) {
            return true;
        }
        return !Character.isJavaIdentifierPart(sequence2.charAt(offset2 - 1)) || !Character.isJavaIdentifierPart(sequence2.charAt(offset2));
    }

    private static IElementType getToken(int keywordSetIndex) {
        switch (keywordSetIndex) {
            case 0: {
                return CustomHighlighterTokenType.KEYWORD_1;
            }
            case 1: {
                return CustomHighlighterTokenType.KEYWORD_2;
            }
            case 2: {
                return CustomHighlighterTokenType.KEYWORD_3;
            }
            case 3: {
                return CustomHighlighterTokenType.KEYWORD_4;
            }
        }
        throw new AssertionError(keywordSetIndex);
    }
}

