/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageFilter;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CompositeLanguage
extends Language {
    private final List<LanguageFilter> myFilters = ContainerUtil.createLockFreeCopyOnWriteList();

    protected CompositeLanguage(String id) {
        super(id);
    }

    protected CompositeLanguage(String ID2, String ... mimeTypes) {
        super(ID2, mimeTypes);
    }

    protected CompositeLanguage(Language baseLanguage, String ID2, String ... mimeTypes) {
        super(baseLanguage, ID2, mimeTypes);
    }

    public void registerLanguageExtension(LanguageFilter filter2) {
        if (!this.myFilters.contains(filter2)) {
            this.myFilters.add(filter2);
        }
    }

    public boolean unregisterLanguageExtension(LanguageFilter filter2) {
        return this.myFilters.remove(filter2);
    }

    @NotNull
    public Language[] getLanguageExtensionsForFile(@NotNull PsiFile psi) {
        if (psi == null) {
            CompositeLanguage.$$$reportNull$$$0(0);
        }
        ArrayList<Language> extensions = new ArrayList<Language>(1);
        for (LanguageFilter filter2 : this.myFilters) {
            if (!filter2.isRelevantForFile(psi)) continue;
            extensions.add(filter2.getLanguage());
        }
        Language[] languageArray = extensions.toArray(new Language[extensions.size()]);
        if (languageArray == null) {
            CompositeLanguage.$$$reportNull$$$0(1);
        }
        return languageArray;
    }

    @NotNull
    public LanguageFilter[] getLanguageExtensions() {
        LanguageFilter[] languageFilterArray = ArrayUtil.stripTrailingNulls(this.myFilters.toArray(new LanguageFilter[this.myFilters.size()]));
        if (languageFilterArray == null) {
            CompositeLanguage.$$$reportNull$$$0(2);
        }
        return languageFilterArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/CompositeLanguage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/CompositeLanguage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageExtensionsForFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageExtensions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageExtensionsForFile";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

