/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.PossiblyDumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.util.SmartList;
import com.intellij.util.ui.UIUtil;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AnAction
implements PossiblyDumbAware {
    private static final Logger LOG = Logger.getInstance(AnAction.class);
    public static final Key<List<AnAction>> ACTIONS_KEY = Key.create("AnAction.shortcutSet");
    public static final AnAction[] EMPTY_ARRAY = new AnAction[0];
    private Presentation myTemplatePresentation;
    private ShortcutSet myShortcutSet = CustomShortcutSet.EMPTY;
    private boolean myEnabledInModalContext = false;
    private boolean myIsDefaultIcon = true;
    private boolean myWorksInInjected;
    private boolean myIsGlobal;

    public AnAction() {
        this(null, null, null);
    }

    public AnAction(Icon icon) {
        this(null, null, icon);
    }

    public AnAction(@Nullable String text2) {
        this(text2, null, null);
    }

    public AnAction(@Nullable String text2, @Nullable String description2, @Nullable Icon icon) {
        Presentation presentation = this.getTemplatePresentation();
        presentation.setText(text2);
        presentation.setDescription(description2);
        presentation.setIcon(icon);
    }

    public final ShortcutSet getShortcutSet() {
        return this.myShortcutSet;
    }

    public final void registerCustomShortcutSet(@NotNull ShortcutSet shortcutSet, @Nullable JComponent component) {
        if (shortcutSet == null) {
            AnAction.$$$reportNull$$$0(0);
        }
        this.registerCustomShortcutSet(shortcutSet, component, null);
    }

    public final void registerCustomShortcutSet(int keyCode, @JdkConstants.InputEventMask int modifiers2, @Nullable JComponent component) {
        this.registerCustomShortcutSet(new CustomShortcutSet(KeyStroke.getKeyStroke(keyCode, modifiers2)), component);
    }

    public final void registerCustomShortcutSet(@NotNull ShortcutSet shortcutSet, @Nullable JComponent component, @Nullable Disposable parentDisposable) {
        if (shortcutSet == null) {
            AnAction.$$$reportNull$$$0(1);
        }
        this.setShortcutSet(shortcutSet);
        this.registerCustomShortcutSet(component, parentDisposable);
    }

    public final void registerCustomShortcutSet(@Nullable JComponent component, @Nullable Disposable parentDisposable) {
        if (component == null) {
            return;
        }
        List<AnAction> actionList = UIUtil.getClientProperty((Object)component, ACTIONS_KEY);
        if (actionList == null) {
            actionList = new SmartList<AnAction>();
            UIUtil.putClientProperty(component, ACTIONS_KEY, actionList);
        }
        if (!actionList.contains(this)) {
            actionList.add(this);
        }
        if (parentDisposable != null) {
            Disposer.register(parentDisposable, () -> this.unregisterCustomShortcutSet(component));
        }
    }

    public final void unregisterCustomShortcutSet(@Nullable JComponent component) {
        List<AnAction> actionList = UIUtil.getClientProperty((Object)component, ACTIONS_KEY);
        if (actionList != null) {
            actionList.remove(this);
        }
    }

    public final void copyFrom(@NotNull AnAction sourceAction) {
        if (sourceAction == null) {
            AnAction.$$$reportNull$$$0(2);
        }
        Presentation sourcePresentation = sourceAction.getTemplatePresentation();
        Presentation presentation = this.getTemplatePresentation();
        presentation.copyFrom(sourcePresentation);
        this.copyShortcutFrom(sourceAction);
    }

    public final void copyShortcutFrom(@NotNull AnAction sourceAction) {
        if (sourceAction == null) {
            AnAction.$$$reportNull$$$0(3);
        }
        this.setShortcutSet(sourceAction.getShortcutSet());
    }

    public final boolean isEnabledInModalContext() {
        return this.myEnabledInModalContext;
    }

    protected final void setEnabledInModalContext(boolean enabledInModalContext) {
        this.myEnabledInModalContext = enabledInModalContext;
    }

    public boolean displayTextInToolbar() {
        return false;
    }

    public void update(AnActionEvent e) {
    }

    public void beforeActionPerformedUpdate(@NotNull AnActionEvent e) {
        if (e == null) {
            AnAction.$$$reportNull$$$0(4);
        }
        boolean worksInInjected = this.isInInjectedContext();
        e.setInjectedContext(worksInInjected);
        this.update(e);
        if (!e.getPresentation().isEnabled() && worksInInjected) {
            e.setInjectedContext(false);
            this.update(e);
        }
    }

    @NotNull
    public final Presentation getTemplatePresentation() {
        Presentation presentation = this.myTemplatePresentation;
        if (presentation == null) {
            this.myTemplatePresentation = presentation = new Presentation();
        }
        Presentation presentation2 = presentation;
        if (presentation2 == null) {
            AnAction.$$$reportNull$$$0(5);
        }
        return presentation2;
    }

    public abstract void actionPerformed(AnActionEvent var1);

    protected void setShortcutSet(ShortcutSet shortcutSet) {
        if (this.myIsGlobal && this.myShortcutSet != shortcutSet) {
            LOG.warn("ShortcutSet of global AnActions should not be changed outside of KeymapManager.\nThis is likely not what you wanted to do. Consider setting shortcut in keymap defaults, inheriting from other action using `use-shortcut-of` or wrapping with EmptyAction.wrap().", new Throwable());
        }
        this.myShortcutSet = shortcutSet;
    }

    public void setDefaultIcon(boolean isDefaultIconSet) {
        this.myIsDefaultIcon = isDefaultIconSet;
    }

    public boolean isDefaultIcon() {
        return this.myIsDefaultIcon;
    }

    public void setInjectedContext(boolean worksInInjected) {
        this.myWorksInInjected = worksInInjected;
    }

    public boolean isInInjectedContext() {
        return this.myWorksInInjected;
    }

    public boolean isTransparentUpdate() {
        return this instanceof TransparentUpdate;
    }

    @Override
    public boolean isDumbAware() {
        return this instanceof DumbAware;
    }

    public boolean startInTransaction() {
        return false;
    }

    @Nullable
    public static Project getEventProject(AnActionEvent e) {
        return e == null ? null : e.getData(CommonDataKeys.PROJECT);
    }

    public String toString() {
        return this.getTemplatePresentation().toString();
    }

    void markAsGlobal() {
        this.myIsGlobal = true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortcutSet";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceAction";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/actionSystem/AnAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/actionSystem/AnAction";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplatePresentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerCustomShortcutSet";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "copyFrom";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "copyShortcutFrom";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "beforeActionPerformedUpdate";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface TransparentUpdate {
    }
}

