/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.processing;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.ex.DiffFragment;
import com.intellij.openapi.diff.impl.highlighting.FragmentSide;
import com.intellij.openapi.diff.impl.processing.DiffCorrection;
import com.intellij.openapi.diff.impl.string.DiffString;
import com.intellij.openapi.util.text.StringUtil;

class PreferWholeLines
implements DiffCorrection {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.diff.impl.processing.PreferWholeLines");
    public static final DiffCorrection INSTANCE = new PreferWholeLines();

    PreferWholeLines() {
    }

    @Override
    public DiffFragment[] correct(DiffFragment[] fragments2) {
        for (int i2 = 1; i2 < fragments2.length - 1; ++i2) {
            DiffFragment fragment = fragments2[i2];
            if (!fragment.isOneSide()) continue;
            DiffFragment nextFragment = fragments2[i2 + 1];
            FragmentSide side = FragmentSide.chooseSide(fragment);
            DiffString fragmentText = side.getText(fragment);
            DiffString otherNextFragmentText = side.getOtherText(nextFragment);
            DiffString nextFragmentText = side.getText(nextFragment);
            if (nextFragment.isOneSide()) {
                LOG.error("<" + fragmentText + "> <" + otherNextFragmentText + ">");
            }
            if (!StringUtil.startsWithChar(fragmentText, '\n') || !StringUtil.startsWithChar(nextFragmentText, '\n') || !StringUtil.startsWithChar(otherNextFragmentText, '\n')) continue;
            DiffFragment previous = fragments2[i2 - 1];
            DiffString previousText = side.getText(previous);
            DiffString otherPreciousText = side.getOtherText(previous);
            assert (previous != null);
            assert (previousText != null);
            assert (otherPreciousText != null);
            assert (fragmentText != null);
            assert (nextFragmentText != null);
            assert (otherNextFragmentText != null);
            fragments2[i2 - 1] = previous = side.createFragment(previousText.append('\n'), otherPreciousText.append('\n'), previous.isModified());
            fragments2[i2] = fragment = side.createFragment(fragmentText.substring(1).append('\n'), side.getOtherText(fragment), fragment.isModified());
            fragments2[i2 + 1] = nextFragment = side.createFragment(nextFragmentText.substring(1), otherNextFragmentText.substring(1), nextFragment.isModified());
        }
        return fragments2;
    }
}

