/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.event;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import java.util.EventObject;

public class SelectionEvent
extends EventObject {
    private static final TextRange[] EMPTY_RANGES = new TextRange[0];
    private Pair<TextRange[], TextRange> myOldRanges;
    private Pair<TextRange[], TextRange> myNewRanges;

    public SelectionEvent(Editor editor, int[] oldSelectionStarts, int[] oldSelectionEnds, int[] newSelectionStarts, int[] newSelectionEnds) {
        super(editor);
        SelectionEvent.assertCorrectSelection(oldSelectionStarts, oldSelectionEnds);
        SelectionEvent.assertCorrectSelection(newSelectionStarts, newSelectionEnds);
        this.myOldRanges = SelectionEvent.getRanges(oldSelectionStarts, oldSelectionEnds);
        this.myNewRanges = SelectionEvent.getRanges(newSelectionStarts, newSelectionEnds);
    }

    public SelectionEvent(Editor editor, int oldStart, int oldEnd, int newStart, int newEnd) {
        this(editor, new int[]{oldStart}, new int[]{oldEnd}, new int[]{newStart}, new int[]{newEnd});
    }

    private static void assertCorrectSelection(int[] starts, int[] ends) {
        assert (starts.length == ends.length);
    }

    public Editor getEditor() {
        return (Editor)this.getSource();
    }

    public TextRange getOldRange() {
        return (TextRange)this.myOldRanges.second;
    }

    public TextRange getNewRange() {
        return (TextRange)this.myNewRanges.second;
    }

    public TextRange[] getOldRanges() {
        return (TextRange[])this.myOldRanges.first;
    }

    public TextRange[] getNewRanges() {
        return (TextRange[])this.myNewRanges.first;
    }

    private static Pair<TextRange[], TextRange> getRanges(int[] starts, int[] ends) {
        if (starts.length == 0) {
            return Pair.create(EMPTY_RANGES, TextRange.EMPTY_RANGE);
        }
        TextRange[] ranges2 = new TextRange[starts.length];
        int startOffset = Integer.MAX_VALUE;
        int endOffset = Integer.MIN_VALUE;
        for (int i2 = 0; i2 < starts.length; ++i2) {
            int start = starts[i2];
            int end = ends[i2];
            ranges2[i2] = new TextRange(start, end);
            startOffset = Math.min(startOffset, start);
            endOffset = Math.max(endOffset, end);
        }
        return Pair.create(ranges2, new TextRange(startOffset, endOffset));
    }
}

