/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.ex.LineIterator;
import com.intellij.openapi.editor.impl.LineIteratorImpl;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.util.BitUtil;
import com.intellij.util.containers.IntArrayList;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.MergingCharSequence;
import gnu.trove.TByteArrayList;
import gnu.trove.TIntArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class LineSet {
    private static final int MODIFIED_MASK = 4;
    private static final int SEPARATOR_MASK = 3;
    private final int[] myStarts;
    private final byte[] myFlags;
    private final int myLength;
    private static boolean doTest;

    private LineSet(int[] starts, byte[] flags, int length) {
        this.myStarts = starts;
        this.myFlags = flags;
        this.myLength = length;
    }

    public static LineSet createLineSet(CharSequence text2) {
        return LineSet.createLineSet(text2, false);
    }

    @NotNull
    private static LineSet createLineSet(@NotNull CharSequence text2, boolean markModified) {
        if (text2 == null) {
            LineSet.$$$reportNull$$$0(0);
        }
        TIntArrayList starts = new TIntArrayList();
        TByteArrayList flags = new TByteArrayList();
        LineTokenizer lineTokenizer = new LineTokenizer(text2);
        while (!lineTokenizer.atEnd()) {
            starts.add(lineTokenizer.getOffset());
            flags.add((byte)(lineTokenizer.getLineSeparatorLength() | (markModified ? 4 : 0)));
            lineTokenizer.advance();
        }
        LineSet lineSet = new LineSet(starts.toNativeArray(), flags.toNativeArray(), text2.length());
        if (lineSet == null) {
            LineSet.$$$reportNull$$$0(1);
        }
        return lineSet;
    }

    @NotNull
    LineSet update(@NotNull CharSequence prevText, int start, int end, @NotNull CharSequence replacement, boolean wholeTextReplaced) {
        LineSet result2;
        if (prevText == null) {
            LineSet.$$$reportNull$$$0(2);
        }
        if (replacement == null) {
            LineSet.$$$reportNull$$$0(3);
        }
        if (this.myLength == 0) {
            LineSet lineSet = LineSet.createLineSet(replacement, !wholeTextReplaced);
            if (lineSet == null) {
                LineSet.$$$reportNull$$$0(4);
            }
            return lineSet;
        }
        LineSet lineSet = result2 = this.isSingleLineChange(start, end, replacement) ? this.updateInsideOneLine(this.findLineIndex(start), replacement.length() - (end - start)) : this.genericUpdate(prevText, start, end, replacement);
        if (doTest) {
            MergingCharSequence newText = new MergingCharSequence(new MergingCharSequence(prevText.subSequence(0, start), replacement), prevText.subSequence(end, prevText.length()));
            result2.checkEquals(LineSet.createLineSet(newText));
        }
        LineSet lineSet2 = wholeTextReplaced ? result2.clearModificationFlags() : result2;
        if (lineSet2 == null) {
            LineSet.$$$reportNull$$$0(5);
        }
        return lineSet2;
    }

    private boolean isSingleLineChange(int start, int end, @NotNull CharSequence replacement) {
        if (replacement == null) {
            LineSet.$$$reportNull$$$0(6);
        }
        if (start == 0 && end == this.myLength && replacement.length() == 0) {
            return false;
        }
        int startLine = this.findLineIndex(start);
        return startLine == this.findLineIndex(end) && !CharArrayUtil.containLineBreaks(replacement) && !this.isLastEmptyLine(startLine);
    }

    @NotNull
    private LineSet updateInsideOneLine(int line, int lengthDelta) {
        int[] starts = (int[])this.myStarts.clone();
        int i2 = line + 1;
        while (i2 < starts.length) {
            int n = i2++;
            starts[n] = starts[n] + lengthDelta;
        }
        byte[] flags = (byte[])this.myFlags.clone();
        int n = line;
        flags[n] = (byte)(flags[n] | 4);
        LineSet lineSet = new LineSet(starts, flags, this.myLength + lengthDelta);
        if (lineSet == null) {
            LineSet.$$$reportNull$$$0(7);
        }
        return lineSet;
    }

    private LineSet genericUpdate(CharSequence prevText, int _start, int _end, CharSequence replacement) {
        int startOffset = _start;
        if (replacement.length() > 0 && replacement.charAt(0) == '\n' && startOffset > 0 && prevText.charAt(startOffset - 1) == '\r') {
            --startOffset;
        }
        int startLine = this.findLineIndex(startOffset);
        startOffset = this.getLineStart(startLine);
        int endOffset = _end;
        if (replacement.length() > 0 && replacement.charAt(replacement.length() - 1) == '\r' && endOffset < prevText.length() && prevText.charAt(endOffset) == '\n') {
            ++endOffset;
        }
        int endLine = this.findLineIndex(endOffset);
        endOffset = this.getLineEnd(endLine);
        if (!this.isLastEmptyLine(endLine)) {
            ++endLine;
        }
        if (startOffset < _start) {
            replacement = new MergingCharSequence(prevText.subSequence(startOffset, _start), replacement);
        }
        if (_end < endOffset) {
            replacement = new MergingCharSequence(replacement, prevText.subSequence(_end, endOffset));
        }
        LineSet patch = LineSet.createLineSet(replacement, true);
        return this.applyPatch(startOffset, endOffset, startLine, endLine, patch);
    }

    private void checkEquals(@NotNull LineSet fresh) {
        if (fresh == null) {
            LineSet.$$$reportNull$$$0(8);
        }
        if (this.getLineCount() != fresh.getLineCount()) {
            throw new AssertionError();
        }
        for (int i2 = 0; i2 < this.getLineCount(); ++i2) {
            boolean sep;
            boolean start = this.getLineStart(i2) != fresh.getLineStart(i2);
            boolean end = this.getLineEnd(i2) != fresh.getLineEnd(i2);
            boolean bl = sep = this.getSeparatorLength(i2) != fresh.getSeparatorLength(i2);
            if (start || end || sep) {
                throw new AssertionError();
            }
        }
    }

    @NotNull
    private LineSet applyPatch(int startOffset, int endOffset, int startLine, int endLine, @NotNull LineSet patch) {
        int i2;
        if (patch == null) {
            LineSet.$$$reportNull$$$0(9);
        }
        int lineShift = patch.myStarts.length - (endLine - startLine);
        int lengthShift = patch.myLength - (endOffset - startOffset);
        int newLineCount = this.myStarts.length + lineShift;
        int[] starts = new int[newLineCount];
        byte[] flags = new byte[newLineCount];
        for (i2 = 0; i2 < startLine; ++i2) {
            starts[i2] = this.myStarts[i2];
            flags[i2] = this.myFlags[i2];
        }
        for (i2 = 0; i2 < patch.myStarts.length; ++i2) {
            starts[startLine + i2] = patch.myStarts[i2] + startOffset;
            flags[startLine + i2] = patch.myFlags[i2];
        }
        for (i2 = endLine; i2 < this.myStarts.length; ++i2) {
            starts[lineShift + i2] = this.myStarts[i2] + lengthShift;
            flags[lineShift + i2] = this.myFlags[i2];
        }
        LineSet lineSet = new LineSet(starts, flags, this.myLength + lengthShift);
        if (lineSet == null) {
            LineSet.$$$reportNull$$$0(10);
        }
        return lineSet;
    }

    public int findLineIndex(int offset2) {
        if (offset2 < 0 || offset2 > this.myLength) {
            throw new IndexOutOfBoundsException("Wrong offset: " + offset2 + ". Should be in range: [0, " + this.myLength + "]");
        }
        if (this.myLength == 0) {
            return 0;
        }
        if (offset2 == this.myLength) {
            return this.getLineCount() - 1;
        }
        int bsResult = Arrays.binarySearch(this.myStarts, offset2);
        return bsResult >= 0 ? bsResult : -bsResult - 2;
    }

    @NotNull
    public LineIterator createIterator() {
        LineIteratorImpl lineIteratorImpl = new LineIteratorImpl(this);
        if (lineIteratorImpl == null) {
            LineSet.$$$reportNull$$$0(11);
        }
        return lineIteratorImpl;
    }

    public final int getLineStart(int index2) {
        this.checkLineIndex(index2);
        return this.isLastEmptyLine(index2) ? this.myLength : this.myStarts[index2];
    }

    private boolean isLastEmptyLine(int index2) {
        return index2 == this.myFlags.length && index2 > 0 && this.getSeparatorLengthUnsafe(index2 - 1) > 0;
    }

    public final int getLineEnd(int index2) {
        this.checkLineIndex(index2);
        return index2 >= this.myStarts.length - 1 ? this.myLength : this.myStarts[index2 + 1];
    }

    private void checkLineIndex(int index2) {
        if (index2 < 0 || index2 >= this.getLineCount()) {
            throw new IndexOutOfBoundsException("Wrong line: " + index2 + ". Available lines count: " + this.getLineCount());
        }
    }

    final boolean isModified(int index2) {
        this.checkLineIndex(index2);
        return !this.isLastEmptyLine(index2) && BitUtil.isSet((int)this.myFlags[index2], 4);
    }

    @NotNull
    final LineSet setModified(@NotNull IntArrayList indices) {
        int index2;
        if (indices == null) {
            LineSet.$$$reportNull$$$0(12);
        }
        if (indices.isEmpty()) {
            LineSet lineSet = this;
            if (lineSet == null) {
                LineSet.$$$reportNull$$$0(13);
            }
            return lineSet;
        }
        if (indices.size() == 1 && (this.isLastEmptyLine(index2 = indices.get(0)) || this.isModified(index2))) {
            LineSet lineSet = this;
            if (lineSet == null) {
                LineSet.$$$reportNull$$$0(14);
            }
            return lineSet;
        }
        byte[] flags = (byte[])this.myFlags.clone();
        for (int i2 = 0; i2 < indices.size(); ++i2) {
            int index3;
            int n = index3 = indices.get(i2);
            flags[n] = (byte)(flags[n] | 4);
        }
        LineSet lineSet = new LineSet(this.myStarts, flags, this.myLength);
        if (lineSet == null) {
            LineSet.$$$reportNull$$$0(15);
        }
        return lineSet;
    }

    @NotNull
    LineSet clearModificationFlags(int startLine, int endLine) {
        if (startLine > endLine) {
            throw new IllegalArgumentException("endLine < startLine: " + endLine + " < " + startLine + "; lineCount: " + this.getLineCount());
        }
        this.checkLineIndex(startLine);
        this.checkLineIndex(endLine - 1);
        if (this.isLastEmptyLine(endLine - 1)) {
            --endLine;
        }
        if (startLine >= endLine) {
            LineSet lineSet = this;
            if (lineSet == null) {
                LineSet.$$$reportNull$$$0(16);
            }
            return lineSet;
        }
        byte[] flags = (byte[])this.myFlags.clone();
        int i2 = startLine;
        while (i2 < endLine) {
            int n = i2++;
            flags[n] = (byte)(flags[n] & 0xFFFFFFFB);
        }
        LineSet lineSet = new LineSet(this.myStarts, flags, this.myLength);
        if (lineSet == null) {
            LineSet.$$$reportNull$$$0(17);
        }
        return lineSet;
    }

    @NotNull
    LineSet clearModificationFlags() {
        LineSet lineSet = this.getLineCount() == 0 ? this : this.clearModificationFlags(0, this.getLineCount());
        if (lineSet == null) {
            LineSet.$$$reportNull$$$0(18);
        }
        return lineSet;
    }

    final int getSeparatorLength(int index2) {
        this.checkLineIndex(index2);
        return this.getSeparatorLengthUnsafe(index2);
    }

    private int getSeparatorLengthUnsafe(int index2) {
        return index2 < this.myFlags.length ? this.myFlags[index2] & 3 : 0;
    }

    final int getLineCount() {
        return this.myStarts.length + (this.isLastEmptyLine(this.myStarts.length) ? 1 : 0);
    }

    public static void setTestingMode(boolean testMode) {
        doTest = testMode;
    }

    int getLength() {
        return this.myLength;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/LineSet";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prevText";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacement";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fresh";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patch";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indices";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/LineSet";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createLineSet";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "update";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "updateInsideOneLine";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "applyPatch";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createIterator";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "setModified";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "clearModificationFlags";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createLineSet";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isSingleLineChange";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "checkEquals";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "applyPatch";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setModified";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

