/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module.impl.scopes;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collections;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LibraryScopeBase
extends GlobalSearchScope {
    private final LinkedHashSet<VirtualFile> myEntries;
    protected final ProjectFileIndex myIndex;

    public LibraryScopeBase(Project project, VirtualFile[] classes2, VirtualFile[] sources) {
        super(project);
        this.myIndex = ProjectRootManager.getInstance(project).getFileIndex();
        this.myEntries = new LinkedHashSet(classes2.length + sources.length);
        Collections.addAll(this.myEntries, classes2);
        Collections.addAll(this.myEntries, sources);
    }

    @Override
    public boolean contains(@NotNull VirtualFile file2) {
        if (file2 == null) {
            LibraryScopeBase.$$$reportNull$$$0(0);
        }
        return this.myEntries.contains(this.getFileRoot(file2));
    }

    @Nullable
    protected VirtualFile getFileRoot(@NotNull VirtualFile file2) {
        if (file2 == null) {
            LibraryScopeBase.$$$reportNull$$$0(1);
        }
        if (this.myIndex.isInLibraryClasses(file2)) {
            return this.myIndex.getClassRootForFile(file2);
        }
        if (this.myIndex.isInLibrarySource(file2)) {
            return this.myIndex.getSourceRootForFile(file2);
        }
        return null;
    }

    @Override
    public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
        if (file1 == null) {
            LibraryScopeBase.$$$reportNull$$$0(2);
        }
        if (file2 == null) {
            LibraryScopeBase.$$$reportNull$$$0(3);
        }
        VirtualFile r1 = this.getFileRoot(file1);
        VirtualFile r2 = this.getFileRoot(file2);
        for (VirtualFile root2 : this.myEntries) {
            if (Comparing.equal(r1, root2)) {
                return 1;
            }
            if (!Comparing.equal(r2, root2)) continue;
            return -1;
        }
        return 0;
    }

    @Override
    public boolean isSearchInModuleContent(@NotNull Module aModule) {
        if (aModule == null) {
            LibraryScopeBase.$$$reportNull$$$0(4);
        }
        return false;
    }

    @Override
    public boolean isSearchInLibraries() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LibraryScopeBase)) {
            return false;
        }
        return this.myEntries.equals(((LibraryScopeBase)o).myEntries);
    }

    @Override
    public int hashCode() {
        return this.myEntries.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file1";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file2";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aModule";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/module/impl/scopes/LibraryScopeBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "contains";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getFileRoot";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "compare";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isSearchInModuleContent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

