/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectFileStoreOptionManager;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.LocalFileProvider;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a.\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u0001\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\u00a8\u0006\f"}, d2={"isExternalStorageEnabled", "", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)Z", "displayUrlRelativeToProject", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "url", "project", "includeFilePath", "moduleOnTheLeft", "projectModel-api"})
@JvmName(name="ProjectUtilCore")
public final class ProjectUtilCore {
    @NotNull
    public static final String displayUrlRelativeToProject(@NotNull VirtualFile file2, @NotNull String url, @NotNull Project project, boolean includeFilePath, boolean moduleOnTheLeft) {
        Module module2;
        Intrinsics.checkParameterIsNotNull(file2, "file");
        Intrinsics.checkParameterIsNotNull(url, "url");
        Intrinsics.checkParameterIsNotNull(project, "project");
        String result2 = url;
        if (includeFilePath) {
            String string;
            String projectHomeUrl;
            VirtualFile virtualFile2 = project.getBaseDir();
            String string2 = projectHomeUrl = virtualFile2 != null ? virtualFile2.getPresentableUrl() : null;
            if (projectHomeUrl != null && StringsKt.startsWith$default(result2, projectHomeUrl, false, 2, null)) {
                String string3 = result2;
                int n = projectHomeUrl.length();
                StringBuilder stringBuilder = new StringBuilder().append("...");
                String string4 = string3.substring(n);
                Intrinsics.checkExpressionValueIsNotNull(string4, "(this as java.lang.String).substring(startIndex)");
                String string5 = string4;
                string = stringBuilder.append(string5).toString();
            } else {
                String string6 = FileUtil.getLocationRelativeToUserHome(file2.getPresentableUrl());
                string = string6;
                Intrinsics.checkExpressionValueIsNotNull(string6, "FileUtil.getLocationRela\u2026Home(file.presentableUrl)");
            }
            result2 = string;
        }
        if (file2.getFileSystem() instanceof LocalFileProvider) {
            VirtualFileSystem virtualFileSystem = file2.getFileSystem();
            if (virtualFileSystem == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.vfs.LocalFileProvider");
            }
            VirtualFile localFile = ((LocalFileProvider)((Object)virtualFileSystem)).getLocalVirtualFileFor(file2);
            if (localFile != null) {
                OrderEntry libraryEntry = LibraryUtil.findLibraryEntry(file2, project);
                if (libraryEntry instanceof JdkOrderEntry) {
                    return "" + result2 + " [" + ((JdkOrderEntry)libraryEntry).getJdkName() + ']';
                }
                if (libraryEntry != null) {
                    return "" + result2 + " [" + libraryEntry.getPresentableName() + ']';
                }
            }
        }
        return (module2 = ModuleUtilCore.findModuleForFile(file2, project)) == null ? result2 : (moduleOnTheLeft ? '[' + module2.getName() + "] " + result2 : "" + result2 + " [" + module2.getName() + ']');
    }

    public static final boolean isExternalStorageEnabled(@NotNull Project $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        String key = "com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManager";
        Object object = $receiver.getPicoContainer().getComponentInstance(key);
        if (!(object instanceof ProjectFileStoreOptionManager)) {
            object = null;
        }
        ProjectFileStoreOptionManager projectFileStoreOptionManager = (ProjectFileStoreOptionManager)object;
        if (projectFileStoreOptionManager == null) {
            return false;
        }
        ProjectFileStoreOptionManager manager = projectFileStoreOptionManager;
        return manager.isStoredExternally() || Registry.is("store.imported.project.elements.separately", false);
    }
}

