/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.file.impl.FileManager;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class ProjectRootUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.projectRoots.impl.ProjectRootUtil");

    private ProjectRootUtil() {
    }

    @NotNull
    private static PsiDirectory[] convertRoots(Project project, VirtualFile[] roots2) {
        PsiDirectory[] psiDirectoryArray = ProjectRootUtil.convertRoots(((PsiManagerImpl)PsiManager.getInstance(project)).getFileManager(), roots2);
        if (psiDirectoryArray == null) {
            ProjectRootUtil.$$$reportNull$$$0(0);
        }
        return psiDirectoryArray;
    }

    @NotNull
    private static PsiDirectory[] convertRoots(FileManager fileManager, VirtualFile[] roots2) {
        ArrayList<PsiDirectory> dirs = new ArrayList<PsiDirectory>();
        for (VirtualFile root2 : roots2) {
            PsiDirectory dir;
            if (!root2.isValid()) {
                LOG.error("Root " + root2 + " is not valid!");
            }
            if ((dir = fileManager.findDirectory(root2)) == null) continue;
            dirs.add(dir);
        }
        PsiDirectory[] psiDirectoryArray = dirs.toArray(new PsiDirectory[dirs.size()]);
        if (psiDirectoryArray == null) {
            ProjectRootUtil.$$$reportNull$$$0(1);
        }
        return psiDirectoryArray;
    }

    @NotNull
    public static PsiDirectory[] getSourceRootDirectories(Project project) {
        VirtualFile[] files2 = OrderEnumerator.orderEntries(project).sources().usingCache().getRoots();
        PsiDirectory[] psiDirectoryArray = ProjectRootUtil.convertRoots(project, files2);
        if (psiDirectoryArray == null) {
            ProjectRootUtil.$$$reportNull$$$0(2);
        }
        return psiDirectoryArray;
    }

    @NotNull
    public static PsiDirectory[] getAllContentRoots(Project project) {
        VirtualFile[] files2 = ProjectRootManager.getInstance(project).getContentRootsFromAllModules();
        PsiDirectory[] psiDirectoryArray = ProjectRootUtil.convertRoots(project, files2);
        if (psiDirectoryArray == null) {
            ProjectRootUtil.$$$reportNull$$$0(3);
        }
        return psiDirectoryArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/openapi/projectRoots/impl/ProjectRootUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "convertRoots";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceRootDirectories";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllContentRoots";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

