/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.module.EffectiveLanguageLevelUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.impl.FilePropertyPusher;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdater;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.messages.MessageBus;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaLanguageLevelPusher
implements FilePropertyPusher<LanguageLevel> {
    private static final FileAttribute PERSISTENCE = new FileAttribute("language_level_persistence", 3, true);

    public static void pushLanguageLevel(@NotNull Project project) {
        FilePropertyPusher[] extensions;
        if (project == null) {
            JavaLanguageLevelPusher.$$$reportNull$$$0(0);
        }
        PushedFilePropertiesUpdater instance = PushedFilePropertiesUpdater.getInstance(project);
        for (FilePropertyPusher pusher : extensions = (FilePropertyPusher[])EP_NAME.getExtensions()) {
            if (!(pusher instanceof JavaLanguageLevelPusher)) continue;
            instance.pushAll(pusher);
        }
    }

    @Override
    public void initExtra(@NotNull Project project, @NotNull MessageBus bus, @NotNull FilePropertyPusher.Engine languageLevelUpdater) {
        if (project == null) {
            JavaLanguageLevelPusher.$$$reportNull$$$0(1);
        }
        if (bus == null) {
            JavaLanguageLevelPusher.$$$reportNull$$$0(2);
        }
        if (languageLevelUpdater == null) {
            JavaLanguageLevelPusher.$$$reportNull$$$0(3);
        }
    }

    @Override
    @NotNull
    public Key<LanguageLevel> getFileDataKey() {
        Key<LanguageLevel> key = LanguageLevel.KEY;
        if (key == null) {
            JavaLanguageLevelPusher.$$$reportNull$$$0(4);
        }
        return key;
    }

    @Override
    public boolean pushDirectoriesOnly() {
        return true;
    }

    @Override
    @NotNull
    public LanguageLevel getDefaultValue() {
        LanguageLevel languageLevel = LanguageLevel.HIGHEST;
        if (languageLevel == null) {
            JavaLanguageLevelPusher.$$$reportNull$$$0(5);
        }
        return languageLevel;
    }

    @Override
    public LanguageLevel getImmediateValue(@NotNull Project project, @Nullable VirtualFile file2) {
        if (project == null) {
            JavaLanguageLevelPusher.$$$reportNull$$$0(6);
        }
        return null;
    }

    @Override
    public LanguageLevel getImmediateValue(@NotNull Module module2) {
        if (module2 == null) {
            JavaLanguageLevelPusher.$$$reportNull$$$0(7);
        }
        return EffectiveLanguageLevelUtil.getEffectiveLanguageLevel(module2);
    }

    @Override
    public boolean acceptsFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            JavaLanguageLevelPusher.$$$reportNull$$$0(8);
        }
        return false;
    }

    @Override
    public boolean acceptsDirectory(@NotNull VirtualFile file2, @NotNull Project project) {
        if (file2 == null) {
            JavaLanguageLevelPusher.$$$reportNull$$$0(9);
        }
        if (project == null) {
            JavaLanguageLevelPusher.$$$reportNull$$$0(10);
        }
        return ProjectFileIndex.SERVICE.getInstance(project).isInSourceContent(file2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void persistAttribute(@NotNull Project project, @NotNull VirtualFile fileOrDir, @NotNull LanguageLevel level) throws IOException {
        DataInputStream iStream;
        if (project == null) {
            JavaLanguageLevelPusher.$$$reportNull$$$0(11);
        }
        if (fileOrDir == null) {
            JavaLanguageLevelPusher.$$$reportNull$$$0(12);
        }
        if (level == null) {
            JavaLanguageLevelPusher.$$$reportNull$$$0(13);
        }
        if ((iStream = PERSISTENCE.readAttribute(fileOrDir)) != null) {
            try {
                int oldLevelOrdinal = DataInputOutputUtil.readINT(iStream);
                if (oldLevelOrdinal == level.ordinal()) {
                    return;
                }
            }
            finally {
                iStream.close();
            }
        }
        DataOutputStream oStream = PERSISTENCE.writeAttribute(fileOrDir);
        DataInputOutputUtil.writeINT(oStream, level.ordinal());
        oStream.close();
        for (VirtualFile child : fileOrDir.getChildren()) {
            if (child.isDirectory() || !JavaLanguageLevelPusher.isJavaLike(child.getFileType())) continue;
            PushedFilePropertiesUpdater.getInstance(project).filePropertiesChanged(child);
        }
    }

    private static boolean isJavaLike(FileType type2) {
        return type2 instanceof LanguageFileType && ((LanguageFileType)type2).getLanguage().isKindOf(JavaLanguage.INSTANCE);
    }

    @Override
    public void afterRootsChanged(@NotNull Project project) {
        if (project == null) {
            JavaLanguageLevelPusher.$$$reportNull$$$0(14);
        }
    }

    @Nullable
    public String getInconsistencyLanguageLevelMessage(@NotNull String message, @NotNull PsiElement element, @NotNull LanguageLevel level, @NotNull PsiFile file2) {
        if (message == null) {
            JavaLanguageLevelPusher.$$$reportNull$$$0(15);
        }
        if (element == null) {
            JavaLanguageLevelPusher.$$$reportNull$$$0(16);
        }
        if (level == null) {
            JavaLanguageLevelPusher.$$$reportNull$$$0(17);
        }
        if (file2 == null) {
            JavaLanguageLevelPusher.$$$reportNull$$$0(18);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bus";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevelUpdater";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/JavaLanguageLevelPusher";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 8: 
            case 9: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrDir";
                break;
            }
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/JavaLanguageLevelPusher";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileDataKey";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "pushLanguageLevel";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "initExtra";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getImmediateValue";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "acceptsFile";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "acceptsDirectory";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "persistAttribute";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "afterRootsChanged";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getInconsistencyLanguageLevelMessage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

