/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl.libraries;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.roots.impl.RootModelImpl;
import com.intellij.openapi.roots.impl.libraries.LibraryImpl;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.util.InvalidDataException;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryTableImplUtil {
    @NonNls
    public static final String MODULE_LEVEL = "module";

    private LibraryTableImplUtil() {
    }

    @NotNull
    public static Library loadLibrary(@NotNull Element rootElement, @NotNull RootModelImpl rootModel) throws InvalidDataException {
        List<Element> children2;
        if (rootElement == null) {
            LibraryTableImplUtil.$$$reportNull$$$0(0);
        }
        if (rootModel == null) {
            LibraryTableImplUtil.$$$reportNull$$$0(1);
        }
        if ((children2 = rootElement.getChildren("library")).size() != 1) {
            throw new InvalidDataException();
        }
        Element element = children2.get(0);
        LibraryImpl libraryImpl = new LibraryImpl(null, element, (ModifiableRootModel)rootModel);
        if (libraryImpl == null) {
            LibraryTableImplUtil.$$$reportNull$$$0(2);
        }
        return libraryImpl;
    }

    @NotNull
    public static Library createModuleLevelLibrary(@Nullable String name, PersistentLibraryKind kind, @NotNull RootModelImpl rootModel, @Nullable ProjectModelExternalSource externalSource) {
        if (rootModel == null) {
            LibraryTableImplUtil.$$$reportNull$$$0(3);
        }
        LibraryImpl libraryImpl = new LibraryImpl(name, kind, null, rootModel, externalSource);
        if (libraryImpl == null) {
            LibraryTableImplUtil.$$$reportNull$$$0(4);
        }
        return libraryImpl;
    }

    public static boolean isValidLibrary(@NotNull Library library2) {
        LibraryTable table2;
        if (library2 == null) {
            LibraryTableImplUtil.$$$reportNull$$$0(5);
        }
        if ((table2 = library2.getTable()) != null) {
            String name = library2.getName();
            return name != null && table2.getLibraryByName(name) == library2;
        }
        if (!(library2 instanceof LibraryImpl)) {
            return false;
        }
        Module module2 = ((LibraryImpl)library2).getModule();
        if (module2 == null) {
            return false;
        }
        for (OrderEntry entry : ModuleRootManager.getInstance(module2).getOrderEntries()) {
            if (!(entry instanceof LibraryOrderEntry) || ((LibraryOrderEntry)entry).getLibrary() != library2) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootElement";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootModel";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/libraries/LibraryTableImplUtil";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/libraries/LibraryTableImplUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "loadLibrary";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createModuleLevelLibrary";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadLibrary";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createModuleLevelLibrary";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isValidLibrary";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

