/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MultiValuesMap<K, V> {
    private final Map<K, Collection<V>> myBaseMap;
    private final boolean myOrdered;

    public MultiValuesMap() {
        this(false);
    }

    public MultiValuesMap(boolean ordered) {
        this.myOrdered = ordered;
        this.myBaseMap = ordered ? new LinkedHashMap() : new HashMap();
    }

    public void putAll(K key, @NotNull Collection<V> values2) {
        if (values2 == null) {
            MultiValuesMap.$$$reportNull$$$0(0);
        }
        for (V value : values2) {
            this.put(key, value);
        }
    }

    public void putAll(K key, V ... values2) {
        if (values2 == null) {
            MultiValuesMap.$$$reportNull$$$0(1);
        }
        for (V value : values2) {
            this.put(key, value);
        }
    }

    public void put(K key, V value) {
        Collection<V> collection = this.myBaseMap.get(key);
        if (collection == null) {
            collection = this.myOrdered ? new LinkedHashSet() : new HashSet();
            this.myBaseMap.put(key, collection);
        }
        collection.add(value);
    }

    public Collection<V> get(K key) {
        return this.myBaseMap.get(key);
    }

    @NotNull
    public Set<K> keySet() {
        Set<K> set = this.myBaseMap.keySet();
        if (set == null) {
            MultiValuesMap.$$$reportNull$$$0(2);
        }
        return set;
    }

    @NotNull
    public Collection<V> values() {
        HashSet result2 = this.myOrdered ? new LinkedHashSet() : new HashSet();
        for (Collection<V> values2 : this.myBaseMap.values()) {
            result2.addAll(values2);
        }
        HashSet hashSet = result2;
        if (hashSet == null) {
            MultiValuesMap.$$$reportNull$$$0(3);
        }
        return hashSet;
    }

    public void remove(K key, V value) {
        if (!this.myBaseMap.containsKey(key)) {
            return;
        }
        Collection<V> values2 = this.myBaseMap.get(key);
        values2.remove(value);
        if (values2.isEmpty()) {
            this.myBaseMap.remove(key);
        }
    }

    public void clear() {
        this.myBaseMap.clear();
    }

    @Nullable
    public Collection<V> removeAll(K key) {
        return this.myBaseMap.remove(key);
    }

    @NotNull
    public Set<Map.Entry<K, Collection<V>>> entrySet() {
        Set<Map.Entry<K, Collection<V>>> set = this.myBaseMap.entrySet();
        if (set == null) {
            MultiValuesMap.$$$reportNull$$$0(4);
        }
        return set;
    }

    public boolean isEmpty() {
        return this.myBaseMap.isEmpty();
    }

    public boolean containsKey(K key) {
        return this.myBaseMap.containsKey(key);
    }

    @NotNull
    public Collection<V> collectValues() {
        HashSet<V> result2 = new HashSet<V>();
        for (Collection<V> v : this.myBaseMap.values()) {
            result2.addAll(v);
        }
        HashSet<V> hashSet = result2;
        if (hashSet == null) {
            MultiValuesMap.$$$reportNull$$$0(5);
        }
        return hashSet;
    }

    @Nullable
    public V getFirst(K key) {
        Collection<V> values2 = this.myBaseMap.get(key);
        return values2 == null || values2.isEmpty() ? null : (V)values2.iterator().next();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/MultiValuesMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/MultiValuesMap";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "keySet";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "values";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "entrySet";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "collectValues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "putAll";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

