/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.io;

import com.intellij.openapi.diagnostic.LoggerRt;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.ArrayUtilRt;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUtilRt {
    private static final int KILOBYTE = 1024;
    private static final int DEFAULT_INTELLISENSE_LIMIT = 2560000;
    public static final int MEGABYTE = 0x100000;
    public static final int LARGE_FOR_CONTENT_LOADING = Math.max(0x1400000, Math.max(FileUtilRt.getUserFileSizeLimit(), FileUtilRt.getUserContentLoadLimit()));
    public static final int LARGE_FILE_PREVIEW_SIZE = Math.min(FileUtilRt.getLargeFilePreviewSize(), LARGE_FOR_CONTENT_LOADING);
    private static final int MAX_FILE_IO_ATTEMPTS = 10;
    private static final boolean USE_FILE_CHANNELS = "true".equalsIgnoreCase(System.getProperty("idea.fs.useChannels"));
    public static final FileFilter ALL_FILES = new FileFilter(){

        public boolean accept(File file2) {
            return true;
        }
    };
    public static final FileFilter ALL_DIRECTORIES = new FileFilter(){

        public boolean accept(File file2) {
            return file2.isDirectory();
        }
    };
    protected static final ThreadLocal<byte[]> BUFFER = new ThreadLocal<byte[]>(){

        @Override
        protected byte[] initialValue() {
            return new byte[20480];
        }
    };
    private static String ourCanonicalTempPathCache = null;
    private static final Random RANDOM = new Random();

    @NotNull
    public static String getExtension(@NotNull String fileName) {
        int index2;
        if (fileName == null) {
            FileUtilRt.$$$reportNull$$$0(0);
        }
        if ((index2 = fileName.lastIndexOf(46)) < 0) {
            if ("" == null) {
                FileUtilRt.$$$reportNull$$$0(1);
            }
            return "";
        }
        String string = fileName.substring(index2 + 1);
        if (string == null) {
            FileUtilRt.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public static CharSequence getExtension(@NotNull CharSequence fileName) {
        if (fileName == null) {
            FileUtilRt.$$$reportNull$$$0(3);
        }
        CharSequence charSequence = FileUtilRt.getExtension(fileName, "");
        if (charSequence == null) {
            FileUtilRt.$$$reportNull$$$0(4);
        }
        return charSequence;
    }

    public static CharSequence getExtension(@NotNull CharSequence fileName, @Nullable String defaultValue) {
        int index2;
        if (fileName == null) {
            FileUtilRt.$$$reportNull$$$0(5);
        }
        if ((index2 = StringUtilRt.lastIndexOf(fileName, '.', 0, fileName.length())) < 0) {
            return defaultValue;
        }
        return fileName.subSequence(index2 + 1, fileName.length());
    }

    public static boolean extensionEquals(@NotNull String filePath, @NotNull String extension) {
        int extLen;
        if (filePath == null) {
            FileUtilRt.$$$reportNull$$$0(6);
        }
        if (extension == null) {
            FileUtilRt.$$$reportNull$$$0(7);
        }
        if ((extLen = extension.length()) == 0) {
            int lastSlash = Math.max(filePath.lastIndexOf(47), filePath.lastIndexOf(92));
            return filePath.indexOf(46, lastSlash + 1) == -1;
        }
        int extStart = filePath.length() - extLen;
        return extStart >= 1 && filePath.charAt(extStart - 1) == '.' && filePath.regionMatches(!SystemInfoRt.isFileSystemCaseSensitive, extStart, extension, 0, extLen);
    }

    @NotNull
    public static String toSystemDependentName(@NonNls @NotNull String fileName) {
        if (fileName == null) {
            FileUtilRt.$$$reportNull$$$0(8);
        }
        String string = FileUtilRt.toSystemDependentName(fileName, File.separatorChar);
        if (string == null) {
            FileUtilRt.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public static String toSystemDependentName(@NonNls @NotNull String fileName, char separatorChar) {
        if (fileName == null) {
            FileUtilRt.$$$reportNull$$$0(10);
        }
        String string = fileName.replace('/', separatorChar).replace('\\', separatorChar);
        if (string == null) {
            FileUtilRt.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    public static String toSystemIndependentName(@NonNls @NotNull String fileName) {
        if (fileName == null) {
            FileUtilRt.$$$reportNull$$$0(12);
        }
        String string = fileName.replace('\\', '/');
        if (string == null) {
            FileUtilRt.$$$reportNull$$$0(13);
        }
        return string;
    }

    @Nullable
    public static String getRelativePath(File base2, File file2) {
        if (base2 == null || file2 == null) {
            return null;
        }
        if (base2.equals(file2)) {
            return ".";
        }
        String filePath = file2.getAbsolutePath();
        String basePath = base2.getAbsolutePath();
        return FileUtilRt.getRelativePath(basePath, filePath, File.separatorChar);
    }

    @Nullable
    public static String getRelativePath(@NotNull String basePath, @NotNull String filePath, char separator) {
        if (basePath == null) {
            FileUtilRt.$$$reportNull$$$0(14);
        }
        if (filePath == null) {
            FileUtilRt.$$$reportNull$$$0(15);
        }
        return FileUtilRt.getRelativePath(basePath, filePath, separator, SystemInfoRt.isFileSystemCaseSensitive);
    }

    @Nullable
    public static String getRelativePath(@NotNull String basePath, @NotNull String filePath, char separator, boolean caseSensitive) {
        int len;
        CharComparingStrategy strategy;
        if (basePath == null) {
            FileUtilRt.$$$reportNull$$$0(16);
        }
        if (filePath == null) {
            FileUtilRt.$$$reportNull$$$0(17);
        }
        basePath = FileUtilRt.ensureEnds(basePath, separator);
        if (caseSensitive ? basePath.equals(FileUtilRt.ensureEnds(filePath, separator)) : basePath.equalsIgnoreCase(FileUtilRt.ensureEnds(filePath, separator))) {
            return ".";
        }
        int lastSeparatorIndex = 0;
        CharComparingStrategy charComparingStrategy = strategy = caseSensitive ? CharComparingStrategy.IDENTITY : CharComparingStrategy.CASE_INSENSITIVE;
        for (len = 0; len < filePath.length() && len < basePath.length() && strategy.charsEqual(filePath.charAt(len), basePath.charAt(len)); ++len) {
            if (basePath.charAt(len) != separator) continue;
            lastSeparatorIndex = len;
        }
        if (len == 0) {
            return null;
        }
        StringBuilder relativePath = new StringBuilder();
        for (int i2 = len; i2 < basePath.length(); ++i2) {
            if (basePath.charAt(i2) != separator) continue;
            relativePath.append("..");
            relativePath.append(separator);
        }
        relativePath.append(filePath.substring(lastSeparatorIndex + 1));
        return relativePath.toString();
    }

    private static String ensureEnds(@NotNull String s, char endsWith) {
        if (s == null) {
            FileUtilRt.$$$reportNull$$$0(18);
        }
        return StringUtilRt.endsWithChar(s, endsWith) ? s : s + endsWith;
    }

    @NotNull
    public static CharSequence getNameWithoutExtension(@NotNull CharSequence name) {
        int i2;
        if (name == null) {
            FileUtilRt.$$$reportNull$$$0(19);
        }
        CharSequence charSequence = (i2 = StringUtilRt.lastIndexOf(name, '.', 0, name.length())) < 0 ? name : name.subSequence(0, i2);
        if (charSequence == null) {
            FileUtilRt.$$$reportNull$$$0(20);
        }
        return charSequence;
    }

    @NotNull
    public static String getNameWithoutExtension(@NotNull String name) {
        if (name == null) {
            FileUtilRt.$$$reportNull$$$0(21);
        }
        String string = FileUtilRt.getNameWithoutExtension((CharSequence)name).toString();
        if (string == null) {
            FileUtilRt.$$$reportNull$$$0(22);
        }
        return string;
    }

    @NotNull
    public static File createTempDirectory(@NotNull @NonNls String prefix, @Nullable @NonNls String suffix) throws IOException {
        if (prefix == null) {
            FileUtilRt.$$$reportNull$$$0(23);
        }
        File file2 = FileUtilRt.createTempDirectory(prefix, suffix, true);
        if (file2 == null) {
            FileUtilRt.$$$reportNull$$$0(24);
        }
        return file2;
    }

    @NotNull
    public static File createTempDirectory(@NotNull @NonNls String prefix, @Nullable @NonNls String suffix, boolean deleteOnExit) throws IOException {
        if (prefix == null) {
            FileUtilRt.$$$reportNull$$$0(25);
        }
        File dir = new File(FileUtilRt.getTempDirectory());
        File file2 = FileUtilRt.createTempDirectory(dir, prefix, suffix, deleteOnExit);
        if (file2 == null) {
            FileUtilRt.$$$reportNull$$$0(26);
        }
        return file2;
    }

    @NotNull
    public static File createTempDirectory(@NotNull File dir, @NotNull @NonNls String prefix, @Nullable @NonNls String suffix) throws IOException {
        if (dir == null) {
            FileUtilRt.$$$reportNull$$$0(27);
        }
        if (prefix == null) {
            FileUtilRt.$$$reportNull$$$0(28);
        }
        File file2 = FileUtilRt.createTempDirectory(dir, prefix, suffix, true);
        if (file2 == null) {
            FileUtilRt.$$$reportNull$$$0(29);
        }
        return file2;
    }

    @NotNull
    public static File createTempDirectory(@NotNull File dir, @NotNull @NonNls String prefix, @Nullable @NonNls String suffix, boolean deleteOnExit) throws IOException {
        if (dir == null) {
            FileUtilRt.$$$reportNull$$$0(30);
        }
        if (prefix == null) {
            FileUtilRt.$$$reportNull$$$0(31);
        }
        File file2 = FileUtilRt.doCreateTempFile(dir, prefix, suffix, true);
        if (deleteOnExit) {
            FilesToDeleteHolder.ourFilesToDelete.add(file2.getPath());
        }
        if (!file2.isDirectory()) {
            throw new IOException("Cannot create directory: " + file2);
        }
        File file3 = file2;
        if (file3 == null) {
            FileUtilRt.$$$reportNull$$$0(32);
        }
        return file3;
    }

    @NotNull
    public static File createTempFile(@NotNull @NonNls String prefix, @Nullable @NonNls String suffix) throws IOException {
        if (prefix == null) {
            FileUtilRt.$$$reportNull$$$0(33);
        }
        File file2 = FileUtilRt.createTempFile(prefix, suffix, false);
        if (file2 == null) {
            FileUtilRt.$$$reportNull$$$0(34);
        }
        return file2;
    }

    @NotNull
    public static File createTempFile(@NotNull @NonNls String prefix, @Nullable @NonNls String suffix, boolean deleteOnExit) throws IOException {
        if (prefix == null) {
            FileUtilRt.$$$reportNull$$$0(35);
        }
        File dir = new File(FileUtilRt.getTempDirectory());
        File file2 = FileUtilRt.createTempFile(dir, prefix, suffix, true, deleteOnExit);
        if (file2 == null) {
            FileUtilRt.$$$reportNull$$$0(36);
        }
        return file2;
    }

    @NotNull
    public static File createTempFile(@NonNls File dir, @NotNull @NonNls String prefix, @Nullable @NonNls String suffix) throws IOException {
        if (prefix == null) {
            FileUtilRt.$$$reportNull$$$0(37);
        }
        File file2 = FileUtilRt.createTempFile(dir, prefix, suffix, true, true);
        if (file2 == null) {
            FileUtilRt.$$$reportNull$$$0(38);
        }
        return file2;
    }

    @NotNull
    public static File createTempFile(@NonNls File dir, @NotNull @NonNls String prefix, @Nullable @NonNls String suffix, boolean create2) throws IOException {
        if (prefix == null) {
            FileUtilRt.$$$reportNull$$$0(39);
        }
        File file2 = FileUtilRt.createTempFile(dir, prefix, suffix, create2, true);
        if (file2 == null) {
            FileUtilRt.$$$reportNull$$$0(40);
        }
        return file2;
    }

    @NotNull
    public static File createTempFile(@NonNls File dir, @NotNull @NonNls String prefix, @Nullable @NonNls String suffix, boolean create2, boolean deleteOnExit) throws IOException {
        if (prefix == null) {
            FileUtilRt.$$$reportNull$$$0(41);
        }
        File file2 = FileUtilRt.doCreateTempFile(dir, prefix, suffix, false);
        if (deleteOnExit) {
            file2.deleteOnExit();
        }
        if (!create2 && !file2.delete() && file2.exists()) {
            throw new IOException("Cannot delete file: " + file2);
        }
        File file3 = file2;
        if (file3 == null) {
            FileUtilRt.$$$reportNull$$$0(42);
        }
        return file3;
    }

    @NotNull
    private static File doCreateTempFile(@NotNull File dir, @NotNull @NonNls String prefix, @Nullable @NonNls String suffix, boolean isDirectory) throws IOException {
        if (dir == null) {
            FileUtilRt.$$$reportNull$$$0(43);
        }
        if (prefix == null) {
            FileUtilRt.$$$reportNull$$$0(44);
        }
        dir.mkdirs();
        if (prefix.length() < 3) {
            prefix = (prefix + "___").substring(0, 3);
        }
        if (suffix == null) {
            suffix = "";
        }
        prefix = new File(prefix).getName();
        int exceptionsCount = 0;
        int i2 = 0;
        int maxFileNumber = 10;
        while (true) {
            File file2;
            try {
                boolean success;
                File f = FileUtilRt.calcName(dir, prefix, suffix, i2);
                boolean bl = success = isDirectory ? f.mkdir() : f.createNewFile();
                if (!success) {
                    String[] children2 = f.getParentFile().list();
                    List<Object> list2 = children2 == null ? Collections.emptyList() : Arrays.asList(children2);
                    maxFileNumber = Math.max(10, list2.size() * 10);
                    throw new IOException("Unable to create temporary file " + f + "\nDirectory '" + f.getParentFile() + "' list (" + list2.size() + " children): " + list2);
                }
                file2 = FileUtilRt.normalizeFile(f);
            }
            catch (IOException e) {
                if (++exceptionsCount >= 100) {
                    throw e;
                }
                if (++i2 <= 2) continue;
                i2 = 2 + RANDOM.nextInt(maxFileNumber);
                continue;
            }
            if (file2 == null) {
                FileUtilRt.$$$reportNull$$$0(45);
            }
            return file2;
        }
    }

    @NotNull
    private static File calcName(@NotNull File dir, @NotNull String prefix, @NotNull String suffix, int i2) throws IOException {
        File f;
        String name;
        if (dir == null) {
            FileUtilRt.$$$reportNull$$$0(46);
        }
        if (prefix == null) {
            FileUtilRt.$$$reportNull$$$0(47);
        }
        if (suffix == null) {
            FileUtilRt.$$$reportNull$$$0(48);
        }
        if ((prefix = prefix + (i2 == 0 ? "" : Integer.valueOf(i2))).endsWith(".") && suffix.startsWith(".")) {
            prefix = prefix.substring(0, prefix.length() - 1);
        }
        if (!(name = prefix + suffix).equals((f = new File(dir, name)).getName())) {
            throw new IOException("Unable to create temporary file " + f + " for name " + name);
        }
        File file2 = f;
        if (file2 == null) {
            FileUtilRt.$$$reportNull$$$0(49);
        }
        return file2;
    }

    @NotNull
    private static File normalizeFile(@NotNull File temp) throws IOException {
        if (temp == null) {
            FileUtilRt.$$$reportNull$$$0(50);
        }
        File canonical = temp.getCanonicalFile();
        File file2 = SystemInfoRt.isWindows && canonical.getAbsolutePath().contains(" ") ? temp.getAbsoluteFile() : canonical;
        if (file2 == null) {
            FileUtilRt.$$$reportNull$$$0(51);
        }
        return file2;
    }

    @NotNull
    public static String getTempDirectory() {
        if (ourCanonicalTempPathCache == null) {
            ourCanonicalTempPathCache = FileUtilRt.calcCanonicalTempPath();
        }
        String string = ourCanonicalTempPathCache;
        if (string == null) {
            FileUtilRt.$$$reportNull$$$0(52);
        }
        return string;
    }

    @NotNull
    private static String calcCanonicalTempPath() {
        File file2;
        block4: {
            String string;
            file2 = new File(System.getProperty("java.io.tmpdir"));
            try {
                String canonical = file2.getCanonicalPath();
                if (SystemInfoRt.isWindows && canonical.contains(" ")) break block4;
                string = canonical;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (string == null) {
                FileUtilRt.$$$reportNull$$$0(53);
            }
            return string;
        }
        String string = file2.getAbsolutePath();
        if (string == null) {
            FileUtilRt.$$$reportNull$$$0(54);
        }
        return string;
    }

    public static void resetCanonicalTempPathCache(String tempPath) {
        ourCanonicalTempPathCache = tempPath;
    }

    @NotNull
    public static File generateRandomTemporaryPath() throws IOException {
        File file2 = new File(FileUtilRt.getTempDirectory(), UUID.randomUUID().toString());
        for (int i2 = 0; file2.exists() && i2 < 5; ++i2) {
            file2 = new File(FileUtilRt.getTempDirectory(), UUID.randomUUID().toString());
        }
        if (file2.exists()) {
            throw new IOException("Couldn't generate unique random path.");
        }
        File file3 = FileUtilRt.normalizeFile(file2);
        if (file3 == null) {
            FileUtilRt.$$$reportNull$$$0(55);
        }
        return file3;
    }

    public static void setExecutableAttribute(@NotNull String path2, boolean executableFlag) throws IOException {
        if (path2 == null) {
            FileUtilRt.$$$reportNull$$$0(56);
        }
        try {
            File file2 = new File(path2);
            if (!file2.setExecutable(executableFlag) && file2.canExecute() != executableFlag) {
                FileUtilRt.logger().warn("Can't set executable attribute of '" + path2 + "' to " + executableFlag);
            }
        }
        catch (LinkageError linkageError) {
            // empty catch block
        }
    }

    @NotNull
    public static String loadFile(@NotNull File file2) throws IOException {
        if (file2 == null) {
            FileUtilRt.$$$reportNull$$$0(57);
        }
        String string = FileUtilRt.loadFile(file2, null, false);
        if (string == null) {
            FileUtilRt.$$$reportNull$$$0(58);
        }
        return string;
    }

    @NotNull
    public static String loadFile(@NotNull File file2, boolean convertLineSeparators) throws IOException {
        if (file2 == null) {
            FileUtilRt.$$$reportNull$$$0(59);
        }
        String string = FileUtilRt.loadFile(file2, null, convertLineSeparators);
        if (string == null) {
            FileUtilRt.$$$reportNull$$$0(60);
        }
        return string;
    }

    @NotNull
    public static String loadFile(@NotNull File file2, @Nullable @NonNls String encoding) throws IOException {
        if (file2 == null) {
            FileUtilRt.$$$reportNull$$$0(61);
        }
        String string = FileUtilRt.loadFile(file2, encoding, false);
        if (string == null) {
            FileUtilRt.$$$reportNull$$$0(62);
        }
        return string;
    }

    @NotNull
    public static String loadFile(@NotNull File file2, @Nullable @NonNls String encoding, boolean convertLineSeparators) throws IOException {
        if (file2 == null) {
            FileUtilRt.$$$reportNull$$$0(63);
        }
        String s = new String(FileUtilRt.loadFileText(file2, encoding));
        String string = convertLineSeparators ? StringUtilRt.convertLineSeparators(s) : s;
        if (string == null) {
            FileUtilRt.$$$reportNull$$$0(64);
        }
        return string;
    }

    @NotNull
    public static char[] loadFileText(@NotNull File file2) throws IOException {
        if (file2 == null) {
            FileUtilRt.$$$reportNull$$$0(65);
        }
        char[] cArray = FileUtilRt.loadFileText(file2, (String)null);
        if (cArray == null) {
            FileUtilRt.$$$reportNull$$$0(66);
        }
        return cArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static char[] loadFileText(@NotNull File file2, @Nullable @NonNls String encoding) throws IOException {
        char[] cArray;
        InputStreamReader reader;
        block4: {
            if (file2 == null) {
                FileUtilRt.$$$reportNull$$$0(67);
            }
            FileInputStream stream2 = new FileInputStream(file2);
            reader = encoding == null ? new InputStreamReader(stream2) : new InputStreamReader((InputStream)stream2, encoding);
            cArray = FileUtilRt.loadText(reader, (int)file2.length());
            if (cArray != null) break block4;
            FileUtilRt.$$$reportNull$$$0(68);
        }
        return cArray;
        finally {
            ((Reader)reader).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static char[] loadFileText(@NotNull File file2, @NotNull @NonNls Charset encoding) throws IOException {
        char[] cArray;
        InputStreamReader reader;
        block5: {
            if (file2 == null) {
                FileUtilRt.$$$reportNull$$$0(69);
            }
            if (encoding == null) {
                FileUtilRt.$$$reportNull$$$0(70);
            }
            reader = new InputStreamReader((InputStream)new FileInputStream(file2), encoding);
            cArray = FileUtilRt.loadText(reader, (int)file2.length());
            if (cArray != null) break block5;
            FileUtilRt.$$$reportNull$$$0(71);
        }
        return cArray;
        finally {
            ((Reader)reader).close();
        }
    }

    @NotNull
    public static char[] loadText(@NotNull Reader reader, int length) throws IOException {
        int count2;
        int n;
        if (reader == null) {
            FileUtilRt.$$$reportNull$$$0(72);
        }
        char[] chars = new char[length];
        for (count2 = 0; count2 < chars.length && (n = reader.read(chars, count2, chars.length - count2)) > 0; count2 += n) {
        }
        if (count2 == chars.length) {
            if (chars == null) {
                FileUtilRt.$$$reportNull$$$0(73);
            }
            return chars;
        }
        char[] newChars = new char[count2];
        System.arraycopy(chars, 0, newChars, 0, count2);
        if (newChars == null) {
            FileUtilRt.$$$reportNull$$$0(74);
        }
        return newChars;
    }

    @NotNull
    public static List<String> loadLines(@NotNull File file2) throws IOException {
        if (file2 == null) {
            FileUtilRt.$$$reportNull$$$0(75);
        }
        List<String> list2 = FileUtilRt.loadLines(file2.getPath());
        if (list2 == null) {
            FileUtilRt.$$$reportNull$$$0(76);
        }
        return list2;
    }

    @NotNull
    public static List<String> loadLines(@NotNull File file2, @Nullable @NonNls String encoding) throws IOException {
        if (file2 == null) {
            FileUtilRt.$$$reportNull$$$0(77);
        }
        List<String> list2 = FileUtilRt.loadLines(file2.getPath(), encoding);
        if (list2 == null) {
            FileUtilRt.$$$reportNull$$$0(78);
        }
        return list2;
    }

    @NotNull
    public static List<String> loadLines(@NotNull String path2) throws IOException {
        if (path2 == null) {
            FileUtilRt.$$$reportNull$$$0(79);
        }
        List<String> list2 = FileUtilRt.loadLines(path2, null);
        if (list2 == null) {
            FileUtilRt.$$$reportNull$$$0(80);
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @NotNull
    public static List<String> loadLines(@NotNull String path2, @Nullable @NonNls String encoding) throws IOException {
        if (path2 == null) {
            FileUtilRt.$$$reportNull$$$0(81);
        }
        FileInputStream stream2 = new FileInputStream(path2);
        InputStreamReader in = encoding == null ? new InputStreamReader(stream2) : new InputStreamReader((InputStream)stream2, encoding);
        BufferedReader reader = new BufferedReader(in);
        List<String> list2 = FileUtilRt.loadLines(reader);
        reader.close();
        List<String> list3 = list2;
        if (list3 == null) {
            FileUtilRt.$$$reportNull$$$0(82);
        }
        return list3;
        {
            catch (Throwable throwable) {
                reader.close();
                throw throwable;
            }
        }
        finally {
            ((InputStream)stream2).close();
        }
    }

    @NotNull
    public static List<String> loadLines(@NotNull BufferedReader reader) throws IOException {
        String line;
        if (reader == null) {
            FileUtilRt.$$$reportNull$$$0(83);
        }
        ArrayList<String> lines = new ArrayList<String>();
        while ((line = reader.readLine()) != null) {
            lines.add(line);
        }
        ArrayList<String> arrayList = lines;
        if (arrayList == null) {
            FileUtilRt.$$$reportNull$$$0(84);
        }
        return arrayList;
    }

    @NotNull
    public static byte[] loadBytes(@NotNull InputStream stream2) throws IOException {
        if (stream2 == null) {
            FileUtilRt.$$$reportNull$$$0(85);
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        FileUtilRt.copy(stream2, buffer);
        byte[] byArray = buffer.toByteArray();
        if (byArray == null) {
            FileUtilRt.$$$reportNull$$$0(86);
        }
        return byArray;
    }

    public static boolean isTooLarge(long len) {
        return len > (long)LARGE_FOR_CONTENT_LOADING;
    }

    @NotNull
    public static byte[] loadBytes(@NotNull InputStream stream2, int length) throws IOException {
        int n;
        if (stream2 == null) {
            FileUtilRt.$$$reportNull$$$0(87);
        }
        if (length == 0) {
            if (ArrayUtilRt.EMPTY_BYTE_ARRAY == null) {
                FileUtilRt.$$$reportNull$$$0(88);
            }
            return ArrayUtilRt.EMPTY_BYTE_ARRAY;
        }
        byte[] bytes = new byte[length];
        for (int count2 = 0; count2 < length && (n = stream2.read(bytes, count2, length - count2)) > 0; count2 += n) {
        }
        if (bytes == null) {
            FileUtilRt.$$$reportNull$$$0(89);
        }
        return bytes;
    }

    @Nullable
    public static File getParentFile(@NotNull File file2) {
        if (file2 == null) {
            FileUtilRt.$$$reportNull$$$0(90);
        }
        int skipCount = 0;
        File parentFile = file2;
        while (true) {
            if ((parentFile = parentFile.getParentFile()) == null) {
                return null;
            }
            if (".".equals(parentFile.getName())) continue;
            if ("..".equals(parentFile.getName())) {
                ++skipCount;
                continue;
            }
            if (skipCount <= 0) break;
            --skipCount;
        }
        return parentFile;
    }

    public static boolean delete(@NotNull File file2) {
        if (file2 == null) {
            FileUtilRt.$$$reportNull$$$0(91);
        }
        if (NIOReflect.IS_AVAILABLE) {
            return FileUtilRt.deleteRecursivelyNIO(file2);
        }
        return FileUtilRt.deleteRecursively(file2);
    }

    protected static boolean deleteRecursivelyNIO(File file2) {
        try {
            Object pathObject = NIOReflect.ourFileToPathMethod.invoke((Object)file2, new Object[0]);
            NIOReflect.ourFilesWalkMethod.invoke(null, pathObject, NIOReflect.ourDeletionVisitor);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause == null || !NIOReflect.ourNoSuchFileExceptionClass.isInstance(cause)) {
                FileUtilRt.logger().info(e);
                return false;
            }
        }
        catch (Exception e) {
            FileUtilRt.logger().info(e);
            return false;
        }
        return true;
    }

    private static boolean deleteRecursively(@NotNull File file2) {
        File[] files2;
        if (file2 == null) {
            FileUtilRt.$$$reportNull$$$0(92);
        }
        if ((files2 = file2.listFiles()) != null) {
            for (File child : files2) {
                if (FileUtilRt.deleteRecursively(child)) continue;
                return false;
            }
        }
        return FileUtilRt.deleteFile(file2);
    }

    @Nullable
    public static <T, E extends Throwable> T doIOOperation(@NotNull RepeatableIOOperation<T, E> ioTask) throws E {
        if (ioTask == null) {
            FileUtilRt.$$$reportNull$$$0(93);
        }
        for (int i2 = 10; i2 > 0; --i2) {
            T result2 = ioTask.execute(i2 == 1);
            if (result2 != null) {
                return result2;
            }
            try {
                Thread.sleep(10L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return null;
    }

    protected static boolean deleteFile(final @NotNull File file2) {
        if (file2 == null) {
            FileUtilRt.$$$reportNull$$$0(94);
        }
        Boolean result2 = FileUtilRt.doIOOperation(new RepeatableIOOperation<Boolean, RuntimeException>(){

            @Override
            public Boolean execute(boolean lastAttempt) {
                if (file2.delete() || !file2.exists()) {
                    return Boolean.TRUE;
                }
                if (lastAttempt) {
                    return Boolean.FALSE;
                }
                return null;
            }
        });
        return Boolean.TRUE.equals(result2);
    }

    public static boolean ensureCanCreateFile(@NotNull File file2) {
        if (file2 == null) {
            FileUtilRt.$$$reportNull$$$0(95);
        }
        if (file2.exists()) {
            return file2.canWrite();
        }
        if (!FileUtilRt.createIfNotExists(file2)) {
            return false;
        }
        return FileUtilRt.delete(file2);
    }

    public static boolean createIfNotExists(@NotNull File file2) {
        if (file2 == null) {
            FileUtilRt.$$$reportNull$$$0(96);
        }
        if (file2.exists()) {
            return true;
        }
        try {
            if (!FileUtilRt.createParentDirs(file2)) {
                return false;
            }
            FileOutputStream s = new FileOutputStream(file2);
            ((OutputStream)s).close();
            return true;
        }
        catch (IOException e) {
            FileUtilRt.logger().info(e);
            return false;
        }
    }

    public static boolean createParentDirs(@NotNull File file2) {
        File parentFile;
        if (file2 == null) {
            FileUtilRt.$$$reportNull$$$0(97);
        }
        if (!file2.exists() && (parentFile = file2.getParentFile()) != null) {
            return FileUtilRt.createDirectory(parentFile);
        }
        return true;
    }

    public static boolean createDirectory(@NotNull File path2) {
        if (path2 == null) {
            FileUtilRt.$$$reportNull$$$0(98);
        }
        return path2.isDirectory() || path2.mkdirs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(@NotNull File fromFile, @NotNull File toFile) throws IOException {
        if (fromFile == null) {
            FileUtilRt.$$$reportNull$$$0(99);
        }
        if (toFile == null) {
            FileUtilRt.$$$reportNull$$$0(100);
        }
        if (!FileUtilRt.ensureCanCreateFile(toFile)) {
            return;
        }
        FileOutputStream fos = new FileOutputStream(toFile);
        try {
            FileInputStream fis = new FileInputStream(fromFile);
            try {
                FileUtilRt.copy(fis, fos);
            }
            finally {
                fis.close();
            }
        }
        finally {
            fos.close();
        }
        long timeStamp = fromFile.lastModified();
        if (timeStamp < 0L) {
            FileUtilRt.logger().warn("Invalid timestamp " + timeStamp + " of '" + fromFile + "'");
        } else if (!toFile.setLastModified(timeStamp)) {
            FileUtilRt.logger().warn("Unable to set timestamp " + timeStamp + " to '" + toFile + "'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(@NotNull InputStream inputStream, @NotNull OutputStream outputStream2) throws IOException {
        block10: {
            int read2;
            if (inputStream == null) {
                FileUtilRt.$$$reportNull$$$0(101);
            }
            if (outputStream2 == null) {
                FileUtilRt.$$$reportNull$$$0(102);
            }
            if (USE_FILE_CHANNELS && inputStream instanceof FileInputStream && outputStream2 instanceof FileOutputStream) {
                FileChannel fromChannel = ((FileInputStream)inputStream).getChannel();
                try {
                    FileChannel toChannel2 = ((FileOutputStream)outputStream2).getChannel();
                    try {
                        fromChannel.transferTo(0L, Long.MAX_VALUE, toChannel2);
                        break block10;
                    }
                    finally {
                        toChannel2.close();
                    }
                }
                finally {
                    fromChannel.close();
                }
            }
            byte[] buffer = FileUtilRt.getThreadLocalBuffer();
            while ((read2 = inputStream.read(buffer)) >= 0) {
                outputStream2.write(buffer, 0, read2);
            }
        }
    }

    @NotNull
    public static byte[] getThreadLocalBuffer() {
        byte[] byArray = BUFFER.get();
        if (byArray == null) {
            FileUtilRt.$$$reportNull$$$0(103);
        }
        return byArray;
    }

    public static int getUserFileSizeLimit() {
        return FileUtilRt.parseKilobyteProperty("idea.max.intellisense.filesize", 2560000);
    }

    public static int getUserContentLoadLimit() {
        return FileUtilRt.parseKilobyteProperty("idea.max.content.load.filesize", 0x1400000);
    }

    private static int getLargeFilePreviewSize() {
        return FileUtilRt.parseKilobyteProperty("idea.max.content.load.large.preview.size", 2560000);
    }

    private static int parseKilobyteProperty(String key, int defaultValue) {
        try {
            long i2 = Integer.parseInt(System.getProperty(key));
            if (i2 < 0L) {
                return Integer.MAX_VALUE;
            }
            return (int)Math.min(i2 * 1024L, Integer.MAX_VALUE);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    private static LoggerRt logger() {
        return LoggerRt.getInstance("#com.intellij.openapi.util.io.FileUtilRt");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 9: 
            case 11: 
            case 13: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 29: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 42: 
            case 45: 
            case 49: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 58: 
            case 60: 
            case 62: 
            case 64: 
            case 66: 
            case 68: 
            case 71: 
            case 73: 
            case 74: 
            case 76: 
            case 78: 
            case 80: 
            case 82: 
            case 84: 
            case 86: 
            case 88: 
            case 89: 
            case 103: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 9: 
            case 11: 
            case 13: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 29: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 42: 
            case 45: 
            case 49: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 58: 
            case 60: 
            case 62: 
            case 64: 
            case 66: 
            case 68: 
            case 71: 
            case 73: 
            case 74: 
            case 76: 
            case 78: 
            case 80: 
            case 82: 
            case 84: 
            case 86: 
            case 88: 
            case 89: 
            case 103: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 9: 
            case 11: 
            case 13: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 29: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 42: 
            case 45: 
            case 49: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 58: 
            case 60: 
            case 62: 
            case 64: 
            case 66: 
            case 68: 
            case 71: 
            case 73: 
            case 74: 
            case 76: 
            case 78: 
            case 80: 
            case 82: 
            case 84: 
            case 86: 
            case 88: 
            case 89: 
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/io/FileUtilRt";
                break;
            }
            case 6: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "basePath";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 23: 
            case 25: 
            case 28: 
            case 31: 
            case 33: 
            case 35: 
            case 37: 
            case 39: 
            case 41: 
            case 44: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 27: 
            case 30: 
            case 43: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "temp";
                break;
            }
            case 56: 
            case 79: 
            case 81: 
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 57: 
            case 59: 
            case 61: 
            case 63: 
            case 65: 
            case 67: 
            case 69: 
            case 75: 
            case 77: 
            case 90: 
            case 91: 
            case 92: 
            case 94: 
            case 95: 
            case 96: 
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "encoding";
                break;
            }
            case 72: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 85: 
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ioTask";
                break;
            }
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromFile";
                break;
            }
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toFile";
                break;
            }
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/io/FileUtilRt";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtension";
                break;
            }
            case 9: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "toSystemDependentName";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "toSystemIndependentName";
                break;
            }
            case 20: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameWithoutExtension";
                break;
            }
            case 24: 
            case 26: 
            case 29: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "createTempDirectory";
                break;
            }
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "createTempFile";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreateTempFile";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "calcName";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizeFile";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getTempDirectory";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "calcCanonicalTempPath";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "generateRandomTemporaryPath";
                break;
            }
            case 58: 
            case 60: 
            case 62: 
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "loadFile";
                break;
            }
            case 66: 
            case 68: 
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "loadFileText";
                break;
            }
            case 73: 
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "loadText";
                break;
            }
            case 76: 
            case 78: 
            case 80: 
            case 82: 
            case 84: {
                objectArray = objectArray2;
                objectArray2[1] = "loadLines";
                break;
            }
            case 86: 
            case 88: 
            case 89: {
                objectArray = objectArray2;
                objectArray2[1] = "loadBytes";
                break;
            }
            case 103: {
                objectArray = objectArray2;
                objectArray2[1] = "getThreadLocalBuffer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getExtension";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 9: 
            case 11: 
            case 13: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 29: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 42: 
            case 45: 
            case 49: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 58: 
            case 60: 
            case 62: 
            case 64: 
            case 66: 
            case 68: 
            case 71: 
            case 73: 
            case 74: 
            case 76: 
            case 78: 
            case 80: 
            case 82: 
            case 84: 
            case 86: 
            case 88: 
            case 89: 
            case 103: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "extensionEquals";
                break;
            }
            case 8: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "toSystemDependentName";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "toSystemIndependentName";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getRelativePath";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "ensureEnds";
                break;
            }
            case 19: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getNameWithoutExtension";
                break;
            }
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "createTempDirectory";
                break;
            }
            case 33: 
            case 35: 
            case 37: 
            case 39: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "createTempFile";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "doCreateTempFile";
                break;
            }
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "calcName";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "normalizeFile";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "setExecutableAttribute";
                break;
            }
            case 57: 
            case 59: 
            case 61: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "loadFile";
                break;
            }
            case 65: 
            case 67: 
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "loadFileText";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "loadText";
                break;
            }
            case 75: 
            case 77: 
            case 79: 
            case 81: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "loadLines";
                break;
            }
            case 85: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "loadBytes";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "getParentFile";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "delete";
                break;
            }
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "deleteRecursively";
                break;
            }
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "doIOOperation";
                break;
            }
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "deleteFile";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "ensureCanCreateFile";
                break;
            }
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "createIfNotExists";
                break;
            }
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "createParentDirs";
                break;
            }
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "createDirectory";
                break;
            }
            case 99: 
            case 100: 
            case 101: 
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "copy";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 9: 
            case 11: 
            case 13: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 29: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 40: 
            case 42: 
            case 45: 
            case 49: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 58: 
            case 60: 
            case 62: 
            case 64: 
            case 66: 
            case 68: 
            case 71: 
            case 73: 
            case 74: 
            case 76: 
            case 78: 
            case 80: 
            case 82: 
            case 84: 
            case 86: 
            case 88: 
            case 89: 
            case 103: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static interface CharComparingStrategy {
        public static final CharComparingStrategy IDENTITY = new CharComparingStrategy(){

            public boolean charsEqual(char ch1, char ch2) {
                return ch1 == ch2;
            }
        };
        public static final CharComparingStrategy CASE_INSENSITIVE = new CharComparingStrategy(){

            public boolean charsEqual(char ch1, char ch2) {
                return StringUtilRt.charsEqualIgnoreCase(ch1, ch2);
            }
        };

        public boolean charsEqual(char var1, char var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface RepeatableIOOperation<T, E extends Throwable> {
        @Nullable
        public T execute(boolean var1) throws E;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FilesToDeleteHolder {
        private static final Queue<String> ourFilesToDelete = FilesToDeleteHolder.createFilesToDelete();

        private FilesToDeleteHolder() {
        }

        private static Queue<String> createFilesToDelete() {
            final ConcurrentLinkedQueue<String> queue = new ConcurrentLinkedQueue<String>();
            Runtime.getRuntime().addShutdownHook(new Thread("FileUtil deleteOnExit"){

                public void run() {
                    String name = (String)queue.poll();
                    while (name != null) {
                        FileUtilRt.delete(new File(name));
                        name = (String)queue.poll();
                    }
                }
            });
            return queue;
        }
    }

    protected static final class NIOReflect {
        static final boolean IS_AVAILABLE;
        private static Method ourFilesDeleteIfExistsMethod;
        private static Method ourFilesWalkMethod;
        private static Method ourFileToPathMethod;
        private static Method ourPathToFileMethod;
        private static Method ourAttributesIsOtherMethod;
        private static Object ourDeletionVisitor;
        private static Class ourNoSuchFileExceptionClass;
        private static Class ourAccessDeniedExceptionClass;

        protected NIOReflect() {
        }

        static {
            boolean initSuccess = false;
            try {
                Class<?> pathClass = Class.forName("java.nio.file.Path");
                Class<?> visitorClass = Class.forName("java.nio.file.FileVisitor");
                Class<?> filesClass = Class.forName("java.nio.file.Files");
                ourNoSuchFileExceptionClass = Class.forName("java.nio.file.NoSuchFileException");
                ourAccessDeniedExceptionClass = Class.forName("java.nio.file.AccessDeniedException");
                ourFileToPathMethod = Class.forName("java.io.File").getMethod("toPath", new Class[0]);
                ourPathToFileMethod = pathClass.getMethod("toFile", new Class[0]);
                ourFilesWalkMethod = filesClass.getMethod("walkFileTree", pathClass, visitorClass);
                ourAttributesIsOtherMethod = Class.forName("java.nio.file.attribute.BasicFileAttributes").getDeclaredMethod("isOther", new Class[0]);
                ourFilesDeleteIfExistsMethod = filesClass.getMethod("deleteIfExists", pathClass);
                final Object Result_Continue = Class.forName("java.nio.file.FileVisitResult").getDeclaredField("CONTINUE").get(null);
                final Object Result_Skip = Class.forName("java.nio.file.FileVisitResult").getDeclaredField("SKIP_SUBTREE").get(null);
                ourDeletionVisitor = Proxy.newProxyInstance(FileUtilRt.class.getClassLoader(), new Class[]{visitorClass}, new InvocationHandler(){

                    public Object invoke(Object proxy2, Method method, Object[] args) throws Throwable {
                        if (args.length == 2) {
                            Object second = args[1];
                            if (second instanceof Throwable) {
                                throw (Throwable)second;
                            }
                            String methodName = method.getName();
                            if ("visitFile".equals(methodName) || "postVisitDirectory".equals(methodName)) {
                                this.performDelete(args[0]);
                            } else if (SystemInfoRt.isWindows && "preVisitDirectory".equals(methodName)) {
                                boolean notDirectory = false;
                                try {
                                    notDirectory = Boolean.TRUE.equals(ourAttributesIsOtherMethod.invoke(second, new Object[0]));
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                                if (notDirectory) {
                                    this.performDelete(args[0]);
                                    return Result_Skip;
                                }
                            }
                        }
                        return Result_Continue;
                    }

                    private void performDelete(final Object fileObject) throws IOException {
                        Boolean result2 = FileUtilRt.doIOOperation(new RepeatableIOOperation<Boolean, RuntimeException>(){

                            @Override
                            public Boolean execute(boolean lastAttempt) {
                                block8: {
                                    try {
                                        ourFilesDeleteIfExistsMethod.invoke(null, fileObject);
                                        return Boolean.TRUE;
                                    }
                                    catch (InvocationTargetException e) {
                                        Throwable cause = e.getCause();
                                        if (!(cause instanceof IOException)) {
                                            return Boolean.FALSE;
                                        }
                                        if (!ourAccessDeniedExceptionClass.isInstance(cause)) break block8;
                                        try {
                                            File file2 = (File)ourPathToFileMethod.invoke(fileObject, new Object[0]);
                                            if (file2 == null) {
                                                return Boolean.FALSE;
                                            }
                                            if (file2.delete() || !file2.exists()) {
                                                return Boolean.TRUE;
                                            }
                                        }
                                        catch (Throwable ignored) {
                                            return Boolean.FALSE;
                                        }
                                    }
                                    catch (IllegalAccessException e) {
                                        return Boolean.FALSE;
                                    }
                                }
                                return lastAttempt ? Boolean.FALSE : null;
                            }
                        });
                        if (!Boolean.TRUE.equals(result2)) {
                            throw new IOException("Failed to delete " + fileObject){

                                public synchronized Throwable fillInStackTrace() {
                                    return this;
                                }
                            };
                        }
                    }
                });
                initSuccess = true;
            }
            catch (Throwable ignored) {
                FileUtilRt.logger().info("Was not able to detect NIO API");
                ourFileToPathMethod = null;
                ourFilesWalkMethod = null;
                ourFilesDeleteIfExistsMethod = null;
                ourDeletionVisitor = null;
                ourNoSuchFileExceptionClass = null;
            }
            IS_AVAILABLE = initSuccess;
        }
    }
}

