/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.text;

import gnu.trove.TIntProcedure;

class AddonlyIntSet {
    private int size;
    private int[] data;
    private int shift;
    private int mask;
    private boolean hasZeroKey;

    public AddonlyIntSet() {
        this(21);
    }

    public AddonlyIntSet(int expectedSize) {
        int powerOfTwo = Integer.highestOneBit(3 * expectedSize / 2) << 1;
        this.shift = Integer.numberOfLeadingZeros(powerOfTwo) + 1;
        this.mask = powerOfTwo - 1;
        this.data = new int[powerOfTwo];
    }

    public int size() {
        return this.size;
    }

    private int hash(int h, int[] a2) {
        h ^= h >>> 20 ^ h >>> 12;
        return (h ^ h >>> 7 ^ h >>> 4) & this.mask;
    }

    public void add(int key) {
        if (key == 0) {
            if (!this.hasZeroKey) {
                ++this.size;
            }
            this.hasZeroKey = true;
            return;
        }
        if (this.size >= 2 * this.data.length / 3) {
            this.rehash();
        }
        if (this.doPut(this.data, key)) {
            ++this.size;
        }
    }

    private boolean doPut(int[] a2, int o) {
        int obj;
        int index2 = this.hash(o, a2);
        while ((obj = a2[index2]) != 0 && obj != o) {
            if (index2 == 0) {
                index2 = a2.length;
            }
            --index2;
        }
        a2[index2] = o;
        return obj == 0;
    }

    private void rehash() {
        --this.shift;
        int[] b2 = new int[this.data.length << 1];
        this.mask = b2.length - 1;
        int i2 = this.data.length;
        while (--i2 >= 0) {
            int ns = this.data[i2];
            if (ns == 0) continue;
            this.doPut(b2, ns);
        }
        this.data = b2;
    }

    public boolean contains(int key) {
        int v;
        if (key == 0) {
            return this.hasZeroKey;
        }
        int index2 = this.hash(key, this.data);
        while ((v = this.data[index2]) != 0) {
            if (v == key) {
                return true;
            }
            if (index2 == 0) {
                index2 = this.data.length;
            }
            --index2;
        }
        return false;
    }

    public boolean forEach(TIntProcedure consumer) {
        if (this.hasZeroKey && !consumer.execute(0)) {
            return false;
        }
        for (int o : this.data) {
            if (o == 0 || consumer.execute(o)) continue;
            return false;
        }
        return true;
    }
}

