/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.text;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.CharFilter;
import com.intellij.openapi.util.text.CharSequenceWithStringHash;
import com.intellij.openapi.util.text.NaturalComparator;
import com.intellij.openapi.util.text.Pluralizer;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.LineSeparator;
import com.intellij.util.NotNullFunction;
import com.intellij.util.SmartList;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.CharSequenceSubSequence;
import com.intellij.util.text.StringFactory;
import com.intellij.util.text.StringTokenizer;
import java.beans.Introspector;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringUtil
extends StringUtilRt {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.util.text.StringUtil");
    @NonNls
    private static final String VOWELS = "aeiouy";
    @NonNls
    private static final Pattern EOL_SPLIT_KEEP_SEPARATORS = Pattern.compile("(?<=(\r\n|\n))|(?<=\r)(?=[^\n])");
    @NonNls
    private static final Pattern EOL_SPLIT_PATTERN = Pattern.compile(" *(\r|\n|\r\n)+ *");
    @NonNls
    private static final Pattern EOL_SPLIT_PATTERN_WITH_EMPTY = Pattern.compile(" *(\r|\n|\r\n) *");
    @NonNls
    private static final Pattern EOL_SPLIT_DONT_TRIM_PATTERN = Pattern.compile("(\r|\n|\r\n)+");
    private static final MyHtml2Text html2TextParser = new MyHtml2Text();
    public static final NotNullFunction<String, String> QUOTER = new NotNullFunction<String, String>(){

        @Override
        @NotNull
        public String fun(String s) {
            String string = "\"" + s + "\"";
            if (string == null) {
                1.$$$reportNull$$$0(0);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil$1", "fun"));
        }
    };
    public static final NotNullFunction<String, String> SINGLE_QUOTER = new NotNullFunction<String, String>(){

        @Override
        @NotNull
        public String fun(String s) {
            String string = "'" + s + "'";
            if (string == null) {
                2.$$$reportNull$$$0(0);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil$2", "fun"));
        }
    };
    @NotNull
    public static final Function<String, String> TRIMMER = new Function<String, String>(){

        @Override
        @Nullable
        public String fun(@Nullable String s) {
            return StringUtil.trim(s);
        }
    };
    @NonNls
    private static final String[] ourPrepositions = new String[]{"a", "an", "and", "as", "at", "but", "by", "down", "for", "from", "if", "in", "into", "not", "of", "on", "onto", "or", "out", "over", "per", "nor", "the", "to", "up", "upon", "via", "with"};
    @NonNls
    private static final String[] REPLACES_REFS = new String[]{"&lt;", "&gt;", "&amp;", "&#39;", "&quot;"};
    @NonNls
    private static final String[] REPLACES_DISP = new String[]{"<", ">", "&", "'", "\""};
    @NonNls
    private static final String[] MN_QUOTED = new String[]{"&&", "__"};
    @NonNls
    private static final String[] MN_CHARS = new String[]{"&", "_"};
    private static final Pattern UNICODE_CHAR = Pattern.compile("\\\\u[0-9a-eA-E]{4}");

    @NotNull
    @Contract(pure=true)
    public static List<String> getWordsInStringLongestFirst(@NotNull String find) {
        if (find == null) {
            StringUtil.$$$reportNull$$$0(0);
        }
        List<String> words = StringUtil.getWordsIn(find);
        Collections.sort(words, new Comparator<String>(){

            @Override
            public int compare(@NotNull String o1, @NotNull String o2) {
                if (o1 == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (o2 == null) {
                    3.$$$reportNull$$$0(1);
                }
                return o2.length() - o1.length();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "o1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "o2";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/openapi/util/text/StringUtil$3";
                objectArray[2] = "compare";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        List<String> list2 = words;
        if (list2 == null) {
            StringUtil.$$$reportNull$$$0(1);
        }
        return list2;
    }

    @NotNull
    @Contract(pure=true)
    public static String escapePattern(@NotNull String text2) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(2);
        }
        String string = StringUtil.replace(StringUtil.replace(text2, "'", "''"), "{", "'{'");
        if (string == null) {
            StringUtil.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Function<T, String> createToStringFunction(@NotNull Class<T> cls) {
        if (cls == null) {
            StringUtil.$$$reportNull$$$0(4);
        }
        Function function2 = new Function<T, String>(){

            @Override
            public String fun(@NotNull T o) {
                if (o == null) {
                    4.$$$reportNull$$$0(0);
                }
                return o.toString();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/openapi/util/text/StringUtil$4", "fun"));
            }
        };
        if (function2 == null) {
            StringUtil.$$$reportNull$$$0(5);
        }
        return function2;
    }

    @NotNull
    @Contract(pure=true)
    public static String replace(@NonNls @NotNull String text2, @NonNls @NotNull String oldS, @NonNls @NotNull String newS) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(6);
        }
        if (oldS == null) {
            StringUtil.$$$reportNull$$$0(7);
        }
        if (newS == null) {
            StringUtil.$$$reportNull$$$0(8);
        }
        String string = StringUtil.replace(text2, oldS, newS, false);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String replaceIgnoreCase(@NonNls @NotNull String text2, @NonNls @NotNull String oldS, @NonNls @NotNull String newS) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(10);
        }
        if (oldS == null) {
            StringUtil.$$$reportNull$$$0(11);
        }
        if (newS == null) {
            StringUtil.$$$reportNull$$$0(12);
        }
        String string = StringUtil.replace(text2, oldS, newS, true);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(13);
        }
        return string;
    }

    @Deprecated
    @NotNull
    @Contract(pure=true)
    public static String replaceChar(@NotNull String buffer, char oldChar, char newChar) {
        if (buffer == null) {
            StringUtil.$$$reportNull$$$0(14);
        }
        String string = buffer.replace(oldChar, newChar);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(15);
        }
        return string;
    }

    @Contract(pure=true)
    public static String replace(@NonNls @NotNull String text2, @NonNls @NotNull String oldS, @NonNls @NotNull String newS, boolean ignoreCase) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(16);
        }
        if (oldS == null) {
            StringUtil.$$$reportNull$$$0(17);
        }
        if (newS == null) {
            StringUtil.$$$reportNull$$$0(18);
        }
        if (text2.length() < oldS.length()) {
            return text2;
        }
        StringBuilder newText = null;
        int i2 = 0;
        while (i2 < text2.length()) {
            int index2;
            int n = index2 = ignoreCase ? StringUtil.indexOfIgnoreCase(text2, oldS, i2) : text2.indexOf(oldS, i2);
            if (index2 < 0) {
                if (i2 == 0) {
                    return text2;
                }
                newText.append(text2, i2, text2.length());
                break;
            }
            if (newText == null) {
                if (text2.length() == oldS.length()) {
                    return newS;
                }
                newText = new StringBuilder(text2.length() - i2);
            }
            newText.append(text2, i2, index2);
            newText.append(newS);
            i2 = index2 + oldS.length();
        }
        return newText != null ? newText.toString() : "";
    }

    @Contract(pure=true)
    public static int indexOfIgnoreCase(@NotNull String where, @NotNull String what, int fromIndex) {
        if (where == null) {
            StringUtil.$$$reportNull$$$0(19);
        }
        if (what == null) {
            StringUtil.$$$reportNull$$$0(20);
        }
        int targetCount = what.length();
        int sourceCount = where.length();
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        char first2 = what.charAt(0);
        int max = sourceCount - targetCount;
        for (int i2 = fromIndex; i2 <= max; ++i2) {
            if (!StringUtil.charsEqualIgnoreCase(where.charAt(i2), first2)) {
                while (++i2 <= max && !StringUtil.charsEqualIgnoreCase(where.charAt(i2), first2)) {
                }
            }
            if (i2 > max) continue;
            int j = i2 + 1;
            int end = j + targetCount - 1;
            int k = 1;
            while (j < end && StringUtil.charsEqualIgnoreCase(where.charAt(j), what.charAt(k))) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return i2;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int indexOfIgnoreCase(@NotNull String where, char what, int fromIndex) {
        if (where == null) {
            StringUtil.$$$reportNull$$$0(21);
        }
        int sourceCount = where.length();
        for (int i2 = Math.max(fromIndex, 0); i2 < sourceCount; ++i2) {
            if (!StringUtil.charsEqualIgnoreCase(where.charAt(i2), what)) continue;
            return i2;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int lastIndexOfIgnoreCase(@NotNull String where, char what, int fromIndex) {
        if (where == null) {
            StringUtil.$$$reportNull$$$0(22);
        }
        for (int i2 = Math.min(fromIndex, where.length() - 1); i2 >= 0; --i2) {
            if (!StringUtil.charsEqualIgnoreCase(where.charAt(i2), what)) continue;
            return i2;
        }
        return -1;
    }

    @Contract(pure=true)
    public static boolean containsIgnoreCase(@NotNull String where, @NotNull String what) {
        if (where == null) {
            StringUtil.$$$reportNull$$$0(23);
        }
        if (what == null) {
            StringUtil.$$$reportNull$$$0(24);
        }
        return StringUtil.indexOfIgnoreCase(where, what, 0) >= 0;
    }

    @Contract(pure=true)
    public static boolean endsWithIgnoreCase(@NonNls @NotNull String str, @NonNls @NotNull String suffix) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(25);
        }
        if (suffix == null) {
            StringUtil.$$$reportNull$$$0(26);
        }
        return StringUtilRt.endsWithIgnoreCase(str, suffix);
    }

    @Contract(pure=true)
    public static boolean startsWithIgnoreCase(@NonNls @NotNull String str, @NonNls @NotNull String prefix) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(27);
        }
        if (prefix == null) {
            StringUtil.$$$reportNull$$$0(28);
        }
        return StringUtilRt.startsWithIgnoreCase(str, prefix);
    }

    @Contract(pure=true)
    @NotNull
    public static String stripHtml(@NotNull String html2, boolean convertBreaks) {
        if (html2 == null) {
            StringUtil.$$$reportNull$$$0(29);
        }
        if (convertBreaks) {
            html2 = html2.replaceAll("<br/?>", "\n\n");
        }
        String string = html2.replaceAll("<(.|\n)*?>", "");
        if (string == null) {
            StringUtil.$$$reportNull$$$0(30);
        }
        return string;
    }

    @Contract(value="null -> null; !null -> !null", pure=true)
    public static String toLowerCase(@Nullable String str) {
        return str == null ? null : str.toLowerCase();
    }

    @NotNull
    @Contract(pure=true)
    public static String getPackageName(@NotNull String fqName2) {
        if (fqName2 == null) {
            StringUtil.$$$reportNull$$$0(31);
        }
        String string = StringUtil.getPackageName(fqName2, '.');
        if (string == null) {
            StringUtil.$$$reportNull$$$0(32);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String getPackageName(@NotNull String fqName2, char separator) {
        int lastPointIdx;
        if (fqName2 == null) {
            StringUtil.$$$reportNull$$$0(33);
        }
        if ((lastPointIdx = fqName2.lastIndexOf(separator)) >= 0) {
            String string = fqName2.substring(0, lastPointIdx);
            if (string == null) {
                StringUtil.$$$reportNull$$$0(34);
            }
            return string;
        }
        if ("" == null) {
            StringUtil.$$$reportNull$$$0(35);
        }
        return "";
    }

    @Contract(pure=true)
    public static int getLineBreakCount(@NotNull CharSequence text2) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(36);
        }
        int count2 = 0;
        for (int i2 = 0; i2 < text2.length(); ++i2) {
            char c = text2.charAt(i2);
            if (c == '\n') {
                ++count2;
                continue;
            }
            if (c != '\r') continue;
            if (i2 + 1 < text2.length() && text2.charAt(i2 + 1) == '\n') {
                ++i2;
                ++count2;
                continue;
            }
            ++count2;
        }
        return count2;
    }

    @Contract(pure=true)
    public static boolean containsLineBreak(@NotNull CharSequence text2) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(37);
        }
        for (int i2 = 0; i2 < text2.length(); ++i2) {
            char c = text2.charAt(i2);
            if (!StringUtil.isLineBreak(c)) continue;
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    public static boolean isLineBreak(char c) {
        return c == '\n' || c == '\r';
    }

    @NotNull
    @Contract(pure=true)
    public static String escapeLineBreak(@NotNull String text2) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(38);
        }
        StringBuilder buffer = new StringBuilder(text2.length());
        block4: for (int i2 = 0; i2 < text2.length(); ++i2) {
            char c = text2.charAt(i2);
            switch (c) {
                case '\n': {
                    buffer.append("\\n");
                    continue block4;
                }
                case '\r': {
                    buffer.append("\\r");
                    continue block4;
                }
                default: {
                    buffer.append(c);
                }
            }
        }
        String string = buffer.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(39);
        }
        return string;
    }

    @Contract(pure=true)
    public static boolean endsWithLineBreak(@NotNull CharSequence text2) {
        int len;
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(40);
        }
        return (len = text2.length()) > 0 && StringUtil.isLineBreak(text2.charAt(len - 1));
    }

    @Contract(pure=true)
    public static int lineColToOffset(@NotNull CharSequence text2, int line, int col2) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(41);
        }
        int curLine = 0;
        int offset2 = 0;
        while (line != curLine) {
            if (offset2 == text2.length()) {
                return -1;
            }
            char c = text2.charAt(offset2);
            if (c == '\n') {
                ++curLine;
            } else if (c == '\r') {
                ++curLine;
                if (offset2 < text2.length() - 1 && text2.charAt(offset2 + 1) == '\n') {
                    ++offset2;
                }
            }
            ++offset2;
        }
        return offset2 + col2;
    }

    @Contract(pure=true)
    public static int offsetToLineNumber(@NotNull CharSequence text2, int offset2) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(42);
        }
        int curLine = 0;
        for (int curOffset = 0; curOffset < offset2; ++curOffset) {
            if (curOffset == text2.length()) {
                return -1;
            }
            char c = text2.charAt(curOffset);
            if (c == '\n') {
                ++curLine;
                continue;
            }
            if (c != '\r') continue;
            ++curLine;
            if (curOffset >= text2.length() - 1 || text2.charAt(curOffset + 1) != '\n') continue;
            ++curOffset;
        }
        return curLine;
    }

    @Contract(pure=true)
    public static int difference(@NotNull String s1, @NotNull String s2) {
        int i2;
        if (s1 == null) {
            StringUtil.$$$reportNull$$$0(43);
        }
        if (s2 == null) {
            StringUtil.$$$reportNull$$$0(44);
        }
        int[][] a2 = new int[s1.length()][s2.length()];
        for (i2 = 0; i2 < s1.length(); ++i2) {
            a2[i2][0] = i2;
        }
        for (int j = 0; j < s2.length(); ++j) {
            a2[0][j] = j;
        }
        for (i2 = 1; i2 < s1.length(); ++i2) {
            for (int j = 1; j < s2.length(); ++j) {
                a2[i2][j] = Math.min(Math.min(a2[i2 - 1][j - 1] + (s1.charAt(i2) == s2.charAt(j) ? 0 : 1), a2[i2 - 1][j] + 1), a2[i2][j - 1] + 1);
            }
        }
        return a2[s1.length() - 1][s2.length() - 1];
    }

    @NotNull
    @Contract(pure=true)
    public static String wordsToBeginFromUpperCase(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(45);
        }
        String string = StringUtil.fixCapitalization(s, ourPrepositions, true);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(46);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String wordsToBeginFromLowerCase(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(47);
        }
        String string = StringUtil.fixCapitalization(s, ourPrepositions, false);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(48);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String toTitleCase(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(49);
        }
        String string = StringUtil.fixCapitalization(s, ArrayUtil.EMPTY_STRING_ARRAY, true);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(50);
        }
        return string;
    }

    @NotNull
    private static String fixCapitalization(@NotNull String s, @NotNull String[] prepositions, boolean title2) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(51);
        }
        if (prepositions == null) {
            StringUtil.$$$reportNull$$$0(52);
        }
        StringBuilder buffer = null;
        for (int i2 = 0; i2 < s.length(); ++i2) {
            int j;
            char prevChar = i2 == 0 ? (char)' ' : (char)s.charAt(i2 - 1);
            char currChar = s.charAt(i2);
            if (Character.isLetterOrDigit(prevChar) || prevChar == 39 || !Character.isLetterOrDigit(currChar) || !title2 && !Character.isUpperCase(currChar)) continue;
            for (j = i2; j < s.length() && Character.isLetterOrDigit(s.charAt(j)); ++j) {
            }
            if (!title2 && j > i2 + 1 && !Character.isLowerCase(s.charAt(i2 + 1)) || StringUtil.isPreposition(s, i2, j - 1, prepositions)) continue;
            if (buffer == null) {
                buffer = new StringBuilder(s);
            }
            buffer.setCharAt(i2, title2 ? StringUtil.toUpperCase(currChar) : StringUtil.toLowerCase(currChar));
        }
        String string = buffer == null ? s : buffer.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(53);
        }
        return string;
    }

    @Contract(pure=true)
    public static boolean isPreposition(@NotNull String s, int firstChar, int lastChar) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(54);
        }
        return StringUtil.isPreposition(s, firstChar, lastChar, ourPrepositions);
    }

    @Contract(pure=true)
    public static boolean isPreposition(@NotNull String s, int firstChar, int lastChar, @NotNull String[] prepositions) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(55);
        }
        if (prepositions == null) {
            StringUtil.$$$reportNull$$$0(56);
        }
        for (String preposition : prepositions) {
            boolean found = false;
            if (lastChar - firstChar + 1 == preposition.length()) {
                found = true;
                for (int j = 0; j < preposition.length(); ++j) {
                    if (StringUtil.toLowerCase(s.charAt(firstChar + j)) == preposition.charAt(j)) continue;
                    found = false;
                }
            }
            if (!found) continue;
            return true;
        }
        return false;
    }

    @NotNull
    @Contract(pure=true)
    public static NotNullFunction<String, String> escaper(final boolean escapeSlash, final @Nullable String additionalChars) {
        NotNullFunction<String, String> notNullFunction = new NotNullFunction<String, String>(){

            @Override
            @NotNull
            public String fun(@NotNull String dom) {
                if (dom == null) {
                    6.$$$reportNull$$$0(0);
                }
                StringBuilder builder = new StringBuilder(dom.length());
                StringUtil.escapeStringCharacters(dom.length(), dom, additionalChars, escapeSlash, builder);
                String string = builder.toString();
                if (string == null) {
                    6.$$$reportNull$$$0(1);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dom";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/util/text/StringUtil$6";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/util/text/StringUtil$6";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "fun";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "fun";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (notNullFunction == null) {
            StringUtil.$$$reportNull$$$0(57);
        }
        return notNullFunction;
    }

    public static void escapeStringCharacters(int length, @NotNull String str, @NotNull @NonNls StringBuilder buffer) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(58);
        }
        if (buffer == null) {
            StringUtil.$$$reportNull$$$0(59);
        }
        StringUtil.escapeStringCharacters(length, str, "\"", buffer);
    }

    @NotNull
    public static StringBuilder escapeStringCharacters(int length, @NotNull String str, @Nullable String additionalChars, @NotNull @NonNls StringBuilder buffer) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(60);
        }
        if (buffer == null) {
            StringUtil.$$$reportNull$$$0(61);
        }
        StringBuilder stringBuilder = StringUtil.escapeStringCharacters(length, str, additionalChars, true, buffer);
        if (stringBuilder == null) {
            StringUtil.$$$reportNull$$$0(62);
        }
        return stringBuilder;
    }

    @NotNull
    public static StringBuilder escapeStringCharacters(int length, @NotNull String str, @Nullable String additionalChars, boolean escapeSlash, @NotNull @NonNls StringBuilder buffer) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(63);
        }
        if (buffer == null) {
            StringUtil.$$$reportNull$$$0(64);
        }
        StringBuilder stringBuilder = StringUtil.escapeStringCharacters(length, str, additionalChars, escapeSlash, true, buffer);
        if (stringBuilder == null) {
            StringUtil.$$$reportNull$$$0(65);
        }
        return stringBuilder;
    }

    @NotNull
    public static StringBuilder escapeStringCharacters(int length, @NotNull String str, @Nullable String additionalChars, boolean escapeSlash, boolean escapeUnicode, @NotNull @NonNls StringBuilder buffer) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(66);
        }
        if (buffer == null) {
            StringUtil.$$$reportNull$$$0(67);
        }
        char prev = '\u0000';
        for (int idx = 0; idx < length; ++idx) {
            char ch = str.charAt(idx);
            switch (ch) {
                case '\b': {
                    buffer.append("\\b");
                    break;
                }
                case '\t': {
                    buffer.append("\\t");
                    break;
                }
                case '\n': {
                    buffer.append("\\n");
                    break;
                }
                case '\f': {
                    buffer.append("\\f");
                    break;
                }
                case '\r': {
                    buffer.append("\\r");
                    break;
                }
                default: {
                    if (escapeSlash && ch == '\\') {
                        buffer.append("\\\\");
                        break;
                    }
                    if (additionalChars != null && additionalChars.indexOf(ch) > -1 && (escapeSlash || prev != '\\')) {
                        buffer.append("\\").append(ch);
                        break;
                    }
                    if (escapeUnicode && !StringUtil.isPrintableUnicode(ch)) {
                        CharSequence hexCode = StringUtilRt.toUpperCase(Integer.toHexString(ch));
                        buffer.append("\\u");
                        int paddingCount = 4 - hexCode.length();
                        while (paddingCount-- > 0) {
                            buffer.append(0);
                        }
                        buffer.append(hexCode);
                        break;
                    }
                    buffer.append(ch);
                }
            }
            prev = ch;
        }
        StringBuilder stringBuilder = buffer;
        if (stringBuilder == null) {
            StringUtil.$$$reportNull$$$0(68);
        }
        return stringBuilder;
    }

    @Contract(pure=true)
    public static boolean isPrintableUnicode(char c) {
        int t = Character.getType(c);
        return t != 0 && t != 13 && t != 14 && t != 15 && t != 16 && t != 18 && t != 19;
    }

    @NotNull
    @Contract(pure=true)
    public static String escapeStringCharacters(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(69);
        }
        StringBuilder buffer = new StringBuilder(s.length());
        StringUtil.escapeStringCharacters(s.length(), s, "\"", buffer);
        String string = buffer.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(70);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String escapeCharCharacters(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(71);
        }
        StringBuilder buffer = new StringBuilder(s.length());
        StringUtil.escapeStringCharacters(s.length(), s, "'", buffer);
        String string = buffer.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(72);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String unescapeStringCharacters(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(73);
        }
        StringBuilder buffer = new StringBuilder(s.length());
        StringUtil.unescapeStringCharacters(s.length(), s, buffer);
        String string = buffer.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(74);
        }
        return string;
    }

    private static boolean isQuoteAt(@NotNull String s, int ind) {
        char ch;
        if (s == null) {
            StringUtil.$$$reportNull$$$0(75);
        }
        return (ch = s.charAt(ind)) == '\'' || ch == '\"';
    }

    @Contract(pure=true)
    public static boolean isQuotedString(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(76);
        }
        return s.length() > 1 && StringUtil.isQuoteAt(s, 0) && s.charAt(0) == s.charAt(s.length() - 1);
    }

    @NotNull
    @Contract(pure=true)
    public static String unquoteString(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(77);
        }
        if (StringUtil.isQuotedString(s)) {
            String string = s.substring(1, s.length() - 1);
            if (string == null) {
                StringUtil.$$$reportNull$$$0(78);
            }
            return string;
        }
        String string = s;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(79);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String unquoteString(@NotNull String s, char quotationChar) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(80);
        }
        if (s.length() > 1 && quotationChar == s.charAt(0) && quotationChar == s.charAt(s.length() - 1)) {
            String string = s.substring(1, s.length() - 1);
            if (string == null) {
                StringUtil.$$$reportNull$$$0(81);
            }
            return string;
        }
        String string = s;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(82);
        }
        return string;
    }

    private static void unescapeStringCharacters(int length, @NotNull String s, @NotNull StringBuilder buffer) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(83);
        }
        if (buffer == null) {
            StringUtil.$$$reportNull$$$0(84);
        }
        boolean escaped = false;
        for (int idx = 0; idx < length; ++idx) {
            char ch = s.charAt(idx);
            if (!escaped) {
                if (ch == '\\') {
                    escaped = true;
                    continue;
                }
                buffer.append(ch);
                continue;
            }
            int octalEscapeMaxLength = 2;
            switch (ch) {
                case 'n': {
                    buffer.append('\n');
                    break;
                }
                case 'r': {
                    buffer.append('\r');
                    break;
                }
                case 'b': {
                    buffer.append('\b');
                    break;
                }
                case 't': {
                    buffer.append('\t');
                    break;
                }
                case 'f': {
                    buffer.append('\f');
                    break;
                }
                case '\'': {
                    buffer.append('\'');
                    break;
                }
                case '\"': {
                    buffer.append('\"');
                    break;
                }
                case '\\': {
                    buffer.append('\\');
                    break;
                }
                case 'u': {
                    if (idx + 4 < length) {
                        try {
                            int code2 = Integer.parseInt(s.substring(idx + 1, idx + 5), 16);
                            idx += 4;
                            buffer.append((char)code2);
                        }
                        catch (NumberFormatException e) {
                            buffer.append("\\u");
                        }
                        break;
                    }
                    buffer.append("\\u");
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': {
                    octalEscapeMaxLength = 3;
                }
                case '4': 
                case '5': 
                case '6': 
                case '7': {
                    int escapeEnd;
                    for (escapeEnd = idx + 1; escapeEnd < length && escapeEnd < idx + octalEscapeMaxLength && StringUtil.isOctalDigit(s.charAt(escapeEnd)); ++escapeEnd) {
                    }
                    try {
                        buffer.append((char)Integer.parseInt(s.substring(idx, escapeEnd), 8));
                    }
                    catch (NumberFormatException e) {
                        throw new RuntimeException("Couldn't parse " + s.substring(idx, escapeEnd), e);
                    }
                    idx = escapeEnd - 1;
                    break;
                }
                default: {
                    buffer.append(ch);
                }
            }
            escaped = false;
        }
        if (escaped) {
            buffer.append('\\');
        }
    }

    @NotNull
    @Contract(pure=true)
    public static String pluralize(@NotNull String word) {
        String plural;
        if (word == null) {
            StringUtil.$$$reportNull$$$0(85);
        }
        if ((plural = Pluralizer.PLURALIZER.plural(word)) != null) {
            String string = plural;
            if (string == null) {
                StringUtil.$$$reportNull$$$0(86);
            }
            return string;
        }
        if (word.endsWith("s")) {
            String string = Pluralizer.restoreCase(word, word + "es");
            if (string == null) {
                StringUtil.$$$reportNull$$$0(87);
            }
            return string;
        }
        String string = Pluralizer.restoreCase(word, word + "s");
        if (string == null) {
            StringUtil.$$$reportNull$$$0(88);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String capitalizeWords(@NotNull String text2, boolean allWords) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(89);
        }
        String string = StringUtil.capitalizeWords(text2, " \t\n\r\f", allWords, false);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(90);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String capitalizeWords(@NotNull String text2, @NotNull String tokenizerDelim, boolean allWords, boolean leaveOriginalDelims) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(91);
        }
        if (tokenizerDelim == null) {
            StringUtil.$$$reportNull$$$0(92);
        }
        java.util.StringTokenizer tokenizer = new java.util.StringTokenizer(text2, tokenizerDelim, leaveOriginalDelims);
        StringBuilder out = new StringBuilder(text2.length());
        boolean toCapitalize = true;
        while (tokenizer.hasMoreTokens()) {
            String word = tokenizer.nextToken();
            if (!leaveOriginalDelims && out.length() > 0) {
                out.append(' ');
            }
            out.append(toCapitalize ? StringUtil.capitalize(word) : word);
            if (allWords) continue;
            toCapitalize = false;
        }
        String string = out.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(93);
        }
        return string;
    }

    @Contract(pure=true)
    public static String decapitalize(String s) {
        return Introspector.decapitalize(s);
    }

    @Contract(pure=true)
    public static boolean isVowel(char c) {
        return VOWELS.indexOf(c) >= 0;
    }

    @NotNull
    @Contract(pure=true)
    public static String capitalize(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(94);
        }
        if (s.isEmpty()) {
            String string = s;
            if (string == null) {
                StringUtil.$$$reportNull$$$0(95);
            }
            return string;
        }
        if (s.length() == 1) {
            String string = StringUtilRt.toUpperCase(s).toString();
            if (string == null) {
                StringUtil.$$$reportNull$$$0(96);
            }
            return string;
        }
        if (Character.isUpperCase(s.charAt(0))) {
            String string = s;
            if (string == null) {
                StringUtil.$$$reportNull$$$0(97);
            }
            return string;
        }
        String string = StringUtil.toUpperCase(s.charAt(0)) + s.substring(1);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(98);
        }
        return string;
    }

    @Contract(value="null -> false", pure=true)
    public static boolean isCapitalized(@Nullable String s) {
        return s != null && !s.isEmpty() && Character.isUpperCase(s.charAt(0));
    }

    @NotNull
    @Contract(pure=true)
    public static String capitalizeWithJavaBeanConvention(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(99);
        }
        if (s.length() > 1 && Character.isUpperCase(s.charAt(1))) {
            String string = s;
            if (string == null) {
                StringUtil.$$$reportNull$$$0(100);
            }
            return string;
        }
        String string = StringUtil.capitalize(s);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(101);
        }
        return string;
    }

    @Contract(pure=true)
    public static int stringHashCode(@NotNull CharSequence chars) {
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(102);
        }
        if (chars instanceof String || chars instanceof CharSequenceWithStringHash) {
            return chars.hashCode();
        }
        return StringUtil.stringHashCode(chars, 0, chars.length());
    }

    @Contract(pure=true)
    public static int stringHashCode(@NotNull CharSequence chars, int from, int to) {
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(103);
        }
        int h = 0;
        for (int off = from; off < to; ++off) {
            h = 31 * h + chars.charAt(off);
        }
        return h;
    }

    @Contract(pure=true)
    public static int stringHashCode(char[] chars, int from, int to) {
        int h = 0;
        for (int off = from; off < to; ++off) {
            h = 31 * h + chars[off];
        }
        return h;
    }

    @Contract(pure=true)
    public static int stringHashCodeInsensitive(@NotNull char[] chars, int from, int to) {
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(104);
        }
        int h = 0;
        for (int off = from; off < to; ++off) {
            h = 31 * h + StringUtil.toLowerCase(chars[off]);
        }
        return h;
    }

    @Contract(pure=true)
    public static int stringHashCodeInsensitive(@NotNull CharSequence chars, int from, int to) {
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(105);
        }
        int h = 0;
        for (int off = from; off < to; ++off) {
            h = 31 * h + StringUtil.toLowerCase(chars.charAt(off));
        }
        return h;
    }

    @Contract(pure=true)
    public static int stringHashCodeInsensitive(@NotNull CharSequence chars) {
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(106);
        }
        return StringUtil.stringHashCodeInsensitive(chars, 0, chars.length());
    }

    @Contract(pure=true)
    public static int stringHashCodeIgnoreWhitespaces(@NotNull char[] chars, int from, int to) {
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(107);
        }
        int h = 0;
        for (int off = from; off < to; ++off) {
            char c = chars[off];
            if (StringUtil.isWhiteSpace(c)) continue;
            h = 31 * h + c;
        }
        return h;
    }

    @Contract(pure=true)
    public static int stringHashCodeIgnoreWhitespaces(@NotNull CharSequence chars, int from, int to) {
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(108);
        }
        int h = 0;
        for (int off = from; off < to; ++off) {
            char c = chars.charAt(off);
            if (StringUtil.isWhiteSpace(c)) continue;
            h = 31 * h + c;
        }
        return h;
    }

    @Contract(pure=true)
    public static int stringHashCodeIgnoreWhitespaces(@NotNull CharSequence chars) {
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(109);
        }
        return StringUtil.stringHashCodeIgnoreWhitespaces(chars, 0, chars.length());
    }

    @Contract(pure=true)
    public static boolean startsWithConcatenation(@NotNull String string, String ... prefixes) {
        if (string == null) {
            StringUtil.$$$reportNull$$$0(110);
        }
        if (prefixes == null) {
            StringUtil.$$$reportNull$$$0(111);
        }
        int offset2 = 0;
        for (String prefix : prefixes) {
            int prefixLen = prefix.length();
            if (!string.regionMatches(offset2, prefix, 0, prefixLen)) {
                return false;
            }
            offset2 += prefixLen;
        }
        return true;
    }

    @Contract(value="null -> null; !null -> !null", pure=true)
    public static String trim(@Nullable String s) {
        return s == null ? null : s.trim();
    }

    @NotNull
    @Contract(pure=true)
    public static String trimEnd(@NotNull String s, @NonNls @NotNull String suffix) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(112);
        }
        if (suffix == null) {
            StringUtil.$$$reportNull$$$0(113);
        }
        String string = StringUtil.trimEnd(s, suffix, false);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(114);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String trimEnd(@NotNull String s, @NonNls @NotNull String suffix, boolean ignoreCase) {
        boolean endsWith;
        if (s == null) {
            StringUtil.$$$reportNull$$$0(115);
        }
        if (suffix == null) {
            StringUtil.$$$reportNull$$$0(116);
        }
        boolean bl = endsWith = ignoreCase ? StringUtil.endsWithIgnoreCase(s, suffix) : s.endsWith(suffix);
        if (endsWith) {
            String string = s.substring(0, s.length() - suffix.length());
            if (string == null) {
                StringUtil.$$$reportNull$$$0(117);
            }
            return string;
        }
        String string = s;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(118);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String trimEnd(@NotNull String s, char suffix) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(119);
        }
        if (StringUtil.endsWithChar(s, suffix)) {
            String string = s.substring(0, s.length() - 1);
            if (string == null) {
                StringUtil.$$$reportNull$$$0(120);
            }
            return string;
        }
        String string = s;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(121);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String trimLog(@NotNull String text2, int limit) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(122);
        }
        if (limit > 5 && text2.length() > limit) {
            String string = text2.substring(0, limit - 5) + " ...\n";
            if (string == null) {
                StringUtil.$$$reportNull$$$0(123);
            }
            return string;
        }
        String string = text2;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(124);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String trimLeading(@NotNull String string) {
        if (string == null) {
            StringUtil.$$$reportNull$$$0(125);
        }
        String string2 = StringUtil.trimLeading((CharSequence)string).toString();
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(126);
        }
        return string2;
    }

    @NotNull
    @Contract(pure=true)
    public static CharSequence trimLeading(@NotNull CharSequence string) {
        int index2;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(127);
        }
        for (index2 = 0; index2 < string.length() && Character.isWhitespace(string.charAt(index2)); ++index2) {
        }
        CharSequence charSequence = string.subSequence(index2, string.length());
        if (charSequence == null) {
            StringUtil.$$$reportNull$$$0(128);
        }
        return charSequence;
    }

    @NotNull
    @Contract(pure=true)
    public static String trimLeading(@NotNull String string, char symbol2) {
        int index2;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(129);
        }
        for (index2 = 0; index2 < string.length() && string.charAt(index2) == symbol2; ++index2) {
        }
        String string2 = string.substring(index2);
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(130);
        }
        return string2;
    }

    @NotNull
    public static StringBuilder trimLeading(@NotNull StringBuilder builder, char symbol2) {
        int index2;
        if (builder == null) {
            StringUtil.$$$reportNull$$$0(131);
        }
        for (index2 = 0; index2 < builder.length() && builder.charAt(index2) == symbol2; ++index2) {
        }
        if (index2 > 0) {
            builder.delete(0, index2);
        }
        StringBuilder stringBuilder = builder;
        if (stringBuilder == null) {
            StringUtil.$$$reportNull$$$0(132);
        }
        return stringBuilder;
    }

    @NotNull
    @Contract(pure=true)
    public static String trimTrailing(@NotNull String string) {
        if (string == null) {
            StringUtil.$$$reportNull$$$0(133);
        }
        String string2 = StringUtil.trimTrailing((CharSequence)string).toString();
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(134);
        }
        return string2;
    }

    @NotNull
    @Contract(pure=true)
    public static CharSequence trimTrailing(@NotNull CharSequence string) {
        int index2;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(135);
        }
        for (index2 = string.length() - 1; index2 >= 0 && Character.isWhitespace(string.charAt(index2)); --index2) {
        }
        CharSequence charSequence = string.subSequence(0, index2 + 1);
        if (charSequence == null) {
            StringUtil.$$$reportNull$$$0(136);
        }
        return charSequence;
    }

    @NotNull
    @Contract(pure=true)
    public static String trimTrailing(@NotNull String string, char symbol2) {
        int index2;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(137);
        }
        for (index2 = string.length() - 1; index2 >= 0 && string.charAt(index2) == symbol2; --index2) {
        }
        String string2 = string.substring(0, index2 + 1);
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(138);
        }
        return string2;
    }

    @NotNull
    public static StringBuilder trimTrailing(@NotNull StringBuilder builder, char symbol2) {
        int index2;
        if (builder == null) {
            StringUtil.$$$reportNull$$$0(139);
        }
        for (index2 = builder.length() - 1; index2 >= 0 && builder.charAt(index2) == symbol2; --index2) {
        }
        builder.setLength(index2 + 1);
        StringBuilder stringBuilder = builder;
        if (stringBuilder == null) {
            StringUtil.$$$reportNull$$$0(140);
        }
        return stringBuilder;
    }

    @Contract(pure=true)
    public static boolean startsWithChar(@Nullable CharSequence s, char prefix) {
        return s != null && s.length() != 0 && s.charAt(0) == prefix;
    }

    @Contract(pure=true)
    public static boolean endsWithChar(@Nullable CharSequence s, char suffix) {
        return StringUtilRt.endsWithChar(s, suffix);
    }

    @NotNull
    @Contract(pure=true)
    public static String trimStart(@NotNull String s, @NonNls @NotNull String prefix) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(141);
        }
        if (prefix == null) {
            StringUtil.$$$reportNull$$$0(142);
        }
        if (s.startsWith(prefix)) {
            String string = s.substring(prefix.length());
            if (string == null) {
                StringUtil.$$$reportNull$$$0(143);
            }
            return string;
        }
        String string = s;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(144);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String trimExtensions(@NotNull String name) {
        int index2;
        if (name == null) {
            StringUtil.$$$reportNull$$$0(145);
        }
        String string = (index2 = name.indexOf(46)) < 0 ? name : name.substring(0, index2);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(146);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String pluralize(@NotNull String base2, int n) {
        if (base2 == null) {
            StringUtil.$$$reportNull$$$0(147);
        }
        if (n == 1) {
            String string = base2;
            if (string == null) {
                StringUtil.$$$reportNull$$$0(148);
            }
            return string;
        }
        String string = StringUtil.pluralize(base2);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(149);
        }
        return string;
    }

    public static void repeatSymbol(@NotNull Appendable buffer, char symbol2, int times) {
        if (buffer == null) {
            StringUtil.$$$reportNull$$$0(150);
        }
        assert (times >= 0) : times;
        try {
            for (int i2 = 0; i2 < times; ++i2) {
                buffer.append(symbol2);
            }
        }
        catch (IOException e) {
            LOG.error(e);
        }
    }

    @Contract(pure=true)
    public static String defaultIfEmpty(@Nullable String value, String defaultValue) {
        return StringUtil.isEmpty(value) ? defaultValue : value;
    }

    @Contract(value="null -> false", pure=true)
    public static boolean isNotEmpty(@Nullable String s) {
        return !StringUtil.isEmpty(s);
    }

    @Contract(value="null -> true", pure=true)
    public static boolean isEmpty(@Nullable String s) {
        return s == null || s.isEmpty();
    }

    @Contract(value="null -> true", pure=true)
    public static boolean isEmpty(@Nullable CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    @Contract(pure=true)
    public static int length(@Nullable CharSequence cs) {
        return cs == null ? 0 : cs.length();
    }

    @NotNull
    @Contract(pure=true)
    public static String notNullize(@Nullable String s) {
        String string = StringUtil.notNullize(s, "");
        if (string == null) {
            StringUtil.$$$reportNull$$$0(151);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String notNullize(@Nullable String s, @NotNull String defaultValue) {
        if (defaultValue == null) {
            StringUtil.$$$reportNull$$$0(152);
        }
        String string = s == null ? defaultValue : s;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(153);
        }
        return string;
    }

    @Nullable
    @Contract(pure=true)
    public static String nullize(@Nullable String s) {
        return StringUtil.nullize(s, false);
    }

    @Nullable
    @Contract(pure=true)
    public static String nullize(@Nullable String s, boolean nullizeSpaces) {
        if (nullizeSpaces ? StringUtil.isEmptyOrSpaces(s) : StringUtil.isEmpty(s)) {
            return null;
        }
        return s;
    }

    @Contract(value="null -> true", pure=true)
    public static boolean isEmptyOrSpaces(@Nullable String s) {
        return StringUtil.isEmptyOrSpaces((CharSequence)s);
    }

    @Contract(value="null -> true", pure=true)
    public static boolean isEmptyOrSpaces(@Nullable CharSequence s) {
        if (StringUtil.isEmpty(s)) {
            return true;
        }
        for (int i2 = 0; i2 < s.length(); ++i2) {
            if (s.charAt(i2) <= ' ') continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static boolean isWhiteSpace(char c) {
        return c == '\n' || c == '\t' || c == ' ';
    }

    @NotNull
    @Contract(pure=true)
    public static String getThrowableText(@NotNull Throwable aThrowable) {
        if (aThrowable == null) {
            StringUtil.$$$reportNull$$$0(154);
        }
        String string = ExceptionUtil.getThrowableText(aThrowable);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(155);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String getThrowableText(@NotNull Throwable aThrowable, @NonNls @NotNull String stackFrameSkipPattern) {
        if (aThrowable == null) {
            StringUtil.$$$reportNull$$$0(156);
        }
        if (stackFrameSkipPattern == null) {
            StringUtil.$$$reportNull$$$0(157);
        }
        String string = ExceptionUtil.getThrowableText(aThrowable, stackFrameSkipPattern);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(158);
        }
        return string;
    }

    @Nullable
    @Contract(pure=true)
    public static String getMessage(@NotNull Throwable e) {
        if (e == null) {
            StringUtil.$$$reportNull$$$0(159);
        }
        return ExceptionUtil.getMessage(e);
    }

    @NotNull
    @Contract(pure=true)
    public static String repeatSymbol(char aChar, int count2) {
        char[] buffer = new char[count2];
        Arrays.fill(buffer, aChar);
        String string = StringFactory.createShared(buffer);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(160);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String repeat(@NotNull String s, int count2) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(161);
        }
        assert (count2 >= 0) : count2;
        StringBuilder sb = new StringBuilder(s.length() * count2);
        for (int i2 = 0; i2 < count2; ++i2) {
            sb.append(s);
        }
        String string = sb.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(162);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static List<String> splitHonorQuotes(@NotNull String s, char separator) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(163);
        }
        ArrayList<String> result2 = new ArrayList<String>();
        StringBuilder builder = new StringBuilder(s.length());
        boolean inQuotes = false;
        for (int i2 = 0; i2 < s.length(); ++i2) {
            char c = s.charAt(i2);
            if (c == separator && !inQuotes) {
                if (builder.length() <= 0) continue;
                result2.add(builder.toString());
                builder.setLength(0);
                continue;
            }
            if (!(c != '\"' && c != '\'' || i2 > 0 && s.charAt(i2 - 1) == '\\')) {
                inQuotes = !inQuotes;
            }
            builder.append(c);
        }
        if (builder.length() > 0) {
            result2.add(builder.toString());
        }
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            StringUtil.$$$reportNull$$$0(164);
        }
        return arrayList;
    }

    @NotNull
    @Contract(pure=true)
    public static List<String> split(@NotNull String s, @NotNull String separator) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(165);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(166);
        }
        List<String> list2 = StringUtil.split(s, separator, true);
        if (list2 == null) {
            StringUtil.$$$reportNull$$$0(167);
        }
        return list2;
    }

    @NotNull
    @Contract(pure=true)
    public static List<CharSequence> split(@NotNull CharSequence s, @NotNull CharSequence separator) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(168);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(169);
        }
        List<CharSequence> list2 = StringUtil.split(s, separator, true, true);
        if (list2 == null) {
            StringUtil.$$$reportNull$$$0(170);
        }
        return list2;
    }

    @NotNull
    @Contract(pure=true)
    public static List<String> split(@NotNull String s, @NotNull String separator, boolean excludeSeparator) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(171);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(172);
        }
        List<String> list2 = StringUtil.split(s, separator, excludeSeparator, true);
        if (list2 == null) {
            StringUtil.$$$reportNull$$$0(173);
        }
        return list2;
    }

    @NotNull
    @Contract(pure=true)
    public static List<String> split(@NotNull String s, @NotNull String separator, boolean excludeSeparator, boolean excludeEmptyStrings) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(174);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(175);
        }
        List<CharSequence> list2 = StringUtil.split((CharSequence)s, (CharSequence)separator, excludeSeparator, excludeEmptyStrings);
        if (list2 == null) {
            StringUtil.$$$reportNull$$$0(176);
        }
        return list2;
    }

    @NotNull
    @Contract(pure=true)
    public static List<CharSequence> split(@NotNull CharSequence s, @NotNull CharSequence separator, boolean excludeSeparator, boolean excludeEmptyStrings) {
        int index2;
        if (s == null) {
            StringUtil.$$$reportNull$$$0(177);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(178);
        }
        if (separator.length() == 0) {
            List<CharSequence> list2 = Collections.singletonList(s);
            if (list2 == null) {
                StringUtil.$$$reportNull$$$0(179);
            }
            return list2;
        }
        ArrayList<CharSequence> result2 = new ArrayList<CharSequence>();
        int pos = 0;
        while ((index2 = StringUtil.indexOf(s, separator, pos)) != -1) {
            int nextPos = index2 + separator.length();
            CharSequence token = s.subSequence(pos, excludeSeparator ? index2 : nextPos);
            if (token.length() != 0 || !excludeEmptyStrings) {
                result2.add(token);
            }
            pos = nextPos;
        }
        if (pos < s.length() || !excludeEmptyStrings && pos == s.length()) {
            result2.add(s.subSequence(pos, s.length()));
        }
        ArrayList<CharSequence> arrayList = result2;
        if (arrayList == null) {
            StringUtil.$$$reportNull$$$0(180);
        }
        return arrayList;
    }

    @NotNull
    @Contract(pure=true)
    public static Iterable<String> tokenize(@NotNull String s, @NotNull String separators) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(181);
        }
        if (separators == null) {
            StringUtil.$$$reportNull$$$0(182);
        }
        final StringTokenizer tokenizer = new StringTokenizer(s, separators);
        Iterable<String> iterable = new Iterable<String>(){

            @Override
            @NotNull
            public Iterator<String> iterator() {
                Iterator<String> iterator2 = new Iterator<String>(){

                    @Override
                    public boolean hasNext() {
                        return tokenizer.hasMoreTokens();
                    }

                    @Override
                    public String next() {
                        return tokenizer.nextToken();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
                if (iterator2 == null) {
                    7.$$$reportNull$$$0(0);
                }
                return iterator2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil$7", "iterator"));
            }
        };
        if (iterable == null) {
            StringUtil.$$$reportNull$$$0(183);
        }
        return iterable;
    }

    @NotNull
    @Contract(pure=true)
    public static Iterable<String> tokenize(final @NotNull java.util.StringTokenizer tokenizer) {
        if (tokenizer == null) {
            StringUtil.$$$reportNull$$$0(184);
        }
        Iterable<String> iterable = new Iterable<String>(){

            @Override
            @NotNull
            public Iterator<String> iterator() {
                Iterator<String> iterator2 = new Iterator<String>(){

                    @Override
                    public boolean hasNext() {
                        return tokenizer.hasMoreTokens();
                    }

                    @Override
                    public String next() {
                        return tokenizer.nextToken();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
                if (iterator2 == null) {
                    8.$$$reportNull$$$0(0);
                }
                return iterator2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil$8", "iterator"));
            }
        };
        if (iterable == null) {
            StringUtil.$$$reportNull$$$0(185);
        }
        return iterable;
    }

    @NotNull
    @Contract(pure=true)
    public static List<String> getWordsIn(@NotNull String text2) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(186);
        }
        SmartList<String> result2 = null;
        int start = -1;
        for (int i2 = 0; i2 < text2.length(); ++i2) {
            char c = text2.charAt(i2);
            boolean isIdentifierPart = Character.isJavaIdentifierPart(c);
            if (isIdentifierPart && start == -1) {
                start = i2;
            }
            if (isIdentifierPart && i2 == text2.length() - 1 && start != -1) {
                if (result2 == null) {
                    result2 = new SmartList();
                }
                result2.add(text2.substring(start, i2 + 1));
                continue;
            }
            if (isIdentifierPart || start == -1) continue;
            if (result2 == null) {
                result2 = new SmartList<String>();
            }
            result2.add(text2.substring(start, i2));
            start = -1;
        }
        if (result2 == null) {
            List<String> list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                StringUtil.$$$reportNull$$$0(187);
            }
            return list2;
        }
        SmartList<String> smartList = result2;
        if (smartList == null) {
            StringUtil.$$$reportNull$$$0(188);
        }
        return smartList;
    }

    @NotNull
    @Contract(pure=true)
    public static List<TextRange> getWordIndicesIn(@NotNull String text2) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(189);
        }
        SmartList<TextRange> result2 = new SmartList<TextRange>();
        int start = -1;
        for (int i2 = 0; i2 < text2.length(); ++i2) {
            char c = text2.charAt(i2);
            boolean isIdentifierPart = Character.isJavaIdentifierPart(c);
            if (isIdentifierPart && start == -1) {
                start = i2;
            }
            if (isIdentifierPart && i2 == text2.length() - 1 && start != -1) {
                result2.add(new TextRange(start, i2 + 1));
                continue;
            }
            if (isIdentifierPart || start == -1) continue;
            result2.add(new TextRange(start, i2));
            start = -1;
        }
        SmartList<TextRange> smartList = result2;
        if (smartList == null) {
            StringUtil.$$$reportNull$$$0(190);
        }
        return smartList;
    }

    @NotNull
    @Contract(pure=true)
    public static String join(@NotNull String[] strings, @NotNull String separator) {
        if (strings == null) {
            StringUtil.$$$reportNull$$$0(191);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(192);
        }
        String string = StringUtil.join(strings, 0, strings.length, separator);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(193);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String join(@NotNull String[] strings, int startIndex, int endIndex, @NotNull String separator) {
        if (strings == null) {
            StringUtil.$$$reportNull$$$0(194);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(195);
        }
        StringBuilder result2 = new StringBuilder();
        for (int i2 = startIndex; i2 < endIndex; ++i2) {
            if (i2 > startIndex) {
                result2.append(separator);
            }
            result2.append(strings[i2]);
        }
        String string = result2.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(196);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String[] zip(@NotNull String[] strings1, @NotNull String[] strings2, String separator) {
        if (strings1 == null) {
            StringUtil.$$$reportNull$$$0(197);
        }
        if (strings2 == null) {
            StringUtil.$$$reportNull$$$0(198);
        }
        if (strings1.length != strings2.length) {
            throw new IllegalArgumentException();
        }
        String[] result2 = ArrayUtil.newStringArray(strings1.length);
        for (int i2 = 0; i2 < result2.length; ++i2) {
            result2[i2] = strings1[i2] + separator + strings2[i2];
        }
        if (result2 == null) {
            StringUtil.$$$reportNull$$$0(199);
        }
        return result2;
    }

    @NotNull
    @Contract(pure=true)
    public static String[] surround(@NotNull String[] strings1, String prefix, String suffix) {
        if (strings1 == null) {
            StringUtil.$$$reportNull$$$0(200);
        }
        String[] result2 = ArrayUtil.newStringArray(strings1.length);
        for (int i2 = 0; i2 < result2.length; ++i2) {
            result2[i2] = prefix + strings1[i2] + suffix;
        }
        if (result2 == null) {
            StringUtil.$$$reportNull$$$0(201);
        }
        return result2;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> String join(@NotNull T[] items, @NotNull Function<T, String> f, @NotNull @NonNls String separator) {
        if (items == null) {
            StringUtil.$$$reportNull$$$0(202);
        }
        if (f == null) {
            StringUtil.$$$reportNull$$$0(203);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(204);
        }
        String string = StringUtil.join(Arrays.asList(items), f, separator);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(205);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> String join(@NotNull Collection<? extends T> items, @NotNull Function<? super T, String> f, @NotNull @NonNls String separator) {
        if (items == null) {
            StringUtil.$$$reportNull$$$0(206);
        }
        if (f == null) {
            StringUtil.$$$reportNull$$$0(207);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(208);
        }
        if (items.isEmpty()) {
            if ("" == null) {
                StringUtil.$$$reportNull$$$0(209);
            }
            return "";
        }
        if (items.size() == 1) {
            String string = StringUtil.notNullize(f.fun(items.iterator().next()));
            if (string == null) {
                StringUtil.$$$reportNull$$$0(210);
            }
            return string;
        }
        String string = StringUtil.join(items, f, separator);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(211);
        }
        return string;
    }

    @Contract(pure=true)
    public static String join(@NotNull Iterable<?> items, @NotNull @NonNls String separator) {
        if (items == null) {
            StringUtil.$$$reportNull$$$0(212);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(213);
        }
        StringBuilder result2 = new StringBuilder();
        for (Object item : items) {
            result2.append(item).append(separator);
        }
        if (result2.length() > 0) {
            result2.setLength(result2.length() - separator.length());
        }
        return result2.toString();
    }

    @NotNull
    @Contract(pure=true)
    public static <T> String join(@NotNull Iterable<? extends T> items, @NotNull Function<? super T, String> f, @NotNull @NonNls String separator) {
        if (items == null) {
            StringUtil.$$$reportNull$$$0(214);
        }
        if (f == null) {
            StringUtil.$$$reportNull$$$0(215);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(216);
        }
        StringBuilder result2 = new StringBuilder();
        StringUtil.join(items, f, separator, result2);
        String string = result2.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(217);
        }
        return string;
    }

    public static <T> void join(@NotNull Iterable<? extends T> items, @NotNull Function<? super T, String> f, @NotNull @NonNls String separator, @NotNull StringBuilder result2) {
        if (items == null) {
            StringUtil.$$$reportNull$$$0(218);
        }
        if (f == null) {
            StringUtil.$$$reportNull$$$0(219);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(220);
        }
        if (result2 == null) {
            StringUtil.$$$reportNull$$$0(221);
        }
        boolean isFirst = true;
        for (T item : items) {
            String string = f.fun(item);
            if (string == null || string.isEmpty()) continue;
            if (isFirst) {
                isFirst = false;
            } else {
                result2.append(separator);
            }
            result2.append(string);
        }
    }

    @NotNull
    @Contract(pure=true)
    public static String join(@NotNull Collection<String> strings, @NotNull String separator) {
        if (strings == null) {
            StringUtil.$$$reportNull$$$0(222);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(223);
        }
        if (strings.size() <= 1) {
            String string = StringUtil.notNullize(ContainerUtil.getFirstItem(strings));
            if (string == null) {
                StringUtil.$$$reportNull$$$0(224);
            }
            return string;
        }
        StringBuilder result2 = new StringBuilder();
        StringUtil.join(strings, separator, result2);
        String string = result2.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(225);
        }
        return string;
    }

    public static void join(@NotNull Collection<String> strings, @NotNull String separator, @NotNull StringBuilder result2) {
        if (strings == null) {
            StringUtil.$$$reportNull$$$0(226);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(227);
        }
        if (result2 == null) {
            StringUtil.$$$reportNull$$$0(228);
        }
        boolean isFirst = true;
        for (String string : strings) {
            if (string == null) continue;
            if (isFirst) {
                isFirst = false;
            } else {
                result2.append(separator);
            }
            result2.append(string);
        }
    }

    @NotNull
    @Contract(pure=true)
    public static String join(@NotNull int[] strings, @NotNull String separator) {
        if (strings == null) {
            StringUtil.$$$reportNull$$$0(229);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(230);
        }
        StringBuilder result2 = new StringBuilder();
        for (int i2 = 0; i2 < strings.length; ++i2) {
            if (i2 > 0) {
                result2.append(separator);
            }
            result2.append(strings[i2]);
        }
        String string = result2.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(231);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String join(String ... strings) {
        if (strings == null || strings.length == 0) {
            if ("" == null) {
                StringUtil.$$$reportNull$$$0(232);
            }
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (String string : strings) {
            builder.append(string);
        }
        String string = builder.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(233);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String stripQuotesAroundValue(@NotNull String text2) {
        int len;
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(234);
        }
        if ((len = text2.length()) > 0) {
            int to;
            int from = StringUtil.isQuoteAt(text2, 0) ? 1 : 0;
            int n = to = len > 1 && StringUtil.isQuoteAt(text2, len - 1) ? len - 1 : len;
            if (from > 0 || to < len) {
                String string = text2.substring(from, to);
                if (string == null) {
                    StringUtil.$$$reportNull$$$0(235);
                }
                return string;
            }
        }
        String string = text2;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(236);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String formatFileSize(long fileSize) {
        String string = StringUtil.formatValue(fileSize, null, new String[]{"B", "K", "M", "G", "T", "P", "E"}, new long[]{1000L, 1000L, 1000L, 1000L, 1000L, 1000L});
        if (string == null) {
            StringUtil.$$$reportNull$$$0(237);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String formatDuration(long duration) {
        String string = StringUtil.formatValue(duration, " ", new String[]{"ms", "s", "m", "h", "d", "w", "mo", "yr", "c", "ml", "ep"}, new long[]{1000L, 60L, 60L, 24L, 7L, 4L, 12L, 100L, 10L, 10000L});
        if (string == null) {
            StringUtil.$$$reportNull$$$0(238);
        }
        return string;
    }

    @NotNull
    private static String formatValue(long value, String partSeparator, String[] units, long[] multipliers) {
        int i2;
        StringBuilder sb = new StringBuilder();
        long count2 = value;
        long remainder = 0L;
        for (i2 = 0; i2 < units.length; ++i2) {
            long multiplier;
            long l = multiplier = i2 < multipliers.length ? multipliers[i2] : -1L;
            if (multiplier == -1L || count2 < multiplier) break;
            remainder = count2 % multiplier;
            count2 /= multiplier;
            if (partSeparator == null || remainder == 0L && sb.length() <= 0) continue;
            sb.insert(0, units[i2]).insert(0, remainder).insert(0, partSeparator);
        }
        if (partSeparator != null || remainder == 0L) {
            sb.insert(0, units[i2]).insert(0, count2);
        } else if (remainder > 0L) {
            sb.append(String.format(Locale.US, "%.2f", (double)count2 + (double)remainder / (double)multipliers[i2 - 1])).append(units[i2]);
        }
        String string = sb.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(239);
        }
        return string;
    }

    @Nullable
    @Contract(pure=true)
    public static String unpluralize(@NotNull String word) {
        String singular;
        if (word == null) {
            StringUtil.$$$reportNull$$$0(240);
        }
        if ((singular = Pluralizer.PLURALIZER.singular(word)) != null) {
            return singular;
        }
        if (word.endsWith("es")) {
            return StringUtil.nullize(StringUtil.trimEnd(word, "es", true));
        }
        if (word.endsWith("s")) {
            return StringUtil.nullize(StringUtil.trimEnd(word, "s", true));
        }
        return null;
    }

    @Contract(pure=true)
    public static boolean containsAlphaCharacters(@NotNull String value) {
        if (value == null) {
            StringUtil.$$$reportNull$$$0(241);
        }
        for (int i2 = 0; i2 < value.length(); ++i2) {
            if (!Character.isLetter(value.charAt(i2))) continue;
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    public static boolean containsAnyChar(@NotNull String value, @NotNull String chars) {
        if (value == null) {
            StringUtil.$$$reportNull$$$0(242);
        }
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(243);
        }
        return chars.length() > value.length() ? StringUtil.containsAnyChar(value, chars, 0, value.length()) : StringUtil.containsAnyChar(chars, value, 0, chars.length());
    }

    @Contract(pure=true)
    public static boolean containsAnyChar(@NotNull String value, @NotNull String chars, int start, int end) {
        if (value == null) {
            StringUtil.$$$reportNull$$$0(244);
        }
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(245);
        }
        for (int i2 = start; i2 < end; ++i2) {
            if (chars.indexOf(value.charAt(i2)) < 0) continue;
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    public static boolean containsChar(@NotNull String value, char ch) {
        if (value == null) {
            StringUtil.$$$reportNull$$$0(246);
        }
        return value.indexOf(ch) >= 0;
    }

    @Contract(value="null -> null; !null -> !null", pure=true)
    public static String firstLetterToUpperCase(@Nullable String displayString) {
        if (displayString == null || displayString.isEmpty()) {
            return displayString;
        }
        char firstChar = displayString.charAt(0);
        char uppedFirstChar = StringUtil.toUpperCase(firstChar);
        if (uppedFirstChar == firstChar) {
            return displayString;
        }
        char[] buffer = displayString.toCharArray();
        buffer[0] = uppedFirstChar;
        return StringFactory.createShared(buffer);
    }

    @NotNull
    @Contract(pure=true)
    public static String strip(@NotNull String s, @NotNull CharFilter filter2) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(247);
        }
        if (filter2 == null) {
            StringUtil.$$$reportNull$$$0(248);
        }
        StringBuilder result2 = new StringBuilder(s.length());
        for (int i2 = 0; i2 < s.length(); ++i2) {
            char ch = s.charAt(i2);
            if (!filter2.accept(ch)) continue;
            result2.append(ch);
        }
        String string = result2.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(249);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static List<String> findMatches(@NotNull String s, @NotNull Pattern pattern) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(250);
        }
        if (pattern == null) {
            StringUtil.$$$reportNull$$$0(251);
        }
        List<String> list2 = StringUtil.findMatches(s, pattern, 1);
        if (list2 == null) {
            StringUtil.$$$reportNull$$$0(252);
        }
        return list2;
    }

    @NotNull
    @Contract(pure=true)
    public static List<String> findMatches(@NotNull String s, @NotNull Pattern pattern, int groupIndex) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(253);
        }
        if (pattern == null) {
            StringUtil.$$$reportNull$$$0(254);
        }
        SmartList<String> result2 = new SmartList<String>();
        Matcher m = pattern.matcher(s);
        while (m.find()) {
            String group = m.group(groupIndex);
            if (group == null) continue;
            result2.add(group);
        }
        SmartList<String> smartList = result2;
        if (smartList == null) {
            StringUtil.$$$reportNull$$$0(255);
        }
        return smartList;
    }

    @Contract(pure=true)
    public static int findFirst(@NotNull CharSequence s, @NotNull CharFilter filter2) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(256);
        }
        if (filter2 == null) {
            StringUtil.$$$reportNull$$$0(257);
        }
        for (int i2 = 0; i2 < s.length(); ++i2) {
            char ch = s.charAt(i2);
            if (!filter2.accept(ch)) continue;
            return i2;
        }
        return -1;
    }

    @NotNull
    @Contract(pure=true)
    public static String replaceSubstring(@NotNull String string, @NotNull TextRange range, @NotNull String replacement) {
        if (string == null) {
            StringUtil.$$$reportNull$$$0(258);
        }
        if (range == null) {
            StringUtil.$$$reportNull$$$0(259);
        }
        if (replacement == null) {
            StringUtil.$$$reportNull$$$0(260);
        }
        String string2 = range.replace(string, replacement);
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(261);
        }
        return string2;
    }

    @Contract(pure=true)
    public static boolean startsWithWhitespace(@NotNull String text2) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(262);
        }
        return !text2.isEmpty() && Character.isWhitespace(text2.charAt(0));
    }

    @Contract(pure=true)
    public static boolean isChar(CharSequence seq, int index2, char c) {
        return index2 >= 0 && index2 < seq.length() && seq.charAt(index2) == c;
    }

    @Contract(pure=true)
    public static boolean startsWith(@NotNull CharSequence text2, @NotNull CharSequence prefix) {
        int l2;
        int l1;
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(263);
        }
        if (prefix == null) {
            StringUtil.$$$reportNull$$$0(264);
        }
        if ((l1 = text2.length()) < (l2 = prefix.length())) {
            return false;
        }
        for (int i2 = 0; i2 < l2; ++i2) {
            if (text2.charAt(i2) == prefix.charAt(i2)) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static boolean startsWith(@NotNull CharSequence text2, int startIndex, @NotNull CharSequence prefix) {
        int l2;
        int l1;
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(265);
        }
        if (prefix == null) {
            StringUtil.$$$reportNull$$$0(266);
        }
        if ((l1 = text2.length() - startIndex) < (l2 = prefix.length())) {
            return false;
        }
        for (int i2 = 0; i2 < l2; ++i2) {
            if (text2.charAt(i2 + startIndex) == prefix.charAt(i2)) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static boolean endsWith(@NotNull CharSequence text2, @NotNull CharSequence suffix) {
        int l2;
        int l1;
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(267);
        }
        if (suffix == null) {
            StringUtil.$$$reportNull$$$0(268);
        }
        if ((l1 = text2.length()) < (l2 = suffix.length())) {
            return false;
        }
        for (int i2 = l1 - 1; i2 >= l1 - l2; --i2) {
            if (text2.charAt(i2) == suffix.charAt(i2 + l2 - l1)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    @Contract(pure=true)
    public static String commonPrefix(@NotNull String s1, @NotNull String s2) {
        if (s1 == null) {
            StringUtil.$$$reportNull$$$0(269);
        }
        if (s2 == null) {
            StringUtil.$$$reportNull$$$0(270);
        }
        String string = s1.substring(0, StringUtil.commonPrefixLength(s1, s2));
        if (string == null) {
            StringUtil.$$$reportNull$$$0(271);
        }
        return string;
    }

    @Contract(pure=true)
    public static int commonPrefixLength(@NotNull CharSequence s1, @NotNull CharSequence s2) {
        if (s1 == null) {
            StringUtil.$$$reportNull$$$0(272);
        }
        if (s2 == null) {
            StringUtil.$$$reportNull$$$0(273);
        }
        return StringUtil.commonPrefixLength(s1, s2, false);
    }

    @Contract(pure=true)
    public static int commonPrefixLength(@NotNull CharSequence s1, @NotNull CharSequence s2, boolean ignoreCase) {
        int i2;
        if (s1 == null) {
            StringUtil.$$$reportNull$$$0(274);
        }
        if (s2 == null) {
            StringUtil.$$$reportNull$$$0(275);
        }
        int minLength = Math.min(s1.length(), s2.length());
        for (i2 = 0; i2 < minLength && StringUtil.charsMatch(s1.charAt(i2), s2.charAt(i2), ignoreCase); ++i2) {
        }
        return i2;
    }

    @NotNull
    @Contract(pure=true)
    public static String commonSuffix(@NotNull String s1, @NotNull String s2) {
        if (s1 == null) {
            StringUtil.$$$reportNull$$$0(276);
        }
        if (s2 == null) {
            StringUtil.$$$reportNull$$$0(277);
        }
        String string = s1.substring(s1.length() - StringUtil.commonSuffixLength(s1, s2));
        if (string == null) {
            StringUtil.$$$reportNull$$$0(278);
        }
        return string;
    }

    @Contract(pure=true)
    public static int commonSuffixLength(@NotNull CharSequence s1, @NotNull CharSequence s2) {
        int i2;
        if (s1 == null) {
            StringUtil.$$$reportNull$$$0(279);
        }
        if (s2 == null) {
            StringUtil.$$$reportNull$$$0(280);
        }
        int s1Length = s1.length();
        int s2Length = s2.length();
        if (s1Length == 0 || s2Length == 0) {
            return 0;
        }
        for (i2 = 0; i2 < s1Length && i2 < s2Length && s1.charAt(s1Length - i2 - 1) == s2.charAt(s2Length - i2 - 1); ++i2) {
        }
        return i2;
    }

    @Contract(pure=true)
    public static boolean contains(@NotNull CharSequence s, int start, int end, char c) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(281);
        }
        return StringUtil.indexOf(s, c, start, end) >= 0;
    }

    @Contract(pure=true)
    public static boolean containsWhitespaces(@Nullable CharSequence s) {
        if (s == null) {
            return false;
        }
        for (int i2 = 0; i2 < s.length(); ++i2) {
            if (!Character.isWhitespace(s.charAt(i2))) continue;
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence s, char c) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(282);
        }
        return StringUtil.indexOf(s, c, 0, s.length());
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence s, char c, int start) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(283);
        }
        return StringUtil.indexOf(s, c, start, s.length());
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence s, char c, int start, int end) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(284);
        }
        end = Math.min(end, s.length());
        for (int i2 = Math.max(start, 0); i2 < end; ++i2) {
            if (s.charAt(i2) != c) continue;
            return i2;
        }
        return -1;
    }

    @Contract(pure=true)
    public static boolean contains(@NotNull CharSequence sequence2, @NotNull CharSequence infix) {
        if (sequence2 == null) {
            StringUtil.$$$reportNull$$$0(285);
        }
        if (infix == null) {
            StringUtil.$$$reportNull$$$0(286);
        }
        return StringUtil.indexOf(sequence2, infix) >= 0;
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence sequence2, @NotNull CharSequence infix) {
        if (sequence2 == null) {
            StringUtil.$$$reportNull$$$0(287);
        }
        if (infix == null) {
            StringUtil.$$$reportNull$$$0(288);
        }
        return StringUtil.indexOf(sequence2, infix, 0);
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence sequence2, @NotNull CharSequence infix, int start) {
        if (sequence2 == null) {
            StringUtil.$$$reportNull$$$0(289);
        }
        if (infix == null) {
            StringUtil.$$$reportNull$$$0(290);
        }
        return StringUtil.indexOf(sequence2, infix, start, sequence2.length());
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence sequence2, @NotNull CharSequence infix, int start, int end) {
        if (sequence2 == null) {
            StringUtil.$$$reportNull$$$0(291);
        }
        if (infix == null) {
            StringUtil.$$$reportNull$$$0(292);
        }
        for (int i2 = start; i2 <= end - infix.length(); ++i2) {
            if (!StringUtil.startsWith(sequence2, i2, infix)) continue;
            return i2;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence s, char c, int start, int end, boolean caseSensitive) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(293);
        }
        end = Math.min(end, s.length());
        for (int i2 = Math.max(start, 0); i2 < end; ++i2) {
            if (!StringUtil.charsMatch(s.charAt(i2), c, !caseSensitive)) continue;
            return i2;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull char[] s, char c, int start, int end, boolean caseSensitive) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(294);
        }
        end = Math.min(end, s.length);
        for (int i2 = Math.max(start, 0); i2 < end; ++i2) {
            if (!StringUtil.charsMatch(s[i2], c, !caseSensitive)) continue;
            return i2;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int indexOfSubstringEnd(@NotNull String text2, @NotNull String subString) {
        int i2;
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(295);
        }
        if (subString == null) {
            StringUtil.$$$reportNull$$$0(296);
        }
        if ((i2 = text2.indexOf(subString)) == -1) {
            return -1;
        }
        return i2 + subString.length();
    }

    @Contract(pure=true)
    public static int indexOfAny(@NotNull String s, @NotNull String chars) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(297);
        }
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(298);
        }
        return StringUtil.indexOfAny(s, chars, 0, s.length());
    }

    @Contract(pure=true)
    public static int indexOfAny(@NotNull CharSequence s, @NotNull String chars) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(299);
        }
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(300);
        }
        return StringUtil.indexOfAny(s, chars, 0, s.length());
    }

    @Contract(pure=true)
    public static int indexOfAny(@NotNull String s, @NotNull String chars, int start, int end) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(301);
        }
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(302);
        }
        return StringUtil.indexOfAny((CharSequence)s, chars, start, end);
    }

    @Contract(pure=true)
    public static int indexOfAny(@NotNull CharSequence s, @NotNull String chars, int start, int end) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(303);
        }
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(304);
        }
        end = Math.min(end, s.length());
        for (int i2 = Math.max(start, 0); i2 < end; ++i2) {
            if (!StringUtil.containsChar(chars, s.charAt(i2))) continue;
            return i2;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int lastIndexOfAny(@NotNull CharSequence s, @NotNull String chars) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(305);
        }
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(306);
        }
        for (int i2 = s.length() - 1; i2 >= 0; --i2) {
            if (!StringUtil.containsChar(chars, s.charAt(i2))) continue;
            return i2;
        }
        return -1;
    }

    @Nullable
    @Contract(pure=true)
    public static String substringBefore(@NotNull String text2, @NotNull String subString) {
        int i2;
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(307);
        }
        if (subString == null) {
            StringUtil.$$$reportNull$$$0(308);
        }
        if ((i2 = text2.indexOf(subString)) == -1) {
            return null;
        }
        return text2.substring(0, i2);
    }

    @NotNull
    @Contract(pure=true)
    public static String substringBeforeLast(@NotNull String text2, @NotNull String subString) {
        int i2;
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(309);
        }
        if (subString == null) {
            StringUtil.$$$reportNull$$$0(310);
        }
        if ((i2 = text2.lastIndexOf(subString)) == -1) {
            String string = text2;
            if (string == null) {
                StringUtil.$$$reportNull$$$0(311);
            }
            return string;
        }
        String string = text2.substring(0, i2);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(312);
        }
        return string;
    }

    @Nullable
    @Contract(pure=true)
    public static String substringAfter(@NotNull String text2, @NotNull String subString) {
        int i2;
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(313);
        }
        if (subString == null) {
            StringUtil.$$$reportNull$$$0(314);
        }
        if ((i2 = text2.indexOf(subString)) == -1) {
            return null;
        }
        return text2.substring(i2 + subString.length());
    }

    @Nullable
    @Contract(pure=true)
    public static String substringAfterLast(@NotNull String text2, @NotNull String subString) {
        int i2;
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(315);
        }
        if (subString == null) {
            StringUtil.$$$reportNull$$$0(316);
        }
        if ((i2 = text2.lastIndexOf(subString)) == -1) {
            return null;
        }
        return text2.substring(i2 + subString.length());
    }

    @Contract(pure=true)
    public static int lastIndexOf(@NotNull CharSequence s, char c, int start, int end) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(317);
        }
        return StringUtilRt.lastIndexOf(s, c, start, end);
    }

    @NotNull
    @Contract(pure=true)
    public static String first(@NotNull String text2, int maxLength, boolean appendEllipsis) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(318);
        }
        String string = text2.length() > maxLength ? text2.substring(0, maxLength) + (appendEllipsis ? "..." : "") : text2;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(319);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static CharSequence first(@NotNull CharSequence text2, int length, boolean appendEllipsis) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(320);
        }
        CharSequence charSequence = text2.length() > length ? text2.subSequence(0, length) + (appendEllipsis ? "..." : "") : text2;
        if (charSequence == null) {
            StringUtil.$$$reportNull$$$0(321);
        }
        return charSequence;
    }

    @NotNull
    @Contract(pure=true)
    public static CharSequence last(@NotNull CharSequence text2, int length, boolean prependEllipsis) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(322);
        }
        CharSequence charSequence = text2.length() > length ? (prependEllipsis ? "..." : "") + text2.subSequence(text2.length() - length, text2.length()) : text2;
        if (charSequence == null) {
            StringUtil.$$$reportNull$$$0(323);
        }
        return charSequence;
    }

    @NotNull
    @Contract(pure=true)
    public static String firstLast(@NotNull String text2, int length) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(324);
        }
        String string = text2.length() > length ? text2.subSequence(0, length / 2) + "\u2026" + text2.subSequence(text2.length() - length / 2 - 1, text2.length()) : text2;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(325);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String escapeChar(@NotNull String str, char character) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(326);
        }
        String string = StringUtil.escapeChars(str, character);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(327);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String escapeChars(@NotNull String str, char ... character) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(328);
        }
        StringBuilder buf = new StringBuilder(str);
        for (char c : character) {
            StringUtil.escapeChar(buf, c);
        }
        String string = buf.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(329);
        }
        return string;
    }

    public static void escapeChar(@NotNull StringBuilder buf, char character) {
        if (buf == null) {
            StringUtil.$$$reportNull$$$0(330);
        }
        int idx = 0;
        while ((idx = StringUtil.indexOf((CharSequence)buf, character, idx)) >= 0) {
            buf.insert(idx, "\\");
            idx += 2;
        }
    }

    @NotNull
    @Contract(pure=true)
    public static String escapeQuotes(@NotNull String str) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(331);
        }
        String string = StringUtil.escapeChar(str, '\"');
        if (string == null) {
            StringUtil.$$$reportNull$$$0(332);
        }
        return string;
    }

    public static void escapeQuotes(@NotNull StringBuilder buf) {
        if (buf == null) {
            StringUtil.$$$reportNull$$$0(333);
        }
        StringUtil.escapeChar(buf, '\"');
    }

    @NotNull
    @Contract(pure=true)
    public static String escapeSlashes(@NotNull String str) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(334);
        }
        String string = StringUtil.escapeChar(str, '/');
        if (string == null) {
            StringUtil.$$$reportNull$$$0(335);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String escapeBackSlashes(@NotNull String str) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(336);
        }
        String string = StringUtil.escapeChar(str, '\\');
        if (string == null) {
            StringUtil.$$$reportNull$$$0(337);
        }
        return string;
    }

    public static void escapeSlashes(@NotNull StringBuilder buf) {
        if (buf == null) {
            StringUtil.$$$reportNull$$$0(338);
        }
        StringUtil.escapeChar(buf, '/');
    }

    @NotNull
    @Contract(pure=true)
    public static String unescapeSlashes(@NotNull String str) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(339);
        }
        StringBuilder buf = new StringBuilder(str.length());
        StringUtil.unescapeChar(buf, str, '/');
        String string = buf.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(340);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String unescapeBackSlashes(@NotNull String str) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(341);
        }
        StringBuilder buf = new StringBuilder(str.length());
        StringUtil.unescapeChar(buf, str, '\\');
        String string = buf.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(342);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String unescapeChar(@NotNull String str, char unescapeChar) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(343);
        }
        StringBuilder buf = new StringBuilder(str.length());
        StringUtil.unescapeChar(buf, str, unescapeChar);
        String string = buf.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(344);
        }
        return string;
    }

    private static void unescapeChar(@NotNull StringBuilder buf, @NotNull String str, char unescapeChar) {
        if (buf == null) {
            StringUtil.$$$reportNull$$$0(345);
        }
        if (str == null) {
            StringUtil.$$$reportNull$$$0(346);
        }
        int length = str.length();
        int last2 = length - 1;
        for (int i2 = 0; i2 < length; ++i2) {
            char ch = str.charAt(i2);
            if (ch == '\\' && i2 != last2 && (ch = str.charAt(++i2)) != unescapeChar) {
                buf.append('\\');
            }
            buf.append(ch);
        }
    }

    public static void quote(@NotNull StringBuilder builder) {
        if (builder == null) {
            StringUtil.$$$reportNull$$$0(347);
        }
        StringUtil.quote(builder, '\"');
    }

    public static void quote(@NotNull StringBuilder builder, char quotingChar) {
        if (builder == null) {
            StringUtil.$$$reportNull$$$0(348);
        }
        builder.insert(0, quotingChar);
        builder.append(quotingChar);
    }

    @NotNull
    @Contract(pure=true)
    public static String wrapWithDoubleQuote(@NotNull String str) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(349);
        }
        String string = '\"' + str + "\"";
        if (string == null) {
            StringUtil.$$$reportNull$$$0(350);
        }
        return string;
    }

    @Contract(value="null -> null; !null -> !null", pure=true)
    public static String unescapeXml(@Nullable String text2) {
        if (text2 == null) {
            return null;
        }
        return StringUtil.replace(text2, REPLACES_REFS, REPLACES_DISP);
    }

    @Contract(value="null -> null; !null -> !null", pure=true)
    public static String escapeXml(@Nullable String text2) {
        if (text2 == null) {
            return null;
        }
        return StringUtil.replace(text2, REPLACES_DISP, REPLACES_REFS);
    }

    public static String removeHtmlTags(@Nullable String htmlString) {
        if (StringUtil.isEmpty(htmlString)) {
            return htmlString;
        }
        try {
            html2TextParser.parse(new StringReader(htmlString));
        }
        catch (IOException e) {
            LOG.error(e);
        }
        return html2TextParser.getText();
    }

    @Contract(value="null -> null; !null -> !null", pure=true)
    public static String escapeMnemonics(@Nullable String text2) {
        if (text2 == null) {
            return null;
        }
        return StringUtil.replace(text2, MN_CHARS, MN_QUOTED);
    }

    @NotNull
    @Contract(pure=true)
    public static String htmlEmphasize(@NotNull String text2) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(351);
        }
        String string = "<b><code>" + StringUtil.escapeXml(text2) + "</code></b>";
        if (string == null) {
            StringUtil.$$$reportNull$$$0(352);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String escapeToRegexp(@NotNull String text2) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(353);
        }
        StringBuilder result2 = new StringBuilder(text2.length());
        String string = StringUtil.escapeToRegexp(text2, result2).toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(354);
        }
        return string;
    }

    @NotNull
    public static StringBuilder escapeToRegexp(@NotNull CharSequence text2, @NotNull StringBuilder builder) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(355);
        }
        if (builder == null) {
            StringUtil.$$$reportNull$$$0(356);
        }
        for (int i2 = 0; i2 < text2.length(); ++i2) {
            char c = text2.charAt(i2);
            if (c == ' ' || Character.isLetter(c) || Character.isDigit(c) || c == '_') {
                builder.append(c);
                continue;
            }
            if (c == '\n') {
                builder.append("\\n");
                continue;
            }
            if (c == '\r') {
                builder.append("\\r");
                continue;
            }
            builder.append('\\').append(c);
        }
        StringBuilder stringBuilder = builder;
        if (stringBuilder == null) {
            StringUtil.$$$reportNull$$$0(357);
        }
        return stringBuilder;
    }

    @Contract(pure=true)
    public static boolean isEscapedBackslash(@NotNull char[] chars, int startOffset, int backslashOffset) {
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(358);
        }
        if (chars[backslashOffset] != '\\') {
            return true;
        }
        boolean escaped = false;
        for (int i2 = startOffset; i2 < backslashOffset; ++i2) {
            escaped = chars[i2] == '\\' ? !escaped : false;
        }
        return escaped;
    }

    @Contract(pure=true)
    public static boolean isEscapedBackslash(@NotNull CharSequence text2, int startOffset, int backslashOffset) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(359);
        }
        if (text2.charAt(backslashOffset) != '\\') {
            return true;
        }
        boolean escaped = false;
        for (int i2 = startOffset; i2 < backslashOffset; ++i2) {
            escaped = text2.charAt(i2) == '\\' ? !escaped : false;
        }
        return escaped;
    }

    @NotNull
    @Contract(pure=true)
    public static String replace(@NotNull String text2, @NotNull String[] from, @NotNull String[] to) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(360);
        }
        if (from == null) {
            StringUtil.$$$reportNull$$$0(361);
        }
        if (to == null) {
            StringUtil.$$$reportNull$$$0(362);
        }
        String string = StringUtil.replace(text2, Arrays.asList(from), Arrays.asList(to));
        if (string == null) {
            StringUtil.$$$reportNull$$$0(363);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String replace(@NotNull String text2, @NotNull List<String> from, @NotNull List<String> to) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(364);
        }
        if (from == null) {
            StringUtil.$$$reportNull$$$0(365);
        }
        if (to == null) {
            StringUtil.$$$reportNull$$$0(366);
        }
        assert (from.size() == to.size());
        StringBuilder result2 = new StringBuilder(text2.length());
        block0: for (int i2 = 0; i2 < text2.length(); ++i2) {
            for (int j = 0; j < from.size(); ++j) {
                String toReplace = from.get(j);
                String replaceWith = to.get(j);
                int len = toReplace.length();
                if (!text2.regionMatches(i2, toReplace, 0, len)) continue;
                result2.append(replaceWith);
                i2 += len - 1;
                continue block0;
            }
            result2.append(text2.charAt(i2));
        }
        String string = result2.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(367);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String[] filterEmptyStrings(@NotNull String[] strings) {
        if (strings == null) {
            StringUtil.$$$reportNull$$$0(368);
        }
        int emptyCount = 0;
        for (String string : strings) {
            if (string != null && !string.isEmpty()) continue;
            ++emptyCount;
        }
        if (emptyCount == 0) {
            if (strings == null) {
                StringUtil.$$$reportNull$$$0(369);
            }
            return strings;
        }
        String[] result2 = ArrayUtil.newStringArray(strings.length - emptyCount);
        int count2 = 0;
        for (String string : strings) {
            if (string == null || string.isEmpty()) continue;
            result2[count2++] = string;
        }
        if (result2 == null) {
            StringUtil.$$$reportNull$$$0(370);
        }
        return result2;
    }

    @Contract(pure=true)
    public static int countNewLines(@NotNull CharSequence text2) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(371);
        }
        return StringUtil.countChars(text2, '\n');
    }

    @Contract(pure=true)
    public static int countChars(@NotNull CharSequence text2, char c) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(372);
        }
        return StringUtil.countChars(text2, c, 0, false);
    }

    @Contract(pure=true)
    public static int countChars(@NotNull CharSequence text2, char c, int offset2, boolean stopAtOtherChar) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(373);
        }
        return StringUtil.countChars(text2, c, offset2, text2.length(), stopAtOtherChar);
    }

    @Contract(pure=true)
    public static int countChars(@NotNull CharSequence text2, char c, int start, int end, boolean stopAtOtherChar) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(374);
        }
        int count2 = 0;
        int len = Math.min(text2.length(), end);
        for (int i2 = start; i2 < len; ++i2) {
            if (text2.charAt(i2) == c) {
                ++count2;
                continue;
            }
            if (stopAtOtherChar) break;
        }
        return count2;
    }

    @NotNull
    @Contract(pure=true)
    public static String capitalsOnly(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(375);
        }
        StringBuilder b2 = new StringBuilder();
        for (int i2 = 0; i2 < s.length(); ++i2) {
            if (!Character.isUpperCase(s.charAt(i2))) continue;
            b2.append(s.charAt(i2));
        }
        String string = b2.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(376);
        }
        return string;
    }

    @Nullable
    @Contract(pure=true)
    public static String joinOrNull(String ... args) {
        if (args == null) {
            StringUtil.$$$reportNull$$$0(377);
        }
        StringBuilder r = new StringBuilder();
        for (String arg : args) {
            if (arg == null) {
                return null;
            }
            r.append(arg);
        }
        return r.toString();
    }

    @Nullable
    @Contract(pure=true)
    public static String getPropertyName(@NonNls @NotNull String methodName) {
        if (methodName == null) {
            StringUtil.$$$reportNull$$$0(378);
        }
        if (methodName.startsWith("get")) {
            return Introspector.decapitalize(methodName.substring(3));
        }
        if (methodName.startsWith("is")) {
            return Introspector.decapitalize(methodName.substring(2));
        }
        if (methodName.startsWith("set")) {
            return Introspector.decapitalize(methodName.substring(3));
        }
        return null;
    }

    @Contract(pure=true)
    public static boolean isJavaIdentifierStart(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || Character.isJavaIdentifierStart(c);
    }

    @Contract(pure=true)
    public static boolean isJavaIdentifierPart(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || Character.isJavaIdentifierPart(c);
    }

    @Contract(pure=true)
    public static boolean isJavaIdentifier(@NotNull String text2) {
        int len;
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(379);
        }
        if ((len = text2.length()) == 0) {
            return false;
        }
        if (!StringUtil.isJavaIdentifierStart(text2.charAt(0))) {
            return false;
        }
        for (int i2 = 1; i2 < len; ++i2) {
            if (StringUtil.isJavaIdentifierPart(text2.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    @NotNull
    @Contract(pure=true)
    public static String escapeProperty(@NotNull String input2, boolean isKey) {
        if (input2 == null) {
            StringUtil.$$$reportNull$$$0(380);
        }
        StringBuilder escaped = new StringBuilder(input2.length());
        block8: for (int i2 = 0; i2 < input2.length(); ++i2) {
            char ch = input2.charAt(i2);
            switch (ch) {
                case ' ': {
                    if (isKey && i2 == 0) {
                        escaped.append('\\');
                    }
                    escaped.append(' ');
                    continue block8;
                }
                case '\t': {
                    escaped.append("\\t");
                    continue block8;
                }
                case '\r': {
                    escaped.append("\\r");
                    continue block8;
                }
                case '\n': {
                    escaped.append("\\n");
                    continue block8;
                }
                case '\f': {
                    escaped.append("\\f");
                    continue block8;
                }
                case '!': 
                case '#': 
                case ':': 
                case '=': 
                case '\\': {
                    escaped.append('\\');
                    escaped.append(ch);
                    continue block8;
                }
                default: {
                    if ('\u0014' < ch && ch < '\u007f') {
                        escaped.append(ch);
                        continue block8;
                    }
                    escaped.append("\\u");
                    escaped.append(Character.forDigit(ch >> 12 & 0xF, 16));
                    escaped.append(Character.forDigit(ch >> 8 & 0xF, 16));
                    escaped.append(Character.forDigit(ch >> 4 & 0xF, 16));
                    escaped.append(Character.forDigit(ch & 0xF, 16));
                }
            }
        }
        String string = escaped.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(381);
        }
        return string;
    }

    @Contract(pure=true)
    public static String getQualifiedName(@Nullable String packageName, String className2) {
        if (packageName == null || packageName.isEmpty()) {
            return className2;
        }
        return packageName + '.' + className2;
    }

    @Contract(pure=true)
    public static int compareVersionNumbers(@Nullable String v1, @Nullable String v2) {
        String[] parts;
        int idx;
        if (v1 == null && v2 == null) {
            return 0;
        }
        if (v1 == null) {
            return -1;
        }
        if (v2 == null) {
            return 1;
        }
        String[] part1 = v1.split("[\\.\\_\\-]");
        String[] part2 = v2.split("[\\.\\_\\-]");
        for (idx = 0; idx < part1.length && idx < part2.length; ++idx) {
            String p1 = part1[idx];
            String p2 = part2[idx];
            int cmp = p1.matches("\\d+") && p2.matches("\\d+") ? new Integer(p1).compareTo(new Integer(p2)) : part1[idx].compareTo(part2[idx]);
            if (cmp == 0) continue;
            return cmp;
        }
        if (part1.length == part2.length) {
            return 0;
        }
        boolean left = part1.length > idx;
        String[] stringArray = parts = left ? part1 : part2;
        while (idx < parts.length) {
            String p2 = parts[idx];
            int cmp = p2.matches("\\d+") ? new Integer(p2).compareTo(0) : 1;
            if (cmp != 0) {
                return left ? cmp : -cmp;
            }
            ++idx;
        }
        return 0;
    }

    @Contract(pure=true)
    public static int getOccurrenceCount(@NotNull String text2, char c) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(382);
        }
        int res2 = 0;
        for (int i2 = 0; i2 < text2.length() && (i2 = text2.indexOf(c, i2)) >= 0; ++i2) {
            ++res2;
        }
        return res2;
    }

    @Contract(pure=true)
    public static int getOccurrenceCount(@NotNull String text2, @NotNull String s) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(383);
        }
        if (s == null) {
            StringUtil.$$$reportNull$$$0(384);
        }
        int res2 = 0;
        for (int i2 = 0; i2 < text2.length() && (i2 = text2.indexOf(s, i2)) >= 0; ++i2) {
            ++res2;
        }
        return res2;
    }

    @Contract(pure=true)
    public static int getIgnoreCaseOccurrenceCount(@NotNull String text2, @NotNull String s) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(385);
        }
        if (s == null) {
            StringUtil.$$$reportNull$$$0(386);
        }
        int res2 = 0;
        for (int i2 = 0; i2 < text2.length() && (i2 = StringUtil.indexOfIgnoreCase(text2, s, i2)) >= 0; ++i2) {
            ++res2;
        }
        return res2;
    }

    @NotNull
    @Contract(pure=true)
    public static String fixVariableNameDerivedFromPropertyName(@NotNull String name) {
        if (name == null) {
            StringUtil.$$$reportNull$$$0(387);
        }
        if (StringUtil.isEmptyOrSpaces(name)) {
            String string = name;
            if (string == null) {
                StringUtil.$$$reportNull$$$0(388);
            }
            return string;
        }
        char c = name.charAt(0);
        if (StringUtil.isVowel(c)) {
            String string = "an" + Character.toUpperCase(c) + name.substring(1);
            if (string == null) {
                StringUtil.$$$reportNull$$$0(389);
            }
            return string;
        }
        String string = "a" + Character.toUpperCase(c) + name.substring(1);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(390);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String sanitizeJavaIdentifier(@NotNull String name) {
        if (name == null) {
            StringUtil.$$$reportNull$$$0(391);
        }
        StringBuilder result2 = new StringBuilder(name.length());
        for (int i2 = 0; i2 < name.length(); ++i2) {
            char ch = name.charAt(i2);
            if (!Character.isJavaIdentifierPart(ch)) continue;
            if (result2.length() == 0 && !Character.isJavaIdentifierStart(ch)) {
                result2.append("_");
            }
            result2.append(ch);
        }
        String string = result2.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(392);
        }
        return string;
    }

    public static void assertValidSeparators(@NotNull CharSequence s) {
        int i2;
        if (s == null) {
            StringUtil.$$$reportNull$$$0(393);
        }
        char[] chars = CharArrayUtil.fromSequenceWithoutCopying(s);
        int slashRIndex = -1;
        if (chars != null) {
            int len = s.length();
            for (i2 = 0; i2 < len; ++i2) {
                if (chars[i2] != '\r') continue;
                slashRIndex = i2;
                break;
            }
        } else {
            int len = s.length();
            for (i2 = 0; i2 < len; ++i2) {
                if (s.charAt(i2) != '\r') continue;
                slashRIndex = i2;
                break;
            }
        }
        if (slashRIndex != -1) {
            String context = String.valueOf(StringUtil.last(s.subSequence(0, slashRIndex), 10, true)) + StringUtil.first(s.subSequence(slashRIndex, s.length()), 10, true);
            context = StringUtil.escapeStringCharacters(context);
            throw new AssertionError((Object)("Wrong line separators: '" + context + "' at offset " + slashRIndex));
        }
    }

    @NotNull
    @Contract(pure=true)
    public static String tail(@NotNull String s, int idx) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(394);
        }
        String string = idx >= s.length() ? "" : s.substring(idx, s.length());
        if (string == null) {
            StringUtil.$$$reportNull$$$0(395);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String[] splitByLines(@NotNull String string) {
        if (string == null) {
            StringUtil.$$$reportNull$$$0(396);
        }
        String[] stringArray = StringUtil.splitByLines(string, true);
        if (stringArray == null) {
            StringUtil.$$$reportNull$$$0(397);
        }
        return stringArray;
    }

    @NotNull
    @Contract(pure=true)
    public static String[] splitByLines(@NotNull String string, boolean excludeEmptyStrings) {
        if (string == null) {
            StringUtil.$$$reportNull$$$0(398);
        }
        String[] stringArray = (excludeEmptyStrings ? EOL_SPLIT_PATTERN : EOL_SPLIT_PATTERN_WITH_EMPTY).split(string);
        if (stringArray == null) {
            StringUtil.$$$reportNull$$$0(399);
        }
        return stringArray;
    }

    @NotNull
    @Contract(pure=true)
    public static String[] splitByLinesDontTrim(@NotNull String string) {
        if (string == null) {
            StringUtil.$$$reportNull$$$0(400);
        }
        String[] stringArray = EOL_SPLIT_DONT_TRIM_PATTERN.split(string);
        if (stringArray == null) {
            StringUtil.$$$reportNull$$$0(401);
        }
        return stringArray;
    }

    @NotNull
    @Contract(pure=true)
    public static String[] splitByLinesKeepSeparators(@NotNull String string) {
        if (string == null) {
            StringUtil.$$$reportNull$$$0(402);
        }
        String[] stringArray = EOL_SPLIT_KEEP_SEPARATORS.split(string);
        if (stringArray == null) {
            StringUtil.$$$reportNull$$$0(403);
        }
        return stringArray;
    }

    @NotNull
    @Contract(pure=true)
    public static List<Pair<String, Integer>> getWordsWithOffset(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(404);
        }
        ArrayList<Pair<String, Integer>> res2 = ContainerUtil.newArrayList();
        s = s + " ";
        StringBuilder name = new StringBuilder();
        int startInd = -1;
        for (int i2 = 0; i2 < s.length(); ++i2) {
            if (Character.isWhitespace(s.charAt(i2))) {
                if (name.length() <= 0) continue;
                res2.add(Pair.create(name.toString(), startInd));
                name.setLength(0);
                startInd = -1;
                continue;
            }
            if (startInd == -1) {
                startInd = i2;
            }
            name.append(s.charAt(i2));
        }
        ArrayList<Pair<String, Integer>> arrayList = res2;
        if (arrayList == null) {
            StringUtil.$$$reportNull$$$0(405);
        }
        return arrayList;
    }

    @Contract(pure=true)
    public static int naturalCompare(@Nullable String string1, @Nullable String string2) {
        return NaturalComparator.INSTANCE.compare(string1, string2);
    }

    @Contract(pure=true)
    public static boolean isDecimalDigit(char c) {
        return c >= '0' && c <= '9';
    }

    @Contract(pure=true)
    public static int compare(@Nullable String s1, @Nullable String s2, boolean ignoreCase) {
        if (s1 == s2) {
            return 0;
        }
        if (s1 == null) {
            return -1;
        }
        if (s2 == null) {
            return 1;
        }
        return ignoreCase ? s1.compareToIgnoreCase(s2) : s1.compareTo(s2);
    }

    @Contract(pure=true)
    public static int comparePairs(@Nullable String s1, @Nullable String t1, @Nullable String s2, @Nullable String t2, boolean ignoreCase) {
        int compare = StringUtil.compare(s1, s2, ignoreCase);
        return compare != 0 ? compare : StringUtil.compare(t1, t2, ignoreCase);
    }

    @Contract(pure=true)
    public static int hashCode(@NotNull CharSequence s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(406);
        }
        return StringUtil.stringHashCode(s);
    }

    @Contract(pure=true)
    public static boolean equals(@Nullable CharSequence s1, @Nullable CharSequence s2) {
        if (s1 == null ^ s2 == null) {
            return false;
        }
        if (s1 == null) {
            return true;
        }
        if (s1.length() != s2.length()) {
            return false;
        }
        for (int i2 = 0; i2 < s1.length(); ++i2) {
            if (s1.charAt(i2) == s2.charAt(i2)) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static boolean equalsIgnoreCase(@Nullable CharSequence s1, @Nullable CharSequence s2) {
        if (s1 == null ^ s2 == null) {
            return false;
        }
        if (s1 == null) {
            return true;
        }
        if (s1.length() != s2.length()) {
            return false;
        }
        for (int i2 = 0; i2 < s1.length(); ++i2) {
            if (StringUtil.charsEqualIgnoreCase(s1.charAt(i2), s2.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static boolean equalsIgnoreWhitespaces(@Nullable CharSequence s1, @Nullable CharSequence s2) {
        if (s1 == null ^ s2 == null) {
            return false;
        }
        if (s1 == null) {
            return true;
        }
        int len1 = s1.length();
        int len2 = s2.length();
        int index1 = 0;
        int index2 = 0;
        while (index1 < len1 && index2 < len2) {
            if (s1.charAt(index1) == s2.charAt(index2)) {
                ++index1;
                ++index2;
                continue;
            }
            boolean skipped = false;
            while (index1 != len1 && StringUtil.isWhiteSpace(s1.charAt(index1))) {
                skipped = true;
                ++index1;
            }
            while (index2 != len2 && StringUtil.isWhiteSpace(s2.charAt(index2))) {
                skipped = true;
                ++index2;
            }
            if (skipped) continue;
            return false;
        }
        while (index1 != len1) {
            if (!StringUtil.isWhiteSpace(s1.charAt(index1))) {
                return false;
            }
            ++index1;
        }
        while (index2 != len2) {
            if (!StringUtil.isWhiteSpace(s2.charAt(index2))) {
                return false;
            }
            ++index2;
        }
        return true;
    }

    @Contract(pure=true)
    public static boolean equalsTrimWhitespaces(@NotNull CharSequence s1, @NotNull CharSequence s2) {
        char c;
        int start2;
        char c2;
        int start1;
        if (s1 == null) {
            StringUtil.$$$reportNull$$$0(407);
        }
        if (s2 == null) {
            StringUtil.$$$reportNull$$$0(408);
        }
        int end1 = s1.length();
        int end2 = s2.length();
        for (start1 = 0; start1 < end1 && StringUtil.isWhiteSpace(c2 = s1.charAt(start1)); ++start1) {
        }
        while (start1 < end1 && StringUtil.isWhiteSpace(c2 = s1.charAt(end1 - 1))) {
            --end1;
        }
        for (start2 = 0; start2 < end2 && StringUtil.isWhiteSpace(c = s2.charAt(start2)); ++start2) {
        }
        while (start2 < end2 && StringUtil.isWhiteSpace(c = s2.charAt(end2 - 1))) {
            --end2;
        }
        CharSequenceSubSequence ts1 = new CharSequenceSubSequence(s1, start1, end1);
        CharSequenceSubSequence ts2 = new CharSequenceSubSequence(s2, start2, end2);
        return StringUtil.equals(ts1, ts2);
    }

    @Contract(pure=true)
    public static boolean findIgnoreCase(@Nullable String toFind, String ... where) {
        if (where == null) {
            StringUtil.$$$reportNull$$$0(409);
        }
        for (String string : where) {
            if (!StringUtil.equalsIgnoreCase(toFind, string)) continue;
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    public static int compare(char c1, char c2, boolean ignoreCase) {
        char u2;
        int d = c1 - c2;
        if (d == 0 || !ignoreCase) {
            return d;
        }
        char u1 = StringUtilRt.toUpperCase(c1);
        d = u1 - (u2 = StringUtilRt.toUpperCase(c2));
        if (d != 0) {
            d = StringUtilRt.toLowerCase(u1) - StringUtilRt.toLowerCase(u2);
        }
        return d;
    }

    @Contract(pure=true)
    public static boolean charsMatch(char c1, char c2, boolean ignoreCase) {
        return StringUtil.compare(c1, c2, ignoreCase) == 0;
    }

    @NotNull
    @Contract(pure=true)
    public static String formatLinks(@NotNull String message) {
        if (message == null) {
            StringUtil.$$$reportNull$$$0(410);
        }
        Pattern linkPattern = Pattern.compile("http://[a-zA-Z0-9\\./\\-\\+]+");
        StringBuffer result2 = new StringBuffer();
        Matcher m = linkPattern.matcher(message);
        while (m.find()) {
            m.appendReplacement(result2, "<a href=\"" + m.group() + "\">" + m.group() + "</a>");
        }
        m.appendTail(result2);
        String string = result2.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(411);
        }
        return string;
    }

    @Contract(pure=true)
    public static boolean isHexDigit(char c) {
        return '0' <= c && c <= '9' || 'a' <= c && c <= 'f' || 'A' <= c && c <= 'F';
    }

    @Contract(pure=true)
    public static boolean isOctalDigit(char c) {
        return '0' <= c && c <= '7';
    }

    @NotNull
    @Contract(pure=true)
    public static String shortenTextWithEllipsis(@NotNull String text2, int maxLength, int suffixLength) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(412);
        }
        String string = StringUtil.shortenTextWithEllipsis(text2, maxLength, suffixLength, false);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(413);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String trimMiddle(@NotNull String text2, int maxLength) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(414);
        }
        String string = StringUtil.shortenTextWithEllipsis(text2, maxLength, maxLength >> 1, true);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(415);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String shortenTextWithEllipsis(@NotNull String text2, int maxLength, int suffixLength, @NotNull String symbol2) {
        int textLength;
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(416);
        }
        if (symbol2 == null) {
            StringUtil.$$$reportNull$$$0(417);
        }
        if ((textLength = text2.length()) > maxLength) {
            int prefixLength = maxLength - suffixLength - symbol2.length();
            assert (prefixLength > 0);
            String string = text2.substring(0, prefixLength) + symbol2 + text2.substring(textLength - suffixLength);
            if (string == null) {
                StringUtil.$$$reportNull$$$0(418);
            }
            return string;
        }
        String string = text2;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(419);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String shortenTextWithEllipsis(@NotNull String text2, int maxLength, int suffixLength, boolean useEllipsisSymbol) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(420);
        }
        String symbol2 = useEllipsisSymbol ? "\u2026" : "...";
        String string = StringUtil.shortenTextWithEllipsis(text2, maxLength, suffixLength, symbol2);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(421);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String shortenPathWithEllipsis(@NotNull String path2, int maxLength, boolean useEllipsisSymbol) {
        if (path2 == null) {
            StringUtil.$$$reportNull$$$0(422);
        }
        String string = StringUtil.shortenTextWithEllipsis(path2, maxLength, (int)((double)maxLength * 0.7), useEllipsisSymbol);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(423);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String shortenPathWithEllipsis(@NotNull String path2, int maxLength) {
        if (path2 == null) {
            StringUtil.$$$reportNull$$$0(424);
        }
        String string = StringUtil.shortenPathWithEllipsis(path2, maxLength, false);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(425);
        }
        return string;
    }

    @Contract(pure=true)
    public static boolean charsEqualIgnoreCase(char a2, char b2) {
        return StringUtil.charsMatch(a2, b2, true);
    }

    @Contract(pure=true)
    public static char toUpperCase(char a2) {
        return StringUtilRt.toUpperCase(a2);
    }

    @Contract(value="null -> null; !null -> !null", pure=true)
    public static String toUpperCase(String a2) {
        return a2 == null ? null : StringUtilRt.toUpperCase(a2).toString();
    }

    @Contract(pure=true)
    public static char toLowerCase(char a2) {
        return StringUtilRt.toLowerCase(a2);
    }

    @Nullable
    public static LineSeparator detectSeparators(@NotNull CharSequence text2) {
        int index2;
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(426);
        }
        if ((index2 = StringUtil.indexOfAny(text2, "\n\r")) == -1) {
            return null;
        }
        LineSeparator lineSeparator = StringUtil.getLineSeparatorAt(text2, index2);
        if (lineSeparator == null) {
            throw new AssertionError();
        }
        return lineSeparator;
    }

    @Nullable
    public static LineSeparator getLineSeparatorAt(@NotNull CharSequence text2, int index2) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(427);
        }
        if (index2 < 0 || index2 >= text2.length()) {
            return null;
        }
        char ch = text2.charAt(index2);
        if (ch == '\r') {
            return index2 + 1 < text2.length() && text2.charAt(index2 + 1) == '\n' ? LineSeparator.CRLF : LineSeparator.CR;
        }
        return ch == '\n' ? LineSeparator.LF : null;
    }

    @NotNull
    @Contract(pure=true)
    public static String convertLineSeparators(@NotNull String text2) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(428);
        }
        String string = StringUtilRt.convertLineSeparators(text2);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(429);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String convertLineSeparators(@NotNull String text2, boolean keepCarriageReturn) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(430);
        }
        String string = StringUtilRt.convertLineSeparators(text2, keepCarriageReturn);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(431);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String convertLineSeparators(@NotNull String text2, @NotNull String newSeparator) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(432);
        }
        if (newSeparator == null) {
            StringUtil.$$$reportNull$$$0(433);
        }
        String string = StringUtilRt.convertLineSeparators(text2, newSeparator);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(434);
        }
        return string;
    }

    @NotNull
    public static String convertLineSeparators(@NotNull String text2, @NotNull String newSeparator, @Nullable int[] offsetsToKeep) {
        if (text2 == null) {
            StringUtil.$$$reportNull$$$0(435);
        }
        if (newSeparator == null) {
            StringUtil.$$$reportNull$$$0(436);
        }
        String string = StringUtilRt.convertLineSeparators(text2, newSeparator, offsetsToKeep);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(437);
        }
        return string;
    }

    @Contract(pure=true)
    public static int parseInt(String string, int defaultValue) {
        return StringUtilRt.parseInt(string, defaultValue);
    }

    @Contract(pure=true)
    public static long parseLong(@Nullable String string, long defaultValue) {
        return StringUtilRt.parseLong(string, defaultValue);
    }

    @Contract(pure=true)
    public static double parseDouble(String string, double defaultValue) {
        return StringUtilRt.parseDouble(string, defaultValue);
    }

    @Contract(pure=true)
    public static boolean parseBoolean(String string, boolean defaultValue) {
        return StringUtilRt.parseBoolean(string, defaultValue);
    }

    @Contract(pure=true)
    public static <E extends Enum<E>> E parseEnum(@NotNull String string, E defaultValue, @NotNull Class<E> clazz) {
        if (string == null) {
            StringUtil.$$$reportNull$$$0(438);
        }
        if (clazz == null) {
            StringUtil.$$$reportNull$$$0(439);
        }
        return StringUtilRt.parseEnum(string, defaultValue, clazz);
    }

    @NotNull
    @Contract(pure=true)
    public static String getShortName(@NotNull Class aClass2) {
        if (aClass2 == null) {
            StringUtil.$$$reportNull$$$0(440);
        }
        String string = StringUtilRt.getShortName(aClass2);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(441);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String getShortName(@NotNull String fqName2) {
        if (fqName2 == null) {
            StringUtil.$$$reportNull$$$0(442);
        }
        String string = StringUtilRt.getShortName(fqName2);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(443);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String getShortName(@NotNull String fqName2, char separator) {
        if (fqName2 == null) {
            StringUtil.$$$reportNull$$$0(444);
        }
        String string = StringUtilRt.getShortName(fqName2, separator);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(445);
        }
        return string;
    }

    @Contract(value="null->null;!null->!null")
    static String toShortString(@Nullable Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof CharSequence) {
            return o.toString();
        }
        String className2 = o.getClass().getName();
        String s = o.toString();
        if (!s.startsWith(className2)) {
            return s;
        }
        return s.length() > className2.length() && !Character.isLetter(s.charAt(className2.length())) ? StringUtil.trimStart(s, className2) : s;
    }

    @NotNull
    @Contract(pure=true)
    public static CharSequence newBombedCharSequence(@NotNull CharSequence sequence2, long delay) {
        if (sequence2 == null) {
            StringUtil.$$$reportNull$$$0(446);
        }
        final long myTime = System.currentTimeMillis() + delay;
        BombedCharSequence bombedCharSequence = new BombedCharSequence(sequence2){

            @Override
            protected void checkCanceled() {
                long l = System.currentTimeMillis();
                if (l >= myTime) {
                    throw new ProcessCanceledException();
                }
            }
        };
        if (bombedCharSequence == null) {
            StringUtil.$$$reportNull$$$0(447);
        }
        return bombedCharSequence;
    }

    public static boolean trimEnd(@NotNull StringBuilder buffer, @NotNull CharSequence end) {
        if (buffer == null) {
            StringUtil.$$$reportNull$$$0(448);
        }
        if (end == null) {
            StringUtil.$$$reportNull$$$0(449);
        }
        if (StringUtil.endsWith(buffer, end)) {
            buffer.delete(buffer.length() - end.length(), buffer.length());
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    public static boolean isBetween(@NotNull String string, @NotNull String smallPart, @NotNull String bigPart) {
        String s;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(450);
        }
        if (smallPart == null) {
            StringUtil.$$$reportNull$$$0(451);
        }
        if (bigPart == null) {
            StringUtil.$$$reportNull$$$0(452);
        }
        return (s = string.toLowerCase()).startsWith(smallPart.toLowerCase()) && bigPart.toLowerCase().startsWith(s);
    }

    public static boolean hasUpperCaseChar(String s) {
        char[] chars;
        for (char c : chars = s.toCharArray()) {
            if (!Character.isUpperCase(c)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasLowerCaseChar(String s) {
        char[] chars;
        for (char c : chars = s.toCharArray()) {
            if (!Character.isLowerCase(c)) continue;
            return true;
        }
        return false;
    }

    public static String replaceUnicodeEscapeSequences(String text2) {
        if (text2 == null) {
            return null;
        }
        Matcher matcher = UNICODE_CHAR.matcher(text2);
        if (!matcher.find()) {
            return text2;
        }
        matcher.reset();
        int lastEnd = 0;
        StringBuilder sb = new StringBuilder(text2.length());
        while (matcher.find()) {
            sb.append(text2.substring(lastEnd, matcher.start()));
            char c = (char)Integer.parseInt(matcher.group().substring(2), 16);
            sb.append(c);
            lastEnd = matcher.end();
        }
        sb.append(text2.substring(lastEnd, text2.length()));
        return sb.toString();
    }

    @Contract(pure=true)
    @NotNull
    public static String toHexString(@NotNull byte[] bytes) {
        if (bytes == null) {
            StringUtil.$$$reportNull$$$0(453);
        }
        String digits = "0123456789abcdef";
        StringBuilder sb = new StringBuilder(2 * bytes.length);
        for (byte b2 : bytes) {
            sb.append(digits.charAt(b2 >> 4 & 0xF)).append(digits.charAt(b2 & 0xF));
        }
        String string = sb.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(454);
        }
        return string;
    }

    public static boolean startsWithConcatenationOf(@NotNull String string, @NotNull String firstPrefix, @NotNull String secondPrefix) {
        if (string == null) {
            StringUtil.$$$reportNull$$$0(455);
        }
        if (firstPrefix == null) {
            StringUtil.$$$reportNull$$$0(456);
        }
        if (secondPrefix == null) {
            StringUtil.$$$reportNull$$$0(457);
        }
        return StringUtil.startsWithConcatenation(string, firstPrefix, secondPrefix);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 9: 
            case 13: 
            case 15: 
            case 30: 
            case 32: 
            case 34: 
            case 35: 
            case 39: 
            case 46: 
            case 48: 
            case 50: 
            case 53: 
            case 57: 
            case 62: 
            case 65: 
            case 68: 
            case 70: 
            case 72: 
            case 74: 
            case 78: 
            case 79: 
            case 81: 
            case 82: 
            case 86: 
            case 87: 
            case 88: 
            case 90: 
            case 93: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 100: 
            case 101: 
            case 114: 
            case 117: 
            case 118: 
            case 120: 
            case 121: 
            case 123: 
            case 124: 
            case 126: 
            case 128: 
            case 130: 
            case 132: 
            case 134: 
            case 136: 
            case 138: 
            case 140: 
            case 143: 
            case 144: 
            case 146: 
            case 148: 
            case 149: 
            case 151: 
            case 153: 
            case 155: 
            case 158: 
            case 160: 
            case 162: 
            case 164: 
            case 167: 
            case 170: 
            case 173: 
            case 176: 
            case 179: 
            case 180: 
            case 183: 
            case 185: 
            case 187: 
            case 188: 
            case 190: 
            case 193: 
            case 196: 
            case 199: 
            case 201: 
            case 205: 
            case 209: 
            case 210: 
            case 211: 
            case 217: 
            case 224: 
            case 225: 
            case 231: 
            case 232: 
            case 233: 
            case 235: 
            case 236: 
            case 237: 
            case 238: 
            case 239: 
            case 249: 
            case 252: 
            case 255: 
            case 261: 
            case 271: 
            case 278: 
            case 311: 
            case 312: 
            case 319: 
            case 321: 
            case 323: 
            case 325: 
            case 327: 
            case 329: 
            case 332: 
            case 335: 
            case 337: 
            case 340: 
            case 342: 
            case 344: 
            case 350: 
            case 352: 
            case 354: 
            case 357: 
            case 363: 
            case 367: 
            case 369: 
            case 370: 
            case 376: 
            case 381: 
            case 388: 
            case 389: 
            case 390: 
            case 392: 
            case 395: 
            case 397: 
            case 399: 
            case 401: 
            case 403: 
            case 405: 
            case 411: 
            case 413: 
            case 415: 
            case 418: 
            case 419: 
            case 421: 
            case 423: 
            case 425: 
            case 429: 
            case 431: 
            case 434: 
            case 437: 
            case 441: 
            case 443: 
            case 445: 
            case 447: 
            case 454: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 9: 
            case 13: 
            case 15: 
            case 30: 
            case 32: 
            case 34: 
            case 35: 
            case 39: 
            case 46: 
            case 48: 
            case 50: 
            case 53: 
            case 57: 
            case 62: 
            case 65: 
            case 68: 
            case 70: 
            case 72: 
            case 74: 
            case 78: 
            case 79: 
            case 81: 
            case 82: 
            case 86: 
            case 87: 
            case 88: 
            case 90: 
            case 93: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 100: 
            case 101: 
            case 114: 
            case 117: 
            case 118: 
            case 120: 
            case 121: 
            case 123: 
            case 124: 
            case 126: 
            case 128: 
            case 130: 
            case 132: 
            case 134: 
            case 136: 
            case 138: 
            case 140: 
            case 143: 
            case 144: 
            case 146: 
            case 148: 
            case 149: 
            case 151: 
            case 153: 
            case 155: 
            case 158: 
            case 160: 
            case 162: 
            case 164: 
            case 167: 
            case 170: 
            case 173: 
            case 176: 
            case 179: 
            case 180: 
            case 183: 
            case 185: 
            case 187: 
            case 188: 
            case 190: 
            case 193: 
            case 196: 
            case 199: 
            case 201: 
            case 205: 
            case 209: 
            case 210: 
            case 211: 
            case 217: 
            case 224: 
            case 225: 
            case 231: 
            case 232: 
            case 233: 
            case 235: 
            case 236: 
            case 237: 
            case 238: 
            case 239: 
            case 249: 
            case 252: 
            case 255: 
            case 261: 
            case 271: 
            case 278: 
            case 311: 
            case 312: 
            case 319: 
            case 321: 
            case 323: 
            case 325: 
            case 327: 
            case 329: 
            case 332: 
            case 335: 
            case 337: 
            case 340: 
            case 342: 
            case 344: 
            case 350: 
            case 352: 
            case 354: 
            case 357: 
            case 363: 
            case 367: 
            case 369: 
            case 370: 
            case 376: 
            case 381: 
            case 388: 
            case 389: 
            case 390: 
            case 392: 
            case 395: 
            case 397: 
            case 399: 
            case 401: 
            case 403: 
            case 405: 
            case 411: 
            case 413: 
            case 415: 
            case 418: 
            case 419: 
            case 421: 
            case 423: 
            case 425: 
            case 429: 
            case 431: 
            case 434: 
            case 437: 
            case 441: 
            case 443: 
            case 445: 
            case 447: 
            case 454: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "find";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 9: 
            case 13: 
            case 15: 
            case 30: 
            case 32: 
            case 34: 
            case 35: 
            case 39: 
            case 46: 
            case 48: 
            case 50: 
            case 53: 
            case 57: 
            case 62: 
            case 65: 
            case 68: 
            case 70: 
            case 72: 
            case 74: 
            case 78: 
            case 79: 
            case 81: 
            case 82: 
            case 86: 
            case 87: 
            case 88: 
            case 90: 
            case 93: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 100: 
            case 101: 
            case 114: 
            case 117: 
            case 118: 
            case 120: 
            case 121: 
            case 123: 
            case 124: 
            case 126: 
            case 128: 
            case 130: 
            case 132: 
            case 134: 
            case 136: 
            case 138: 
            case 140: 
            case 143: 
            case 144: 
            case 146: 
            case 148: 
            case 149: 
            case 151: 
            case 153: 
            case 155: 
            case 158: 
            case 160: 
            case 162: 
            case 164: 
            case 167: 
            case 170: 
            case 173: 
            case 176: 
            case 179: 
            case 180: 
            case 183: 
            case 185: 
            case 187: 
            case 188: 
            case 190: 
            case 193: 
            case 196: 
            case 199: 
            case 201: 
            case 205: 
            case 209: 
            case 210: 
            case 211: 
            case 217: 
            case 224: 
            case 225: 
            case 231: 
            case 232: 
            case 233: 
            case 235: 
            case 236: 
            case 237: 
            case 238: 
            case 239: 
            case 249: 
            case 252: 
            case 255: 
            case 261: 
            case 271: 
            case 278: 
            case 311: 
            case 312: 
            case 319: 
            case 321: 
            case 323: 
            case 325: 
            case 327: 
            case 329: 
            case 332: 
            case 335: 
            case 337: 
            case 340: 
            case 342: 
            case 344: 
            case 350: 
            case 352: 
            case 354: 
            case 357: 
            case 363: 
            case 367: 
            case 369: 
            case 370: 
            case 376: 
            case 381: 
            case 388: 
            case 389: 
            case 390: 
            case 392: 
            case 395: 
            case 397: 
            case 399: 
            case 401: 
            case 403: 
            case 405: 
            case 411: 
            case 413: 
            case 415: 
            case 418: 
            case 419: 
            case 421: 
            case 423: 
            case 425: 
            case 429: 
            case 431: 
            case 434: 
            case 437: 
            case 441: 
            case 443: 
            case 445: 
            case 447: 
            case 454: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/text/StringUtil";
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 16: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 89: 
            case 91: 
            case 122: 
            case 186: 
            case 189: 
            case 234: 
            case 262: 
            case 263: 
            case 265: 
            case 267: 
            case 295: 
            case 307: 
            case 309: 
            case 313: 
            case 315: 
            case 318: 
            case 320: 
            case 322: 
            case 324: 
            case 351: 
            case 353: 
            case 355: 
            case 359: 
            case 360: 
            case 364: 
            case 371: 
            case 372: 
            case 373: 
            case 374: 
            case 379: 
            case 382: 
            case 383: 
            case 385: 
            case 412: 
            case 414: 
            case 416: 
            case 420: 
            case 426: 
            case 427: 
            case 428: 
            case 430: 
            case 432: 
            case 435: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cls";
                break;
            }
            case 7: 
            case 11: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldS";
                break;
            }
            case 8: 
            case 12: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newS";
                break;
            }
            case 14: 
            case 59: 
            case 61: 
            case 64: 
            case 67: 
            case 84: 
            case 150: 
            case 448: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 409: {
                objectArray2 = objectArray3;
                objectArray3[0] = "where";
                break;
            }
            case 20: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "what";
                break;
            }
            case 25: 
            case 27: 
            case 58: 
            case 60: 
            case 63: 
            case 66: 
            case 326: 
            case 328: 
            case 331: 
            case 334: 
            case 336: 
            case 339: 
            case 341: 
            case 343: 
            case 346: 
            case 349: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 26: 
            case 113: 
            case 116: 
            case 268: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 28: 
            case 142: 
            case 264: 
            case 266: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "html";
                break;
            }
            case 31: 
            case 33: 
            case 442: 
            case 444: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqName";
                break;
            }
            case 43: 
            case 269: 
            case 272: 
            case 274: 
            case 276: 
            case 279: 
            case 407: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s1";
                break;
            }
            case 44: 
            case 270: 
            case 273: 
            case 275: 
            case 277: 
            case 280: 
            case 408: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s2";
                break;
            }
            case 45: 
            case 47: 
            case 49: 
            case 51: 
            case 54: 
            case 55: 
            case 69: 
            case 71: 
            case 73: 
            case 75: 
            case 76: 
            case 77: 
            case 80: 
            case 83: 
            case 94: 
            case 99: 
            case 112: 
            case 115: 
            case 119: 
            case 141: 
            case 161: 
            case 163: 
            case 165: 
            case 168: 
            case 171: 
            case 174: 
            case 177: 
            case 181: 
            case 247: 
            case 250: 
            case 253: 
            case 256: 
            case 281: 
            case 282: 
            case 283: 
            case 284: 
            case 293: 
            case 294: 
            case 297: 
            case 299: 
            case 301: 
            case 303: 
            case 305: 
            case 317: 
            case 375: 
            case 384: 
            case 386: 
            case 393: 
            case 394: 
            case 404: 
            case 406: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 52: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prepositions";
                break;
            }
            case 85: 
            case 240: {
                objectArray2 = objectArray3;
                objectArray3[0] = "word";
                break;
            }
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenizerDelim";
                break;
            }
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 243: 
            case 245: 
            case 298: 
            case 300: 
            case 302: 
            case 304: 
            case 306: 
            case 358: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chars";
                break;
            }
            case 110: 
            case 125: 
            case 127: 
            case 129: 
            case 133: 
            case 135: 
            case 137: 
            case 258: 
            case 396: 
            case 398: 
            case 400: 
            case 402: 
            case 438: 
            case 450: 
            case 455: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 111: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefixes";
                break;
            }
            case 131: 
            case 139: 
            case 347: 
            case 348: 
            case 356: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 145: 
            case 387: 
            case 391: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 147: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 152: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 154: 
            case 156: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aThrowable";
                break;
            }
            case 157: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stackFrameSkipPattern";
                break;
            }
            case 159: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 166: 
            case 169: 
            case 172: 
            case 175: 
            case 178: 
            case 192: 
            case 195: 
            case 204: 
            case 208: 
            case 213: 
            case 216: 
            case 220: 
            case 223: 
            case 227: 
            case 230: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
            case 182: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separators";
                break;
            }
            case 184: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenizer";
                break;
            }
            case 191: 
            case 194: 
            case 222: 
            case 226: 
            case 229: 
            case 368: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strings";
                break;
            }
            case 197: 
            case 200: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strings1";
                break;
            }
            case 198: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strings2";
                break;
            }
            case 202: 
            case 206: 
            case 212: 
            case 214: 
            case 218: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 203: 
            case 207: 
            case 215: 
            case 219: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 221: 
            case 228: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 241: 
            case 242: 
            case 244: 
            case 246: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 248: 
            case 257: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 251: 
            case 254: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 259: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 260: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacement";
                break;
            }
            case 285: 
            case 287: 
            case 289: 
            case 291: 
            case 446: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 286: 
            case 288: 
            case 290: 
            case 292: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infix";
                break;
            }
            case 296: 
            case 308: 
            case 310: 
            case 314: 
            case 316: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subString";
                break;
            }
            case 330: 
            case 333: 
            case 338: 
            case 345: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buf";
                break;
            }
            case 361: 
            case 365: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 362: 
            case 366: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 377: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 378: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 380: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 410: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 417: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 422: 
            case 424: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 433: 
            case 436: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSeparator";
                break;
            }
            case 439: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 440: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 449: {
                objectArray2 = objectArray3;
                objectArray3[0] = "end";
                break;
            }
            case 451: {
                objectArray2 = objectArray3;
                objectArray3[0] = "smallPart";
                break;
            }
            case 452: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bigPart";
                break;
            }
            case 453: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
            case 456: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstPrefix";
                break;
            }
            case 457: {
                objectArray2 = objectArray3;
                objectArray3[0] = "secondPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/text/StringUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getWordsInStringLongestFirst";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "escapePattern";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createToStringFunction";
                break;
            }
            case 9: 
            case 363: 
            case 367: {
                objectArray = objectArray2;
                objectArray2[1] = "replace";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceIgnoreCase";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceChar";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "stripHtml";
                break;
            }
            case 32: 
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageName";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeLineBreak";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "wordsToBeginFromUpperCase";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "wordsToBeginFromLowerCase";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "toTitleCase";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "fixCapitalization";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "escaper";
                break;
            }
            case 62: 
            case 65: 
            case 68: 
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeStringCharacters";
                break;
            }
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeCharCharacters";
                break;
            }
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "unescapeStringCharacters";
                break;
            }
            case 78: 
            case 79: 
            case 81: 
            case 82: {
                objectArray = objectArray2;
                objectArray2[1] = "unquoteString";
                break;
            }
            case 86: 
            case 87: 
            case 88: 
            case 148: 
            case 149: {
                objectArray = objectArray2;
                objectArray2[1] = "pluralize";
                break;
            }
            case 90: 
            case 93: {
                objectArray = objectArray2;
                objectArray2[1] = "capitalizeWords";
                break;
            }
            case 95: 
            case 96: 
            case 97: 
            case 98: {
                objectArray = objectArray2;
                objectArray2[1] = "capitalize";
                break;
            }
            case 100: 
            case 101: {
                objectArray = objectArray2;
                objectArray2[1] = "capitalizeWithJavaBeanConvention";
                break;
            }
            case 114: 
            case 117: 
            case 118: 
            case 120: 
            case 121: {
                objectArray = objectArray2;
                objectArray2[1] = "trimEnd";
                break;
            }
            case 123: 
            case 124: {
                objectArray = objectArray2;
                objectArray2[1] = "trimLog";
                break;
            }
            case 126: 
            case 128: 
            case 130: 
            case 132: {
                objectArray = objectArray2;
                objectArray2[1] = "trimLeading";
                break;
            }
            case 134: 
            case 136: 
            case 138: 
            case 140: {
                objectArray = objectArray2;
                objectArray2[1] = "trimTrailing";
                break;
            }
            case 143: 
            case 144: {
                objectArray = objectArray2;
                objectArray2[1] = "trimStart";
                break;
            }
            case 146: {
                objectArray = objectArray2;
                objectArray2[1] = "trimExtensions";
                break;
            }
            case 151: 
            case 153: {
                objectArray = objectArray2;
                objectArray2[1] = "notNullize";
                break;
            }
            case 155: 
            case 158: {
                objectArray = objectArray2;
                objectArray2[1] = "getThrowableText";
                break;
            }
            case 160: {
                objectArray = objectArray2;
                objectArray2[1] = "repeatSymbol";
                break;
            }
            case 162: {
                objectArray = objectArray2;
                objectArray2[1] = "repeat";
                break;
            }
            case 164: {
                objectArray = objectArray2;
                objectArray2[1] = "splitHonorQuotes";
                break;
            }
            case 167: 
            case 170: 
            case 173: 
            case 176: 
            case 179: 
            case 180: {
                objectArray = objectArray2;
                objectArray2[1] = "split";
                break;
            }
            case 183: 
            case 185: {
                objectArray = objectArray2;
                objectArray2[1] = "tokenize";
                break;
            }
            case 187: 
            case 188: {
                objectArray = objectArray2;
                objectArray2[1] = "getWordsIn";
                break;
            }
            case 190: {
                objectArray = objectArray2;
                objectArray2[1] = "getWordIndicesIn";
                break;
            }
            case 193: 
            case 196: 
            case 205: 
            case 209: 
            case 210: 
            case 211: 
            case 217: 
            case 224: 
            case 225: 
            case 231: 
            case 232: 
            case 233: {
                objectArray = objectArray2;
                objectArray2[1] = "join";
                break;
            }
            case 199: {
                objectArray = objectArray2;
                objectArray2[1] = "zip";
                break;
            }
            case 201: {
                objectArray = objectArray2;
                objectArray2[1] = "surround";
                break;
            }
            case 235: 
            case 236: {
                objectArray = objectArray2;
                objectArray2[1] = "stripQuotesAroundValue";
                break;
            }
            case 237: {
                objectArray = objectArray2;
                objectArray2[1] = "formatFileSize";
                break;
            }
            case 238: {
                objectArray = objectArray2;
                objectArray2[1] = "formatDuration";
                break;
            }
            case 239: {
                objectArray = objectArray2;
                objectArray2[1] = "formatValue";
                break;
            }
            case 249: {
                objectArray = objectArray2;
                objectArray2[1] = "strip";
                break;
            }
            case 252: 
            case 255: {
                objectArray = objectArray2;
                objectArray2[1] = "findMatches";
                break;
            }
            case 261: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceSubstring";
                break;
            }
            case 271: {
                objectArray = objectArray2;
                objectArray2[1] = "commonPrefix";
                break;
            }
            case 278: {
                objectArray = objectArray2;
                objectArray2[1] = "commonSuffix";
                break;
            }
            case 311: 
            case 312: {
                objectArray = objectArray2;
                objectArray2[1] = "substringBeforeLast";
                break;
            }
            case 319: 
            case 321: {
                objectArray = objectArray2;
                objectArray2[1] = "first";
                break;
            }
            case 323: {
                objectArray = objectArray2;
                objectArray2[1] = "last";
                break;
            }
            case 325: {
                objectArray = objectArray2;
                objectArray2[1] = "firstLast";
                break;
            }
            case 327: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeChar";
                break;
            }
            case 329: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeChars";
                break;
            }
            case 332: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeQuotes";
                break;
            }
            case 335: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeSlashes";
                break;
            }
            case 337: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeBackSlashes";
                break;
            }
            case 340: {
                objectArray = objectArray2;
                objectArray2[1] = "unescapeSlashes";
                break;
            }
            case 342: {
                objectArray = objectArray2;
                objectArray2[1] = "unescapeBackSlashes";
                break;
            }
            case 344: {
                objectArray = objectArray2;
                objectArray2[1] = "unescapeChar";
                break;
            }
            case 350: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapWithDoubleQuote";
                break;
            }
            case 352: {
                objectArray = objectArray2;
                objectArray2[1] = "htmlEmphasize";
                break;
            }
            case 354: 
            case 357: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeToRegexp";
                break;
            }
            case 369: 
            case 370: {
                objectArray = objectArray2;
                objectArray2[1] = "filterEmptyStrings";
                break;
            }
            case 376: {
                objectArray = objectArray2;
                objectArray2[1] = "capitalsOnly";
                break;
            }
            case 381: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeProperty";
                break;
            }
            case 388: 
            case 389: 
            case 390: {
                objectArray = objectArray2;
                objectArray2[1] = "fixVariableNameDerivedFromPropertyName";
                break;
            }
            case 392: {
                objectArray = objectArray2;
                objectArray2[1] = "sanitizeJavaIdentifier";
                break;
            }
            case 395: {
                objectArray = objectArray2;
                objectArray2[1] = "tail";
                break;
            }
            case 397: 
            case 399: {
                objectArray = objectArray2;
                objectArray2[1] = "splitByLines";
                break;
            }
            case 401: {
                objectArray = objectArray2;
                objectArray2[1] = "splitByLinesDontTrim";
                break;
            }
            case 403: {
                objectArray = objectArray2;
                objectArray2[1] = "splitByLinesKeepSeparators";
                break;
            }
            case 405: {
                objectArray = objectArray2;
                objectArray2[1] = "getWordsWithOffset";
                break;
            }
            case 411: {
                objectArray = objectArray2;
                objectArray2[1] = "formatLinks";
                break;
            }
            case 413: 
            case 418: 
            case 419: 
            case 421: {
                objectArray = objectArray2;
                objectArray2[1] = "shortenTextWithEllipsis";
                break;
            }
            case 415: {
                objectArray = objectArray2;
                objectArray2[1] = "trimMiddle";
                break;
            }
            case 423: 
            case 425: {
                objectArray = objectArray2;
                objectArray2[1] = "shortenPathWithEllipsis";
                break;
            }
            case 429: 
            case 431: 
            case 434: 
            case 437: {
                objectArray = objectArray2;
                objectArray2[1] = "convertLineSeparators";
                break;
            }
            case 441: 
            case 443: 
            case 445: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 447: {
                objectArray = objectArray2;
                objectArray2[1] = "newBombedCharSequence";
                break;
            }
            case 454: {
                objectArray = objectArray2;
                objectArray2[1] = "toHexString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getWordsInStringLongestFirst";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 9: 
            case 13: 
            case 15: 
            case 30: 
            case 32: 
            case 34: 
            case 35: 
            case 39: 
            case 46: 
            case 48: 
            case 50: 
            case 53: 
            case 57: 
            case 62: 
            case 65: 
            case 68: 
            case 70: 
            case 72: 
            case 74: 
            case 78: 
            case 79: 
            case 81: 
            case 82: 
            case 86: 
            case 87: 
            case 88: 
            case 90: 
            case 93: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 100: 
            case 101: 
            case 114: 
            case 117: 
            case 118: 
            case 120: 
            case 121: 
            case 123: 
            case 124: 
            case 126: 
            case 128: 
            case 130: 
            case 132: 
            case 134: 
            case 136: 
            case 138: 
            case 140: 
            case 143: 
            case 144: 
            case 146: 
            case 148: 
            case 149: 
            case 151: 
            case 153: 
            case 155: 
            case 158: 
            case 160: 
            case 162: 
            case 164: 
            case 167: 
            case 170: 
            case 173: 
            case 176: 
            case 179: 
            case 180: 
            case 183: 
            case 185: 
            case 187: 
            case 188: 
            case 190: 
            case 193: 
            case 196: 
            case 199: 
            case 201: 
            case 205: 
            case 209: 
            case 210: 
            case 211: 
            case 217: 
            case 224: 
            case 225: 
            case 231: 
            case 232: 
            case 233: 
            case 235: 
            case 236: 
            case 237: 
            case 238: 
            case 239: 
            case 249: 
            case 252: 
            case 255: 
            case 261: 
            case 271: 
            case 278: 
            case 311: 
            case 312: 
            case 319: 
            case 321: 
            case 323: 
            case 325: 
            case 327: 
            case 329: 
            case 332: 
            case 335: 
            case 337: 
            case 340: 
            case 342: 
            case 344: 
            case 350: 
            case 352: 
            case 354: 
            case 357: 
            case 363: 
            case 367: 
            case 369: 
            case 370: 
            case 376: 
            case 381: 
            case 388: 
            case 389: 
            case 390: 
            case 392: 
            case 395: 
            case 397: 
            case 399: 
            case 401: 
            case 403: 
            case 405: 
            case 411: 
            case 413: 
            case 415: 
            case 418: 
            case 419: 
            case 421: 
            case 423: 
            case 425: 
            case 429: 
            case 431: 
            case 434: 
            case 437: 
            case 441: 
            case 443: 
            case 445: 
            case 447: 
            case 454: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "escapePattern";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createToStringFunction";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 16: 
            case 17: 
            case 18: 
            case 360: 
            case 361: 
            case 362: 
            case 364: 
            case 365: 
            case 366: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "replaceIgnoreCase";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "replaceChar";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "indexOfIgnoreCase";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "lastIndexOfIgnoreCase";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "containsIgnoreCase";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "endsWithIgnoreCase";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "startsWithIgnoreCase";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "stripHtml";
                break;
            }
            case 31: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getPackageName";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getLineBreakCount";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "containsLineBreak";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "escapeLineBreak";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "endsWithLineBreak";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "lineColToOffset";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "offsetToLineNumber";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "difference";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "wordsToBeginFromUpperCase";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "wordsToBeginFromLowerCase";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "toTitleCase";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "fixCapitalization";
                break;
            }
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "isPreposition";
                break;
            }
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 63: 
            case 64: 
            case 66: 
            case 67: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "escapeStringCharacters";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "escapeCharCharacters";
                break;
            }
            case 73: 
            case 83: 
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "unescapeStringCharacters";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "isQuoteAt";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "isQuotedString";
                break;
            }
            case 77: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "unquoteString";
                break;
            }
            case 85: 
            case 147: {
                objectArray = objectArray;
                objectArray[2] = "pluralize";
                break;
            }
            case 89: 
            case 91: 
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "capitalizeWords";
                break;
            }
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "capitalize";
                break;
            }
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "capitalizeWithJavaBeanConvention";
                break;
            }
            case 102: 
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "stringHashCode";
                break;
            }
            case 104: 
            case 105: 
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "stringHashCodeInsensitive";
                break;
            }
            case 107: 
            case 108: 
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "stringHashCodeIgnoreWhitespaces";
                break;
            }
            case 110: 
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "startsWithConcatenation";
                break;
            }
            case 112: 
            case 113: 
            case 115: 
            case 116: 
            case 119: 
            case 448: 
            case 449: {
                objectArray = objectArray;
                objectArray[2] = "trimEnd";
                break;
            }
            case 122: {
                objectArray = objectArray;
                objectArray[2] = "trimLog";
                break;
            }
            case 125: 
            case 127: 
            case 129: 
            case 131: {
                objectArray = objectArray;
                objectArray[2] = "trimLeading";
                break;
            }
            case 133: 
            case 135: 
            case 137: 
            case 139: {
                objectArray = objectArray;
                objectArray[2] = "trimTrailing";
                break;
            }
            case 141: 
            case 142: {
                objectArray = objectArray;
                objectArray[2] = "trimStart";
                break;
            }
            case 145: {
                objectArray = objectArray;
                objectArray[2] = "trimExtensions";
                break;
            }
            case 150: {
                objectArray = objectArray;
                objectArray[2] = "repeatSymbol";
                break;
            }
            case 152: {
                objectArray = objectArray;
                objectArray[2] = "notNullize";
                break;
            }
            case 154: 
            case 156: 
            case 157: {
                objectArray = objectArray;
                objectArray[2] = "getThrowableText";
                break;
            }
            case 159: {
                objectArray = objectArray;
                objectArray[2] = "getMessage";
                break;
            }
            case 161: {
                objectArray = objectArray;
                objectArray[2] = "repeat";
                break;
            }
            case 163: {
                objectArray = objectArray;
                objectArray[2] = "splitHonorQuotes";
                break;
            }
            case 165: 
            case 166: 
            case 168: 
            case 169: 
            case 171: 
            case 172: 
            case 174: 
            case 175: 
            case 177: 
            case 178: {
                objectArray = objectArray;
                objectArray[2] = "split";
                break;
            }
            case 181: 
            case 182: 
            case 184: {
                objectArray = objectArray;
                objectArray[2] = "tokenize";
                break;
            }
            case 186: {
                objectArray = objectArray;
                objectArray[2] = "getWordsIn";
                break;
            }
            case 189: {
                objectArray = objectArray;
                objectArray[2] = "getWordIndicesIn";
                break;
            }
            case 191: 
            case 192: 
            case 194: 
            case 195: 
            case 202: 
            case 203: 
            case 204: 
            case 206: 
            case 207: 
            case 208: 
            case 212: 
            case 213: 
            case 214: 
            case 215: 
            case 216: 
            case 218: 
            case 219: 
            case 220: 
            case 221: 
            case 222: 
            case 223: 
            case 226: 
            case 227: 
            case 228: 
            case 229: 
            case 230: {
                objectArray = objectArray;
                objectArray[2] = "join";
                break;
            }
            case 197: 
            case 198: {
                objectArray = objectArray;
                objectArray[2] = "zip";
                break;
            }
            case 200: {
                objectArray = objectArray;
                objectArray[2] = "surround";
                break;
            }
            case 234: {
                objectArray = objectArray;
                objectArray[2] = "stripQuotesAroundValue";
                break;
            }
            case 240: {
                objectArray = objectArray;
                objectArray[2] = "unpluralize";
                break;
            }
            case 241: {
                objectArray = objectArray;
                objectArray[2] = "containsAlphaCharacters";
                break;
            }
            case 242: 
            case 243: 
            case 244: 
            case 245: {
                objectArray = objectArray;
                objectArray[2] = "containsAnyChar";
                break;
            }
            case 246: {
                objectArray = objectArray;
                objectArray[2] = "containsChar";
                break;
            }
            case 247: 
            case 248: {
                objectArray = objectArray;
                objectArray[2] = "strip";
                break;
            }
            case 250: 
            case 251: 
            case 253: 
            case 254: {
                objectArray = objectArray;
                objectArray[2] = "findMatches";
                break;
            }
            case 256: 
            case 257: {
                objectArray = objectArray;
                objectArray[2] = "findFirst";
                break;
            }
            case 258: 
            case 259: 
            case 260: {
                objectArray = objectArray;
                objectArray[2] = "replaceSubstring";
                break;
            }
            case 262: {
                objectArray = objectArray;
                objectArray[2] = "startsWithWhitespace";
                break;
            }
            case 263: 
            case 264: 
            case 265: 
            case 266: {
                objectArray = objectArray;
                objectArray[2] = "startsWith";
                break;
            }
            case 267: 
            case 268: {
                objectArray = objectArray;
                objectArray[2] = "endsWith";
                break;
            }
            case 269: 
            case 270: {
                objectArray = objectArray;
                objectArray[2] = "commonPrefix";
                break;
            }
            case 272: 
            case 273: 
            case 274: 
            case 275: {
                objectArray = objectArray;
                objectArray[2] = "commonPrefixLength";
                break;
            }
            case 276: 
            case 277: {
                objectArray = objectArray;
                objectArray[2] = "commonSuffix";
                break;
            }
            case 279: 
            case 280: {
                objectArray = objectArray;
                objectArray[2] = "commonSuffixLength";
                break;
            }
            case 281: 
            case 285: 
            case 286: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 282: 
            case 283: 
            case 284: 
            case 287: 
            case 288: 
            case 289: 
            case 290: 
            case 291: 
            case 292: 
            case 293: 
            case 294: {
                objectArray = objectArray;
                objectArray[2] = "indexOf";
                break;
            }
            case 295: 
            case 296: {
                objectArray = objectArray;
                objectArray[2] = "indexOfSubstringEnd";
                break;
            }
            case 297: 
            case 298: 
            case 299: 
            case 300: 
            case 301: 
            case 302: 
            case 303: 
            case 304: {
                objectArray = objectArray;
                objectArray[2] = "indexOfAny";
                break;
            }
            case 305: 
            case 306: {
                objectArray = objectArray;
                objectArray[2] = "lastIndexOfAny";
                break;
            }
            case 307: 
            case 308: {
                objectArray = objectArray;
                objectArray[2] = "substringBefore";
                break;
            }
            case 309: 
            case 310: {
                objectArray = objectArray;
                objectArray[2] = "substringBeforeLast";
                break;
            }
            case 313: 
            case 314: {
                objectArray = objectArray;
                objectArray[2] = "substringAfter";
                break;
            }
            case 315: 
            case 316: {
                objectArray = objectArray;
                objectArray[2] = "substringAfterLast";
                break;
            }
            case 317: {
                objectArray = objectArray;
                objectArray[2] = "lastIndexOf";
                break;
            }
            case 318: 
            case 320: {
                objectArray = objectArray;
                objectArray[2] = "first";
                break;
            }
            case 322: {
                objectArray = objectArray;
                objectArray[2] = "last";
                break;
            }
            case 324: {
                objectArray = objectArray;
                objectArray[2] = "firstLast";
                break;
            }
            case 326: 
            case 330: {
                objectArray = objectArray;
                objectArray[2] = "escapeChar";
                break;
            }
            case 328: {
                objectArray = objectArray;
                objectArray[2] = "escapeChars";
                break;
            }
            case 331: 
            case 333: {
                objectArray = objectArray;
                objectArray[2] = "escapeQuotes";
                break;
            }
            case 334: 
            case 338: {
                objectArray = objectArray;
                objectArray[2] = "escapeSlashes";
                break;
            }
            case 336: {
                objectArray = objectArray;
                objectArray[2] = "escapeBackSlashes";
                break;
            }
            case 339: {
                objectArray = objectArray;
                objectArray[2] = "unescapeSlashes";
                break;
            }
            case 341: {
                objectArray = objectArray;
                objectArray[2] = "unescapeBackSlashes";
                break;
            }
            case 343: 
            case 345: 
            case 346: {
                objectArray = objectArray;
                objectArray[2] = "unescapeChar";
                break;
            }
            case 347: 
            case 348: {
                objectArray = objectArray;
                objectArray[2] = "quote";
                break;
            }
            case 349: {
                objectArray = objectArray;
                objectArray[2] = "wrapWithDoubleQuote";
                break;
            }
            case 351: {
                objectArray = objectArray;
                objectArray[2] = "htmlEmphasize";
                break;
            }
            case 353: 
            case 355: 
            case 356: {
                objectArray = objectArray;
                objectArray[2] = "escapeToRegexp";
                break;
            }
            case 358: 
            case 359: {
                objectArray = objectArray;
                objectArray[2] = "isEscapedBackslash";
                break;
            }
            case 368: {
                objectArray = objectArray;
                objectArray[2] = "filterEmptyStrings";
                break;
            }
            case 371: {
                objectArray = objectArray;
                objectArray[2] = "countNewLines";
                break;
            }
            case 372: 
            case 373: 
            case 374: {
                objectArray = objectArray;
                objectArray[2] = "countChars";
                break;
            }
            case 375: {
                objectArray = objectArray;
                objectArray[2] = "capitalsOnly";
                break;
            }
            case 377: {
                objectArray = objectArray;
                objectArray[2] = "joinOrNull";
                break;
            }
            case 378: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyName";
                break;
            }
            case 379: {
                objectArray = objectArray;
                objectArray[2] = "isJavaIdentifier";
                break;
            }
            case 380: {
                objectArray = objectArray;
                objectArray[2] = "escapeProperty";
                break;
            }
            case 382: 
            case 383: 
            case 384: {
                objectArray = objectArray;
                objectArray[2] = "getOccurrenceCount";
                break;
            }
            case 385: 
            case 386: {
                objectArray = objectArray;
                objectArray[2] = "getIgnoreCaseOccurrenceCount";
                break;
            }
            case 387: {
                objectArray = objectArray;
                objectArray[2] = "fixVariableNameDerivedFromPropertyName";
                break;
            }
            case 391: {
                objectArray = objectArray;
                objectArray[2] = "sanitizeJavaIdentifier";
                break;
            }
            case 393: {
                objectArray = objectArray;
                objectArray[2] = "assertValidSeparators";
                break;
            }
            case 394: {
                objectArray = objectArray;
                objectArray[2] = "tail";
                break;
            }
            case 396: 
            case 398: {
                objectArray = objectArray;
                objectArray[2] = "splitByLines";
                break;
            }
            case 400: {
                objectArray = objectArray;
                objectArray[2] = "splitByLinesDontTrim";
                break;
            }
            case 402: {
                objectArray = objectArray;
                objectArray[2] = "splitByLinesKeepSeparators";
                break;
            }
            case 404: {
                objectArray = objectArray;
                objectArray[2] = "getWordsWithOffset";
                break;
            }
            case 406: {
                objectArray = objectArray;
                objectArray[2] = "hashCode";
                break;
            }
            case 407: 
            case 408: {
                objectArray = objectArray;
                objectArray[2] = "equalsTrimWhitespaces";
                break;
            }
            case 409: {
                objectArray = objectArray;
                objectArray[2] = "findIgnoreCase";
                break;
            }
            case 410: {
                objectArray = objectArray;
                objectArray[2] = "formatLinks";
                break;
            }
            case 412: 
            case 416: 
            case 417: 
            case 420: {
                objectArray = objectArray;
                objectArray[2] = "shortenTextWithEllipsis";
                break;
            }
            case 414: {
                objectArray = objectArray;
                objectArray[2] = "trimMiddle";
                break;
            }
            case 422: 
            case 424: {
                objectArray = objectArray;
                objectArray[2] = "shortenPathWithEllipsis";
                break;
            }
            case 426: {
                objectArray = objectArray;
                objectArray[2] = "detectSeparators";
                break;
            }
            case 427: {
                objectArray = objectArray;
                objectArray[2] = "getLineSeparatorAt";
                break;
            }
            case 428: 
            case 430: 
            case 432: 
            case 433: 
            case 435: 
            case 436: {
                objectArray = objectArray;
                objectArray[2] = "convertLineSeparators";
                break;
            }
            case 438: 
            case 439: {
                objectArray = objectArray;
                objectArray[2] = "parseEnum";
                break;
            }
            case 440: 
            case 442: 
            case 444: {
                objectArray = objectArray;
                objectArray[2] = "getShortName";
                break;
            }
            case 446: {
                objectArray = objectArray;
                objectArray[2] = "newBombedCharSequence";
                break;
            }
            case 450: 
            case 451: 
            case 452: {
                objectArray = objectArray;
                objectArray[2] = "isBetween";
                break;
            }
            case 453: {
                objectArray = objectArray;
                objectArray[2] = "toHexString";
                break;
            }
            case 455: 
            case 456: 
            case 457: {
                objectArray = objectArray;
                objectArray[2] = "startsWithConcatenationOf";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 9: 
            case 13: 
            case 15: 
            case 30: 
            case 32: 
            case 34: 
            case 35: 
            case 39: 
            case 46: 
            case 48: 
            case 50: 
            case 53: 
            case 57: 
            case 62: 
            case 65: 
            case 68: 
            case 70: 
            case 72: 
            case 74: 
            case 78: 
            case 79: 
            case 81: 
            case 82: 
            case 86: 
            case 87: 
            case 88: 
            case 90: 
            case 93: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 100: 
            case 101: 
            case 114: 
            case 117: 
            case 118: 
            case 120: 
            case 121: 
            case 123: 
            case 124: 
            case 126: 
            case 128: 
            case 130: 
            case 132: 
            case 134: 
            case 136: 
            case 138: 
            case 140: 
            case 143: 
            case 144: 
            case 146: 
            case 148: 
            case 149: 
            case 151: 
            case 153: 
            case 155: 
            case 158: 
            case 160: 
            case 162: 
            case 164: 
            case 167: 
            case 170: 
            case 173: 
            case 176: 
            case 179: 
            case 180: 
            case 183: 
            case 185: 
            case 187: 
            case 188: 
            case 190: 
            case 193: 
            case 196: 
            case 199: 
            case 201: 
            case 205: 
            case 209: 
            case 210: 
            case 211: 
            case 217: 
            case 224: 
            case 225: 
            case 231: 
            case 232: 
            case 233: 
            case 235: 
            case 236: 
            case 237: 
            case 238: 
            case 239: 
            case 249: 
            case 252: 
            case 255: 
            case 261: 
            case 271: 
            case 278: 
            case 311: 
            case 312: 
            case 319: 
            case 321: 
            case 323: 
            case 325: 
            case 327: 
            case 329: 
            case 332: 
            case 335: 
            case 337: 
            case 340: 
            case 342: 
            case 344: 
            case 350: 
            case 352: 
            case 354: 
            case 357: 
            case 363: 
            case 367: 
            case 369: 
            case 370: 
            case 376: 
            case 381: 
            case 388: 
            case 389: 
            case 390: 
            case 392: 
            case 395: 
            case 397: 
            case 399: 
            case 401: 
            case 403: 
            case 405: 
            case 411: 
            case 413: 
            case 415: 
            case 418: 
            case 419: 
            case 421: 
            case 423: 
            case 425: 
            case 429: 
            case 431: 
            case 434: 
            case 437: 
            case 441: 
            case 443: 
            case 445: 
            case 447: 
            case 454: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static abstract class BombedCharSequence
    implements CharSequence {
        private final CharSequence delegate;
        private int i;

        public BombedCharSequence(@NotNull CharSequence sequence2) {
            if (sequence2 == null) {
                BombedCharSequence.$$$reportNull$$$0(0);
            }
            this.delegate = sequence2;
        }

        @Override
        public int length() {
            this.check();
            return this.delegate.length();
        }

        @Override
        public char charAt(int i2) {
            this.check();
            return this.delegate.charAt(i2);
        }

        protected void check() {
            if ((++this.i & 0x3FF) == 0) {
                this.checkCanceled();
            }
        }

        @Override
        @NotNull
        public String toString() {
            this.check();
            String string = this.delegate.toString();
            if (string == null) {
                BombedCharSequence.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected abstract void checkCanceled();

        @Override
        @NotNull
        public CharSequence subSequence(int i2, int i1) {
            this.check();
            CharSequence charSequence = this.delegate.subSequence(i2, i1);
            if (charSequence == null) {
                BombedCharSequence.$$$reportNull$$$0(2);
            }
            return charSequence;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sequence";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/util/text/StringUtil$BombedCharSequence";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/util/text/StringUtil$BombedCharSequence";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "subSequence";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MyHtml2Text
    extends HTMLEditorKit.ParserCallback {
        @NotNull
        private final StringBuilder myBuffer = new StringBuilder();

        private MyHtml2Text() {
        }

        public void parse(Reader in) throws IOException {
            this.myBuffer.setLength(0);
            new ParserDelegator().parse(in, this, Boolean.TRUE);
        }

        @Override
        public void handleText(char[] text2, int pos) {
            this.myBuffer.append(text2);
        }

        @Override
        public void handleStartTag(HTML.Tag tag, MutableAttributeSet set, int i2) {
            this.handleTag(tag);
        }

        @Override
        public void handleSimpleTag(HTML.Tag tag, MutableAttributeSet set, int i2) {
            this.handleTag(tag);
        }

        private void handleTag(HTML.Tag tag) {
            if (tag.breaksFlow() && this.myBuffer.length() > 0) {
                this.myBuffer.append(SystemProperties.getLineSeparator());
            }
        }

        public String getText() {
            return this.myBuffer.toString();
        }
    }
}

