/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies;

import com.intellij.analysis.AnalysisScope;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageDependencies.DependencyRule;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.packageDependencies.DependencyVisitorFactory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiFileEx;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DependenciesBuilder {
    private final Project myProject;
    private final AnalysisScope myScope;
    private final AnalysisScope myScopeOfInterest;
    private final Map<PsiFile, Set<PsiFile>> myDependencies;
    protected int myTotalFileCount;
    protected int myFileCount;
    protected int myTransitive;

    protected DependenciesBuilder(@NotNull Project project, @NotNull AnalysisScope scope) {
        if (project == null) {
            DependenciesBuilder.$$$reportNull$$$0(0);
        }
        if (scope == null) {
            DependenciesBuilder.$$$reportNull$$$0(1);
        }
        this(project, scope, null);
    }

    public DependenciesBuilder(Project project, AnalysisScope scope, @Nullable AnalysisScope scopeOfInterest) {
        this.myDependencies = new HashMap<PsiFile, Set<PsiFile>>();
        this.myFileCount = 0;
        this.myTransitive = 0;
        this.myProject = project;
        this.myScope = scope;
        this.myScopeOfInterest = scopeOfInterest;
        this.myTotalFileCount = scope.getFileCount();
    }

    public void setInitialFileCount(int fileCount) {
        this.myFileCount = fileCount;
    }

    public void setTotalFileCount(int totalFileCount) {
        this.myTotalFileCount = totalFileCount;
    }

    public int getTotalFileCount() {
        return this.myTotalFileCount;
    }

    public Map<PsiFile, Set<PsiFile>> getDependencies() {
        return this.myDependencies;
    }

    public Map<PsiFile, Set<PsiFile>> getDirectDependencies() {
        return this.getDependencies();
    }

    public AnalysisScope getScope() {
        return this.myScope;
    }

    public AnalysisScope getScopeOfInterest() {
        return this.myScopeOfInterest;
    }

    public Project getProject() {
        return this.myProject;
    }

    public abstract String getRootNodeNameInUsageView();

    public abstract String getInitialUsagesPosition();

    public abstract boolean isBackward();

    public abstract void analyze();

    public Map<PsiFile, Map<DependencyRule, Set<PsiFile>>> getIllegalDependencies() {
        HashMap<PsiFile, Map<DependencyRule, Set<PsiFile>>> result2 = new HashMap<PsiFile, Map<DependencyRule, Set<PsiFile>>>();
        DependencyValidationManager validator = DependencyValidationManager.getInstance(this.myProject);
        for (PsiFile file2 : this.getDirectDependencies().keySet()) {
            Set<PsiFile> deps = this.getDirectDependencies().get(file2);
            HashMap<DependencyRule, HashSet<PsiFile>> illegal = null;
            for (PsiFile dependency : deps) {
                HashSet<PsiFile> illegalFilesByRule;
                DependencyRule rule = this.isBackward() ? validator.getViolatorDependencyRule(dependency, file2) : validator.getViolatorDependencyRule(file2, dependency);
                if (rule == null) continue;
                if (illegal == null) {
                    illegal = new HashMap<DependencyRule, HashSet<PsiFile>>();
                    result2.put(file2, illegal);
                }
                if ((illegalFilesByRule = (HashSet<PsiFile>)illegal.get(rule)) == null) {
                    illegalFilesByRule = new HashSet<PsiFile>();
                }
                illegalFilesByRule.add(dependency);
                illegal.put(rule, illegalFilesByRule);
            }
        }
        return result2;
    }

    public List<List<PsiFile>> findPaths(PsiFile from, PsiFile to) {
        return this.findPaths(from, to, new HashSet<PsiFile>());
    }

    private List<List<PsiFile>> findPaths(PsiFile from, PsiFile to, Set<PsiFile> processed2) {
        ArrayList<List<PsiFile>> result2 = new ArrayList<List<PsiFile>>();
        Set<PsiFile> reachable = this.getDirectDependencies().get(from);
        if (reachable != null) {
            if (reachable.contains(to)) {
                result2.add(new ArrayList());
                return result2;
            }
            if (processed2.add(from)) {
                for (PsiFile file2 : reachable) {
                    if (this.getScope().contains(file2)) continue;
                    List<List<PsiFile>> paths = this.findPaths(file2, to, processed2);
                    for (List<PsiFile> path2 : paths) {
                        path2.add(0, file2);
                    }
                    result2.addAll(paths);
                }
            }
        }
        return result2;
    }

    public boolean isTransitive() {
        return this.myTransitive > 0;
    }

    public int getTransitiveBorder() {
        return this.myTransitive;
    }

    public String getRelativeToProjectPath(@NotNull VirtualFile virtualFile2) {
        if (virtualFile2 == null) {
            DependenciesBuilder.$$$reportNull$$$0(2);
        }
        return ProjectUtilCore.displayUrlRelativeToProject(virtualFile2, virtualFile2.getPresentableUrl(), this.getProject(), true, false);
    }

    public static void analyzeFileDependencies(@NotNull PsiFile file2, @NotNull DependencyProcessor processor) {
        if (file2 == null) {
            DependenciesBuilder.$$$reportNull$$$0(3);
        }
        if (processor == null) {
            DependenciesBuilder.$$$reportNull$$$0(4);
        }
        DependenciesBuilder.analyzeFileDependencies(file2, processor, DependencyVisitorFactory.VisitorOptions.fromSettings(file2.getProject()));
    }

    public static void analyzeFileDependencies(@NotNull PsiFile file2, @NotNull DependencyProcessor processor, @NotNull DependencyVisitorFactory.VisitorOptions options) {
        if (file2 == null) {
            DependenciesBuilder.$$$reportNull$$$0(5);
        }
        if (processor == null) {
            DependenciesBuilder.$$$reportNull$$$0(6);
        }
        if (options == null) {
            DependenciesBuilder.$$$reportNull$$$0(7);
        }
        file2.putUserData(PsiFileEx.BATCH_REFERENCE_PROCESSING, Boolean.TRUE);
        file2.accept(DependencyVisitorFactory.createVisitor(file2, processor, options));
        file2.putUserData(PsiFileEx.BATCH_REFERENCE_PROCESSING, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
        }
        objectArray2[1] = "com/intellij/packageDependencies/DependenciesBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getRelativeToProjectPath";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "analyzeFileDependencies";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface DependencyProcessor {
        public void process(PsiElement var1, PsiElement var2);
    }
}

