/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.pom.java;

import com.intellij.core.JavaCoreBundle;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum LanguageLevel {
    JDK_1_3("Java 1.3", JavaCoreBundle.message("jdk.1.3.language.level.description", new Object[0]), "1.3"),
    JDK_1_4("Java 1.4", JavaCoreBundle.message("jdk.1.4.language.level.description", new Object[0]), "1.4"),
    JDK_1_5("Java 5.0", JavaCoreBundle.message("jdk.1.5.language.level.description", new Object[0]), "1.5", "5"),
    JDK_1_6("Java 6", JavaCoreBundle.message("jdk.1.6.language.level.description", new Object[0]), "1.6", "6"),
    JDK_1_7("Java 7", JavaCoreBundle.message("jdk.1.7.language.level.description", new Object[0]), "1.7", "7"),
    JDK_1_8("Java 8", JavaCoreBundle.message("jdk.1.8.language.level.description", new Object[0]), "1.8", "8"),
    JDK_1_9("Java 9", JavaCoreBundle.message("jdk.1.9.language.level.description", new Object[0]), "9", "1.9"),
    JDK_X("Java X", JavaCoreBundle.message("jdk.X.language.level.description", new Object[0]), "");

    public static final LanguageLevel HIGHEST;
    public static final Key<LanguageLevel> KEY;
    public static final String EXPERIMENTAL_KEY = "java.experimental.support";
    private final String myName;
    private final String myPresentableText;
    private final String[] myCompilerComplianceOptions;

    private LanguageLevel(String name, String presentableText, String ... compilerComplianceOptions) {
        this.myName = name;
        this.myPresentableText = presentableText;
        this.myCompilerComplianceOptions = compilerComplianceOptions;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            LanguageLevel.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    @Nls
    public String getPresentableText() {
        String string = this.myPresentableText;
        if (string == null) {
            LanguageLevel.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAtLeast(@NotNull LanguageLevel level) {
        if (level == null) {
            LanguageLevel.$$$reportNull$$$0(2);
        }
        return this.compareTo(level) >= 0;
    }

    public boolean isLessThan(@NotNull LanguageLevel level) {
        if (level == null) {
            LanguageLevel.$$$reportNull$$$0(3);
        }
        return this.compareTo(level) < 0;
    }

    public String getCompilerComplianceDefaultOption() {
        return this.myCompilerComplianceOptions[0];
    }

    @Nullable
    public static LanguageLevel parse(@Nullable String compilerComplianceOption) {
        if (StringUtil.isEmpty(compilerComplianceOption)) {
            return null;
        }
        return ContainerUtil.find(LanguageLevel.values(), level -> ArrayUtil.contains(compilerComplianceOption, level.myCompilerComplianceOptions));
    }

    static {
        HIGHEST = JDK_1_9;
        KEY = Key.create("LANGUAGE_LEVEL");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/pom/java/LanguageLevel";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableText";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/pom/java/LanguageLevel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAtLeast";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isLessThan";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

