/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.filters.position;

import com.intellij.psi.PsiElement;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.position.PositionElementFilter;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlTag;

public class RootTagFilter
extends PositionElementFilter {
    public RootTagFilter(ElementFilter filter2) {
        this.setFilter(filter2);
    }

    @Override
    public boolean isAcceptable(Object element, PsiElement scope) {
        if (!(element instanceof XmlDocument)) {
            return false;
        }
        XmlTag rootTag = ((XmlDocument)element).getRootTag();
        if (rootTag == null) {
            return false;
        }
        return this.getFilter().isAcceptable(rootTag, (PsiElement)element);
    }

    @Override
    public String toString() {
        return "roottag(" + this.getFilter().toString() + ")";
    }
}

