/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.ResolveState;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.impl.ElementBase;
import com.intellij.psi.impl.ElementPresentationUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.ResolveScopeManager;
import com.intellij.psi.impl.ScopedClassHierarchy;
import com.intellij.psi.impl.TypeCorrector;
import com.intellij.psi.impl.java.stubs.PsiClassReferenceListStub;
import com.intellij.psi.impl.source.ClassInnerStuffCache;
import com.intellij.psi.impl.source.PsiImmediateClassType;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.scope.ElementClassFilter;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.processor.FilterScopeProcessor;
import com.intellij.psi.scope.processor.MethodResolverProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PackageScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.ui.IconDeferrer;
import com.intellij.ui.RowIcon;
import com.intellij.util.BitUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairProcessor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiClassImplUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.PsiClassImplUtil");
    private static final Key<ParameterizedCachedValue<Map<GlobalSearchScope, MembersMap>, PsiClass>> MAP_IN_CLASS_KEY = Key.create("MAP_KEY");
    private static final String VALUES_METHOD = "values";
    private static final String VALUE_OF_METHOD = "valueOf";
    @NonNls
    private static final String ALL = "Intellij-IDEA-ALL";
    private static final Function<ClassIconRequest, Icon> FULL_ICON_EVALUATOR = r -> {
        if (!((ClassIconRequest)r).psiClass.isValid() || ((ClassIconRequest)r).psiClass.getProject().isDisposed()) {
            return null;
        }
        boolean isLocked = BitUtil.isSet(((ClassIconRequest)r).flags, 2) && !((ClassIconRequest)r).psiClass.isWritable();
        Icon symbolIcon = ((ClassIconRequest)r).symbolIcon != null ? ((ClassIconRequest)r).symbolIcon : ElementPresentationUtil.getClassIconOfKind(((ClassIconRequest)r).psiClass, ElementPresentationUtil.getClassKind(((ClassIconRequest)r).psiClass));
        RowIcon baseIcon = ElementPresentationUtil.createLayeredIcon(symbolIcon, ((ClassIconRequest)r).psiClass, isLocked);
        Icon result2 = ElementPresentationUtil.addVisibilityIcon(((ClassIconRequest)r).psiClass, ((ClassIconRequest)r).flags, baseIcon);
        Iconable.LastComputedIcon.put(((ClassIconRequest)r).psiClass, result2, ((ClassIconRequest)r).flags);
        return result2;
    };

    private PsiClassImplUtil() {
    }

    @NotNull
    public static PsiField[] getAllFields(@NotNull PsiClass aClass2) {
        if (aClass2 == null) {
            PsiClassImplUtil.$$$reportNull$$$0(0);
        }
        List<PsiField> map2 = PsiClassImplUtil.getAllByMap(aClass2, MemberType.FIELD);
        PsiField[] psiFieldArray = map2.toArray(new PsiField[map2.size()]);
        if (psiFieldArray == null) {
            PsiClassImplUtil.$$$reportNull$$$0(1);
        }
        return psiFieldArray;
    }

    @NotNull
    public static PsiMethod[] getAllMethods(@NotNull PsiClass aClass2) {
        if (aClass2 == null) {
            PsiClassImplUtil.$$$reportNull$$$0(2);
        }
        List<PsiMethod> methods2 = PsiClassImplUtil.getAllByMap(aClass2, MemberType.METHOD);
        PsiMethod[] psiMethodArray = methods2.toArray(new PsiMethod[methods2.size()]);
        if (psiMethodArray == null) {
            PsiClassImplUtil.$$$reportNull$$$0(3);
        }
        return psiMethodArray;
    }

    @NotNull
    public static PsiClass[] getAllInnerClasses(@NotNull PsiClass aClass2) {
        if (aClass2 == null) {
            PsiClassImplUtil.$$$reportNull$$$0(4);
        }
        List<PsiClass> classes2 = PsiClassImplUtil.getAllByMap(aClass2, MemberType.CLASS);
        PsiClass[] psiClassArray = classes2.toArray(new PsiClass[classes2.size()]);
        if (psiClassArray == null) {
            PsiClassImplUtil.$$$reportNull$$$0(5);
        }
        return psiClassArray;
    }

    @Nullable
    public static PsiField findFieldByName(@NotNull PsiClass aClass2, String name, boolean checkBases) {
        List<PsiMember> byMap;
        if (aClass2 == null) {
            PsiClassImplUtil.$$$reportNull$$$0(6);
        }
        return (byMap = PsiClassImplUtil.findByMap(aClass2, name, checkBases, MemberType.FIELD)).isEmpty() ? null : (PsiField)byMap.get(0);
    }

    @NotNull
    public static PsiMethod[] findMethodsByName(@NotNull PsiClass aClass2, String name, boolean checkBases) {
        if (aClass2 == null) {
            PsiClassImplUtil.$$$reportNull$$$0(7);
        }
        List<PsiMember> methods2 = PsiClassImplUtil.findByMap(aClass2, name, checkBases, MemberType.METHOD);
        PsiMethod[] psiMethodArray = methods2.toArray(new PsiMethod[methods2.size()]);
        if (psiMethodArray == null) {
            PsiClassImplUtil.$$$reportNull$$$0(8);
        }
        return psiMethodArray;
    }

    @Nullable
    public static PsiMethod findMethodBySignature(@NotNull PsiClass aClass2, @NotNull PsiMethod patternMethod, boolean checkBases) {
        List<PsiMethod> result2;
        if (aClass2 == null) {
            PsiClassImplUtil.$$$reportNull$$$0(9);
        }
        if (patternMethod == null) {
            PsiClassImplUtil.$$$reportNull$$$0(10);
        }
        return (result2 = PsiClassImplUtil.findMethodsBySignature(aClass2, patternMethod, checkBases, true)).isEmpty() ? null : result2.get(0);
    }

    @NotNull
    public static PsiMethod[] findMethodsBySignature(@NotNull PsiClass aClass2, @NotNull PsiMethod patternMethod, boolean checkBases) {
        if (aClass2 == null) {
            PsiClassImplUtil.$$$reportNull$$$0(11);
        }
        if (patternMethod == null) {
            PsiClassImplUtil.$$$reportNull$$$0(12);
        }
        List<PsiMethod> methods2 = PsiClassImplUtil.findMethodsBySignature(aClass2, patternMethod, checkBases, false);
        PsiMethod[] psiMethodArray = methods2.toArray(new PsiMethod[methods2.size()]);
        if (psiMethodArray == null) {
            PsiClassImplUtil.$$$reportNull$$$0(13);
        }
        return psiMethodArray;
    }

    @NotNull
    private static List<PsiMethod> findMethodsBySignature(@NotNull PsiClass aClass2, @NotNull PsiMethod patternMethod, boolean checkBases, boolean stopOnFirst) {
        PsiMethod[] methodsByName;
        if (aClass2 == null) {
            PsiClassImplUtil.$$$reportNull$$$0(14);
        }
        if (patternMethod == null) {
            PsiClassImplUtil.$$$reportNull$$$0(15);
        }
        if ((methodsByName = aClass2.findMethodsByName(patternMethod.getName(), checkBases)).length == 0) {
            List<PsiMethod> list2 = Collections.emptyList();
            if (list2 == null) {
                PsiClassImplUtil.$$$reportNull$$$0(16);
            }
            return list2;
        }
        SmartList<PsiMethod> methods2 = new SmartList<PsiMethod>();
        MethodSignature patternSignature = patternMethod.getSignature(PsiSubstitutor.EMPTY);
        for (PsiMethod method : methodsByName) {
            PsiClass superClass = method.getContainingClass();
            PsiSubstitutor substitutor2 = checkBases && !aClass2.equals(superClass) && superClass != null ? TypeConversionUtil.getSuperClassSubstitutor(superClass, aClass2, PsiSubstitutor.EMPTY) : PsiSubstitutor.EMPTY;
            MethodSignature signature2 = method.getSignature(substitutor2);
            if (!signature2.equals(patternSignature)) continue;
            methods2.add(method);
            if (stopOnFirst) break;
        }
        SmartList<PsiMethod> smartList = methods2;
        if (smartList == null) {
            PsiClassImplUtil.$$$reportNull$$$0(17);
        }
        return smartList;
    }

    @Nullable
    public static PsiClass findInnerByName(@NotNull PsiClass aClass2, String name, boolean checkBases) {
        List<PsiMember> byMap;
        if (aClass2 == null) {
            PsiClassImplUtil.$$$reportNull$$$0(18);
        }
        return (byMap = PsiClassImplUtil.findByMap(aClass2, name, checkBases, MemberType.CLASS)).isEmpty() ? null : (PsiClass)byMap.get(0);
    }

    @NotNull
    private static List<PsiMember> findByMap(@NotNull PsiClass aClass2, String name, boolean checkBases, @NotNull MemberType type2) {
        if (aClass2 == null) {
            PsiClassImplUtil.$$$reportNull$$$0(19);
        }
        if (type2 == null) {
            PsiClassImplUtil.$$$reportNull$$$0(20);
        }
        if (name == null) {
            List<PsiMember> list2 = Collections.emptyList();
            if (list2 == null) {
                PsiClassImplUtil.$$$reportNull$$$0(21);
            }
            return list2;
        }
        if (checkBases) {
            PsiMember[] list3 = PsiClassImplUtil.getMap(aClass2, type2).get(name);
            if (list3 == null) {
                List<PsiMember> list4 = Collections.emptyList();
                if (list4 == null) {
                    PsiClassImplUtil.$$$reportNull$$$0(22);
                }
                return list4;
            }
            List<PsiMember> list5 = Arrays.asList(list3);
            if (list5 == null) {
                PsiClassImplUtil.$$$reportNull$$$0(23);
            }
            return list5;
        }
        PsiMember[] members2 = null;
        switch (type2) {
            case METHOD: {
                members2 = aClass2.getMethods();
                break;
            }
            case CLASS: {
                members2 = aClass2.getInnerClasses();
                break;
            }
            case FIELD: {
                members2 = aClass2.getFields();
            }
        }
        ArrayList<PsiMember> list6 = new ArrayList<PsiMember>();
        for (PsiMember member : members2) {
            if (!name.equals(member.getName())) continue;
            list6.add(member);
        }
        ArrayList<PsiMember> arrayList = list6;
        if (arrayList == null) {
            PsiClassImplUtil.$$$reportNull$$$0(24);
        }
        return arrayList;
    }

    @NotNull
    public static <T extends PsiMember> List<Pair<T, PsiSubstitutor>> getAllWithSubstitutorsByMap(@NotNull PsiClass aClass2, @NotNull MemberType type2) {
        if (aClass2 == null) {
            PsiClassImplUtil.$$$reportNull$$$0(25);
        }
        if (type2 == null) {
            PsiClassImplUtil.$$$reportNull$$$0(26);
        }
        List<Pair<T, PsiSubstitutor>> list2 = PsiClassImplUtil.withSubstitutors(aClass2, PsiClassImplUtil.getMap(aClass2, type2).get(ALL));
        if (list2 == null) {
            PsiClassImplUtil.$$$reportNull$$$0(27);
        }
        return list2;
    }

    @NotNull
    private static <T extends PsiMember> List<T> getAllByMap(@NotNull PsiClass aClass2, @NotNull MemberType type2) {
        if (aClass2 == null) {
            PsiClassImplUtil.$$$reportNull$$$0(28);
        }
        if (type2 == null) {
            PsiClassImplUtil.$$$reportNull$$$0(29);
        }
        List<Pair<T, PsiSubstitutor>> pairs = PsiClassImplUtil.getAllWithSubstitutorsByMap(aClass2, type2);
        ArrayList<PsiMember> ret = new ArrayList<PsiMember>(pairs.size());
        for (int i2 = 0; i2 < pairs.size(); ++i2) {
            Pair<T, PsiSubstitutor> pair = pairs.get(i2);
            PsiMember t = (PsiMember)pair.getFirst();
            LOG.assertTrue(t != null, aClass2);
            ret.add(t);
        }
        ArrayList<PsiMember> arrayList = ret;
        if (arrayList == null) {
            PsiClassImplUtil.$$$reportNull$$$0(30);
        }
        return arrayList;
    }

    private static Map<String, PsiMember[]> getMap(@NotNull PsiClass aClass2, @NotNull MemberType type2) {
        if (aClass2 == null) {
            PsiClassImplUtil.$$$reportNull$$$0(31);
        }
        if (type2 == null) {
            PsiClassImplUtil.$$$reportNull$$$0(32);
        }
        ParameterizedCachedValue<Map<GlobalSearchScope, MembersMap>, PsiClass> value = PsiClassImplUtil.getValues(aClass2);
        return value.getValue(aClass2).get(aClass2.getResolveScope()).get(type2);
    }

    @NotNull
    private static ParameterizedCachedValue<Map<GlobalSearchScope, MembersMap>, PsiClass> getValues(@NotNull PsiClass aClass2) {
        ParameterizedCachedValue<Map<GlobalSearchScope, MembersMap>, PsiClass> value;
        if (aClass2 == null) {
            PsiClassImplUtil.$$$reportNull$$$0(33);
        }
        if ((value = aClass2.getUserData(MAP_IN_CLASS_KEY)) == null) {
            value = CachedValuesManager.getManager(aClass2.getProject()).createParameterizedCachedValue(ByNameCachedValueProvider.INSTANCE, false);
            if (aClass2.isPhysical()) {
                value = ((UserDataHolderEx)((Object)aClass2)).putUserDataIfAbsent(MAP_IN_CLASS_KEY, value);
            }
        }
        ParameterizedCachedValue<Map<GlobalSearchScope, MembersMap>, PsiClass> parameterizedCachedValue = value;
        if (parameterizedCachedValue == null) {
            PsiClassImplUtil.$$$reportNull$$$0(34);
        }
        return parameterizedCachedValue;
    }

    public static Icon getClassIcon(int flags, @NotNull PsiClass aClass2) {
        if (aClass2 == null) {
            PsiClassImplUtil.$$$reportNull$$$0(35);
        }
        return PsiClassImplUtil.getClassIcon(flags, aClass2, null);
    }

    public static Icon getClassIcon(int flags, @NotNull PsiClass aClass2, @Nullable Icon symbolIcon) {
        Icon base2;
        if (aClass2 == null) {
            PsiClassImplUtil.$$$reportNull$$$0(36);
        }
        if ((base2 = Iconable.LastComputedIcon.get(aClass2, flags)) == null) {
            if (symbolIcon == null) {
                symbolIcon = ElementPresentationUtil.getClassIconOfKind(aClass2, ElementPresentationUtil.getBasicClassKind(aClass2));
            }
            RowIcon baseIcon = ElementBase.createLayeredIcon(aClass2, symbolIcon, 0);
            base2 = ElementPresentationUtil.addVisibilityIcon(aClass2, flags, baseIcon);
        }
        return IconDeferrer.getInstance().defer(base2, new ClassIconRequest(aClass2, flags, symbolIcon), FULL_ICON_EVALUATOR);
    }

    @NotNull
    public static SearchScope getClassUseScope(@NotNull PsiClass aClass2) {
        PsiDirectory dir;
        if (aClass2 == null) {
            PsiClassImplUtil.$$$reportNull$$$0(37);
        }
        if (aClass2 instanceof PsiAnonymousClass) {
            LocalSearchScope localSearchScope = new LocalSearchScope(aClass2);
            if (localSearchScope == null) {
                PsiClassImplUtil.$$$reportNull$$$0(38);
            }
            return localSearchScope;
        }
        GlobalSearchScope maximalUseScope = ResolveScopeManager.getElementUseScope(aClass2);
        PsiFile file2 = aClass2.getContainingFile();
        if (PsiImplUtil.isInServerPage(file2)) {
            GlobalSearchScope globalSearchScope = maximalUseScope;
            if (globalSearchScope == null) {
                PsiClassImplUtil.$$$reportNull$$$0(39);
            }
            return globalSearchScope;
        }
        PsiClass containingClass = aClass2.getContainingClass();
        if (aClass2.hasModifierProperty("public") || aClass2.hasModifierProperty("protected")) {
            SearchScope searchScope = containingClass == null ? maximalUseScope : containingClass.getUseScope();
            if (searchScope == null) {
                PsiClassImplUtil.$$$reportNull$$$0(40);
            }
            return searchScope;
        }
        if (aClass2.hasModifierProperty("private") || aClass2 instanceof PsiTypeParameter) {
            PsiClass topClass = PsiUtil.getTopLevelClass(aClass2);
            LocalSearchScope localSearchScope = new LocalSearchScope(topClass == null ? aClass2.getContainingFile() : topClass);
            if (localSearchScope == null) {
                PsiClassImplUtil.$$$reportNull$$$0(41);
            }
            return localSearchScope;
        }
        PsiPackage aPackage = null;
        if (file2 instanceof PsiJavaFile) {
            aPackage = JavaPsiFacade.getInstance(aClass2.getProject()).findPackage(((PsiJavaFile)file2).getPackageName());
        }
        if (aPackage == null && (dir = file2.getContainingDirectory()) != null) {
            aPackage = JavaDirectoryService.getInstance().getPackage(dir);
        }
        if (aPackage != null) {
            SearchScope scope = PackageScope.packageScope(aPackage, false);
            SearchScope searchScope = scope = ((SearchScope)scope).intersectWith(maximalUseScope);
            if (searchScope == null) {
                PsiClassImplUtil.$$$reportNull$$$0(42);
            }
            return searchScope;
        }
        LocalSearchScope localSearchScope = new LocalSearchScope(file2);
        if (localSearchScope == null) {
            PsiClassImplUtil.$$$reportNull$$$0(43);
        }
        return localSearchScope;
    }

    public static boolean isMainOrPremainMethod(@NotNull PsiMethod method) {
        if (method == null) {
            PsiClassImplUtil.$$$reportNull$$$0(44);
        }
        if (!PsiType.VOID.equals(method.getReturnType())) {
            return false;
        }
        String name = method.getName();
        if (!("main".equals(name) || "premain".equals(name) || "agentmain".equals(name))) {
            return false;
        }
        PsiElementFactory factory2 = JavaPsiFacade.getInstance(method.getProject()).getElementFactory();
        MethodSignature signature2 = method.getSignature(PsiSubstitutor.EMPTY);
        try {
            MethodSignature main2 = PsiClassImplUtil.createSignatureFromText(factory2, "void main(String[] args);");
            if (MethodSignatureUtil.areSignaturesEqual(signature2, main2)) {
                return true;
            }
            MethodSignature premain = PsiClassImplUtil.createSignatureFromText(factory2, "void premain(String args, java.lang.instrument.Instrumentation i);");
            if (MethodSignatureUtil.areSignaturesEqual(signature2, premain)) {
                return true;
            }
            MethodSignature agentmain = PsiClassImplUtil.createSignatureFromText(factory2, "void agentmain(String args, java.lang.instrument.Instrumentation i);");
            if (MethodSignatureUtil.areSignaturesEqual(signature2, agentmain)) {
                return true;
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error(e);
        }
        return false;
    }

    @NotNull
    private static MethodSignature createSignatureFromText(@NotNull PsiElementFactory factory2, @NotNull String text2) {
        if (factory2 == null) {
            PsiClassImplUtil.$$$reportNull$$$0(45);
        }
        if (text2 == null) {
            PsiClassImplUtil.$$$reportNull$$$0(46);
        }
        MethodSignature methodSignature = factory2.createMethodFromText(text2, null).getSignature(PsiSubstitutor.EMPTY);
        if (methodSignature == null) {
            PsiClassImplUtil.$$$reportNull$$$0(47);
        }
        return methodSignature;
    }

    private static ConcurrentMap<MemberType, Map<String, PsiMember[]>> createMembersMap(PsiClass psiClass, GlobalSearchScope scope) {
        return ConcurrentFactoryMap.createMap(key -> {
            final THashMap map2 = ContainerUtil.newTroveMap();
            final ArrayList allMembers2 = ContainerUtil.newArrayList();
            map2.put(ALL, allMembers2);
            ElementClassFilter filter2 = key == MemberType.CLASS ? ElementClassFilter.CLASS : (key == MemberType.METHOD ? ElementClassFilter.METHOD : ElementClassFilter.FIELD);
            final ElementClassHint classHint = new ElementClassHint((MemberType)((Object)key)){
                final /* synthetic */ MemberType val$key;
                {
                    this.val$key = memberType;
                }

                @Override
                public boolean shouldProcess(ElementClassHint.DeclarationKind kind) {
                    return this.val$key == MemberType.CLASS && kind == ElementClassHint.DeclarationKind.CLASS || this.val$key == MemberType.FIELD && (kind == ElementClassHint.DeclarationKind.FIELD || kind == ElementClassHint.DeclarationKind.ENUM_CONST) || this.val$key == MemberType.METHOD && kind == ElementClassHint.DeclarationKind.METHOD;
                }
            };
            FilterScopeProcessor<MethodCandidateInfo> processor = new FilterScopeProcessor<MethodCandidateInfo>((ElementFilter)filter2){

                @Override
                protected void add(@NotNull PsiElement element, @NotNull PsiSubstitutor substitutor2) {
                    if (element == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (substitutor2 == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    if (key == MemberType.CLASS && element instanceof PsiClass || key == MemberType.METHOD && element instanceof PsiMethod || key == MemberType.FIELD && element instanceof PsiField) {
                        PsiUtilCore.ensureValid(element);
                        allMembers2.add((PsiMember)element);
                        String currentName = ((PsiMember)element).getName();
                        List listByName = (List)map2.get(currentName);
                        if (listByName == null) {
                            listByName = ContainerUtil.newSmartList();
                            map2.put(currentName, listByName);
                        }
                        listByName.add((PsiMember)element);
                    }
                }

                @Override
                public <K> K getHint(@NotNull Key<K> hintKey) {
                    if (hintKey == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    return (K)(ElementClassHint.KEY == hintKey ? classHint : super.getHint(hintKey));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "element";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "substitutor";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "hintKey";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/psi/impl/PsiClassImplUtil$2";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "add";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "getHint";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            PsiClassImplUtil.processDeclarationsInClassNotCached(psiClass, processor, ResolveState.initial(), null, null, psiClass, false, PsiUtil.getLanguageLevel(psiClass), scope);
            THashMap<String, PsiMember[]> result2 = ContainerUtil.newTroveMap();
            for (String name : map2.keySet()) {
                result2.put(name, ((List)map2.get(name)).toArray(PsiMember.EMPTY_ARRAY));
            }
            return result2;
        });
    }

    public static boolean processDeclarationsInEnum(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state2, @NotNull ClassInnerStuffCache innerStuffCache) {
        ElementClassHint classHint;
        if (processor == null) {
            PsiClassImplUtil.$$$reportNull$$$0(48);
        }
        if (state2 == null) {
            PsiClassImplUtil.$$$reportNull$$$0(49);
        }
        if (innerStuffCache == null) {
            PsiClassImplUtil.$$$reportNull$$$0(50);
        }
        if ((classHint = processor.getHint(ElementClassHint.KEY)) == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.METHOD)) {
            PsiMethod method;
            NameHint nameHint = processor.getHint(NameHint.KEY);
            if ((nameHint == null || VALUES_METHOD.equals(nameHint.getName(state2))) && (method = innerStuffCache.getValuesMethod()) != null && !processor.execute(method, ResolveState.initial())) {
                return false;
            }
            if ((nameHint == null || VALUE_OF_METHOD.equals(nameHint.getName(state2))) && (method = innerStuffCache.getValueOfMethod()) != null && !processor.execute(method, ResolveState.initial())) {
                return false;
            }
        }
        return true;
    }

    public static boolean processDeclarationsInClass(@NotNull PsiClass aClass2, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state2, @Nullable Set<PsiClass> visited2, PsiElement last2, @NotNull PsiElement place, @NotNull LanguageLevel languageLevel, boolean isRaw) {
        if (aClass2 == null) {
            PsiClassImplUtil.$$$reportNull$$$0(51);
        }
        if (processor == null) {
            PsiClassImplUtil.$$$reportNull$$$0(52);
        }
        if (state2 == null) {
            PsiClassImplUtil.$$$reportNull$$$0(53);
        }
        if (place == null) {
            PsiClassImplUtil.$$$reportNull$$$0(54);
        }
        if (languageLevel == null) {
            PsiClassImplUtil.$$$reportNull$$$0(55);
        }
        return PsiClassImplUtil.processDeclarationsInClass(aClass2, processor, state2, visited2, last2, place, languageLevel, isRaw, place.getResolveScope());
    }

    private static boolean processDeclarationsInClass(@NotNull PsiClass aClass2, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state2, @Nullable Set<PsiClass> visited2, PsiElement last2, @NotNull PsiElement place, @NotNull LanguageLevel languageLevel, boolean isRaw, @NotNull GlobalSearchScope resolveScope) {
        if (aClass2 == null) {
            PsiClassImplUtil.$$$reportNull$$$0(56);
        }
        if (processor == null) {
            PsiClassImplUtil.$$$reportNull$$$0(57);
        }
        if (state2 == null) {
            PsiClassImplUtil.$$$reportNull$$$0(58);
        }
        if (place == null) {
            PsiClassImplUtil.$$$reportNull$$$0(59);
        }
        if (languageLevel == null) {
            PsiClassImplUtil.$$$reportNull$$$0(60);
        }
        if (resolveScope == null) {
            PsiClassImplUtil.$$$reportNull$$$0(61);
        }
        if (last2 instanceof PsiTypeParameterList || last2 instanceof PsiModifierList && aClass2.getModifierList() == last2) {
            return true;
        }
        if (visited2 != null && visited2.contains(aClass2)) {
            return true;
        }
        PsiSubstitutor substitutor2 = state2.get(PsiSubstitutor.KEY);
        isRaw = isRaw || PsiUtil.isRawSubstitutor(aClass2, substitutor2);
        NameHint nameHint = processor.getHint(NameHint.KEY);
        if (nameHint != null) {
            String name = nameHint.getName(state2);
            return PsiClassImplUtil.processCachedMembersByName(aClass2, processor, state2, visited2, last2, place, isRaw, substitutor2, PsiClassImplUtil.getValues(aClass2).getValue(aClass2).get(resolveScope), name, languageLevel);
        }
        return PsiClassImplUtil.processDeclarationsInClassNotCached(aClass2, processor, state2, visited2, last2, place, isRaw, languageLevel, resolveScope);
    }

    /*
     * WARNING - void declaration
     */
    private static boolean processCachedMembersByName(final @NotNull PsiClass aClass2, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state2, @Nullable Set<PsiClass> visited2, PsiElement last2, final @NotNull PsiElement place, final boolean isRaw, final @NotNull PsiSubstitutor substitutor2, @NotNull MembersMap value, String name, final @NotNull LanguageLevel languageLevel) {
        PsiClass containingClass;
        boolean resolved;
        if (aClass2 == null) {
            PsiClassImplUtil.$$$reportNull$$$0(62);
        }
        if (processor == null) {
            PsiClassImplUtil.$$$reportNull$$$0(63);
        }
        if (state2 == null) {
            PsiClassImplUtil.$$$reportNull$$$0(64);
        }
        if (place == null) {
            PsiClassImplUtil.$$$reportNull$$$0(65);
        }
        if (substitutor2 == null) {
            PsiClassImplUtil.$$$reportNull$$$0(66);
        }
        if (value == null) {
            PsiClassImplUtil.$$$reportNull$$$0(67);
        }
        if (languageLevel == null) {
            PsiClassImplUtil.$$$reportNull$$$0(68);
        }
        Function<PsiMember, PsiSubstitutor> finalSubstitutor = new Function<PsiMember, PsiSubstitutor>(){
            final ScopedClassHierarchy hierarchy;
            final PsiElementFactory factory;
            {
                this.hierarchy = ScopedClassHierarchy.getHierarchy(aClass2, place.getResolveScope());
                this.factory = JavaPsiFacade.getInstance(aClass2.getProject()).getElementFactory();
            }

            @Override
            public PsiSubstitutor fun(PsiMember member) {
                PsiClass containingClass;
                PsiSubstitutor superSubstitutor = this.hierarchy.getSuperMembersSubstitutor(containingClass = ObjectUtils.assertNotNull(member.getContainingClass()), languageLevel);
                PsiSubstitutor finalSubstitutor = PsiClassImplUtil.obtainFinalSubstitutor(containingClass, superSubstitutor == null ? PsiSubstitutor.EMPTY : superSubstitutor, aClass2, substitutor2, this.factory, languageLevel);
                return member instanceof PsiMethod ? PsiClassImplUtil.checkRaw(isRaw, this.factory, (PsiMethod)member, finalSubstitutor) : finalSubstitutor;
            }
        };
        ElementClassHint classHint = processor.getHint(ElementClassHint.KEY);
        if (classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.FIELD)) {
            PsiField fieldByName = aClass2.findFieldByName(name, false);
            if (fieldByName != null) {
                PsiUtilCore.ensureValid(fieldByName);
                processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, aClass2);
                if (!processor.execute(fieldByName, state2)) {
                    return false;
                }
            } else {
                Map allFieldsMap = value.get(MemberType.FIELD);
                PsiMember[] list2 = (PsiMember[])allFieldsMap.get(name);
                if (list2 != null) {
                    resolved = false;
                    for (PsiMember candidateField : list2) {
                        containingClass = candidateField.getContainingClass();
                        PsiUtilCore.ensureValid(candidateField);
                        if (containingClass == null) {
                            PsiElement parent2 = candidateField.getParent();
                            LOG.error("No class for field " + candidateField.getName() + " of " + candidateField.getClass() + ", parent " + parent2 + " of " + (parent2 == null ? null : parent2.getClass()));
                            continue;
                        }
                        processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, containingClass);
                        if (processor.execute(candidateField, state2.put(PsiSubstitutor.KEY, finalSubstitutor.fun(candidateField)))) continue;
                        resolved = true;
                    }
                    if (resolved) {
                        return false;
                    }
                }
            }
        }
        if (classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.CLASS)) {
            if (last2 != null && last2.getContext() == aClass2) {
                if (last2 instanceof PsiClass && !processor.execute(last2, state2)) {
                    return false;
                }
                PsiTypeParameterList list3 = aClass2.getTypeParameterList();
                if (list3 != null && !list3.processDeclarations(processor, state2, last2, place)) {
                    return false;
                }
            }
            if (!(last2 instanceof PsiReferenceList)) {
                PsiClass classByName = aClass2.findInnerClassByName(name, false);
                if (classByName != null) {
                    PsiUtilCore.ensureValid(classByName);
                    processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, aClass2);
                    if (!processor.execute(classByName, state2)) {
                        return false;
                    }
                } else {
                    Map allClassesMap = value.get(MemberType.CLASS);
                    PsiMember[] list2 = (PsiMember[])allClassesMap.get(name);
                    if (list2 != null) {
                        resolved = false;
                        for (PsiMember inner : list2) {
                            PsiUtilCore.ensureValid(inner);
                            containingClass = inner.getContainingClass();
                            if (containingClass == null) continue;
                            processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, containingClass);
                            if (processor.execute(inner, state2.put(PsiSubstitutor.KEY, finalSubstitutor.fun(inner)))) continue;
                            resolved = true;
                        }
                        if (resolved) {
                            return false;
                        }
                    }
                }
            }
        }
        if (classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.METHOD)) {
            MethodResolverProcessor methodResolverProcessor;
            if (processor instanceof MethodResolverProcessor && (methodResolverProcessor = (MethodResolverProcessor)processor).isConstructor()) {
                PsiMethod[] constructors2 = aClass2.getConstructors();
                methodResolverProcessor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, aClass2);
                for (PsiMember psiMember : constructors2) {
                    PsiUtilCore.ensureValid(psiMember);
                    if (methodResolverProcessor.execute(psiMember, state2)) continue;
                    return false;
                }
                return true;
            }
            Map allMethodsMap = value.get(MemberType.METHOD);
            PsiMember[] list4 = (PsiMember[])allMethodsMap.get(name);
            if (list4 != null) {
                void var18_26;
                boolean resolved2 = false;
                PsiMember[] psiMemberArray = list4;
                int n = psiMemberArray.length;
                boolean bl = false;
                while (var18_26 < n) {
                    PsiMember candidate2 = psiMemberArray[var18_26];
                    ProgressIndicatorProvider.checkCanceled();
                    PsiMethod candidateMethod = (PsiMethod)candidate2;
                    PsiUtilCore.ensureValid(candidateMethod);
                    if (!(processor instanceof MethodResolverProcessor && candidateMethod.isConstructor() != ((MethodResolverProcessor)processor).isConstructor() || (containingClass = candidateMethod.getContainingClass()) == null || visited2 != null && visited2.contains(containingClass))) {
                        processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, containingClass);
                        if (!processor.execute(candidateMethod, state2.put(PsiSubstitutor.KEY, finalSubstitutor.fun(candidateMethod)))) {
                            resolved2 = true;
                        }
                    }
                    ++var18_26;
                }
                if (resolved2) {
                    return false;
                }
                if (visited2 != null) {
                    void var18_28;
                    psiMemberArray = list4;
                    n = psiMemberArray.length;
                    boolean bl2 = false;
                    while (var18_28 < n) {
                        PsiMember aList = psiMemberArray[var18_28];
                        visited2.add(aList.getContainingClass());
                        ++var18_28;
                    }
                }
            }
        }
        return true;
    }

    private static PsiSubstitutor checkRaw(boolean isRaw, @NotNull PsiElementFactory factory2, @NotNull PsiMethod candidateMethod, @NotNull PsiSubstitutor substitutor2) {
        PsiClass containingClass;
        if (factory2 == null) {
            PsiClassImplUtil.$$$reportNull$$$0(69);
        }
        if (candidateMethod == null) {
            PsiClassImplUtil.$$$reportNull$$$0(70);
        }
        if (substitutor2 == null) {
            PsiClassImplUtil.$$$reportNull$$$0(71);
        }
        if (isRaw && !candidateMethod.hasModifierProperty("static") && (containingClass = candidateMethod.getContainingClass()) != null && containingClass.hasTypeParameters()) {
            PsiTypeParameter[] methodTypeParameters = candidateMethod.getTypeParameters();
            substitutor2 = factory2.createRawSubstitutor(substitutor2, methodTypeParameters);
        }
        return substitutor2;
    }

    public static PsiSubstitutor obtainFinalSubstitutor(@NotNull PsiClass candidateClass, @NotNull PsiSubstitutor candidateSubstitutor, @NotNull PsiClass aClass2, @NotNull PsiSubstitutor substitutor2, @NotNull PsiElementFactory elementFactory, @NotNull LanguageLevel languageLevel) {
        if (candidateClass == null) {
            PsiClassImplUtil.$$$reportNull$$$0(72);
        }
        if (candidateSubstitutor == null) {
            PsiClassImplUtil.$$$reportNull$$$0(73);
        }
        if (aClass2 == null) {
            PsiClassImplUtil.$$$reportNull$$$0(74);
        }
        if (substitutor2 == null) {
            PsiClassImplUtil.$$$reportNull$$$0(75);
        }
        if (elementFactory == null) {
            PsiClassImplUtil.$$$reportNull$$$0(76);
        }
        if (languageLevel == null) {
            PsiClassImplUtil.$$$reportNull$$$0(77);
        }
        if (PsiUtil.isRawSubstitutor(aClass2, substitutor2)) {
            return elementFactory.createRawSubstitutor(candidateClass).putAll(substitutor2);
        }
        PsiClassType containingType = elementFactory.createType(candidateClass, candidateSubstitutor, languageLevel);
        PsiType type2 = substitutor2.substitute(containingType);
        if (!(type2 instanceof PsiClassType)) {
            return candidateSubstitutor;
        }
        return ((PsiClassType)type2).resolveGenerics().getSubstitutor();
    }

    private static boolean processDeclarationsInClassNotCached(@NotNull PsiClass aClass2, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state2, @Nullable Set<PsiClass> visited2, PsiElement last2, @NotNull PsiElement place, boolean isRaw, @NotNull LanguageLevel languageLevel, @NotNull GlobalSearchScope resolveScope) {
        if (aClass2 == null) {
            PsiClassImplUtil.$$$reportNull$$$0(78);
        }
        if (processor == null) {
            PsiClassImplUtil.$$$reportNull$$$0(79);
        }
        if (state2 == null) {
            PsiClassImplUtil.$$$reportNull$$$0(80);
        }
        if (place == null) {
            PsiClassImplUtil.$$$reportNull$$$0(81);
        }
        if (languageLevel == null) {
            PsiClassImplUtil.$$$reportNull$$$0(82);
        }
        if (resolveScope == null) {
            PsiClassImplUtil.$$$reportNull$$$0(83);
        }
        if (visited2 == null) {
            visited2 = new THashSet<PsiClass>();
        }
        if (!visited2.add(aClass2)) {
            return true;
        }
        processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, aClass2);
        ElementClassHint classHint = processor.getHint(ElementClassHint.KEY);
        NameHint nameHint = processor.getHint(NameHint.KEY);
        if (classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.FIELD)) {
            if (nameHint != null) {
                PsiField fieldByName = aClass2.findFieldByName(nameHint.getName(state2), false);
                if (fieldByName != null && !processor.execute(fieldByName, state2)) {
                    return false;
                }
            } else {
                PsiField[] fields2;
                for (PsiField field : fields2 = aClass2.getFields()) {
                    if (processor.execute(field, state2)) continue;
                    return false;
                }
            }
        }
        PsiElementFactory factory2 = JavaPsiFacade.getInstance(aClass2.getProject()).getElementFactory();
        if (classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.METHOD)) {
            PsiMethod[] methods2;
            PsiSubstitutor baseSubstitutor = state2.get(PsiSubstitutor.KEY);
            for (PsiMethod method : methods2 = nameHint != null ? aClass2.findMethodsByName(nameHint.getName(state2), false) : aClass2.getMethods()) {
                ResolveState methodState;
                PsiSubstitutor finalSubstitutor2 = PsiClassImplUtil.checkRaw(isRaw, factory2, method, baseSubstitutor);
                ResolveState resolveState = methodState = finalSubstitutor2 == baseSubstitutor ? state2 : state2.put(PsiSubstitutor.KEY, finalSubstitutor2);
                if (processor.execute(method, methodState)) continue;
                return false;
            }
        }
        if (classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.CLASS)) {
            PsiTypeParameterList list2;
            if (last2 != null && last2.getContext() == aClass2 && (list2 = aClass2.getTypeParameterList()) != null && !list2.processDeclarations(processor, ResolveState.initial(), last2, place)) {
                return false;
            }
            if (!(last2 instanceof PsiReferenceList) && !(last2 instanceof PsiModifierList)) {
                if (nameHint != null) {
                    PsiClass inner = aClass2.findInnerClassByName(nameHint.getName(state2), false);
                    if (inner != null && !processor.execute(inner, state2)) {
                        return false;
                    }
                } else {
                    PsiClass[] inners;
                    for (PsiClass inner : inners = aClass2.getInnerClasses()) {
                        if (processor.execute(inner, state2)) continue;
                        return false;
                    }
                }
            }
        }
        if (last2 instanceof PsiReferenceList) {
            return true;
        }
        Set<PsiClass> visited1 = visited2;
        return PsiClassImplUtil.processSuperTypes(aClass2, state2.get(PsiSubstitutor.KEY), factory2, languageLevel, resolveScope, (superClass, finalSubstitutor) -> {
            if (processor == null) {
                PsiClassImplUtil.$$$reportNull$$$0(153);
            }
            if (state2 == null) {
                PsiClassImplUtil.$$$reportNull$$$0(154);
            }
            if (place == null) {
                PsiClassImplUtil.$$$reportNull$$$0(155);
            }
            if (languageLevel == null) {
                PsiClassImplUtil.$$$reportNull$$$0(156);
            }
            if (resolveScope == null) {
                PsiClassImplUtil.$$$reportNull$$$0(157);
            }
            return PsiClassImplUtil.processDeclarationsInClass(superClass, processor, state2.put(PsiSubstitutor.KEY, finalSubstitutor), visited1, last2, place, languageLevel, isRaw, resolveScope);
        });
    }

    @Nullable
    public static <T extends PsiType> T correctType(@Nullable T originalType, @NotNull GlobalSearchScope resolveScope) {
        if (resolveScope == null) {
            PsiClassImplUtil.$$$reportNull$$$0(84);
        }
        if (originalType == null || !Registry.is("java.correct.class.type.by.place.resolve.scope")) {
            return originalType;
        }
        return new TypeCorrector(resolveScope).correctType(originalType);
    }

    public static List<PsiClassType.ClassResolveResult> getScopeCorrectedSuperTypes(PsiClass aClass2, GlobalSearchScope resolveScope) {
        PsiUtilCore.ensureValid(aClass2);
        return ScopedClassHierarchy.getHierarchy(aClass2, resolveScope).getImmediateSupersWithCapturing();
    }

    static boolean processSuperTypes(@NotNull PsiClass aClass2, PsiSubstitutor substitutor2, @NotNull PsiElementFactory factory2, @NotNull LanguageLevel languageLevel, GlobalSearchScope resolveScope, PairProcessor<PsiClass, PsiSubstitutor> processor) {
        if (aClass2 == null) {
            PsiClassImplUtil.$$$reportNull$$$0(85);
        }
        if (factory2 == null) {
            PsiClassImplUtil.$$$reportNull$$$0(86);
        }
        if (languageLevel == null) {
            PsiClassImplUtil.$$$reportNull$$$0(87);
        }
        boolean resolved = false;
        for (PsiClassType.ClassResolveResult superTypeResolveResult : PsiClassImplUtil.getScopeCorrectedSuperTypes(aClass2, resolveScope)) {
            PsiClass superClass = superTypeResolveResult.getElement();
            assert (superClass != null);
            PsiSubstitutor finalSubstitutor = PsiClassImplUtil.obtainFinalSubstitutor(superClass, superTypeResolveResult.getSubstitutor(), aClass2, substitutor2, factory2, languageLevel);
            if (processor.process(superClass, finalSubstitutor)) continue;
            resolved = true;
        }
        return !resolved;
    }

    @Nullable
    public static PsiClass getSuperClass(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            PsiClassImplUtil.$$$reportNull$$$0(88);
        }
        if (psiClass.isInterface()) {
            return PsiClassImplUtil.findSpecialSuperClass(psiClass, "java.lang.Object");
        }
        if (psiClass.isEnum()) {
            return PsiClassImplUtil.findSpecialSuperClass(psiClass, "java.lang.Enum");
        }
        if (psiClass instanceof PsiAnonymousClass) {
            PsiClassType baseClassReference = ((PsiAnonymousClass)psiClass).getBaseClassType();
            PsiClass baseClass = baseClassReference.resolve();
            if (baseClass == null || baseClass.isInterface()) {
                return PsiClassImplUtil.findSpecialSuperClass(psiClass, "java.lang.Object");
            }
            return baseClass;
        }
        if ("java.lang.Object".equals(psiClass.getQualifiedName())) {
            return null;
        }
        PsiClassType[] referenceElements = psiClass.getExtendsListTypes();
        if (referenceElements.length == 0) {
            return PsiClassImplUtil.findSpecialSuperClass(psiClass, "java.lang.Object");
        }
        PsiClass psiResolved = referenceElements[0].resolve();
        return psiResolved == null ? PsiClassImplUtil.findSpecialSuperClass(psiClass, "java.lang.Object") : psiResolved;
    }

    @Nullable
    private static PsiClass findSpecialSuperClass(@NotNull PsiClass psiClass, String className2) {
        if (psiClass == null) {
            PsiClassImplUtil.$$$reportNull$$$0(89);
        }
        return JavaPsiFacade.getInstance(psiClass.getProject()).findClass(className2, psiClass.getResolveScope());
    }

    @NotNull
    public static PsiClass[] getSupers(@NotNull PsiClass psiClass) {
        PsiClass[] supers;
        if (psiClass == null) {
            PsiClassImplUtil.$$$reportNull$$$0(90);
        }
        for (PsiClass aSuper : supers = PsiClassImplUtil.getSupersInner(psiClass)) {
            LOG.assertTrue(aSuper != null);
        }
        if (supers == null) {
            PsiClassImplUtil.$$$reportNull$$$0(91);
        }
        return supers;
    }

    @NotNull
    private static PsiClass[] getSupersInner(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            PsiClassImplUtil.$$$reportNull$$$0(92);
        }
        PsiClassType[] extendsListTypes = psiClass.getExtendsListTypes();
        if (psiClass.isInterface()) {
            PsiClass[] psiClassArray = PsiClassImplUtil.resolveClassReferenceList(extendsListTypes, psiClass, true);
            if (psiClassArray == null) {
                PsiClassImplUtil.$$$reportNull$$$0(93);
            }
            return psiClassArray;
        }
        if (psiClass instanceof PsiAnonymousClass) {
            PsiClass[] psiClassArray;
            PsiAnonymousClass psiAnonymousClass = (PsiAnonymousClass)psiClass;
            PsiClassType baseClassReference = psiAnonymousClass.getBaseClassType();
            PsiClass baseClass = baseClassReference.resolve();
            if (baseClass != null) {
                if (baseClass.isInterface()) {
                    PsiClass[] psiClassArray2;
                    PsiClass objectClass = PsiClassImplUtil.findSpecialSuperClass(psiClass, "java.lang.Object");
                    if (objectClass != null) {
                        PsiClass[] psiClassArray3 = new PsiClass[2];
                        psiClassArray3[0] = objectClass;
                        psiClassArray2 = psiClassArray3;
                        psiClassArray3[1] = baseClass;
                    } else {
                        PsiClass[] psiClassArray4 = new PsiClass[1];
                        psiClassArray2 = psiClassArray4;
                        psiClassArray4[0] = baseClass;
                    }
                    if (psiClassArray2 == null) {
                        PsiClassImplUtil.$$$reportNull$$$0(94);
                    }
                    return psiClassArray2;
                }
                PsiClass[] psiClassArray5 = new PsiClass[]{baseClass};
                if (psiClassArray5 == null) {
                    PsiClassImplUtil.$$$reportNull$$$0(95);
                }
                return psiClassArray5;
            }
            PsiClass objectClass = PsiClassImplUtil.findSpecialSuperClass(psiClass, "java.lang.Object");
            if (objectClass != null) {
                PsiClass[] psiClassArray6 = new PsiClass[1];
                psiClassArray = psiClassArray6;
                psiClassArray6[0] = objectClass;
            } else {
                psiClassArray = PsiClass.EMPTY_ARRAY;
            }
            if (psiClassArray == null) {
                PsiClassImplUtil.$$$reportNull$$$0(96);
            }
            return psiClassArray;
        }
        if (psiClass instanceof PsiTypeParameter) {
            if (extendsListTypes.length == 0) {
                PsiClass[] psiClassArray;
                PsiClass objectClass = PsiClassImplUtil.findSpecialSuperClass(psiClass, "java.lang.Object");
                if (objectClass != null) {
                    PsiClass[] psiClassArray7 = new PsiClass[1];
                    psiClassArray = psiClassArray7;
                    psiClassArray7[0] = objectClass;
                } else {
                    psiClassArray = PsiClass.EMPTY_ARRAY;
                }
                if (psiClassArray == null) {
                    PsiClassImplUtil.$$$reportNull$$$0(97);
                }
                return psiClassArray;
            }
            PsiClass[] psiClassArray = PsiClassImplUtil.resolveClassReferenceList(extendsListTypes, psiClass, false);
            if (psiClassArray == null) {
                PsiClassImplUtil.$$$reportNull$$$0(98);
            }
            return psiClassArray;
        }
        PsiClassType[] implementsListTypes = psiClass.getImplementsListTypes();
        PsiClass[] interfaces = PsiClassImplUtil.resolveClassReferenceList(implementsListTypes, psiClass, false);
        PsiClass superClass = PsiClassImplUtil.getSuperClass(psiClass);
        if (superClass == null) {
            if (interfaces == null) {
                PsiClassImplUtil.$$$reportNull$$$0(99);
            }
            return interfaces;
        }
        PsiClass[] types = new PsiClass[interfaces.length + 1];
        types[0] = superClass;
        System.arraycopy(interfaces, 0, types, 1, interfaces.length);
        if (types == null) {
            PsiClassImplUtil.$$$reportNull$$$0(100);
        }
        return types;
    }

    @NotNull
    public static PsiClassType[] getSuperTypes(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            PsiClassImplUtil.$$$reportNull$$$0(101);
        }
        if (psiClass instanceof PsiAnonymousClass) {
            PsiClassType baseClassType = ((PsiAnonymousClass)psiClass).getBaseClassType();
            PsiClass baseClass = baseClassType.resolve();
            if (baseClass == null || !baseClass.isInterface()) {
                PsiClassType[] psiClassTypeArray = new PsiClassType[]{baseClassType};
                if (psiClassTypeArray == null) {
                    PsiClassImplUtil.$$$reportNull$$$0(102);
                }
                return psiClassTypeArray;
            }
            PsiClassType objectType = PsiType.getJavaLangObject(psiClass.getManager(), psiClass.getResolveScope());
            PsiClassType[] psiClassTypeArray = new PsiClassType[]{objectType, baseClassType};
            if (psiClassTypeArray == null) {
                PsiClassImplUtil.$$$reportNull$$$0(103);
            }
            return psiClassTypeArray;
        }
        PsiClassType[] extendsTypes = psiClass.getExtendsListTypes();
        PsiClassType[] implementsTypes = psiClass.getImplementsListTypes();
        boolean hasExtends = extendsTypes.length != 0;
        int extendsListLength = extendsTypes.length + (hasExtends ? 0 : 1);
        PsiClassType[] result2 = new PsiClassType[extendsListLength + implementsTypes.length];
        System.arraycopy(extendsTypes, 0, result2, 0, extendsTypes.length);
        if (!hasExtends) {
            PsiClassType objectType;
            if ("java.lang.Object".equals(psiClass.getQualifiedName())) {
                if (PsiClassType.EMPTY_ARRAY == null) {
                    PsiClassImplUtil.$$$reportNull$$$0(104);
                }
                return PsiClassType.EMPTY_ARRAY;
            }
            PsiManager manager = psiClass.getManager();
            result2[0] = objectType = PsiType.getJavaLangObject(manager, psiClass.getResolveScope());
        }
        System.arraycopy(implementsTypes, 0, result2, extendsListLength, implementsTypes.length);
        if (result2 == null) {
            PsiClassImplUtil.$$$reportNull$$$0(105);
        }
        return result2;
    }

    @NotNull
    private static PsiClassType getAnnotationSuperType(@NotNull PsiClass psiClass, @NotNull PsiElementFactory factory2) {
        if (psiClass == null) {
            PsiClassImplUtil.$$$reportNull$$$0(106);
        }
        if (factory2 == null) {
            PsiClassImplUtil.$$$reportNull$$$0(107);
        }
        PsiClassType psiClassType = factory2.createTypeByFQClassName("java.lang.annotation.Annotation", psiClass.getResolveScope());
        if (psiClassType == null) {
            PsiClassImplUtil.$$$reportNull$$$0(108);
        }
        return psiClassType;
    }

    private static PsiClassType getEnumSuperType(@NotNull PsiClass psiClass, @NotNull PsiElementFactory factory2) {
        PsiClassType superType;
        PsiClass enumClass2;
        if (psiClass == null) {
            PsiClassImplUtil.$$$reportNull$$$0(109);
        }
        if (factory2 == null) {
            PsiClassImplUtil.$$$reportNull$$$0(110);
        }
        if ((enumClass2 = PsiClassImplUtil.findSpecialSuperClass(psiClass, "java.lang.Enum")) == null) {
            try {
                superType = (PsiClassType)factory2.createTypeFromText("java.lang.Enum", null);
            }
            catch (IncorrectOperationException e) {
                superType = null;
            }
        } else {
            PsiTypeParameter[] typeParameters2 = enumClass2.getTypeParameters();
            PsiSubstitutor substitutor2 = PsiSubstitutor.EMPTY;
            if (typeParameters2.length == 1) {
                substitutor2 = substitutor2.put(typeParameters2[0], factory2.createType(psiClass));
            }
            superType = new PsiImmediateClassType(enumClass2, substitutor2);
        }
        return superType;
    }

    @NotNull
    public static PsiClass[] getInterfaces(@NotNull PsiTypeParameter typeParameter) {
        PsiClassType[] referencedTypes;
        if (typeParameter == null) {
            PsiClassImplUtil.$$$reportNull$$$0(111);
        }
        if ((referencedTypes = typeParameter.getExtendsListTypes()).length == 0) {
            if (PsiClass.EMPTY_ARRAY == null) {
                PsiClassImplUtil.$$$reportNull$$$0(112);
            }
            return PsiClass.EMPTY_ARRAY;
        }
        ArrayList<PsiClass> result2 = new ArrayList<PsiClass>(referencedTypes.length);
        for (PsiClassType referencedType : referencedTypes) {
            PsiClass psiClass = referencedType.resolve();
            if (psiClass == null || !psiClass.isInterface()) continue;
            result2.add(psiClass);
        }
        PsiClass[] psiClassArray = result2.toArray(new PsiClass[result2.size()]);
        if (psiClassArray == null) {
            PsiClassImplUtil.$$$reportNull$$$0(113);
        }
        return psiClassArray;
    }

    @NotNull
    public static PsiClass[] getInterfaces(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            PsiClassImplUtil.$$$reportNull$$$0(114);
        }
        if (psiClass.isInterface()) {
            PsiClass[] psiClassArray = PsiClassImplUtil.resolveClassReferenceList(psiClass.getExtendsListTypes(), psiClass, false);
            if (psiClassArray == null) {
                PsiClassImplUtil.$$$reportNull$$$0(115);
            }
            return psiClassArray;
        }
        if (psiClass instanceof PsiAnonymousClass) {
            PsiClass[] psiClassArray;
            PsiClassType baseClassReference = ((PsiAnonymousClass)psiClass).getBaseClassType();
            PsiClass baseClass = baseClassReference.resolve();
            if (baseClass != null && baseClass.isInterface()) {
                PsiClass[] psiClassArray2 = new PsiClass[1];
                psiClassArray = psiClassArray2;
                psiClassArray2[0] = baseClass;
            } else {
                psiClassArray = PsiClass.EMPTY_ARRAY;
            }
            if (psiClassArray == null) {
                PsiClassImplUtil.$$$reportNull$$$0(116);
            }
            return psiClassArray;
        }
        PsiClassType[] implementsListTypes = psiClass.getImplementsListTypes();
        PsiClass[] psiClassArray = PsiClassImplUtil.resolveClassReferenceList(implementsListTypes, psiClass, false);
        if (psiClassArray == null) {
            PsiClassImplUtil.$$$reportNull$$$0(117);
        }
        return psiClassArray;
    }

    @NotNull
    private static PsiClass[] resolveClassReferenceList(@NotNull PsiClassType[] listOfTypes, @NotNull PsiClass psiClass, boolean includeObject) {
        if (listOfTypes == null) {
            PsiClassImplUtil.$$$reportNull$$$0(118);
        }
        if (psiClass == null) {
            PsiClassImplUtil.$$$reportNull$$$0(119);
        }
        PsiClass objectClass = null;
        if (includeObject && (objectClass = PsiClassImplUtil.findSpecialSuperClass(psiClass, "java.lang.Object")) == null) {
            includeObject = false;
        }
        if (listOfTypes.length == 0) {
            if (includeObject) {
                PsiClass[] psiClassArray = new PsiClass[]{objectClass};
                if (psiClassArray == null) {
                    PsiClassImplUtil.$$$reportNull$$$0(120);
                }
                return psiClassArray;
            }
            if (PsiClass.EMPTY_ARRAY == null) {
                PsiClassImplUtil.$$$reportNull$$$0(121);
            }
            return PsiClass.EMPTY_ARRAY;
        }
        int referenceCount = listOfTypes.length;
        if (includeObject) {
            ++referenceCount;
        }
        PsiClass[] resolved = new PsiClass[referenceCount];
        int resolvedCount = 0;
        if (includeObject) {
            resolved[resolvedCount++] = objectClass;
        }
        for (PsiClassType reference : listOfTypes) {
            PsiClass refResolved = reference.resolve();
            if (refResolved == null) continue;
            resolved[resolvedCount++] = refResolved;
        }
        if (resolvedCount < referenceCount) {
            PsiClass[] shorter = new PsiClass[resolvedCount];
            System.arraycopy(resolved, 0, shorter, 0, resolvedCount);
            resolved = shorter;
        }
        if (resolved == null) {
            PsiClassImplUtil.$$$reportNull$$$0(122);
        }
        return resolved;
    }

    @NotNull
    public static List<Pair<PsiMethod, PsiSubstitutor>> findMethodsAndTheirSubstitutorsByName(@NotNull PsiClass psiClass, String name, boolean checkBases) {
        if (psiClass == null) {
            PsiClassImplUtil.$$$reportNull$$$0(123);
        }
        if (!checkBases) {
            PsiMethod[] methodsByName = psiClass.findMethodsByName(name, false);
            ArrayList<Pair<PsiMethod, PsiSubstitutor>> ret = new ArrayList<Pair<PsiMethod, PsiSubstitutor>>(methodsByName.length);
            for (PsiMethod method : methodsByName) {
                ret.add(Pair.create(method, PsiSubstitutor.EMPTY));
            }
            ArrayList<Pair<PsiMethod, PsiSubstitutor>> arrayList = ret;
            if (arrayList == null) {
                PsiClassImplUtil.$$$reportNull$$$0(124);
            }
            return arrayList;
        }
        PsiMember[] list2 = PsiClassImplUtil.getMap(psiClass, MemberType.METHOD).get(name);
        if (list2 == null) {
            List<Pair<PsiMethod, PsiSubstitutor>> list3 = Collections.emptyList();
            if (list3 == null) {
                PsiClassImplUtil.$$$reportNull$$$0(125);
            }
            return list3;
        }
        List<Pair<PsiMethod, PsiSubstitutor>> list4 = PsiClassImplUtil.withSubstitutors(psiClass, list2);
        if (list4 == null) {
            PsiClassImplUtil.$$$reportNull$$$0(126);
        }
        return list4;
    }

    @NotNull
    private static <T extends PsiMember> List<Pair<T, PsiSubstitutor>> withSubstitutors(@NotNull PsiClass psiClass, PsiMember[] members2) {
        if (psiClass == null) {
            PsiClassImplUtil.$$$reportNull$$$0(127);
        }
        ScopedClassHierarchy hierarchy = ScopedClassHierarchy.getHierarchy(psiClass, psiClass.getResolveScope());
        LanguageLevel level = PsiUtil.getLanguageLevel(psiClass);
        List<Pair<T, PsiSubstitutor>> list2 = ContainerUtil.map(members2, member -> {
            PsiClass containingClass = member.getContainingClass();
            PsiSubstitutor substitutor2 = containingClass == null ? null : hierarchy.getSuperMembersSubstitutor(containingClass, level);
            return Pair.create(member, substitutor2 == null ? PsiSubstitutor.EMPTY : substitutor2);
        });
        if (list2 == null) {
            PsiClassImplUtil.$$$reportNull$$$0(128);
        }
        return list2;
    }

    @NotNull
    public static PsiClassType[] getExtendsListTypes(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            PsiClassImplUtil.$$$reportNull$$$0(129);
        }
        if (psiClass.isEnum()) {
            PsiClassType[] psiClassTypeArray;
            PsiClassType enumSuperType = PsiClassImplUtil.getEnumSuperType(psiClass, JavaPsiFacade.getInstance(psiClass.getProject()).getElementFactory());
            if (enumSuperType == null) {
                psiClassTypeArray = PsiClassType.EMPTY_ARRAY;
            } else {
                PsiClassType[] psiClassTypeArray2 = new PsiClassType[1];
                psiClassTypeArray = psiClassTypeArray2;
                psiClassTypeArray2[0] = enumSuperType;
            }
            if (psiClassTypeArray == null) {
                PsiClassImplUtil.$$$reportNull$$$0(130);
            }
            return psiClassTypeArray;
        }
        if (psiClass.isAnnotationType()) {
            PsiClassType[] psiClassTypeArray = new PsiClassType[]{PsiClassImplUtil.getAnnotationSuperType(psiClass, JavaPsiFacade.getInstance(psiClass.getProject()).getElementFactory())};
            if (psiClassTypeArray == null) {
                PsiClassImplUtil.$$$reportNull$$$0(131);
            }
            return psiClassTypeArray;
        }
        PsiType upperBound = InferenceSession.getUpperBound(psiClass);
        if (upperBound == null && psiClass instanceof PsiTypeParameter) {
            upperBound = LambdaUtil.getFunctionalTypeMap().get(psiClass);
        }
        if (upperBound instanceof PsiIntersectionType) {
            PsiType[] conjuncts = ((PsiIntersectionType)upperBound).getConjuncts();
            ArrayList<PsiClassType> result2 = new ArrayList<PsiClassType>();
            for (PsiType conjunct : conjuncts) {
                if (!(conjunct instanceof PsiClassType)) continue;
                result2.add((PsiClassType)conjunct);
            }
            PsiClassType[] psiClassTypeArray = result2.toArray(new PsiClassType[result2.size()]);
            if (psiClassTypeArray == null) {
                PsiClassImplUtil.$$$reportNull$$$0(132);
            }
            return psiClassTypeArray;
        }
        if (upperBound instanceof PsiClassType) {
            PsiClassType[] psiClassTypeArray = new PsiClassType[]{(PsiClassType)upperBound};
            if (psiClassTypeArray == null) {
                PsiClassImplUtil.$$$reportNull$$$0(133);
            }
            return psiClassTypeArray;
        }
        PsiReferenceList extendsList = psiClass.getExtendsList();
        if (extendsList != null) {
            PsiClassType[] psiClassTypeArray = extendsList.getReferencedTypes();
            if (psiClassTypeArray == null) {
                PsiClassImplUtil.$$$reportNull$$$0(134);
            }
            return psiClassTypeArray;
        }
        if (PsiClassType.EMPTY_ARRAY == null) {
            PsiClassImplUtil.$$$reportNull$$$0(135);
        }
        return PsiClassType.EMPTY_ARRAY;
    }

    @NotNull
    public static PsiClassType[] getImplementsListTypes(@NotNull PsiClass psiClass) {
        PsiReferenceList extendsList;
        if (psiClass == null) {
            PsiClassImplUtil.$$$reportNull$$$0(136);
        }
        if ((extendsList = psiClass.getImplementsList()) != null) {
            PsiClassType[] psiClassTypeArray = extendsList.getReferencedTypes();
            if (psiClassTypeArray == null) {
                PsiClassImplUtil.$$$reportNull$$$0(137);
            }
            return psiClassTypeArray;
        }
        if (PsiClassType.EMPTY_ARRAY == null) {
            PsiClassImplUtil.$$$reportNull$$$0(138);
        }
        return PsiClassType.EMPTY_ARRAY;
    }

    static boolean isInExtendsList(@NotNull PsiClass psiClass, @NotNull PsiClass baseClass, @Nullable String baseName, @NotNull PsiManager manager) {
        if (psiClass == null) {
            PsiClassImplUtil.$$$reportNull$$$0(139);
        }
        if (baseClass == null) {
            PsiClassImplUtil.$$$reportNull$$$0(140);
        }
        if (manager == null) {
            PsiClassImplUtil.$$$reportNull$$$0(141);
        }
        if (psiClass.isEnum()) {
            return "java.lang.Enum".equals(baseClass.getQualifiedName());
        }
        if (psiClass.isAnnotationType()) {
            return "java.lang.annotation.Annotation".equals(baseClass.getQualifiedName());
        }
        PsiType upperBound = InferenceSession.getUpperBound(psiClass);
        if (upperBound == null && psiClass instanceof PsiTypeParameter) {
            upperBound = LambdaUtil.getFunctionalTypeMap().get(psiClass);
        }
        if (upperBound instanceof PsiIntersectionType) {
            PsiType[] conjuncts;
            for (PsiType conjunct : conjuncts = ((PsiIntersectionType)upperBound).getConjuncts()) {
                if (!(conjunct instanceof PsiClassType) || !((PsiClassType)conjunct).getClassName().equals(baseName) || !baseClass.equals(((PsiClassType)conjunct).resolve())) continue;
                return true;
            }
            return false;
        }
        if (upperBound instanceof PsiClassType) {
            return ((PsiClassType)upperBound).getClassName().equals(baseName) && baseClass.equals(((PsiClassType)upperBound).resolve());
        }
        return PsiClassImplUtil.isInReferenceList(psiClass.getExtendsList(), baseClass, baseName, manager);
    }

    static boolean isInReferenceList(@Nullable PsiReferenceList list2, @NotNull PsiClass baseClass, @Nullable String baseName, @NotNull PsiManager manager) {
        if (baseClass == null) {
            PsiClassImplUtil.$$$reportNull$$$0(142);
        }
        if (manager == null) {
            PsiClassImplUtil.$$$reportNull$$$0(143);
        }
        if (list2 == null) {
            return false;
        }
        if (list2 instanceof StubBasedPsiElement) {
            Object stub = ((StubBasedPsiElement)((Object)list2)).getStub();
            if (stub instanceof PsiClassReferenceListStub && baseName != null) {
                PsiClassReferenceListStub classStub = (PsiClassReferenceListStub)stub;
                String[] names2 = classStub.getReferencedNames();
                for (int i2 = 0; i2 < names2.length; ++i2) {
                    PsiClassType[] referencedTypes;
                    PsiClass resolved;
                    String name = names2[i2];
                    int typeParam = name.indexOf(60);
                    if (typeParam != -1) {
                        name = name.substring(0, typeParam);
                    }
                    if (!name.endsWith(baseName) || !manager.areElementsEquivalent(baseClass, resolved = (referencedTypes = classStub.getReferencedTypes())[i2].resolve())) continue;
                    return true;
                }
                return false;
            }
            if (stub != null) {
                for (PsiClassType type2 : list2.getReferencedTypes()) {
                    if (!Comparing.equal(type2.getClassName(), baseName) || !manager.areElementsEquivalent(baseClass, type2.resolve())) continue;
                    return true;
                }
                return false;
            }
        }
        if (list2.getLanguage() == JavaLanguage.INSTANCE) {
            for (PsiJavaCodeReferenceElement referenceElement : list2.getReferenceElements()) {
                if (!Comparing.strEqual(baseName, referenceElement.getReferenceName()) || !manager.areElementsEquivalent(baseClass, referenceElement.resolve())) continue;
                return true;
            }
            return false;
        }
        for (PsiClassType type3 : list2.getReferencedTypes()) {
            if (!Comparing.equal(type3.getClassName(), baseName) || !manager.areElementsEquivalent(baseClass, type3.resolve())) continue;
            return true;
        }
        return false;
    }

    public static boolean isClassEquivalentTo(@NotNull PsiClass aClass2, PsiElement another) {
        PsiFile original2;
        if (aClass2 == null) {
            PsiClassImplUtil.$$$reportNull$$$0(144);
        }
        if (aClass2 == another) {
            return true;
        }
        if (!(another instanceof PsiClass)) {
            return false;
        }
        String name1 = aClass2.getName();
        if (name1 == null) {
            return false;
        }
        if (!another.isValid()) {
            return false;
        }
        String name2 = ((PsiClass)another).getName();
        if (name2 == null) {
            return false;
        }
        if (name1.hashCode() != name2.hashCode()) {
            return false;
        }
        if (!name1.equals(name2)) {
            return false;
        }
        String qName1 = aClass2.getQualifiedName();
        String qName2 = ((PsiClass)another).getQualifiedName();
        if (qName1 == null || qName2 == null) {
            if (qName1 != qName2) {
                return false;
            }
            if (aClass2 instanceof PsiTypeParameter && another instanceof PsiTypeParameter) {
                PsiTypeParameter p1 = (PsiTypeParameter)aClass2;
                PsiTypeParameter p2 = (PsiTypeParameter)another;
                return p1.getIndex() == p2.getIndex() && (aClass2.getManager().areElementsEquivalent(p1.getOwner(), p2.getOwner()) || TypeConversionUtil.areSameFreshVariables(p1, p2));
            }
            return false;
        }
        if (qName1.hashCode() != qName2.hashCode() || !qName1.equals(qName2)) {
            return false;
        }
        if (aClass2.getOriginalElement().equals(another.getOriginalElement())) {
            return true;
        }
        PsiFile file1 = aClass2.getContainingFile().getOriginalFile();
        PsiFile file2 = another.getContainingFile().getOriginalFile();
        PsiFile original1 = file1.getUserData(PsiFileFactory.ORIGINAL_FILE);
        if (original1 == (original2 = file2.getUserData(PsiFileFactory.ORIGINAL_FILE)) && original1 != null || original1 == file2 || original2 == file1 || file1 == file2) {
            return PsiClassImplUtil.compareClassSeqNumber(aClass2, (PsiClass)another);
        }
        FileIndexFacade fileIndex = ServiceManager.getService(file1.getProject(), FileIndexFacade.class);
        VirtualFile vfile1 = file1.getViewProvider().getVirtualFile();
        VirtualFile vfile2 = file2.getViewProvider().getVirtualFile();
        boolean lib1 = fileIndex.isInLibraryClasses(vfile1);
        boolean lib2 = fileIndex.isInLibraryClasses(vfile2);
        return !(!fileIndex.isInSource(vfile1) && !lib1 || !fileIndex.isInSource(vfile2) && !lib2);
    }

    private static boolean compareClassSeqNumber(@NotNull PsiClass aClass2, @NotNull PsiClass another) {
        int index1;
        if (aClass2 == null) {
            PsiClassImplUtil.$$$reportNull$$$0(145);
        }
        if (another == null) {
            PsiClassImplUtil.$$$reportNull$$$0(146);
        }
        if ((index1 = PsiClassImplUtil.getSeqNumber(aClass2)) == -1) {
            return true;
        }
        int index2 = PsiClassImplUtil.getSeqNumber(another);
        return index1 == index2;
    }

    private static int getSeqNumber(@NotNull PsiClass aClass2) {
        PsiElement parent2;
        if (aClass2 == null) {
            PsiClassImplUtil.$$$reportNull$$$0(147);
        }
        if ((parent2 = aClass2.getParent()) == null) {
            return -1;
        }
        int seqNo = 0;
        for (PsiElement child : parent2.getChildren()) {
            if (child == aClass2) {
                return seqNo;
            }
            if (!(child instanceof PsiClass) || !Comparing.strEqual(aClass2.getName(), ((PsiClass)child).getName())) continue;
            ++seqNo;
        }
        return -1;
    }

    public static boolean isFieldEquivalentTo(@NotNull PsiField field, PsiElement another) {
        if (field == null) {
            PsiClassImplUtil.$$$reportNull$$$0(148);
        }
        if (!(another instanceof PsiField)) {
            return false;
        }
        String name1 = field.getName();
        if (name1 == null) {
            return false;
        }
        if (!another.isValid()) {
            return false;
        }
        String name2 = ((PsiField)another).getName();
        if (!name1.equals(name2)) {
            return false;
        }
        PsiClass aClass1 = field.getContainingClass();
        PsiClass aClass2 = ((PsiField)another).getContainingClass();
        return aClass1 != null && aClass2 != null && field.getManager().areElementsEquivalent(aClass1, aClass2);
    }

    public static boolean isMethodEquivalentTo(@NotNull PsiMethod method1, PsiElement another) {
        PsiParameter[] parameters2;
        if (method1 == null) {
            PsiClassImplUtil.$$$reportNull$$$0(149);
        }
        if (method1 == another) {
            return true;
        }
        if (!(another instanceof PsiMethod)) {
            return false;
        }
        PsiMethod method2 = (PsiMethod)another;
        if (!another.isValid()) {
            return false;
        }
        if (!method1.getName().equals(method2.getName())) {
            return false;
        }
        PsiClass aClass1 = method1.getContainingClass();
        PsiClass aClass2 = method2.getContainingClass();
        PsiManager manager = method1.getManager();
        if (aClass1 == null || aClass2 == null || !manager.areElementsEquivalent(aClass1, aClass2)) {
            return false;
        }
        PsiParameter[] parameters1 = method1.getParameterList().getParameters();
        if (parameters1.length != (parameters2 = method2.getParameterList().getParameters()).length) {
            return false;
        }
        for (int i2 = 0; i2 < parameters1.length; ++i2) {
            PsiType type2;
            PsiParameter parameter1 = parameters1[i2];
            PsiParameter parameter2 = parameters2[i2];
            PsiType type1 = parameter1.getType();
            if (PsiClassImplUtil.compareParamTypes(manager, type1, type2 = parameter2.getType(), new HashSet<String>())) continue;
            return false;
        }
        return true;
    }

    private static boolean compareParamTypes(@NotNull PsiManager manager, @NotNull PsiType type1, @NotNull PsiType type2, Set<String> visited2) {
        if (manager == null) {
            PsiClassImplUtil.$$$reportNull$$$0(150);
        }
        if (type1 == null) {
            PsiClassImplUtil.$$$reportNull$$$0(151);
        }
        if (type2 == null) {
            PsiClassImplUtil.$$$reportNull$$$0(152);
        }
        if (type1 instanceof PsiArrayType) {
            PsiType componentType2;
            PsiType componentType1;
            return type2 instanceof PsiArrayType && PsiClassImplUtil.compareParamTypes(manager, componentType1 = ((PsiArrayType)type1).getComponentType(), componentType2 = ((PsiArrayType)type2).getComponentType(), visited2);
        }
        if (!(type1 instanceof PsiClassType) || !(type2 instanceof PsiClassType)) {
            return type1.equals(type2);
        }
        PsiClass class1 = ((PsiClassType)type1).resolve();
        PsiClass class2 = ((PsiClassType)type2).resolve();
        visited2.add(type1.getCanonicalText());
        visited2.add(type2.getCanonicalText());
        if (class1 instanceof PsiTypeParameter && class2 instanceof PsiTypeParameter) {
            PsiClassType[] eTypes2;
            if (!Comparing.equal(class1.getName(), class2.getName()) || ((PsiTypeParameter)class1).getIndex() != ((PsiTypeParameter)class2).getIndex()) {
                return false;
            }
            PsiClassType[] eTypes1 = class1.getExtendsListTypes();
            if (eTypes1.length != (eTypes2 = class2.getExtendsListTypes()).length) {
                return false;
            }
            for (int i2 = 0; i2 < eTypes1.length; ++i2) {
                PsiClassType eType1 = eTypes1[i2];
                PsiClassType eType2 = eTypes2[i2];
                if (visited2.contains(eType1.getCanonicalText()) || visited2.contains(eType2.getCanonicalText())) {
                    return false;
                }
                if (PsiClassImplUtil.compareParamTypes(manager, eType1, eType2, visited2)) continue;
                return false;
            }
            return true;
        }
        return manager.areElementsEquivalent(class1, class2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 13: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 27: 
            case 30: 
            case 34: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 47: 
            case 91: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 108: 
            case 112: 
            case 113: 
            case 115: 
            case 116: 
            case 117: 
            case 120: 
            case 121: 
            case 122: 
            case 124: 
            case 125: 
            case 126: 
            case 128: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 137: 
            case 138: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 13: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 27: 
            case 30: 
            case 34: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 47: 
            case 91: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 108: 
            case 112: 
            case 113: 
            case 115: 
            case 116: 
            case 117: 
            case 120: 
            case 121: 
            case 122: 
            case 124: 
            case 125: 
            case 126: 
            case 128: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 137: 
            case 138: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 13: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 27: 
            case 30: 
            case 34: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 47: 
            case 91: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 108: 
            case 112: 
            case 113: 
            case 115: 
            case 116: 
            case 117: 
            case 120: 
            case 121: 
            case 122: 
            case 124: 
            case 125: 
            case 126: 
            case 128: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 137: 
            case 138: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/PsiClassImplUtil";
                break;
            }
            case 10: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patternMethod";
                break;
            }
            case 20: 
            case 26: 
            case 29: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 45: 
            case 69: 
            case 86: 
            case 107: 
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 48: 
            case 52: 
            case 57: 
            case 63: 
            case 79: 
            case 153: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 49: 
            case 53: 
            case 58: 
            case 64: 
            case 80: 
            case 154: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "innerStuffCache";
                break;
            }
            case 54: 
            case 59: 
            case 65: 
            case 81: 
            case 155: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 55: 
            case 60: 
            case 68: 
            case 77: 
            case 82: 
            case 87: 
            case 156: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 61: 
            case 83: 
            case 84: 
            case 157: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveScope";
                break;
            }
            case 66: 
            case 71: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidateMethod";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidateClass";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidateSubstitutor";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementFactory";
                break;
            }
            case 88: 
            case 89: 
            case 90: 
            case 92: 
            case 101: 
            case 106: 
            case 109: 
            case 114: 
            case 119: 
            case 123: 
            case 127: 
            case 129: 
            case 136: 
            case 139: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 111: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameter";
                break;
            }
            case 118: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listOfTypes";
                break;
            }
            case 140: 
            case 142: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseClass";
                break;
            }
            case 141: 
            case 143: 
            case 150: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 146: {
                objectArray2 = objectArray3;
                objectArray3[0] = "another";
                break;
            }
            case 148: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 149: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method1";
                break;
            }
            case 151: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type1";
                break;
            }
            case 152: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/PsiClassImplUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllFields";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllMethods";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllInnerClasses";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "findMethodsByName";
                break;
            }
            case 13: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "findMethodsBySignature";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "findByMap";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllWithSubstitutorsByMap";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllByMap";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getValues";
                break;
            }
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassUseScope";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "createSignatureFromText";
                break;
            }
            case 91: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupers";
                break;
            }
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupersInner";
                break;
            }
            case 102: 
            case 103: 
            case 104: 
            case 105: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperTypes";
                break;
            }
            case 108: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotationSuperType";
                break;
            }
            case 112: 
            case 113: 
            case 115: 
            case 116: 
            case 117: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterfaces";
                break;
            }
            case 120: 
            case 121: 
            case 122: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveClassReferenceList";
                break;
            }
            case 124: 
            case 125: 
            case 126: {
                objectArray = objectArray2;
                objectArray2[1] = "findMethodsAndTheirSubstitutorsByName";
                break;
            }
            case 128: {
                objectArray = objectArray2;
                objectArray2[1] = "withSubstitutors";
                break;
            }
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtendsListTypes";
                break;
            }
            case 137: 
            case 138: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplementsListTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAllFields";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 13: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 27: 
            case 30: 
            case 34: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 47: 
            case 91: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 108: 
            case 112: 
            case 113: 
            case 115: 
            case 116: 
            case 117: 
            case 120: 
            case 121: 
            case 122: 
            case 124: 
            case 125: 
            case 126: 
            case 128: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 137: 
            case 138: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getAllMethods";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAllInnerClasses";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findFieldByName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findMethodsByName";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findMethodBySignature";
                break;
            }
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findMethodsBySignature";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findInnerByName";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findByMap";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getAllWithSubstitutorsByMap";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getAllByMap";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getMap";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getValues";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getClassIcon";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getClassUseScope";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "isMainOrPremainMethod";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "createSignatureFromText";
                break;
            }
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarationsInEnum";
                break;
            }
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarationsInClass";
                break;
            }
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "processCachedMembersByName";
                break;
            }
            case 69: 
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "checkRaw";
                break;
            }
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "obtainFinalSubstitutor";
                break;
            }
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarationsInClassNotCached";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "correctType";
                break;
            }
            case 85: 
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "processSuperTypes";
                break;
            }
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "getSuperClass";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "findSpecialSuperClass";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "getSupers";
                break;
            }
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "getSupersInner";
                break;
            }
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "getSuperTypes";
                break;
            }
            case 106: 
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationSuperType";
                break;
            }
            case 109: 
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "getEnumSuperType";
                break;
            }
            case 111: 
            case 114: {
                objectArray = objectArray;
                objectArray[2] = "getInterfaces";
                break;
            }
            case 118: 
            case 119: {
                objectArray = objectArray;
                objectArray[2] = "resolveClassReferenceList";
                break;
            }
            case 123: {
                objectArray = objectArray;
                objectArray[2] = "findMethodsAndTheirSubstitutorsByName";
                break;
            }
            case 127: {
                objectArray = objectArray;
                objectArray[2] = "withSubstitutors";
                break;
            }
            case 129: {
                objectArray = objectArray;
                objectArray[2] = "getExtendsListTypes";
                break;
            }
            case 136: {
                objectArray = objectArray;
                objectArray[2] = "getImplementsListTypes";
                break;
            }
            case 139: 
            case 140: 
            case 141: {
                objectArray = objectArray;
                objectArray[2] = "isInExtendsList";
                break;
            }
            case 142: 
            case 143: {
                objectArray = objectArray;
                objectArray[2] = "isInReferenceList";
                break;
            }
            case 144: {
                objectArray = objectArray;
                objectArray[2] = "isClassEquivalentTo";
                break;
            }
            case 145: 
            case 146: {
                objectArray = objectArray;
                objectArray[2] = "compareClassSeqNumber";
                break;
            }
            case 147: {
                objectArray = objectArray;
                objectArray[2] = "getSeqNumber";
                break;
            }
            case 148: {
                objectArray = objectArray;
                objectArray[2] = "isFieldEquivalentTo";
                break;
            }
            case 149: {
                objectArray = objectArray;
                objectArray[2] = "isMethodEquivalentTo";
                break;
            }
            case 150: 
            case 151: 
            case 152: {
                objectArray = objectArray;
                objectArray[2] = "compareParamTypes";
                break;
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processDeclarationsInClassNotCached$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 13: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 27: 
            case 30: 
            case 34: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 47: 
            case 91: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 108: 
            case 112: 
            case 113: 
            case 115: 
            case 116: 
            case 117: 
            case 120: 
            case 121: 
            case 122: 
            case 124: 
            case 125: 
            case 126: 
            case 128: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 137: 
            case 138: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ByNameCachedValueProvider
    implements ParameterizedCachedValueProvider<Map<GlobalSearchScope, MembersMap>, PsiClass> {
        private static final ByNameCachedValueProvider INSTANCE = new ByNameCachedValueProvider();

        private ByNameCachedValueProvider() {
        }

        @Override
        public CachedValueProvider.Result<Map<GlobalSearchScope, MembersMap>> compute(@NotNull PsiClass myClass) {
            if (myClass == null) {
                ByNameCachedValueProvider.$$$reportNull$$$0(0);
            }
            ConcurrentMap<GlobalSearchScope, MembersMap> map2 = ConcurrentFactoryMap.createMap(scope -> {
                if (myClass == null) {
                    ByNameCachedValueProvider.$$$reportNull$$$0(1);
                }
                return new MembersMap(myClass, (GlobalSearchScope)scope);
            });
            return CachedValueProvider.Result.create(map2, PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "myClass";
            objectArray2[1] = "com/intellij/psi/impl/PsiClassImplUtil$ByNameCachedValueProvider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "compute";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$compute$0";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MembersMap {
        final ConcurrentMap<MemberType, Map<String, PsiMember[]>> myMap;

        MembersMap(PsiClass psiClass, GlobalSearchScope scope) {
            this.myMap = PsiClassImplUtil.createMembersMap(psiClass, scope);
        }

        private Map<String, PsiMember[]> get(MemberType type2) {
            return (Map)this.myMap.get((Object)type2);
        }
    }

    private static class ClassIconRequest {
        @NotNull
        private final PsiClass psiClass;
        private final int flags;
        private final Icon symbolIcon;

        private ClassIconRequest(@NotNull PsiClass psiClass, int flags, Icon symbolIcon) {
            if (psiClass == null) {
                ClassIconRequest.$$$reportNull$$$0(0);
            }
            this.psiClass = psiClass;
            this.flags = flags;
            this.symbolIcon = symbolIcon;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ClassIconRequest)) {
                return false;
            }
            ClassIconRequest that = (ClassIconRequest)o;
            return this.flags == that.flags && this.psiClass.equals(that.psiClass);
        }

        public int hashCode() {
            int result2 = this.psiClass.hashCode();
            result2 = 31 * result2 + this.flags;
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/psi/impl/PsiClassImplUtil$ClassIconRequest", "<init>"));
        }
    }

    public static enum MemberType {
        CLASS,
        FIELD,
        METHOD;

    }
}

