/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.file;

import com.intellij.codeInsight.completion.scope.JavaCompletionHints;
import com.intellij.core.CoreJavaDirectoryService;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.JavaPsiFacadeImpl;
import com.intellij.psi.impl.file.PsiPackageBase;
import com.intellij.psi.impl.file.PsiPackageImplementationHelper;
import com.intellij.psi.impl.source.tree.java.PsiCompositeModifierList;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.EverythingGlobalScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiClassUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.reference.SoftReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiPackageImpl
extends PsiPackageBase
implements PsiPackage,
Queryable {
    private static final Logger LOG = Logger.getInstance(PsiPackageImpl.class);
    private volatile CachedValue<PsiModifierList> myAnnotationList;
    private volatile CachedValue<Collection<PsiDirectory>> myDirectories;
    private volatile CachedValue<Collection<PsiDirectory>> myDirectoriesWithLibSources;
    private volatile SoftReference<Map<String, PsiClass[]>> myClassCache;
    private volatile SoftReference<Map<GlobalSearchScope, Map<String, PsiClass[]>>> myDumbModeFullCache;
    private volatile SoftReference<Map<Pair<GlobalSearchScope, String>, PsiClass[]>> myDumbModePartialCache;

    public PsiPackageImpl(PsiManager manager, String qualifiedName2) {
        super(manager, qualifiedName2);
    }

    @Override
    protected Collection<PsiDirectory> getAllDirectories(boolean includeLibrarySources) {
        if (includeLibrarySources) {
            if (this.myDirectoriesWithLibSources == null) {
                this.myDirectoriesWithLibSources = this.createCachedDirectories(true);
            }
            return this.myDirectoriesWithLibSources.getValue();
        }
        if (this.myDirectories == null) {
            this.myDirectories = this.createCachedDirectories(false);
        }
        return this.myDirectories.getValue();
    }

    @NotNull
    private CachedValue<Collection<PsiDirectory>> createCachedDirectories(boolean includeLibrarySources) {
        CachedValue<Collection<PsiDirectory>> cachedValue2 = CachedValuesManager.getManager(this.myManager.getProject()).createCachedValue(() -> {
            ArrayList result2 = new ArrayList();
            Processor<PsiDirectory> processor = Processors.cancelableCollectProcessor(result2);
            this.getFacade().processPackageDirectories(this, this.allScope(), processor, includeLibrarySources);
            return CachedValueProvider.Result.create(result2, PsiPackageImplementationHelper.getInstance().getDirectoryCachedValueDependencies(this));
        }, false);
        if (cachedValue2 == null) {
            PsiPackageImpl.$$$reportNull$$$0(0);
        }
        return cachedValue2;
    }

    @Override
    protected PsiElement findPackage(String qName) {
        return this.getFacade().findPackage(qName);
    }

    @Override
    public void handleQualifiedNameChange(@NotNull String newQualifiedName) {
        if (newQualifiedName == null) {
            PsiPackageImpl.$$$reportNull$$$0(1);
        }
        PsiPackageImplementationHelper.getInstance().handleQualifiedNameChange(this, newQualifiedName);
    }

    @Override
    @NotNull
    public VirtualFile[] occursInPackagePrefixes() {
        VirtualFile[] virtualFileArray = PsiPackageImplementationHelper.getInstance().occursInPackagePrefixes(this);
        if (virtualFileArray == null) {
            PsiPackageImpl.$$$reportNull$$$0(2);
        }
        return virtualFileArray;
    }

    @Override
    public PsiPackageImpl getParentPackage() {
        return (PsiPackageImpl)super.getParentPackage();
    }

    @Override
    protected PsiPackageImpl createInstance(PsiManager manager, String qName) {
        return new PsiPackageImpl(this.myManager, qName);
    }

    @Override
    @NotNull
    public Language getLanguage() {
        JavaLanguage javaLanguage = JavaLanguage.INSTANCE;
        if (javaLanguage == null) {
            PsiPackageImpl.$$$reportNull$$$0(3);
        }
        return javaLanguage;
    }

    @Override
    public boolean isValid() {
        return !this.myManager.getProject().isDisposed() && (PsiPackageImplementationHelper.getInstance().packagePrefixExists(this) || !this.getAllDirectories(true).isEmpty());
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            PsiPackageImpl.$$$reportNull$$$0(4);
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitPackage(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiPackage:" + this.getQualifiedName();
    }

    @Override
    @NotNull
    public PsiClass[] getClasses() {
        PsiClass[] psiClassArray = this.getClasses(this.allScope());
        if (psiClassArray == null) {
            PsiPackageImpl.$$$reportNull$$$0(5);
        }
        return psiClassArray;
    }

    @NotNull
    protected GlobalSearchScope allScope() {
        GlobalSearchScope globalSearchScope = PsiPackageImplementationHelper.getInstance().adjustAllScope(this, GlobalSearchScope.allScope(this.getProject()));
        if (globalSearchScope == null) {
            PsiPackageImpl.$$$reportNull$$$0(6);
        }
        return globalSearchScope;
    }

    @Override
    @NotNull
    public PsiClass[] getClasses(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            PsiPackageImpl.$$$reportNull$$$0(7);
        }
        PsiClass[] psiClassArray = this.getFacade().getClasses(this, scope);
        if (psiClassArray == null) {
            PsiPackageImpl.$$$reportNull$$$0(8);
        }
        return psiClassArray;
    }

    @Override
    @NotNull
    public PsiFile[] getFiles(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            PsiPackageImpl.$$$reportNull$$$0(9);
        }
        PsiFile[] psiFileArray = this.getFacade().getPackageFiles(this, scope);
        if (psiFileArray == null) {
            PsiPackageImpl.$$$reportNull$$$0(10);
        }
        return psiFileArray;
    }

    @Override
    @Nullable
    public PsiModifierList getAnnotationList() {
        if (this.myAnnotationList == null) {
            this.myAnnotationList = CachedValuesManager.getManager(this.myManager.getProject()).createCachedValue(new PackageAnnotationValueProvider(), false);
        }
        return this.myAnnotationList.getValue();
    }

    @Override
    @NotNull
    public PsiPackage[] getSubPackages() {
        PsiPackage[] psiPackageArray = this.getSubPackages(this.allScope());
        if (psiPackageArray == null) {
            PsiPackageImpl.$$$reportNull$$$0(11);
        }
        return psiPackageArray;
    }

    @Override
    @NotNull
    public PsiPackage[] getSubPackages(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            PsiPackageImpl.$$$reportNull$$$0(12);
        }
        PsiPackage[] psiPackageArray = this.getFacade().getSubPackages(this, scope);
        if (psiPackageArray == null) {
            PsiPackageImpl.$$$reportNull$$$0(13);
        }
        return psiPackageArray;
    }

    private JavaPsiFacadeImpl getFacade() {
        return (JavaPsiFacadeImpl)JavaPsiFacade.getInstance(this.myManager.getProject());
    }

    @NotNull
    private PsiClass[] getCachedClassesByName(@NotNull String name, GlobalSearchScope scope) {
        PsiClass[] classes2;
        if (name == null) {
            PsiPackageImpl.$$$reportNull$$$0(14);
        }
        if (DumbService.getInstance(this.getProject()).isDumb()) {
            PsiClass[] psiClassArray = this.getCachedClassInDumbMode(name, scope);
            if (psiClassArray == null) {
                PsiPackageImpl.$$$reportNull$$$0(15);
            }
            return psiClassArray;
        }
        Map<String, PsiClass[]> map2 = SoftReference.dereference(this.myClassCache);
        if (map2 == null) {
            map2 = ContainerUtil.createConcurrentSoftValueMap();
            this.myClassCache = new SoftReference<ConcurrentMap<String, PsiClass[]>>((ConcurrentMap<String, PsiClass[]>)map2);
        }
        if ((classes2 = map2.get(name)) != null) {
            if (classes2 == null) {
                PsiPackageImpl.$$$reportNull$$$0(16);
            }
            return classes2;
        }
        String qName = this.getQualifiedName();
        String classQName = !qName.isEmpty() ? qName + "." + name : name;
        classes2 = this.getFacade().findClasses(classQName, new EverythingGlobalScope(this.getProject()));
        map2.put(name, classes2);
        if (classes2 == null) {
            PsiPackageImpl.$$$reportNull$$$0(17);
        }
        return classes2;
    }

    @NotNull
    private PsiClass[] getCachedClassInDumbMode(String name, GlobalSearchScope scope) {
        PsiClass[] classes2;
        Map<String, PsiClass[]> map2;
        Map<GlobalSearchScope, Map<String, PsiClass[]>> scopeMap = SoftReference.dereference(this.myDumbModeFullCache);
        if (scopeMap == null) {
            scopeMap = ContainerUtil.newConcurrentMap();
            this.myDumbModeFullCache = new SoftReference<ConcurrentMap<GlobalSearchScope, Map<String, PsiClass[]>>>((ConcurrentMap<GlobalSearchScope, Map<String, PsiClass[]>>)scopeMap);
        }
        if ((map2 = scopeMap.get(scope)) == null) {
            PsiClass[] array = this.findClassesHeuristically(name, scope);
            if (array != null) {
                if (array == null) {
                    PsiPackageImpl.$$$reportNull$$$0(18);
                }
                return array;
            }
            map2 = new HashMap<String, PsiClass[]>();
            for (PsiClass psiClass : this.getClasses(scope)) {
                PsiClass[] psiClassArray;
                String psiClassName = psiClass.getName();
                if (psiClassName == null) continue;
                PsiClass[] existing = map2.get(psiClassName);
                if (existing == null) {
                    PsiClass[] psiClassArray2 = new PsiClass[1];
                    psiClassArray = psiClassArray2;
                    psiClassArray2[0] = psiClass;
                } else {
                    psiClassArray = ArrayUtil.append(existing, psiClass);
                }
                map2.put(psiClassName, psiClassArray);
            }
            scopeMap.put(scope, map2);
        }
        PsiClass[] psiClassArray = (classes2 = map2.get(name)) == null ? PsiClass.EMPTY_ARRAY : classes2;
        if (psiClassArray == null) {
            PsiPackageImpl.$$$reportNull$$$0(19);
        }
        return psiClassArray;
    }

    @Nullable
    private PsiClass[] findClassesHeuristically(String name, GlobalSearchScope scope) {
        PsiClass[] result2;
        if (this.findSubPackageByName(name) != null) {
            return PsiClass.EMPTY_ARRAY;
        }
        Map<Pair<GlobalSearchScope, String>, PsiClass[]> partial = SoftReference.dereference(this.myDumbModePartialCache);
        if (partial == null) {
            partial = ContainerUtil.newConcurrentMap();
            this.myDumbModePartialCache = new SoftReference<ConcurrentMap<Pair<GlobalSearchScope, String>, PsiClass[]>>((ConcurrentMap<Pair<GlobalSearchScope, String>, PsiClass[]>)partial);
        }
        if ((result2 = partial.get(Pair.create(scope, name))) == null) {
            ArrayList<PsiClass> fastClasses = ContainerUtil.newArrayList();
            for (PsiDirectory directory : this.getDirectories(scope)) {
                List<PsiFile> sameNamed = ContainerUtil.filter(directory.getFiles(), file2 -> file2.getName().contains(name));
                Collections.addAll(fastClasses, CoreJavaDirectoryService.getPsiClasses(directory, sameNamed.toArray(new PsiFile[sameNamed.size()])));
            }
            if (!fastClasses.isEmpty()) {
                result2 = fastClasses.toArray(new PsiClass[fastClasses.size()]);
                partial.put(Pair.create(scope, name), result2);
            }
        }
        return result2;
    }

    @Override
    public boolean containsClassNamed(@NotNull String name) {
        if (name == null) {
            PsiPackageImpl.$$$reportNull$$$0(20);
        }
        return this.getCachedClassesByName(name, new EverythingGlobalScope(this.getProject())).length > 0;
    }

    @Override
    @NotNull
    public PsiClass[] findClassByShortName(@NotNull String name, @NotNull GlobalSearchScope scope) {
        PsiClass[] allClasses;
        if (name == null) {
            PsiPackageImpl.$$$reportNull$$$0(21);
        }
        if (scope == null) {
            PsiPackageImpl.$$$reportNull$$$0(22);
        }
        if ((allClasses = this.getCachedClassesByName(name, scope)).length == 0) {
            if (allClasses == null) {
                PsiPackageImpl.$$$reportNull$$$0(23);
            }
            return allClasses;
        }
        if (allClasses.length == 1) {
            PsiClass[] psiClassArray = PsiSearchScopeUtil.isInScope(scope, (PsiElement)allClasses[0]) ? allClasses : PsiClass.EMPTY_ARRAY;
            if (psiClassArray == null) {
                PsiPackageImpl.$$$reportNull$$$0(24);
            }
            return psiClassArray;
        }
        PsiClass[] array = ContainerUtil.findAllAsArray(allClasses, aClass2 -> {
            if (scope == null) {
                PsiPackageImpl.$$$reportNull$$$0(35);
            }
            return PsiSearchScopeUtil.isInScope(scope, (PsiElement)aClass2);
        });
        Arrays.sort(array, PsiClassUtil.createScopeComparator(scope));
        if (array == null) {
            PsiPackageImpl.$$$reportNull$$$0(25);
        }
        return array;
    }

    @Nullable
    private PsiPackage findSubPackageByName(@NotNull String name) {
        String qName;
        if (name == null) {
            PsiPackageImpl.$$$reportNull$$$0(26);
        }
        String subpackageQName = (qName = this.getQualifiedName()).isEmpty() ? name : qName + "." + name;
        return this.getFacade().findPackage(subpackageQName);
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state2, PsiElement lastParent, @NotNull PsiElement place) {
        PsiClass[] classes2;
        String providedName;
        if (processor == null) {
            PsiPackageImpl.$$$reportNull$$$0(27);
        }
        if (state2 == null) {
            PsiPackageImpl.$$$reportNull$$$0(28);
        }
        if (place == null) {
            PsiPackageImpl.$$$reportNull$$$0(29);
        }
        GlobalSearchScope scope = place.getResolveScope();
        processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, this);
        ElementClassHint classHint = processor.getHint(ElementClassHint.KEY);
        Condition<String> nameCondition = processor.getHint(JavaCompletionHints.NAME_FILTER);
        NameHint providedNameHint = processor.getHint(NameHint.KEY);
        String string = providedName = providedNameHint == null ? null : providedNameHint.getName(state2);
        if ((classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.CLASS)) && (providedName != null ? !PsiPackageImpl.processClasses(processor, state2, classes2 = this.findClassByShortName(providedName, scope), Conditions.alwaysTrue()) : !PsiPackageImpl.processClasses(processor, state2, classes2 = this.getClasses(scope), nameCondition != null ? nameCondition : Conditions.alwaysTrue()))) {
            return false;
        }
        if (classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.PACKAGE)) {
            if (providedName != null) {
                PsiPackage aPackage = this.findSubPackageByName(providedName);
                if (aPackage != null && !processor.execute(aPackage, state2)) {
                    return false;
                }
            } else {
                PsiPackage[] packs;
                for (PsiPackage pack : packs = this.getSubPackages(scope)) {
                    String packageName = pack.getName();
                    if (packageName == null || !PsiNameHelper.getInstance(this.myManager.getProject()).isIdentifier(packageName, PsiUtil.getLanguageLevel(this)) || processor.execute(pack, state2)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private static boolean processClasses(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state2, @NotNull PsiClass[] classes2, @NotNull Condition<String> nameCondition) {
        if (processor == null) {
            PsiPackageImpl.$$$reportNull$$$0(30);
        }
        if (state2 == null) {
            PsiPackageImpl.$$$reportNull$$$0(31);
        }
        if (classes2 == null) {
            PsiPackageImpl.$$$reportNull$$$0(32);
        }
        if (nameCondition == null) {
            PsiPackageImpl.$$$reportNull$$$0(33);
        }
        for (PsiClass aClass2 : classes2) {
            String name = aClass2.getName();
            if (name == null || !nameCondition.value(name)) continue;
            try {
                if (processor.execute(aClass2, state2)) continue;
                return false;
            }
            catch (ProcessCanceledException | IndexNotReadyException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error(e);
            }
        }
        return true;
    }

    @Override
    public boolean canNavigate() {
        return this.isValid();
    }

    @Override
    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation(this);
    }

    @Override
    public void navigate(boolean requestFocus) {
        PsiPackageImplementationHelper.getInstance().navigate(this, requestFocus);
    }

    @Override
    @Nullable
    public PsiModifierList getModifierList() {
        return this.getAnnotationList();
    }

    @Override
    public boolean hasModifierProperty(@NonNls @NotNull String name) {
        if (name == null) {
            PsiPackageImpl.$$$reportNull$$$0(34);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 9: 
            case 12: 
            case 14: 
            case 20: 
            case 21: 
            case 22: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 9: 
            case 12: 
            case 14: 
            case 20: 
            case 21: 
            case 22: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/file/PsiPackageImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newQualifiedName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 7: 
            case 9: 
            case 12: 
            case 22: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 14: 
            case 20: 
            case 21: 
            case 26: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classes";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameCondition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createCachedDirectories";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 9: 
            case 12: 
            case 14: 
            case 20: 
            case 21: 
            case 22: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/file/PsiPackageImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "occursInPackagePrefixes";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 5: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getClasses";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "allScope";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFiles";
                break;
            }
            case 11: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubPackages";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedClassesByName";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedClassInDumbMode";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "findClassByShortName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "handleQualifiedNameChange";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getClasses";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getFiles";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getSubPackages";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getCachedClassesByName";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "containsClassNamed";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "findClassByShortName";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "findSubPackageByName";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "processClasses";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "hasModifierProperty";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findClassByShortName$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 9: 
            case 12: 
            case 14: 
            case 20: 
            case 21: 
            case 22: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class PackageAnnotationValueProvider
    implements CachedValueProvider<PsiModifierList> {
        private PackageAnnotationValueProvider() {
        }

        @Override
        public CachedValueProvider.Result<PsiModifierList> compute() {
            ArrayList<PsiModifierList> modifiers2 = ContainerUtil.newArrayList();
            for (PsiDirectory psiDirectory : PsiPackageImpl.this.getDirectories()) {
                PsiFile file2 = psiDirectory.findFile("package-info.java");
                PsiPackageStatement stmt = file2 == null ? null : PsiTreeUtil.getChildOfType(file2, PsiPackageStatement.class);
                PsiModifierList modifierList = stmt == null ? null : stmt.getAnnotationList();
                ContainerUtil.addIfNotNull(modifiers2, modifierList);
            }
            for (NavigatablePsiElement navigatablePsiElement : PsiPackageImpl.this.getFacade().findClasses(PsiPackageImpl.this.getQualifiedName() + ".package-info", PsiPackageImpl.this.allScope())) {
                ContainerUtil.addIfNotNull(modifiers2, navigatablePsiElement.getModifierList());
            }
            PsiCompositeModifierList result2 = modifiers2.isEmpty() ? null : new PsiCompositeModifierList(PsiPackageImpl.this.getManager(), modifiers2);
            return new CachedValueProvider.Result<PsiModifierList>(result2, PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT);
        }
    }
}

