/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.file.impl;

import com.intellij.ProjectTopics;
import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.PackageIndex;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.file.PsiPackageImpl;
import com.intellij.psi.impl.file.impl.JavaFileManager;
import com.intellij.psi.impl.java.stubs.index.JavaAutoModuleNameIndex;
import com.intellij.psi.impl.java.stubs.index.JavaFullClassNameIndex;
import com.intellij.psi.impl.java.stubs.index.JavaModuleNameIndex;
import com.intellij.psi.impl.light.LightJavaModule;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public class JavaFileManagerImpl
implements JavaFileManager,
Disposable {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.file.impl.JavaFileManagerImpl");
    private final PsiManagerEx myManager;
    private volatile Set<String> myNontrivialPackagePrefixes;
    private boolean myDisposed;
    private final PackageIndex myPackageIndex;

    public JavaFileManagerImpl(Project project) {
        this.myManager = PsiManagerEx.getInstanceEx(project);
        this.myPackageIndex = PackageIndex.getInstance(this.myManager.getProject());
        project.getMessageBus().connect().subscribe(ProjectTopics.PROJECT_ROOTS, new ModuleRootListener(){

            @Override
            public void rootsChanged(ModuleRootEvent event) {
                JavaFileManagerImpl.this.myNontrivialPackagePrefixes = null;
            }
        });
    }

    @Override
    public void dispose() {
        this.myDisposed = true;
    }

    @Override
    @Nullable
    public PsiPackage findPackage(@NotNull String packageName) {
        Query<VirtualFile> dirs;
        if (packageName == null) {
            JavaFileManagerImpl.$$$reportNull$$$0(0);
        }
        if ((dirs = this.myPackageIndex.getDirsByPackageName(packageName, true)).findFirst() == null) {
            return null;
        }
        return new PsiPackageImpl(this.myManager, packageName);
    }

    @Override
    @NotNull
    public PsiClass[] findClasses(@NotNull String qName, @NotNull GlobalSearchScope scope) {
        List<Pair<PsiClass, VirtualFile>> result2;
        int count2;
        if (qName == null) {
            JavaFileManagerImpl.$$$reportNull$$$0(1);
        }
        if (scope == null) {
            JavaFileManagerImpl.$$$reportNull$$$0(2);
        }
        if ((count2 = (result2 = this.doFindClasses(qName, scope)).size()) == 0) {
            if (PsiClass.EMPTY_ARRAY == null) {
                JavaFileManagerImpl.$$$reportNull$$$0(3);
            }
            return PsiClass.EMPTY_ARRAY;
        }
        if (count2 == 1) {
            PsiClass[] psiClassArray = new PsiClass[]{result2.get(0).getFirst()};
            if (psiClassArray == null) {
                JavaFileManagerImpl.$$$reportNull$$$0(4);
            }
            return psiClassArray;
        }
        ContainerUtil.quickSort(result2, (o1, o2) -> {
            if (scope == null) {
                JavaFileManagerImpl.$$$reportNull$$$0(19);
            }
            return scope.compare((VirtualFile)o2.getSecond(), (VirtualFile)o1.getSecond());
        });
        PsiClass[] psiClassArray = (PsiClass[])result2.stream().map(p2 -> (PsiClass)p2.getFirst()).toArray(PsiClass[]::new);
        if (psiClassArray == null) {
            JavaFileManagerImpl.$$$reportNull$$$0(5);
        }
        return psiClassArray;
    }

    @NotNull
    private List<Pair<PsiClass, VirtualFile>> doFindClasses(@NotNull String qName, @NotNull GlobalSearchScope scope) {
        Collection<PsiClass> classes2;
        if (qName == null) {
            JavaFileManagerImpl.$$$reportNull$$$0(6);
        }
        if (scope == null) {
            JavaFileManagerImpl.$$$reportNull$$$0(7);
        }
        if ((classes2 = JavaFullClassNameIndex.getInstance().get(qName.hashCode(), this.myManager.getProject(), scope)).isEmpty()) {
            List<Pair<PsiClass, VirtualFile>> list2 = Collections.emptyList();
            if (list2 == null) {
                JavaFileManagerImpl.$$$reportNull$$$0(8);
            }
            return list2;
        }
        ArrayList<Pair<PsiClass, VirtualFile>> result2 = new ArrayList<Pair<PsiClass, VirtualFile>>(classes2.size());
        for (PsiClass aClass2 : classes2) {
            String qualifiedName2 = aClass2.getQualifiedName();
            if (qualifiedName2 == null || !qualifiedName2.equals(qName)) continue;
            PsiFile file2 = aClass2.getContainingFile();
            if (file2 == null) {
                throw new AssertionError((Object)("No file for class: " + aClass2 + " of " + aClass2.getClass()));
            }
            boolean valid = file2.isValid();
            VirtualFile vFile = file2.getVirtualFile();
            if (!valid) {
                LOG.error("Invalid file " + file2 + "; virtualFile:" + vFile + (vFile != null && !vFile.isValid() ? " (invalid)" : "") + "; id=" + (vFile == null ? 0 : ((VirtualFileWithId)((Object)vFile)).getId()), new PsiInvalidElementAccessException(aClass2));
                continue;
            }
            if (!this.hasAcceptablePackage(vFile)) continue;
            result2.add(Pair.create(aClass2, vFile));
        }
        ArrayList<Pair<PsiClass, VirtualFile>> arrayList = result2;
        if (arrayList == null) {
            JavaFileManagerImpl.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    @Override
    @Nullable
    public PsiClass findClass(@NotNull String qName, @NotNull GlobalSearchScope scope) {
        if (qName == null) {
            JavaFileManagerImpl.$$$reportNull$$$0(10);
        }
        if (scope == null) {
            JavaFileManagerImpl.$$$reportNull$$$0(11);
        }
        LOG.assertTrue(!this.myDisposed);
        VirtualFile bestFile = null;
        PsiClass bestClass = null;
        List<Pair<PsiClass, VirtualFile>> result2 = this.doFindClasses(qName, scope);
        for (int i2 = 0; i2 < result2.size(); ++i2) {
            Pair<PsiClass, VirtualFile> pair = result2.get(i2);
            VirtualFile vFile = pair.getSecond();
            if (bestFile != null && scope.compare(vFile, bestFile) <= 0) continue;
            bestFile = vFile;
            bestClass = pair.getFirst();
        }
        return bestClass;
    }

    private boolean hasAcceptablePackage(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            JavaFileManagerImpl.$$$reportNull$$$0(12);
        }
        if (vFile.getFileType() == JavaClassFileType.INSTANCE) {
            VirtualFile root2 = ProjectRootManager.getInstance(this.myManager.getProject()).getFileIndex().getClassRootForFile(vFile);
            PsiNameHelper nameHelper = PsiNameHelper.getInstance(this.myManager.getProject());
            for (VirtualFile parent2 = vFile.getParent(); parent2 != null && !Comparing.equal(parent2, root2); parent2 = parent2.getParent()) {
                if (nameHelper.isIdentifier(parent2.getName())) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    @NotNull
    public Collection<String> getNonTrivialPackagePrefixes() {
        Set<String> names2 = this.myNontrivialPackagePrefixes;
        if (names2 == null) {
            names2 = new HashSet<String>();
            ProjectRootManager rootManager = ProjectRootManager.getInstance(this.myManager.getProject());
            List<VirtualFile> sourceRoots = rootManager.getModuleSourceRoots(JavaModuleSourceRootTypes.SOURCES);
            ProjectFileIndex fileIndex = rootManager.getFileIndex();
            for (VirtualFile sourceRoot : sourceRoots) {
                String packageName;
                if (!sourceRoot.isDirectory() || (packageName = fileIndex.getPackageNameByDirectory(sourceRoot)) == null || packageName.isEmpty()) continue;
                names2.add(packageName);
            }
            this.myNontrivialPackagePrefixes = names2;
        }
        Set<String> set = names2;
        if (set == null) {
            JavaFileManagerImpl.$$$reportNull$$$0(13);
        }
        return set;
    }

    @Override
    @NotNull
    public Collection<PsiJavaModule> findModules(@NotNull String moduleName, @NotNull GlobalSearchScope scope) {
        List<PsiJavaModule> automatic;
        Collection<PsiJavaModule> named;
        if (moduleName == null) {
            JavaFileManagerImpl.$$$reportNull$$$0(14);
        }
        if (scope == null) {
            JavaFileManagerImpl.$$$reportNull$$$0(15);
        }
        if (!(named = JavaModuleNameIndex.getInstance().get(moduleName, this.myManager.getProject(), scope)).isEmpty()) {
            Collection<PsiJavaModule> collection = named;
            if (collection == null) {
                JavaFileManagerImpl.$$$reportNull$$$0(16);
            }
            return collection;
        }
        Collection<VirtualFile> jars = JavaAutoModuleNameIndex.getFilesByKey(moduleName, scope);
        if (!jars.isEmpty() && !(automatic = jars.stream().map(f -> LightJavaModule.getModule(this.myManager, f)).collect(Collectors.toList())).isEmpty()) {
            List<PsiJavaModule> list2 = automatic;
            if (list2 == null) {
                JavaFileManagerImpl.$$$reportNull$$$0(17);
            }
            return list2;
        }
        List<PsiJavaModule> list3 = Collections.emptyList();
        if (list3 == null) {
            JavaFileManagerImpl.$$$reportNull$$$0(18);
        }
        return list3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 13: 
            case 16: 
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 13: 
            case 16: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 1: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qName";
                break;
            }
            case 2: 
            case 7: 
            case 11: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 13: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/file/impl/JavaFileManagerImpl";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/file/impl/JavaFileManagerImpl";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findClasses";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "doFindClasses";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonTrivialPackagePrefixes";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "findModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findPackage";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findClasses";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 13: 
            case 16: 
            case 17: 
            case 18: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doFindClasses";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findClass";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "hasAcceptablePackage";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findModules";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findClasses$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 13: 
            case 16: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

