/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java;

import com.google.common.base.MoreObjects;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.java.ReferenceChainLink;
import com.intellij.psi.impl.search.ApproximateResolver;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.IOUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class FunExprOccurrence {
    public final int funExprOffset;
    private final int argIndex;
    private final List<ReferenceChainLink> referenceContext;

    public FunExprOccurrence(int funExprOffset, int argIndex, List<ReferenceChainLink> referenceContext) {
        this.funExprOffset = funExprOffset;
        this.argIndex = argIndex;
        this.referenceContext = referenceContext;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FunExprOccurrence)) {
            return false;
        }
        FunExprOccurrence that = (FunExprOccurrence)o;
        if (this.funExprOffset != that.funExprOffset) {
            return false;
        }
        if (this.argIndex != that.argIndex) {
            return false;
        }
        return this.referenceContext.equals(that.referenceContext);
    }

    public int hashCode() {
        int result2 = this.funExprOffset;
        result2 = 31 * result2 + this.argIndex;
        result2 = 31 * result2 + this.referenceContext.hashCode();
        return result2;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("offset", this.funExprOffset).add("argIndex", this.argIndex).add("chain", this.referenceContext).toString();
    }

    void serialize(DataOutput out) throws IOException {
        DataInputOutputUtil.writeINT(out, this.funExprOffset);
        DataInputOutputUtil.writeINT(out, this.argIndex);
        DataInputOutputUtil.writeINT(out, this.referenceContext.size());
        for (ReferenceChainLink link2 : this.referenceContext) {
            FunExprOccurrence.serializeLink(out, link2);
        }
    }

    static FunExprOccurrence deserialize(DataInput in) throws IOException {
        int offset2 = DataInputOutputUtil.readINT(in);
        int argIndex = DataInputOutputUtil.readINT(in);
        int contextSize = DataInputOutputUtil.readINT(in);
        ArrayList<ReferenceChainLink> context = new ArrayList<ReferenceChainLink>(contextSize);
        for (int i2 = 0; i2 < contextSize; ++i2) {
            context.add(FunExprOccurrence.deserializeLink(in));
        }
        return new FunExprOccurrence(offset2, argIndex, context);
    }

    private static void serializeLink(DataOutput out, ReferenceChainLink link2) throws IOException {
        IOUtil.writeUTF(out, link2.referenceName);
        out.writeBoolean(link2.isCall);
        if (link2.isCall) {
            DataInputOutputUtil.writeINT(out, link2.argCount);
        }
    }

    @NotNull
    private static ReferenceChainLink deserializeLink(DataInput in) throws IOException {
        boolean isCall;
        String referenceName = IOUtil.readUTF(in);
        ReferenceChainLink referenceChainLink = new ReferenceChainLink(referenceName, isCall, (isCall = in.readBoolean()) ? DataInputOutputUtil.readINT(in) : -1);
        if (referenceChainLink == null) {
            FunExprOccurrence.$$$reportNull$$$0(0);
        }
        return referenceChainLink;
    }

    public boolean canHaveType(@NotNull List<PsiClass> samClasses, @NotNull VirtualFile placeFile) {
        if (samClasses == null) {
            FunExprOccurrence.$$$reportNull$$$0(1);
        }
        if (placeFile == null) {
            FunExprOccurrence.$$$reportNull$$$0(2);
        }
        if (this.referenceContext.isEmpty()) {
            return true;
        }
        Set<PsiClass> qualifiers = null;
        for (int i2 = 0; i2 < this.referenceContext.size(); ++i2) {
            List<? extends PsiMember> candidates2;
            ReferenceChainLink link2 = this.referenceContext.get(i2);
            List<? extends PsiMember> list2 = candidates2 = i2 == 0 ? link2.getGlobalMembers(placeFile, samClasses.get(0).getProject()) : link2.getSymbolMembers(qualifiers);
            if (candidates2 == null) {
                return true;
            }
            if (i2 == this.referenceContext.size() - 1) {
                return ContainerUtil.exists(candidates2, m -> {
                    if (samClasses == null) {
                        FunExprOccurrence.$$$reportNull$$$0(3);
                    }
                    return this.isCompatible(link2, (PsiMember)m, samClasses);
                });
            }
            qualifiers = ApproximateResolver.getDefiniteSymbolTypes(candidates2);
            if (qualifiers != null) continue;
            return true;
        }
        return true;
    }

    private boolean isCompatible(ReferenceChainLink link2, PsiMember member, List<PsiClass> samClasses) {
        if (link2.isCall) {
            return member instanceof PsiMethod && FunExprOccurrence.hasCompatibleParameter((PsiMethod)member, this.argIndex, samClasses);
        }
        if (member instanceof PsiClass) {
            return ContainerUtil.exists(samClasses, c -> InheritanceUtil.isInheritorOrSelf((PsiClass)member, c, true));
        }
        return member instanceof PsiField && ContainerUtil.exists(samClasses, c -> FunExprOccurrence.canPassFunctionalExpression(c, ((PsiField)member).getType()));
    }

    public static boolean hasCompatibleParameter(PsiMethod method, int argIndex, List<PsiClass> samClasses) {
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        int paramIndex = method.isVarArgs() ? Math.min(argIndex, parameters2.length - 1) : argIndex;
        return paramIndex < parameters2.length && ContainerUtil.exists(samClasses, c -> FunExprOccurrence.canPassFunctionalExpression(c, parameters2[paramIndex].getType()));
    }

    private static boolean canPassFunctionalExpression(PsiClass sam2, PsiType paramType) {
        PsiClass functionalCandidate;
        if (paramType instanceof PsiEllipsisType) {
            paramType = ((PsiEllipsisType)paramType).getComponentType();
        }
        if ((functionalCandidate = PsiUtil.resolveClassInClassTypeOnly(paramType)) instanceof PsiTypeParameter) {
            return InheritanceUtil.isInheritorOrSelf(sam2, PsiUtil.resolveClassInClassTypeOnly(TypeConversionUtil.erasure(paramType)), true);
        }
        return InheritanceUtil.isInheritorOrSelf(functionalCandidate, sam2, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/java/FunExprOccurrence";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "samClasses";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "deserializeLink";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/java/FunExprOccurrence";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "canHaveType";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "lambda$canHaveType$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

