/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaSourceFilterScope
extends DelegatingGlobalSearchScope {
    @Nullable
    private final ProjectFileIndex myIndex;
    private final boolean myIncludeVersions;

    public JavaSourceFilterScope(@NotNull GlobalSearchScope delegate) {
        if (delegate == null) {
            JavaSourceFilterScope.$$$reportNull$$$0(0);
        }
        this(delegate, false);
    }

    public JavaSourceFilterScope(@NotNull GlobalSearchScope delegate, boolean includeVersions) {
        if (delegate == null) {
            JavaSourceFilterScope.$$$reportNull$$$0(1);
        }
        super(delegate);
        Project project = this.getProject();
        this.myIndex = project == null ? null : ProjectRootManager.getInstance(project).getFileIndex();
        this.myIncludeVersions = includeVersions;
    }

    @Override
    public boolean contains(@NotNull VirtualFile file2) {
        if (file2 == null) {
            JavaSourceFilterScope.$$$reportNull$$$0(2);
        }
        if (!super.contains(file2)) {
            return false;
        }
        if (this.myIndex == null) {
            return false;
        }
        if (JavaClassFileType.INSTANCE == file2.getFileType()) {
            return this.myIndex.isInLibraryClasses(file2) && (this.myIncludeVersions || !JavaSourceFilterScope.isVersioned(file2, this.myIndex));
        }
        return this.myIndex.isInSourceContent(file2) || this.myBaseScope.isForceSearchingInLibrarySources() && this.myIndex.isInLibrarySource(file2);
    }

    private static boolean isVersioned(VirtualFile file2, ProjectFileIndex index2) {
        VirtualFile root2 = index2.getClassRootForFile(file2);
        while ((file2 = file2.getParent()) != null && !file2.equals(root2)) {
            VirtualFile parent2;
            if (!Comparing.equal(file2.getNameSequence(), (CharSequence)"versions") || (parent2 = file2.getParent()) == null || !Comparing.equal(parent2.getNameSequence(), (CharSequence)"META-INF")) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/search/JavaSourceFilterScope";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "contains";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

