/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.searches.DirectClassInheritorsSearch;
import com.intellij.psi.stubsHierarchy.ClassHierarchy;
import com.intellij.psi.stubsHierarchy.HierarchyService;
import com.intellij.psi.stubsHierarchy.SmartClassAnchor;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;

public class StubHierarchyInheritorSearcher
extends QueryExecutorBase<PsiClass, DirectClassInheritorsSearch.SearchParameters> {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.search.StubHierarchyInheritorSearcher");

    public StubHierarchyInheritorSearcher() {
        super(true);
    }

    private static boolean isSearching() {
        return Registry.is("java.use.stub.hierarchy.in.inheritor.search");
    }

    @NotNull
    public static GlobalSearchScope restrictScope(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            StubHierarchyInheritorSearcher.$$$reportNull$$$0(0);
        }
        if (!StubHierarchyInheritorSearcher.isSearching()) {
            GlobalSearchScope globalSearchScope = scope;
            if (globalSearchScope == null) {
                StubHierarchyInheritorSearcher.$$$reportNull$$$0(1);
            }
            return globalSearchScope;
        }
        Project project = scope.getProject();
        GlobalSearchScope globalSearchScope = project == null ? scope : HierarchyService.getHierarchy(project).restrictToUncovered(scope);
        if (globalSearchScope == null) {
            StubHierarchyInheritorSearcher.$$$reportNull$$$0(2);
        }
        return globalSearchScope;
    }

    @Override
    public void processQuery(@NotNull DirectClassInheritorsSearch.SearchParameters p2, @NotNull Processor<PsiClass> consumer) {
        if (p2 == null) {
            StubHierarchyInheritorSearcher.$$$reportNull$$$0(3);
        }
        if (consumer == null) {
            StubHierarchyInheritorSearcher.$$$reportNull$$$0(4);
        }
        if (!(p2.getScope() instanceof GlobalSearchScope) || !StubHierarchyInheritorSearcher.isSearching()) {
            return;
        }
        PsiClass base2 = p2.getClassToProcess();
        PsiElement original = base2.getOriginalElement();
        if (original instanceof PsiClass) {
            base2 = (PsiClass)original;
        }
        GlobalSearchScope scope = (GlobalSearchScope)p2.getScope();
        ClassHierarchy hierarchy = HierarchyService.getHierarchy(base2.getProject());
        for (SmartClassAnchor anchor2 : hierarchy.getDirectSubtypeCandidates(base2)) {
            if (!p2.includeAnonymous() && hierarchy.isAnonymous(anchor2) || StubHierarchyInheritorSearcher.processCandidate(consumer, base2, scope, hierarchy, anchor2)) continue;
            return;
        }
    }

    private static boolean processCandidate(Processor<PsiClass> consumer, PsiClass base2, GlobalSearchScope scope, ClassHierarchy hierarchy, SmartClassAnchor anchor2) {
        VirtualFile file2 = anchor2.retrieveFile();
        if (!scope.contains(file2)) {
            return true;
        }
        PsiClass candidate2 = anchor2.retrieveClass(base2.getProject());
        if (!PsiSearchScopeUtil.isInScope(candidate2.getResolveScope(), (PsiElement)base2)) {
            return true;
        }
        if (hierarchy.hasAmbiguousSupers(anchor2) && !candidate2.isInheritor(base2, false)) {
            return true;
        }
        return consumer.process(candidate2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/search/StubHierarchyInheritorSearcher";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/search/StubHierarchyInheritorSearcher";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "restrictScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "restrictScope";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processQuery";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

