/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.graphInference;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMethodReferenceUtil;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.source.resolve.DefaultParameterTypeInferencePolicy;
import com.intellij.psi.impl.source.resolve.ParameterTypeInferencePolicy;
import com.intellij.psi.impl.source.resolve.graphInference.FunctionalInterfaceParameterizationUtil;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceBound;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceIncorporationPhase;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSessionContainer;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceVariable;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceVariablesOrder;
import com.intellij.psi.impl.source.resolve.graphInference.InitialInferenceState;
import com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.CheckedExceptionCompatibilityConstraint;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.ConstraintFormula;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.ExpressionCompatibilityConstraint;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.InputOutputConstraintFormula;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.StrictSubtypingConstraint;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.TypeCompatibilityConstraint;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.TypeEqualityConstraint;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.JavaClassSupers;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.psi.util.TypesDistinctProver;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InferenceSession {
    private static final Logger LOG = Logger.getInstance(InferenceSession.class);
    private static final Key<PsiType> LOWER_BOUND = Key.create("LowBound");
    private static final Key<PsiType> UPPER_BOUND = Key.create("UpperBound");
    private static final Key<Boolean> ERASED = Key.create("UNCHECKED_CONVERSION");
    private static final Function<Pair<PsiType, PsiType>, PsiType> UPPER_BOUND_FUNCTION = new Function<Pair<PsiType, PsiType>, PsiType>(){

        @Override
        public PsiType fun(Pair<PsiType, PsiType> pair) {
            if (!this.isValidGlb((PsiType)pair.first, (PsiType)pair.second)) {
                return null;
            }
            if (!this.isValidGlb((PsiType)pair.second, (PsiType)pair.first)) {
                return null;
            }
            return GenericsUtil.getGreatestLowerBound((PsiType)pair.first, (PsiType)pair.second);
        }

        private boolean isValidGlb(PsiType first2, PsiType second) {
            PsiClass conjunct;
            if (second instanceof PsiArrayType && TypesDistinctProver.proveArrayTypeDistinct((PsiArrayType)second, first2)) {
                return false;
            }
            return !(second instanceof PsiCapturedWildcardType) || first2.isAssignableFrom(second) || (conjunct = PsiUtil.resolveClassInType(first2)) == null || conjunct.isInterface() || conjunct instanceof PsiTypeParameter;
        }
    };
    private static final String EQUALITY_CONSTRAINTS_PRESENTATION = "equality constraints";
    private static final String UPPER_BOUNDS_PRESENTATION = "upper bounds";
    private static final String LOWER_BOUNDS_PRESENTATION = "lower bounds";
    static final Key<PsiCapturedWildcardType> ORIGINAL_CAPTURE = Key.create("ORIGINAL_CAPTURE");
    private final Set<InferenceVariable> myInferenceVariables = new LinkedHashSet<InferenceVariable>();
    private final List<ConstraintFormula> myConstraints = new ArrayList<ConstraintFormula>();
    private final Set<ConstraintFormula> myConstraintsCopy = new HashSet<ConstraintFormula>();
    private InferenceSessionContainer myInferenceSessionContainer = new InferenceSessionContainer();
    private PsiSubstitutor mySiteSubstitutor;
    private final PsiManager myManager;
    private int myConstraintIdx;
    private List<String> myErrorMessages;
    private boolean myErased;
    public final InferenceIncorporationPhase myIncorporationPhase = new InferenceIncorporationPhase(this);
    private final PsiElement myContext;
    private ParameterTypeInferencePolicy myPolicy;
    private PsiSubstitutor myInferenceSubstitution = PsiSubstitutor.EMPTY;
    private PsiSubstitutor myRestoreNameSubstitution = PsiSubstitutor.EMPTY;

    public InferenceSession(InitialInferenceState initialState) {
        this.myContext = initialState.getContext();
        this.myManager = this.myContext.getManager();
        this.myInferenceSubstitution = initialState.getInferenceSubstitutor();
        this.myInferenceVariables.addAll(initialState.getInferenceVariables());
        this.mySiteSubstitutor = initialState.getSiteSubstitutor();
        for (Pair<InferenceVariable[], PsiClassType> capture : initialState.getCaptures()) {
            this.myIncorporationPhase.addCapture((InferenceVariable[])capture.first, (PsiClassType)capture.second);
        }
        this.myInferenceSessionContainer = initialState.getInferenceSessionContainer();
        this.myErased = initialState.isErased();
        this.myPolicy = DefaultParameterTypeInferencePolicy.INSTANCE;
    }

    public InferenceSession(PsiTypeParameter[] typeParams, PsiType[] leftTypes, PsiType[] rightTypes, PsiSubstitutor siteSubstitutor, PsiManager manager, PsiElement context) {
        this.myManager = manager;
        this.mySiteSubstitutor = siteSubstitutor;
        this.myContext = context;
        this.initBounds(typeParams);
        LOG.assertTrue(leftTypes.length == rightTypes.length);
        for (int i2 = 0; i2 < leftTypes.length; ++i2) {
            PsiType rightType = this.mySiteSubstitutor.substitute(rightTypes[i2]);
            PsiType t = this.substituteWithInferenceVariables(leftTypes[i2]);
            PsiType s = this.substituteWithInferenceVariables(rightType);
            if (t == null || s == null) continue;
            this.addConstraint(new TypeCompatibilityConstraint(t, s));
        }
        this.myPolicy = DefaultParameterTypeInferencePolicy.INSTANCE;
    }

    public InferenceSession(PsiTypeParameter[] typeParams, PsiSubstitutor siteSubstitutor, PsiManager manager, PsiElement context) {
        this(typeParams, siteSubstitutor, manager, context, DefaultParameterTypeInferencePolicy.INSTANCE);
    }

    public InferenceSession(PsiTypeParameter[] typeParams, PsiSubstitutor siteSubstitutor, PsiManager manager, PsiElement context, ParameterTypeInferencePolicy policy) {
        this.myManager = manager;
        this.mySiteSubstitutor = siteSubstitutor;
        this.myContext = context;
        this.myPolicy = policy;
        this.initBounds(typeParams);
    }

    public static PsiType getUpperBound(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            InferenceSession.$$$reportNull$$$0(0);
        }
        return psiClass.getUserData(UPPER_BOUND);
    }

    public static PsiType getLowerBound(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            InferenceSession.$$$reportNull$$$0(1);
        }
        return psiClass.getUserData(LOWER_BOUND);
    }

    public static PsiType createTypeParameterTypeWithUpperBound(PsiType upperBound, PsiElement place) {
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory(place.getProject());
        PsiTypeParameter parameter = elementFactory.createTypeParameterFromText("T", place);
        parameter.putUserData(UPPER_BOUND, upperBound);
        return elementFactory.createType(parameter);
    }

    public void initExpressionConstraints(PsiParameter[] parameters2, PsiExpression[] args, PsiElement parent2) {
        MethodCandidateInfo.CurrentCandidateProperties currentProperties = InferenceSession.getCurrentProperties(parent2);
        this.initExpressionConstraints(parameters2, args, parent2, null, currentProperties != null && currentProperties.isVarargs());
    }

    public void initExpressionConstraints(PsiParameter[] parameters2, PsiExpression[] args, PsiElement parent2, PsiMethod method, boolean varargs) {
        MethodCandidateInfo.CurrentCandidateProperties currentProperties = InferenceSession.getCurrentProperties(parent2);
        if (method == null && currentProperties != null) {
            method = currentProperties.getMethod();
        }
        if (method != null) {
            this.initThrowsConstraints(method);
        }
        if (parameters2.length > 0) {
            for (int i2 = 0; i2 < args.length; ++i2) {
                if (!varargs && i2 >= parameters2.length || args[i2] == null || !InferenceSession.isPertinentToApplicability(args[i2], method)) continue;
                PsiType parameterType = InferenceSession.getParameterType(parameters2, i2, this.mySiteSubstitutor, varargs);
                this.addConstraint(new ExpressionCompatibilityConstraint(args[i2], this.substituteWithInferenceVariables(parameterType)));
            }
        }
    }

    public void initThrowsConstraints(PsiMethod method) {
        for (PsiClassType thrownType : method.getThrowsList().getReferencedTypes()) {
            InferenceVariable variable2 = this.getInferenceVariable(this.substituteWithInferenceVariables(thrownType));
            if (variable2 == null) continue;
            variable2.setThrownBound();
        }
    }

    private static MethodCandidateInfo.CurrentCandidateProperties getCurrentProperties(PsiElement parent2) {
        if (parent2 instanceof PsiCall) {
            return MethodCandidateInfo.getCurrentMethod(((PsiCall)parent2).getArgumentList());
        }
        return null;
    }

    public static boolean isPertinentToApplicability(PsiExpression expr, PsiMethod method) {
        return InferenceSession.isPertinentToApplicability(expr, method, null);
    }

    private static boolean isPertinentToApplicability(PsiExpression expr, PsiMethod method, PsiType expectedReturnType) {
        if ((expr instanceof PsiLambdaExpression && ((PsiLambdaExpression)expr).hasFormalParameterTypes() || expr instanceof PsiMethodReferenceExpression && ((PsiMethodReferenceExpression)expr).isExact()) && method != null) {
            PsiElement parent2 = PsiUtil.skipParenthesizedExprUp(expr.getParent());
            PsiType paramType = null;
            if (parent2 instanceof PsiExpressionList) {
                PsiElement gParent = parent2.getParent();
                PsiTypeParameterListOwner owner = InferenceSession.getTypeParameterOwner(method, gParent);
                if (owner != null) {
                    PsiParameter[] parameters2;
                    int idx = LambdaUtil.getLambdaIdx((PsiExpressionList)parent2, expr);
                    if (idx > (parameters2 = method.getParameterList().getParameters()).length - 1) {
                        PsiType lastParamType = parameters2[parameters2.length - 1].getType();
                        paramType = parameters2[parameters2.length - 1].isVarArgs() ? ((PsiEllipsisType)lastParamType).getComponentType() : lastParamType;
                    } else {
                        paramType = parameters2[idx].getType();
                    }
                    if (InferenceSession.isTypeParameterType(owner, paramType)) {
                        return false;
                    }
                }
            } else if (expectedReturnType != null && (parent2 instanceof PsiLambdaExpression || parent2 instanceof PsiReturnStatement && PsiTreeUtil.getParentOfType(parent2, PsiLambdaExpression.class, true, PsiMethod.class) != null)) {
                if (InferenceSession.isTypeParameterType(method, expectedReturnType)) {
                    return false;
                }
                paramType = expectedReturnType;
            }
            if (expr instanceof PsiLambdaExpression) {
                for (PsiExpression expression2 : LambdaUtil.getReturnExpressions((PsiLambdaExpression)expr)) {
                    if (InferenceSession.isPertinentToApplicability(expression2, method, LambdaUtil.getFunctionalInterfaceReturnType(paramType))) continue;
                    return false;
                }
                return true;
            }
        }
        if (expr instanceof PsiLambdaExpression) {
            return ((PsiLambdaExpression)expr).hasFormalParameterTypes();
        }
        if (expr instanceof PsiMethodReferenceExpression) {
            return ((PsiMethodReferenceExpression)expr).isExact();
        }
        if (expr instanceof PsiParenthesizedExpression) {
            return InferenceSession.isPertinentToApplicability(((PsiParenthesizedExpression)expr).getExpression(), method);
        }
        if (expr instanceof PsiConditionalExpression) {
            PsiExpression thenExpression = ((PsiConditionalExpression)expr).getThenExpression();
            if (!InferenceSession.isPertinentToApplicability(thenExpression, method)) {
                return false;
            }
            PsiExpression elseExpression = ((PsiConditionalExpression)expr).getElseExpression();
            if (!InferenceSession.isPertinentToApplicability(elseExpression, method)) {
                return false;
            }
        }
        return true;
    }

    private static PsiTypeParameterListOwner getTypeParameterOwner(@NotNull PsiMethod method, PsiElement gParent) {
        PsiClass containingClass;
        if (method == null) {
            InferenceSession.$$$reportNull$$$0(2);
        }
        PsiTypeParameterListOwner owner = null;
        if (method.getTypeParameters().length > 0 && gParent instanceof PsiCallExpression && ((PsiCallExpression)gParent).getTypeArgumentList().getTypeParameterElements().length == 0) {
            owner = method;
        } else if (method.isConstructor() && gParent instanceof PsiNewExpression && (containingClass = method.getContainingClass()) != null && containingClass.hasTypeParameters() && PsiDiamondType.hasDiamond((PsiNewExpression)gParent)) {
            owner = containingClass;
        }
        return owner;
    }

    private static boolean isTypeParameterType(PsiTypeParameterListOwner method, PsiType paramType) {
        PsiClass psiClass = PsiUtil.resolveClassInType(paramType);
        return psiClass instanceof PsiTypeParameter && ((PsiTypeParameter)psiClass).getOwner() == method;
    }

    private static PsiType getParameterType(PsiParameter[] parameters2, int i2, @Nullable PsiSubstitutor substitutor2, boolean varargs) {
        if (substitutor2 == null) {
            return null;
        }
        return substitutor2.substitute(PsiTypesUtil.getParameterType(parameters2, i2, varargs));
    }

    @NotNull
    public PsiSubstitutor infer() {
        PsiSubstitutor psiSubstitutor = this.infer(null, null, null);
        if (psiSubstitutor == null) {
            InferenceSession.$$$reportNull$$$0(3);
        }
        return psiSubstitutor;
    }

    public PsiSubstitutor collectAdditionalAndInfer(@NotNull PsiParameter[] parameters2, @NotNull PsiExpression[] args, @NotNull MethodCandidateInfo.CurrentCandidateProperties properties2, @NotNull PsiSubstitutor psiSubstitutor) {
        if (parameters2 == null) {
            InferenceSession.$$$reportNull$$$0(4);
        }
        if (args == null) {
            InferenceSession.$$$reportNull$$$0(5);
        }
        if (properties2 == null) {
            InferenceSession.$$$reportNull$$$0(6);
        }
        if (psiSubstitutor == null) {
            InferenceSession.$$$reportNull$$$0(7);
        }
        return this.performGuardedInference(parameters2, args, this.myContext, properties2, psiSubstitutor);
    }

    @NotNull
    public PsiSubstitutor infer(@Nullable PsiParameter[] parameters2, @Nullable PsiExpression[] args, @Nullable PsiElement parent2) {
        PsiSubstitutor psiSubstitutor = this.infer(parameters2, args, parent2, InferenceSession.getCurrentProperties(parent2));
        if (psiSubstitutor == null) {
            InferenceSession.$$$reportNull$$$0(8);
        }
        return psiSubstitutor;
    }

    @NotNull
    public PsiSubstitutor infer(@Nullable PsiParameter[] parameters2, @Nullable PsiExpression[] args, @Nullable PsiElement parent2, @Nullable MethodCandidateInfo.CurrentCandidateProperties properties2) {
        PsiSubstitutor psiSubstitutor = this.performGuardedInference(parameters2, args, parent2, properties2, PsiSubstitutor.EMPTY);
        if (psiSubstitutor == null) {
            InferenceSession.$$$reportNull$$$0(9);
        }
        return psiSubstitutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private PsiSubstitutor performGuardedInference(@Nullable PsiParameter[] parameters2, @Nullable PsiExpression[] args, @Nullable PsiElement parent2, @Nullable MethodCandidateInfo.CurrentCandidateProperties properties2, @NotNull PsiSubstitutor initialSubstitutor) {
        if (initialSubstitutor == null) {
            InferenceSession.$$$reportNull$$$0(10);
        }
        this.doInfer(parameters2, args, parent2, properties2, initialSubstitutor);
        PsiSubstitutor psiSubstitutor = this.prepareSubstitution();
        PsiSubstitutor psiSubstitutor2 = psiSubstitutor;
        if (psiSubstitutor2 == null) {
            InferenceSession.$$$reportNull$$$0(11);
        }
        return psiSubstitutor2;
        finally {
            for (ConstraintFormula formula : this.myConstraintsCopy) {
                if (!(formula instanceof InputOutputConstraintFormula)) continue;
                LambdaUtil.getFunctionalTypeMap().remove(((InputOutputConstraintFormula)formula).getExpression());
            }
            if (properties2 != null && this.myErrorMessages != null) {
                properties2.getInfo().setApplicabilityError(StringUtil.join(this.myErrorMessages, "\n"));
            }
        }
    }

    private void doInfer(@Nullable PsiParameter[] parameters2, @Nullable PsiExpression[] args, @Nullable PsiElement parent2, @Nullable MethodCandidateInfo.CurrentCandidateProperties properties2, @NotNull PsiSubstitutor initialSubstitutor) {
        if (initialSubstitutor == null) {
            InferenceSession.$$$reportNull$$$0(12);
        }
        if (!this.repeatInferencePhases()) {
            return;
        }
        if (properties2 != null && !properties2.isApplicabilityCheck()) {
            PsiType returnType;
            String expectedActualErrorMessage = null;
            PsiMethod method = properties2.getMethod();
            if (parent2 instanceof PsiCallExpression && PsiPolyExpressionUtil.isMethodCallPolyExpression((PsiExpression)parent2, method) && !PsiType.VOID.equals(returnType = method.getReturnType()) && returnType != null) {
                Ref<String> errorMessage = new Ref<String>();
                PsiType targetType = InferenceSession.getTargetTypeFromParent(parent2, errorMessage, false);
                if (targetType == null && errorMessage.get() != null) {
                    return;
                }
                if (targetType != null && !PsiType.VOID.equals(targetType)) {
                    PsiType actualType = PsiUtil.isRawSubstitutor(method, this.mySiteSubstitutor) ? returnType : this.mySiteSubstitutor.substitute(returnType);
                    this.registerReturnTypeConstraints(actualType, targetType, this.myContext);
                    expectedActualErrorMessage = "Incompatible types. Required " + targetType.getPresentableText() + " but '" + method.getName() + "' was inferred to " + actualType.getPresentableText() + ":";
                }
            }
            if (!this.repeatInferencePhases()) {
                if (expectedActualErrorMessage != null && this.myErrorMessages != null) {
                    this.myErrorMessages.add(0, expectedActualErrorMessage);
                }
                this.resolveBounds(this.getInputInferenceVariablesFromTopLevelFunctionalExpressions(args, properties2), initialSubstitutor);
                return;
            }
            if (parameters2 != null && args != null && !this.isOverloadCheck()) {
                LinkedHashSet<ConstraintFormula> additionalConstraints = new LinkedHashSet<ConstraintFormula>();
                HashSet<ConstraintFormula> ignoredConstraints = new HashSet<ConstraintFormula>();
                if (parameters2.length > 0) {
                    this.collectAdditionalConstraints(parameters2, args, properties2.getMethod(), this.mySiteSubstitutor, additionalConstraints, ignoredConstraints, properties2.isVarargs(), initialSubstitutor);
                }
                if (!additionalConstraints.isEmpty() && !this.proceedWithAdditionalConstraints(additionalConstraints, ignoredConstraints)) {
                    this.resolveBounds(this.getInputInferenceVariablesFromTopLevelFunctionalExpressions(args, properties2), initialSubstitutor);
                    return;
                }
            }
        }
        this.resolveBounds(this.myInferenceVariables, initialSubstitutor);
    }

    private Collection<InferenceVariable> getInputInferenceVariablesFromTopLevelFunctionalExpressions(PsiExpression[] args, MethodCandidateInfo.CurrentCandidateProperties properties2) {
        if (args == null) {
            return Collections.emptyList();
        }
        PsiMethod method = properties2.getMethod();
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        if (parameters2.length == 0) {
            return Collections.emptyList();
        }
        HashSet<InferenceVariable> dependencies2 = new HashSet<InferenceVariable>();
        for (int i2 = 0; i2 < args.length; ++i2) {
            PsiSubstitutor nestedSubstitutor;
            PsiType parameterType;
            PsiClassType.ClassResolveResult result2;
            PsiMethod interfaceMethod;
            PsiExpression arg = args[i2];
            if ((!(arg instanceof PsiLambdaExpression) || ((PsiLambdaExpression)arg).hasFormalParameterTypes()) && (!(arg instanceof PsiMethodReferenceExpression) || ((PsiMethodReferenceExpression)arg).isExact()) || (interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(result2 = PsiUtil.resolveGenericsClassInType(parameterType = (nestedSubstitutor = this.myInferenceSessionContainer.findNestedSubstitutor(arg, this.myInferenceSubstitution)).substitute(InferenceSession.getParameterType(parameters2, i2, this.mySiteSubstitutor, properties2.isVarargs()))))) == null) continue;
            PsiSubstitutor substitutor2 = LambdaUtil.getSubstitutor(interfaceMethod, result2);
            for (PsiParameter parameter : interfaceMethod.getParameterList().getParameters()) {
                this.collectDependencies(substitutor2.substitute(parameter.getType()), dependencies2);
            }
        }
        return dependencies2;
    }

    private boolean isOverloadCheck() {
        if (this.myContext != null) {
            for (Object o : MethodCandidateInfo.ourOverloadGuard.currentStack()) {
                if (!(o instanceof PsiExpressionList)) continue;
                PsiExpressionList element = (PsiExpressionList)o;
                for (PsiExpression expression2 : element.getExpressions()) {
                    if (expression2 != this.myContext) continue;
                    return true;
                }
            }
            return false;
        }
        return MethodCandidateInfo.isOverloadCheck();
    }

    private void collectAdditionalConstraints(PsiParameter[] parameters2, PsiExpression[] args, PsiMethod parentMethod, PsiSubstitutor siteSubstitutor, Set<ConstraintFormula> additionalConstraints, Set<ConstraintFormula> ignoredConstraints, boolean varargs, PsiSubstitutor initialSubstitutor) {
        for (int i2 = 0; i2 < args.length; ++i2) {
            PsiExpression arg = PsiUtil.skipParenthesizedExprDown(args[i2]);
            if (arg == null) continue;
            PsiSubstitutor nestedSubstitutor = this.myInferenceSessionContainer.findNestedSubstitutor(arg, this.myInferenceSubstitution);
            PsiType parameterType = nestedSubstitutor.substitute(InferenceSession.getParameterType(parameters2, i2, siteSubstitutor, varargs));
            if (!InferenceSession.isPertinentToApplicability(arg, parentMethod)) {
                if (arg instanceof PsiLambdaExpression && InferenceSession.ignoreConstraintTree(ignoredConstraints, arg, parameterType)) continue;
                additionalConstraints.add(new ExpressionCompatibilityConstraint(arg, parameterType));
            }
            additionalConstraints.add(new CheckedExceptionCompatibilityConstraint(arg, parameterType));
            if (arg instanceof PsiCall) {
                PsiMethod calledMethod = InferenceSession.getCalledMethod((PsiCall)((Object)arg));
                if (calledMethod == null || !PsiPolyExpressionUtil.isMethodCallPolyExpression(arg, calledMethod)) continue;
                this.collectAdditionalConstraints(additionalConstraints, ignoredConstraints, (PsiCall)((Object)arg), initialSubstitutor);
                continue;
            }
            if (!(arg instanceof PsiLambdaExpression) || !InferenceSession.isPertinentToApplicability(arg, parentMethod)) continue;
            this.collectLambdaReturnExpression(additionalConstraints, ignoredConstraints, (PsiLambdaExpression)arg, ((PsiLambdaExpression)arg).getGroundTargetType(parameterType), !this.isProperType(initialSubstitutor.substitute(parameterType)), initialSubstitutor);
        }
    }

    private static boolean ignoreConstraintTree(Set<ConstraintFormula> ignoredConstraints, PsiExpression arg, PsiType parameterType) {
        for (Object expr : MethodCandidateInfo.ourOverloadGuard.currentStack()) {
            if (PsiTreeUtil.getParentOfType((PsiElement)expr, PsiLambdaExpression.class) != arg) continue;
            return true;
        }
        for (Object expr : LambdaUtil.ourParameterGuard.currentStack()) {
            if (!(expr instanceof PsiParameter) || ((PsiParameter)expr).getDeclarationScope() != arg) continue;
            ignoredConstraints.add(new ExpressionCompatibilityConstraint(arg, parameterType));
            return true;
        }
        return false;
    }

    public static PsiMethod getCalledMethod(PsiCall arg) {
        PsiExpressionList argumentList2 = arg.getArgumentList();
        if (argumentList2 == null) {
            return null;
        }
        MethodCandidateInfo.CurrentCandidateProperties properties2 = MethodCandidateInfo.getCurrentMethod(argumentList2);
        if (properties2 != null) {
            return properties2.getMethod();
        }
        JavaResolveResult resolveResult = PsiDiamondType.getDiamondsAwareResolveResult(arg);
        if (resolveResult instanceof MethodCandidateInfo) {
            return (PsiMethod)resolveResult.getElement();
        }
        return null;
    }

    private void collectLambdaReturnExpression(Set<ConstraintFormula> additionalConstraints, Set<ConstraintFormula> ignoredConstraints, PsiLambdaExpression lambdaExpression, PsiType parameterType, boolean addConstraint2, PsiSubstitutor initialSubstitutor) {
        PsiType interfaceReturnType = LambdaUtil.getFunctionalInterfaceReturnType(parameterType);
        if (interfaceReturnType != null) {
            List<PsiExpression> returnExpressions = LambdaUtil.getReturnExpressions(lambdaExpression);
            for (PsiExpression returnExpression : returnExpressions) {
                this.processReturnExpression(additionalConstraints, ignoredConstraints, returnExpression, interfaceReturnType, addConstraint2, initialSubstitutor);
            }
        }
    }

    private void processReturnExpression(Set<ConstraintFormula> additionalConstraints, Set<ConstraintFormula> ignoredConstraints, PsiExpression returnExpression, PsiType functionalType, boolean addConstraint2, PsiSubstitutor initialSubstitutor) {
        if (returnExpression instanceof PsiCallExpression) {
            if (addConstraint2) {
                PsiMethod calledMethod = InferenceSession.getCalledMethod((PsiCallExpression)returnExpression);
                if (calledMethod != null && PsiPolyExpressionUtil.isMethodCallPolyExpression(returnExpression, calledMethod)) {
                    this.collectAdditionalConstraints(additionalConstraints, ignoredConstraints, (PsiCallExpression)returnExpression, initialSubstitutor);
                }
            } else {
                this.getInferenceSessionContainer().registerNestedSession(this, functionalType, returnExpression);
            }
        } else if (returnExpression instanceof PsiParenthesizedExpression) {
            this.processReturnExpression(additionalConstraints, ignoredConstraints, ((PsiParenthesizedExpression)returnExpression).getExpression(), functionalType, addConstraint2, initialSubstitutor);
        } else if (returnExpression instanceof PsiConditionalExpression) {
            this.processReturnExpression(additionalConstraints, ignoredConstraints, ((PsiConditionalExpression)returnExpression).getThenExpression(), functionalType, addConstraint2, initialSubstitutor);
            this.processReturnExpression(additionalConstraints, ignoredConstraints, ((PsiConditionalExpression)returnExpression).getElseExpression(), functionalType, addConstraint2, initialSubstitutor);
        } else if (returnExpression instanceof PsiLambdaExpression) {
            this.collectLambdaReturnExpression(additionalConstraints, ignoredConstraints, (PsiLambdaExpression)returnExpression, functionalType, this.myErased, initialSubstitutor);
        }
    }

    private void collectAdditionalConstraints(Set<ConstraintFormula> additionalConstraints, Set<ConstraintFormula> ignoredConstraints, PsiCall callExpression, PsiSubstitutor initialSubstitutor) {
        PsiExpressionList argumentList2 = callExpression.getArgumentList();
        if (argumentList2 != null) {
            PsiMethod method;
            JavaResolveResult result2;
            MethodCandidateInfo.CurrentCandidateProperties properties2 = MethodCandidateInfo.getCurrentMethod(argumentList2);
            JavaResolveResult javaResolveResult = result2 = properties2 != null ? null : PsiDiamondType.getDiamondsAwareResolveResult(callExpression);
            PsiMethod psiMethod = properties2 != null ? properties2.getMethod() : (method = result2 instanceof MethodCandidateInfo ? ((MethodCandidateInfo)result2).getElement() : null);
            if (method != null) {
                PsiExpression[] newArgs2 = argumentList2.getExpressions();
                PsiParameter[] newParams = method.getParameterList().getParameters();
                if (newParams.length > 0) {
                    this.collectAdditionalConstraints(newParams, newArgs2, method, InferenceSession.chooseSiteSubstitutor(properties2, result2, method), additionalConstraints, ignoredConstraints, InferenceSession.chooseVarargsMode(properties2, result2), initialSubstitutor);
                }
            }
        }
    }

    public static PsiSubstitutor chooseSiteSubstitutor(MethodCandidateInfo.CurrentCandidateProperties candidateProperties, JavaResolveResult resolveResult, PsiMethod method) {
        return resolveResult instanceof MethodCandidateInfo && method != null && !method.isConstructor() ? ((MethodCandidateInfo)resolveResult).getSiteSubstitutor() : (candidateProperties != null ? candidateProperties.getSubstitutor() : PsiSubstitutor.EMPTY);
    }

    public static boolean chooseVarargsMode(MethodCandidateInfo.CurrentCandidateProperties candidateProperties, JavaResolveResult resolveResult) {
        return resolveResult instanceof MethodCandidateInfo && ((MethodCandidateInfo)resolveResult).isVarargs() || candidateProperties != null && candidateProperties.isVarargs();
    }

    public PsiSubstitutor getInstantiations(Collection<InferenceVariable> variables) {
        PsiSubstitutor substitutor2 = PsiSubstitutor.EMPTY;
        for (InferenceVariable variable2 : variables) {
            PsiType equalsBound = this.getEqualsBound(variable2, substitutor2);
            if (equalsBound == null || PsiType.NULL.equals(equalsBound)) continue;
            substitutor2 = substitutor2.put(variable2.getParameter(), equalsBound);
        }
        return substitutor2;
    }

    PsiSubstitutor prepareSubstitution() {
        boolean foundErrorMessage = false;
        Iterator<List<InferenceVariable>> iterator2 = InferenceVariablesOrder.resolveOrderIterator(this.myInferenceVariables, this);
        while (iterator2.hasNext()) {
            List<InferenceVariable> variables = iterator2.next();
            for (InferenceVariable inferenceVariable : variables) {
                PsiTypeParameter typeParameter = inferenceVariable.getParameter();
                PsiType instantiation = inferenceVariable.getInstantiation();
                if (instantiation != PsiType.NULL) continue;
                if (!foundErrorMessage) {
                    foundErrorMessage = this.checkBoundsConsistency(this.mySiteSubstitutor, inferenceVariable) == PsiType.NULL;
                }
                this.mySiteSubstitutor = this.mySiteSubstitutor.put(typeParameter, JavaPsiFacade.getInstance(typeParameter.getProject()).getElementFactory().createType(typeParameter));
            }
        }
        return this.mySiteSubstitutor;
    }

    public InitialInferenceState createInitialState(InferenceSessionContainer container2, Collection<InferenceVariable> variables, PsiSubstitutor topInferenceSubstitutor) {
        return new InitialInferenceState(variables, topInferenceSubstitutor, this.myContext, this.myInferenceSubstitution, this.mySiteSubstitutor, this.myIncorporationPhase.getCaptures(), this.myErased, container2);
    }

    public void initBounds(PsiTypeParameter ... typeParameters2) {
        this.initBounds(this.myContext, typeParameters2);
    }

    public InferenceVariable[] initBounds(PsiElement context, PsiTypeParameter ... typeParameters2) {
        return this.initBounds(context, this.mySiteSubstitutor, typeParameters2);
    }

    public InferenceVariable[] initBounds(PsiElement context, PsiSubstitutor siteSubstitutor, PsiTypeParameter ... typeParameters2) {
        ArrayList<InferenceVariable> result2 = new ArrayList<InferenceVariable>(typeParameters2.length);
        for (PsiTypeParameter parameter : typeParameters2) {
            String name = parameter.getName();
            if (this.myContext != null) {
                name = name + Math.abs(this.myContext.hashCode());
            }
            InferenceVariable variable2 = new InferenceVariable(context, parameter, name);
            result2.add(variable2);
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory(parameter.getProject());
            this.myInferenceSubstitution = this.myInferenceSubstitution.put(parameter, elementFactory.createType(variable2));
            this.myRestoreNameSubstitution = this.myRestoreNameSubstitution.put(variable2, elementFactory.createType(parameter));
            this.myInferenceVariables.add(variable2);
        }
        for (InferenceVariable variable3 : result2) {
            PsiClassType[] extendsListTypes;
            PsiTypeParameter parameter = variable3.getParameter();
            boolean added = false;
            for (PsiType classType : extendsListTypes = parameter.getExtendsListTypes()) {
                if (this.isProperType(classType = this.substituteWithInferenceVariables(siteSubstitutor.substitute(classType)))) {
                    added = true;
                }
                variable3.addBound(classType, InferenceBound.UPPER, null);
            }
            if (added) continue;
            variable3.addBound(PsiType.getJavaLangObject(parameter.getManager(), parameter.getResolveScope()), InferenceBound.UPPER, null);
        }
        return result2.toArray(new InferenceVariable[result2.size()]);
    }

    public void registerReturnTypeConstraints(PsiType returnType, PsiType targetType, PsiElement context) {
        returnType = this.substituteWithInferenceVariables(returnType);
        if (this.myErased) {
            PsiSubstitutor substitutor2;
            InferenceVariable inferenceVariable = this.getInferenceVariable(returnType);
            if (inferenceVariable != null && (returnType = (substitutor2 = this.resolveSubset(Collections.singletonList(inferenceVariable), this.mySiteSubstitutor)).substitute(inferenceVariable)) == null) {
                return;
            }
            this.addConstraint(new TypeCompatibilityConstraint(targetType, TypeConversionUtil.erasure(returnType)));
        } else if (FunctionalInterfaceParameterizationUtil.isWildcardParameterized(returnType)) {
            PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType(returnType);
            PsiClass psiClass = resolveResult.getElement();
            if (psiClass != null) {
                LOG.assertTrue(returnType instanceof PsiClassType);
                PsiClassType substitutedCapture = (PsiClassType)PsiUtil.captureToplevelWildcards(returnType, context);
                PsiTypeParameter[] typeParameters2 = psiClass.getTypeParameters();
                PsiType[] parameters2 = substitutedCapture.getParameters();
                InferenceVariable[] copy = this.initFreshVariablesForCapturedBounds(typeParameters2, parameters2);
                PsiType[] newParameters = new PsiType[parameters2.length];
                PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory(this.myManager.getProject());
                int idx = 0;
                for (int i2 = 0; i2 < parameters2.length; ++i2) {
                    newParameters[i2] = parameters2[i2];
                    if (!(parameters2[i2] instanceof PsiCapturedWildcardType)) continue;
                    newParameters[i2] = elementFactory.createType(copy[idx++]);
                }
                substitutedCapture = elementFactory.createType(psiClass, newParameters);
                this.myIncorporationPhase.addCapture(copy, (PsiClassType)returnType);
                this.addConstraint(new TypeCompatibilityConstraint(targetType, substitutedCapture));
            }
        } else {
            InferenceVariable inferenceVariable = this.shouldResolveAndInstantiate(returnType, targetType);
            if (inferenceVariable != null) {
                PsiSubstitutor substitutor3 = this.resolveSubset(Collections.singletonList(inferenceVariable), this.mySiteSubstitutor);
                PsiType substitutedReturnType = substitutor3.substitute(inferenceVariable);
                if (substitutedReturnType != null) {
                    this.addConstraint(new TypeCompatibilityConstraint(targetType, PsiUtil.captureToplevelWildcards(substitutedReturnType, context)));
                }
            } else {
                this.addConstraint(new TypeCompatibilityConstraint(targetType, returnType));
            }
        }
    }

    private InferenceVariable[] initFreshVariablesForCapturedBounds(PsiTypeParameter[] typeParameters2, PsiType[] parameters2) {
        if (Registry.is("javac.fresh.variables.for.captured.wildcards.only")) {
            ArrayList<PsiTypeParameter> capturedParams = new ArrayList<PsiTypeParameter>();
            PsiSubstitutor restParamSubstitution = PsiSubstitutor.EMPTY;
            for (int i2 = 0; i2 < parameters2.length; ++i2) {
                PsiType parameter = parameters2[i2];
                if (parameter instanceof PsiCapturedWildcardType) {
                    capturedParams.add(typeParameters2[i2]);
                    continue;
                }
                restParamSubstitution = restParamSubstitution.put(typeParameters2[i2], parameter);
            }
            InferenceVariable[] variables = this.initBounds(null, restParamSubstitution, capturedParams.toArray(PsiTypeParameter.EMPTY_ARRAY));
            int idx = 0;
            for (PsiType parameter : parameters2) {
                if (!(parameter instanceof PsiCapturedWildcardType) || !this.isProperType(((PsiCapturedWildcardType)parameter).getWildcard())) continue;
                variables[idx++].putUserData(ORIGINAL_CAPTURE, (PsiCapturedWildcardType)parameter);
            }
            return variables;
        }
        return this.initBounds((PsiElement)null, typeParameters2);
    }

    private InferenceVariable shouldResolveAndInstantiate(PsiType returnType, PsiType targetType) {
        InferenceVariable inferenceVariable = this.getInferenceVariable(returnType);
        if (inferenceVariable != null) {
            if (targetType instanceof PsiPrimitiveType && InferenceSession.hasPrimitiveWrapperBound(inferenceVariable)) {
                return inferenceVariable;
            }
            if (targetType instanceof PsiClassType && (InferenceSession.hasUncheckedBounds(inferenceVariable, (PsiClassType)targetType) || InferenceSession.hasWildcardParameterization(inferenceVariable, (PsiClassType)targetType))) {
                return inferenceVariable;
            }
        }
        return null;
    }

    private static boolean hasPrimitiveWrapperBound(InferenceVariable inferenceVariable) {
        InferenceBound[] boundTypes;
        for (InferenceBound inferenceBound : boundTypes = new InferenceBound[]{InferenceBound.UPPER, InferenceBound.LOWER, InferenceBound.EQ}) {
            List<PsiType> bounds = inferenceVariable.getBounds(inferenceBound);
            for (PsiType bound : bounds) {
                if (PsiPrimitiveType.getUnboxedType(bound) == null) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean hasUncheckedBounds(InferenceVariable inferenceVariable, PsiClassType targetType) {
        if (!targetType.isRaw()) {
            InferenceBound[] boundTypes;
            for (InferenceBound inferenceBound : boundTypes = new InferenceBound[]{InferenceBound.EQ, InferenceBound.LOWER}) {
                List<PsiType> bounds = inferenceVariable.getBounds(inferenceBound);
                for (PsiType bound : bounds) {
                    if (!TypeCompatibilityConstraint.isUncheckedConversion(targetType, bound)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean hasWildcardParameterization(InferenceVariable inferenceVariable, PsiClassType targetType) {
        if (!FunctionalInterfaceParameterizationUtil.isWildcardParameterized(targetType)) {
            Processor<Pair<PsiType, PsiType>> differentParameterizationProcessor;
            List<PsiType> bounds = inferenceVariable.getBounds(InferenceBound.LOWER);
            if (InferenceSession.findParameterizationOfTheSameGenericClass(bounds, differentParameterizationProcessor = pair -> pair.first == null || pair.second == null || !TypesDistinctProver.provablyDistinct((PsiType)pair.first, (PsiType)pair.second)) != null) {
                return true;
            }
            List<PsiType> eqBounds = inferenceVariable.getBounds(InferenceBound.EQ);
            ArrayList<PsiType> boundsToCheck = new ArrayList<PsiType>(bounds);
            boundsToCheck.addAll(eqBounds);
            for (PsiType lowBound : boundsToCheck) {
                if (!FunctionalInterfaceParameterizationUtil.isWildcardParameterized(lowBound)) continue;
                return true;
            }
        }
        return false;
    }

    public static PsiType getTargetType(PsiElement context) {
        return InferenceSession.getTargetTypeFromParent(context, new Ref<String>(), true);
    }

    private static PsiType getTargetTypeFromParent(PsiElement context, Ref<String> errorMessage, boolean inferParent) {
        PsiType targetType = PsiTypesUtil.getExpectedTypeByParent(context);
        if (targetType != null) {
            return targetType;
        }
        PsiElement parent2 = PsiUtil.skipParenthesizedExprUp(context.getParent());
        if (parent2 instanceof PsiExpressionList) {
            PsiExpressionList argumentList2;
            PsiElement gParent = parent2.getParent();
            if (gParent instanceof PsiAnonymousClass) {
                gParent = gParent.getParent();
            }
            if (gParent instanceof PsiCall && (argumentList2 = ((PsiCall)gParent).getArgumentList()) != null) {
                MethodCandidateInfo.CurrentCandidateProperties properties2 = MethodCandidateInfo.getCurrentMethod(argumentList2);
                if (properties2 != null && properties2.isApplicabilityCheck()) {
                    return InferenceSession.getTypeByMethod(context, argumentList2, properties2.getMethod(), properties2.isVarargs(), properties2.getSubstitutor(), inferParent);
                }
                JavaResolveResult result2 = PsiDiamondType.getDiamondsAwareResolveResult((PsiCall)gParent);
                PsiElement element = result2.getElement();
                if (element == null) {
                    errorMessage.set("Overload resolution failed");
                    return null;
                }
                if (element instanceof PsiMethod && (inferParent || !((PsiMethod)element).hasTypeParameters())) {
                    boolean varargs = result2 instanceof MethodCandidateInfo && ((MethodCandidateInfo)result2).isVarargs();
                    return InferenceSession.getTypeByMethod(context, argumentList2, result2.getElement(), varargs, result2.getSubstitutor(), inferParent);
                }
            }
        } else {
            if (parent2 instanceof PsiConditionalExpression) {
                return InferenceSession.getTargetTypeFromParent(parent2, errorMessage, inferParent);
            }
            if (parent2 instanceof PsiLambdaExpression) {
                return InferenceSession.getTargetTypeFromParentLambda((PsiLambdaExpression)parent2, errorMessage, inferParent);
            }
            if (parent2 instanceof PsiReturnStatement) {
                return InferenceSession.getTargetTypeFromParentLambda(PsiTreeUtil.getParentOfType(parent2, PsiLambdaExpression.class, true, PsiMethod.class), errorMessage, inferParent);
            }
        }
        return null;
    }

    private static PsiType getTargetTypeFromParentLambda(PsiLambdaExpression lambdaExpression, Ref<String> errorMessage, boolean inferParent) {
        if (lambdaExpression != null) {
            PsiType typeTypeByParentCall = InferenceSession.getTargetTypeFromParent(lambdaExpression, errorMessage, inferParent);
            if (typeTypeByParentCall != null) {
                return LambdaUtil.getFunctionalInterfaceReturnType(lambdaExpression.getGroundTargetType(typeTypeByParentCall));
            }
            PsiType cachedLambdaType = LambdaUtil.getFunctionalTypeMap().get(lambdaExpression);
            if (cachedLambdaType != null) {
                return LambdaUtil.getFunctionalInterfaceReturnType(lambdaExpression.getGroundTargetType(cachedLambdaType));
            }
            return inferParent || !(PsiUtil.skipParenthesizedExprUp(lambdaExpression.getParent()) instanceof PsiExpressionList) ? LambdaUtil.getFunctionalInterfaceReturnType(lambdaExpression.getFunctionalInterfaceType()) : null;
        }
        return null;
    }

    private static PsiType getTypeByMethod(PsiElement context, PsiExpressionList argumentList2, PsiElement parentMethod, boolean varargs, PsiSubstitutor substitutor2, boolean inferParent) {
        if (parentMethod instanceof PsiMethod) {
            PsiParameter[] parameters2 = ((PsiMethod)parentMethod).getParameterList().getParameters();
            if (parameters2.length == 0) {
                return null;
            }
            PsiExpression[] args = argumentList2.getExpressions();
            if (!((PsiMethod)parentMethod).isVarArgs() && parameters2.length != args.length && !inferParent) {
                return null;
            }
            PsiElement arg = context;
            while (arg.getParent() instanceof PsiParenthesizedExpression) {
                arg = arg.getParent();
            }
            int i2 = ArrayUtilRt.find(args, arg);
            if (i2 < 0) {
                return null;
            }
            PsiType parameterType = InferenceSession.getParameterType(parameters2, i2, substitutor2, varargs);
            boolean isRaw = substitutor2 != null && PsiUtil.isRawSubstitutor((PsiMethod)parentMethod, substitutor2);
            return isRaw ? TypeConversionUtil.erasure(parameterType) : parameterType;
        }
        return null;
    }

    public InferenceVariable getInferenceVariable(PsiType psiType) {
        PsiClass psiClass = PsiUtil.resolveClassInClassTypeOnly(psiType);
        return psiClass instanceof InferenceVariable ? this.getInferenceVariable((PsiTypeParameter)psiClass) : null;
    }

    public boolean isProperType(@Nullable PsiType type2) {
        return this.collectDependencies(type2, null);
    }

    public boolean collectDependencies(@Nullable PsiType type2, @Nullable Set<InferenceVariable> dependencies2) {
        return InferenceSession.collectDependencies(type2, dependencies2, classType -> this.getInferenceVariable((PsiType)classType));
    }

    public static boolean collectDependencies(@Nullable PsiType type2, final @Nullable Set<InferenceVariable> dependencies2, final Function<PsiClassType, InferenceVariable> fun) {
        if (type2 == null) {
            return true;
        }
        Boolean isProper2 = type2.accept(new PsiTypeVisitor<Boolean>(){

            @Override
            public Boolean visitType(PsiType type2) {
                return true;
            }

            @Override
            public Boolean visitCapturedWildcardType(PsiCapturedWildcardType capturedWildcardType) {
                return true;
            }

            @Override
            public Boolean visitArrayType(PsiArrayType arrayType) {
                return arrayType.getComponentType().accept(this);
            }

            @Override
            public Boolean visitWildcardType(PsiWildcardType wildcardType) {
                PsiType bound = wildcardType.getBound();
                if (bound == null) {
                    return true;
                }
                return bound.accept(this);
            }

            @Override
            public Boolean visitClassType(PsiClassType classType) {
                InferenceVariable inferenceVariable = (InferenceVariable)fun.fun(classType);
                if (inferenceVariable != null) {
                    if (dependencies2 != null) {
                        dependencies2.add(inferenceVariable);
                        return true;
                    }
                    return false;
                }
                PsiClassType.ClassResolveResult result2 = classType.resolveGenerics();
                PsiClass aClass2 = result2.getElement();
                if (aClass2 != null) {
                    PsiSubstitutor substitutor2 = result2.getSubstitutor();
                    for (PsiTypeParameter typeParameter : PsiUtil.typeParametersIterable(aClass2)) {
                        PsiType psiType = substitutor2.substitute(typeParameter);
                        if (psiType == null || psiType.accept(this).booleanValue()) continue;
                        return false;
                    }
                }
                return true;
            }
        });
        return dependencies2 != null ? !dependencies2.isEmpty() : isProper2;
    }

    public boolean repeatInferencePhases() {
        do {
            if (!this.reduceConstraints()) {
                return false;
            }
            if (this.myIncorporationPhase.incorporate()) continue;
            return false;
        } while (!this.myIncorporationPhase.isFullyIncorporated() || this.myConstraintIdx < this.myConstraints.size());
        return true;
    }

    private boolean reduceConstraints() {
        ArrayList<ConstraintFormula> newConstraints = new ArrayList<ConstraintFormula>();
        for (int i2 = this.myConstraintIdx; i2 < this.myConstraints.size(); ++i2) {
            ConstraintFormula constraint = this.myConstraints.get(i2);
            if (constraint.reduce(this, newConstraints)) continue;
            return false;
        }
        this.myConstraintIdx = this.myConstraints.size();
        for (ConstraintFormula constraint : newConstraints) {
            this.addConstraint(constraint);
        }
        return true;
    }

    private boolean isThrowable(List<PsiType> upperBounds2) {
        boolean commonThrowable = false;
        for (PsiType upperBound : upperBounds2) {
            if (upperBound.equalsToText("java.lang.Object") || !this.isProperType(upperBound)) continue;
            if (upperBound.equalsToText("java.lang.Exception") || upperBound.equalsToText("java.lang.Throwable")) {
                commonThrowable = true;
                continue;
            }
            return false;
        }
        return commonThrowable;
    }

    private PsiType substituteNonProperBound(PsiType bound, PsiSubstitutor substitutor2) {
        LinkedHashSet<InferenceVariable> dependencies2 = new LinkedHashSet<InferenceVariable>();
        if (!this.collectDependencies(bound, dependencies2)) {
            return bound;
        }
        for (InferenceVariable dependency : dependencies2) {
            PsiType instantiation = dependency.getInstantiation();
            if (instantiation == PsiType.NULL) continue;
            substitutor2 = substitutor2.put(dependency, instantiation);
        }
        return substitutor2.substitute(bound);
    }

    private boolean hasBoundProblems(List<InferenceVariable> typeParams, PsiSubstitutor substitutor2) {
        for (InferenceVariable typeParameter : typeParams) {
            List<PsiType> extendsTypes;
            PsiType[] bounds;
            PsiClass aClass2;
            PsiType type2;
            if (typeParameter.getInstantiation() != PsiType.NULL || (type2 = substitutor2.substitute(typeParameter)) instanceof PsiClassType && (aClass2 = ((PsiClassType)type2).resolve()) instanceof PsiTypeParameter && TypeConversionUtil.isFreshVariable((PsiTypeParameter)aClass2) || GenericsUtil.findTypeParameterBoundError(typeParameter, bounds = (extendsTypes = typeParameter.getBounds(InferenceBound.UPPER)).toArray(new PsiType[extendsTypes.size()]), substitutor2, this.myContext, true) == null) continue;
            return true;
        }
        return false;
    }

    private void resolveBounds(Collection<InferenceVariable> inferenceVariables, @NotNull PsiSubstitutor substitutor2) {
        if (substitutor2 == null) {
            InferenceSession.$$$reportNull$$$0(13);
        }
        ArrayList<InferenceVariable> allVars = new ArrayList<InferenceVariable>(inferenceVariables);
        while (!allVars.isEmpty()) {
            List<InferenceVariable> vars = InferenceVariablesOrder.resolveOrder(allVars, this);
            List<InferenceVariable> unresolved = new ArrayList<InferenceVariable>();
            for (InferenceVariable var : vars) {
                PsiType eqBound = this.getEqualsBound(var, substitutor2);
                if (eqBound != PsiType.NULL) continue;
                unresolved.add(var);
            }
            if (!unresolved.isEmpty() && vars.size() > unresolved.size()) {
                vars.removeAll(unresolved);
                vars.addAll(unresolved);
            }
            if (!this.myIncorporationPhase.hasCaptureConstraints(unresolved)) {
                PsiSubstitutor firstSubstitutor = this.resolveSubset(vars, substitutor2);
                if (this.hasBoundProblems(vars, firstSubstitutor)) {
                    firstSubstitutor = null;
                    unresolved = vars;
                }
                if (firstSubstitutor != null) {
                    substitutor2 = firstSubstitutor;
                    allVars.removeAll(vars);
                    continue;
                }
            }
            if (!this.initFreshVariables(substitutor2, unresolved)) {
                return;
            }
            this.myIncorporationPhase.forgetCaptures(vars);
            if (this.repeatInferencePhases()) continue;
            return;
        }
        this.setUncheckedInContext();
        Map<PsiTypeParameter, PsiType> map2 = substitutor2.getSubstitutionMap();
        for (PsiTypeParameter parameter : map2.keySet()) {
            PsiTypeParameter param2;
            PsiType mapping2 = map2.get(parameter);
            if (parameter instanceof InferenceVariable) {
                ((InferenceVariable)parameter).setInstantiation(mapping2);
                if (((InferenceVariable)parameter).getCallContext() != this.myContext) continue;
                param2 = ((InferenceVariable)parameter).getParameter();
            } else {
                param2 = parameter;
            }
            this.mySiteSubstitutor = this.mySiteSubstitutor.put(param2, mapping2);
        }
    }

    public void setUncheckedInContext() {
        if (this.myContext != null) {
            this.myContext.putUserData(ERASED, this.myErased);
        }
    }

    private boolean initFreshVariables(PsiSubstitutor substitutor2, List<InferenceVariable> vars) {
        int i2;
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory(this.getManager().getProject());
        PsiSubstitutor ySubstitutor = PsiSubstitutor.EMPTY;
        PsiTypeParameter[] yVars = new PsiTypeParameter[vars.size()];
        for (i2 = 0; i2 < vars.size(); ++i2) {
            InferenceVariable var = vars.get(i2);
            PsiTypeParameter parameter = var.getParameter();
            yVars[i2] = elementFactory.createTypeParameterFromText(parameter.getName(), parameter);
            ySubstitutor = ySubstitutor.put(var, elementFactory.createType(yVars[i2]));
        }
        for (i2 = 0; i2 < yVars.length; ++i2) {
            PsiTypeParameter parameter = yVars[i2];
            InferenceVariable var = vars.get(i2);
            PsiType lub = this.getLowerBound(var, substitutor2);
            if (lub != PsiType.NULL) {
                for (PsiClassType upperBoundType : parameter.getExtendsListTypes()) {
                    if (TypeConversionUtil.isAssignable(upperBoundType, lub)) continue;
                    return false;
                }
                parameter.putUserData(LOWER_BOUND, lub);
            }
            parameter.putUserData(UPPER_BOUND, this.composeBound(var, InferenceBound.UPPER, UPPER_BOUND_FUNCTION, ySubstitutor.putAll(substitutor2), true));
            TypeConversionUtil.markAsFreshVariable(parameter, this.myContext);
            if (var.addBound(elementFactory.createType(parameter), InferenceBound.EQ, this.myIncorporationPhase)) continue;
            return false;
        }
        return true;
    }

    private PsiSubstitutor resolveSubsetOrdered(Set<InferenceVariable> varsToResolve, PsiSubstitutor siteSubstitutor) {
        PsiSubstitutor substitutor2 = siteSubstitutor;
        Iterator<List<InferenceVariable>> varsIterator = InferenceVariablesOrder.resolveOrderIterator(varsToResolve, this);
        while (varsIterator.hasNext()) {
            List<InferenceVariable> vars = varsIterator.next();
            PsiSubstitutor resolveSubset = this.resolveSubset(vars, substitutor2);
            substitutor2 = substitutor2.putAll(resolveSubset);
        }
        return substitutor2;
    }

    @NotNull
    private PsiSubstitutor resolveSubset(Collection<InferenceVariable> vars, PsiSubstitutor substitutor2) {
        if (this.myErased) {
            for (InferenceVariable var : vars) {
                substitutor2 = substitutor2.put(var, null);
            }
        }
        for (InferenceVariable var : vars) {
            PsiType instantiation = var.getInstantiation();
            PsiType type2 = instantiation == PsiType.NULL ? this.checkBoundsConsistency(substitutor2, var) : instantiation;
            if (type2 == PsiType.NULL) continue;
            substitutor2 = substitutor2.put(var, type2);
        }
        PsiSubstitutor psiSubstitutor = substitutor2;
        if (psiSubstitutor == null) {
            InferenceSession.$$$reportNull$$$0(14);
        }
        return psiSubstitutor;
    }

    private PsiType checkBoundsConsistency(PsiSubstitutor substitutor2, InferenceVariable var) {
        PsiType type2;
        PsiType eqBound = this.getEqualsBound(var, substitutor2);
        if (eqBound != PsiType.NULL && eqBound instanceof PsiPrimitiveType) {
            return PsiType.NULL;
        }
        PsiType lowerBound = this.getLowerBound(var, substitutor2);
        PsiType upperBound = this.getUpperBound(var, substitutor2);
        if (eqBound != PsiType.NULL && (this.myErased || eqBound != null)) {
            PsiCapturedWildcardType capturedWildcard;
            PsiClass aClass2 = PsiUtil.resolveClassInClassTypeOnly(eqBound);
            if (aClass2 instanceof PsiTypeParameter && TypeConversionUtil.isFreshVariable((PsiTypeParameter)aClass2) && (capturedWildcard = var.getUserData(ORIGINAL_CAPTURE)) != null && capturedWildcard.getUpperBound().equals(InferenceSession.getUpperBound(aClass2))) {
                eqBound = capturedWildcard;
            }
            if (lowerBound != PsiType.NULL && !TypeConversionUtil.isAssignable(eqBound, lowerBound)) {
                String incompatibleBoundsMessage = this.incompatibleBoundsMessage(var, substitutor2, InferenceBound.EQ, EQUALITY_CONSTRAINTS_PRESENTATION, InferenceBound.LOWER, LOWER_BOUNDS_PRESENTATION);
                this.registerIncompatibleErrorMessage(incompatibleBoundsMessage);
                return PsiType.NULL;
            }
            type2 = eqBound;
            if (!TypeConversionUtil.isAssignable(eqBound, lowerBound, false)) {
                this.setErased();
            }
        } else {
            type2 = InferenceVariable.modifyAnnotations(lowerBound, (lb, modifier) -> modifier.modifyLowerBoundAnnotations((PsiType)lb, upperBound));
        }
        if (type2 == PsiType.NULL) {
            if (var.isThrownBound() && this.myPolicy.inferRuntimeExceptionForThrownBoundWithNoConstraints() && this.isThrowable(var.getBounds(InferenceBound.UPPER))) {
                type2 = PsiType.getJavaLangRuntimeException(this.myManager, GlobalSearchScope.allScope(this.myManager.getProject()));
            } else {
                PsiType psiType = type2 = var.getBounds(InferenceBound.UPPER).size() == 1 ? (PsiType)this.myPolicy.getInferredTypeWithNoConstraint((PsiManager)this.myManager, (PsiType)upperBound).first : upperBound;
            }
            if (type2 instanceof PsiIntersectionType) {
                String conflictingConjunctsMessage = ((PsiIntersectionType)type2).getConflictingConjunctsMessage();
                if (conflictingConjunctsMessage == null && InferenceSession.findParameterizationOfTheSameGenericClass(var.getBounds(InferenceBound.UPPER), pair -> pair.first == null || pair.second == null || ((PsiType)pair.first).equals(pair.second)) != null) {
                    conflictingConjunctsMessage = type2.getPresentableText(false);
                }
                if (conflictingConjunctsMessage != null) {
                    this.registerIncompatibleErrorMessage("Type parameter " + var.getParameter().getName() + " has incompatible upper bounds: " + conflictingConjunctsMessage);
                    return PsiType.NULL;
                }
            }
        } else {
            for (PsiType upperType : var.getBounds(InferenceBound.UPPER)) {
                if (!this.isProperType(upperType)) continue;
                String incompatibleBoundsMessage = null;
                if (type2 != lowerBound && !TypeConversionUtil.isAssignable(upperType, type2)) {
                    incompatibleBoundsMessage = this.incompatibleBoundsMessage(var, substitutor2, InferenceBound.EQ, EQUALITY_CONSTRAINTS_PRESENTATION, InferenceBound.UPPER, UPPER_BOUNDS_PRESENTATION);
                } else if (type2 == lowerBound && !TypeConversionUtil.isAssignable(upperType, lowerBound)) {
                    incompatibleBoundsMessage = this.incompatibleBoundsMessage(var, substitutor2, InferenceBound.LOWER, LOWER_BOUNDS_PRESENTATION, InferenceBound.UPPER, UPPER_BOUNDS_PRESENTATION);
                }
                if (incompatibleBoundsMessage == null) continue;
                this.registerIncompatibleErrorMessage(incompatibleBoundsMessage);
                return PsiType.NULL;
            }
        }
        if (type2 == PsiType.NULL) {
            this.registerIncompatibleErrorMessage("Incompatible upper bounds: " + StringUtil.join(var.getBounds(InferenceBound.UPPER), bound -> {
                PsiType substituted = this.substituteNonProperBound((PsiType)bound, substitutor2);
                return this.getPresentableText(substituted != null ? substituted : bound);
            }, ", "));
        }
        return type2;
    }

    public String getPresentableText(PsiType psiType) {
        PsiType substituted = this.myRestoreNameSubstitution.substitute(psiType);
        return substituted != null ? substituted.getPresentableText() : null;
    }

    public void registerIncompatibleErrorMessage(Collection<InferenceVariable> variables, String incompatibleTypesMessage) {
        variables = new ArrayList<InferenceVariable>(variables);
        ((ArrayList)variables).sort((v1, v2) -> Comparing.compare(v1.getName(), v2.getName()));
        String variablesEnumeration = StringUtil.join(variables, variable2 -> variable2.getParameter().getName(), ", ");
        this.registerIncompatibleErrorMessage("no instance(s) of type variable(s) " + variablesEnumeration + " exist so that " + incompatibleTypesMessage);
    }

    public void registerIncompatibleErrorMessage(@NotNull String incompatibleBoundsMessage) {
        if (incompatibleBoundsMessage == null) {
            InferenceSession.$$$reportNull$$$0(15);
        }
        if (this.myErrorMessages == null) {
            this.myErrorMessages = new ArrayList<String>();
        }
        if (!this.myErrorMessages.contains(incompatibleBoundsMessage)) {
            this.myErrorMessages.add(incompatibleBoundsMessage);
        }
    }

    private String incompatibleBoundsMessage(InferenceVariable var, PsiSubstitutor substitutor2, InferenceBound lowBound, String lowBoundName, InferenceBound upperBound, String upperBoundName) {
        Function<PsiType, String> typePresentation = type2 -> {
            PsiType substituted = this.substituteNonProperBound((PsiType)type2, substitutor2);
            return this.getPresentableText(substituted != null ? substituted : type2);
        };
        return "inference variable " + var.getParameter().getName() + " has incompatible bounds:\n " + lowBoundName + ": " + StringUtil.join(var.getBounds(lowBound), typePresentation, ", ") + "\n" + upperBoundName + ": " + StringUtil.join(var.getBounds(upperBound), typePresentation, ", ");
    }

    private PsiType getLowerBound(InferenceVariable var, PsiSubstitutor substitutor2) {
        return this.composeBound(var, InferenceBound.LOWER, pair -> GenericsUtil.getLeastUpperBound((PsiType)pair.first, (PsiType)pair.second, this.myManager), substitutor2);
    }

    private PsiType getUpperBound(InferenceVariable var, PsiSubstitutor substitutor2) {
        return this.composeBound(var, InferenceBound.UPPER, UPPER_BOUND_FUNCTION, substitutor2);
    }

    public PsiType getEqualsBound(InferenceVariable var, PsiSubstitutor substitutor2) {
        return this.composeBound(var, InferenceBound.EQ, pair -> !Comparing.equal(pair.first, pair.second) ? null : (PsiType)pair.first, substitutor2);
    }

    private PsiType composeBound(InferenceVariable variable2, InferenceBound boundType, Function<Pair<PsiType, PsiType>, PsiType> fun, PsiSubstitutor substitutor2) {
        return this.composeBound(variable2, boundType, fun, substitutor2, false);
    }

    private PsiType composeBound(InferenceVariable variable2, InferenceBound boundType, Function<Pair<PsiType, PsiType>, PsiType> fun, PsiSubstitutor substitutor2, boolean includeNonProperBounds) {
        List<PsiType> lowerBounds = variable2.getBounds(boundType);
        PsiType lub = PsiType.NULL;
        for (PsiType lowerBound : lowerBounds) {
            lowerBound = this.substituteNonProperBound(lowerBound, substitutor2);
            if (!includeNonProperBounds && !this.isProperType(lowerBound)) continue;
            if (lub == PsiType.NULL) {
                lub = lowerBound;
                continue;
            }
            Pair<PsiPrimitiveType, PsiType> pair = Pair.create(lub, lowerBound);
            if ((lub = fun.fun(pair)) != null) continue;
            return PsiType.NULL;
        }
        return lub;
    }

    public PsiManager getManager() {
        return this.myManager;
    }

    public GlobalSearchScope getScope() {
        if (this.myContext != null) {
            return this.myContext.getResolveScope();
        }
        return GlobalSearchScope.allScope(this.myManager.getProject());
    }

    public Collection<InferenceVariable> getInferenceVariables() {
        return this.myInferenceVariables;
    }

    public void addConstraint(ConstraintFormula constraint) {
        if (this.myConstraintsCopy.add(constraint)) {
            this.myConstraints.add(constraint);
        }
    }

    private boolean proceedWithAdditionalConstraints(Set<ConstraintFormula> additionalConstraints, Set<ConstraintFormula> ignoredConstraints) {
        PsiSubstitutor siteSubstitutor = PsiSubstitutor.EMPTY;
        while (!additionalConstraints.isEmpty()) {
            Set<ConstraintFormula> subset = this.buildSubset(additionalConstraints, ignoredConstraints);
            LinkedHashSet<InferenceVariable> varsToResolve = new LinkedHashSet<InferenceVariable>();
            for (ConstraintFormula formula : subset) {
                if (!(formula instanceof InputOutputConstraintFormula)) continue;
                this.collectVarsToResolve(varsToResolve, (InputOutputConstraintFormula)formula);
            }
            PsiSubstitutor substitutor2 = this.resolveSubsetOrdered(varsToResolve, siteSubstitutor);
            for (ConstraintFormula formula : subset) {
                if (this.processOneConstraint(formula, additionalConstraints, substitutor2, ignoredConstraints)) continue;
                return false;
            }
        }
        return true;
    }

    private void collectVarsToResolve(Set<InferenceVariable> varsToResolve, InputOutputConstraintFormula formula) {
        Set<InferenceVariable> inputVariables = formula.getInputVariables(this);
        if (inputVariables != null) {
            for (InferenceVariable inputVariable : inputVariables) {
                varsToResolve.addAll(inputVariable.getDependencies(this));
            }
            varsToResolve.addAll(inputVariables);
        }
    }

    private boolean processOneConstraint(ConstraintFormula formula, Set<ConstraintFormula> additionalConstraints, PsiSubstitutor substitutor2, Set<ConstraintFormula> ignoredConstraints) {
        PsiExpression expression2;
        if (this.myContext instanceof PsiCall) {
            PsiExpressionList argumentList2 = ((PsiCall)this.myContext).getArgumentList();
            LOG.assertTrue(argumentList2 != null);
            MethodCandidateInfo.updateSubstitutor(argumentList2, substitutor2);
        }
        formula.apply(substitutor2, true);
        this.addConstraint(formula);
        if (!this.repeatInferencePhases()) {
            return false;
        }
        if (formula instanceof ExpressionCompatibilityConstraint && (expression2 = ((ExpressionCompatibilityConstraint)formula).getExpression()) instanceof PsiLambdaExpression) {
            PsiType parameterType = ((PsiLambdaExpression)expression2).getGroundTargetType(((ExpressionCompatibilityConstraint)formula).getT());
            this.collectLambdaReturnExpression(additionalConstraints, ignoredConstraints, (PsiLambdaExpression)expression2, parameterType, !this.isProperType(parameterType), substitutor2);
        }
        return true;
    }

    private Set<ConstraintFormula> buildSubset(Set<ConstraintFormula> additionalConstraints, Set<ConstraintFormula> ignoredConstraints) {
        Set<InferenceVariable> outputVariables = this.getOutputVariables(additionalConstraints);
        Set<InferenceVariable> ignoredOutputVariables = this.getOutputVariables(ignoredConstraints);
        LinkedHashSet<ConstraintFormula> subset = new LinkedHashSet<ConstraintFormula>();
        LinkedHashSet<ConstraintFormula> noInputVariables = new LinkedHashSet<ConstraintFormula>();
        for (ConstraintFormula constraint : additionalConstraints) {
            if (constraint instanceof InputOutputConstraintFormula) {
                Set<InferenceVariable> inputVariables = ((InputOutputConstraintFormula)constraint).getInputVariables(this);
                if (inputVariables != null) {
                    boolean dependsOnOutput = false;
                    for (InferenceVariable inputVariable : inputVariables) {
                        if (dependsOnOutput) break;
                        Set<InferenceVariable> dependencies2 = inputVariable.getDependencies(this);
                        dependencies2.add(inputVariable);
                        if (!this.hasCapture(inputVariable)) {
                            if (this.dependsOnOutput(ignoredOutputVariables, dependencies2)) {
                                dependsOnOutput = true;
                                ignoredConstraints.add(constraint);
                                break;
                            }
                            dependsOnOutput = this.dependsOnOutput(outputVariables, dependencies2);
                        }
                        dependencies2.retainAll(outputVariables);
                        if (dependencies2.isEmpty()) continue;
                        dependsOnOutput = true;
                        break;
                    }
                    if (dependsOnOutput) continue;
                    subset.add(constraint);
                    if (!inputVariables.isEmpty()) continue;
                    noInputVariables.add(constraint);
                    continue;
                }
                subset.add(constraint);
                noInputVariables.add(constraint);
                continue;
            }
            subset.add(constraint);
        }
        if (subset.isEmpty()) {
            additionalConstraints.removeAll(ignoredConstraints);
            if (!additionalConstraints.isEmpty()) {
                subset.add(additionalConstraints.iterator().next());
            }
        }
        if (!noInputVariables.isEmpty()) {
            subset = noInputVariables;
        }
        additionalConstraints.removeAll(subset);
        return subset;
    }

    private boolean dependsOnOutput(Set<InferenceVariable> outputVariables, Set<InferenceVariable> dependencies2) {
        for (InferenceVariable outputVariable : outputVariables) {
            if (!ContainerUtil.intersects(outputVariable.getDependencies(this), dependencies2)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private Set<InferenceVariable> getOutputVariables(Set<ConstraintFormula> constraintFormulas) {
        HashSet<InferenceVariable> outputVariables = new HashSet<InferenceVariable>();
        for (ConstraintFormula constraint : constraintFormulas) {
            Set<InferenceVariable> inputVariables;
            Set<InferenceVariable> outputVars;
            if (!(constraint instanceof InputOutputConstraintFormula) || (outputVars = ((InputOutputConstraintFormula)constraint).getOutputVariables(inputVariables = ((InputOutputConstraintFormula)constraint).getInputVariables(this), this)) == null) continue;
            outputVariables.addAll(outputVars);
        }
        HashSet<InferenceVariable> hashSet = outputVariables;
        if (hashSet == null) {
            InferenceSession.$$$reportNull$$$0(16);
        }
        return hashSet;
    }

    public PsiSubstitutor collectApplicabilityConstraints(PsiMethodReferenceExpression reference, MethodCandidateInfo candidateInfo, PsiType functionalInterfaceType) {
        block11: {
            PsiSubstitutor psiSubstitutor;
            boolean isStatic;
            PsiParameter[] parameters2;
            PsiParameter[] functionalMethodParameters;
            PsiClass containingClass;
            PsiClass methodContainingClass;
            PsiMethod method;
            boolean varargs;
            MethodSignature signature2;
            block10: {
                PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType(functionalInterfaceType);
                PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(resolveResult);
                LOG.assertTrue(interfaceMethod != null, this.myContext);
                PsiSubstitutor functionalInterfaceSubstitutor = LambdaUtil.getSubstitutor(interfaceMethod, resolveResult);
                signature2 = interfaceMethod.getSignature(functionalInterfaceSubstitutor);
                varargs = candidateInfo.isVarargs();
                method = candidateInfo.getElement();
                methodContainingClass = method.getContainingClass();
                PsiMethodReferenceUtil.QualifierResolveResult qualifierResolveResult = PsiMethodReferenceUtil.getQualifierResolveResult(reference);
                containingClass = qualifierResolveResult.getContainingClass();
                if (containingClass == null) {
                    return this.resolveSubset(this.myInferenceVariables, this.mySiteSubstitutor);
                }
                functionalMethodParameters = interfaceMethod.getParameterList().getParameters();
                parameters2 = method.getParameterList().getParameters();
                isStatic = method.hasModifierProperty("static");
                psiSubstitutor = qualifierResolveResult.getSubstitutor();
                if ((parameters2.length != functionalMethodParameters.length || varargs) && (!isStatic || !varargs)) break block10;
                if (method.isConstructor() && PsiUtil.isRawSubstitutor(containingClass, psiSubstitutor)) {
                    this.initBounds(containingClass.getTypeParameters());
                    psiSubstitutor = PsiSubstitutor.EMPTY;
                }
                if (methodContainingClass != null) {
                    psiSubstitutor = JavaClassSupers.getInstance().getSuperClassSubstitutor(methodContainingClass, containingClass, reference.getResolveScope(), psiSubstitutor);
                    LOG.assertTrue(psiSubstitutor != null, "derived: " + containingClass + "; super: " + methodContainingClass + "; reference: " + reference.getText() + "; containingFile: " + reference.getContainingFile().getName());
                }
                for (int i2 = 0; i2 < functionalMethodParameters.length; ++i2) {
                    PsiType pType = signature2.getParameterTypes()[i2];
                    this.addConstraint(new TypeCompatibilityConstraint(this.substituteWithInferenceVariables(InferenceSession.getParameterType(parameters2, i2, psiSubstitutor, varargs)), PsiUtil.captureToplevelWildcards(pType, functionalMethodParameters[i2])));
                }
                break block11;
            }
            if (!PsiMethodReferenceUtil.isResolvedBySecondSearch(reference, signature2, varargs, isStatic, parameters2.length)) break block11;
            PsiType pType = signature2.getParameterTypes()[0];
            if (PsiUtil.isRawSubstitutor(containingClass, psiSubstitutor)) {
                PsiSubstitutor receiverSubstitutor;
                PsiClassType subclassType = StrictSubtypingConstraint.getSubclassType(containingClass, pType, true);
                PsiSubstitutor psiSubstitutor2 = receiverSubstitutor = subclassType != null ? TypeConversionUtil.getSuperClassSubstitutor(containingClass, (PsiClassType)PsiUtil.captureToplevelWildcards(subclassType, this.myContext)) : null;
                if (receiverSubstitutor != null) {
                    if (!method.hasTypeParameters() && (signature2.getParameterTypes().length == 1 || PsiUtil.isRawSubstitutor(containingClass, receiverSubstitutor))) {
                        return methodContainingClass != null ? JavaClassSupers.getInstance().getSuperClassSubstitutor(methodContainingClass, containingClass, reference.getResolveScope(), receiverSubstitutor) : receiverSubstitutor;
                    }
                    this.mySiteSubstitutor = this.mySiteSubstitutor.putAll(receiverSubstitutor);
                    if (methodContainingClass != null) {
                        PsiSubstitutor superSubstitutor = JavaClassSupers.getInstance().getSuperClassSubstitutor(methodContainingClass, containingClass, reference.getResolveScope(), receiverSubstitutor);
                        LOG.assertTrue(superSubstitutor != null, "mContainingClass: " + methodContainingClass.getName() + "; containingClass: " + containingClass.getName());
                        this.mySiteSubstitutor = this.mySiteSubstitutor.putAll(superSubstitutor);
                    }
                    psiSubstitutor = receiverSubstitutor;
                }
            }
            PsiClassType qType = JavaPsiFacade.getElementFactory(method.getProject()).createType(containingClass, psiSubstitutor);
            this.addConstraint(new TypeCompatibilityConstraint(this.substituteWithInferenceVariables(qType), pType));
            if (methodContainingClass != null) {
                psiSubstitutor = JavaClassSupers.getInstance().getSuperClassSubstitutor(methodContainingClass, containingClass, reference.getResolveScope(), psiSubstitutor);
                LOG.assertTrue(psiSubstitutor != null, "derived: " + containingClass + "; super: " + methodContainingClass + "; reference: " + reference.getText() + "; containingFile: " + reference.getContainingFile().getName());
            }
            for (int i3 = 0; i3 < signature2.getParameterTypes().length - 1; ++i3) {
                PsiType interfaceParamType = signature2.getParameterTypes()[i3 + 1];
                this.addConstraint(new TypeCompatibilityConstraint(this.substituteWithInferenceVariables(InferenceSession.getParameterType(parameters2, i3, psiSubstitutor, varargs)), PsiUtil.captureToplevelWildcards(interfaceParamType, functionalMethodParameters[i3])));
            }
        }
        return null;
    }

    public void setErased() {
        this.myErased = true;
    }

    public InferenceVariable getInferenceVariable(PsiTypeParameter parameter) {
        return parameter instanceof InferenceVariable && this.myInferenceVariables.contains(parameter) ? (InferenceVariable)parameter : null;
    }

    public static boolean isMoreSpecific(PsiMethod m1, PsiMethod m2, PsiSubstitutor siteSubstitutor1, PsiExpression[] args, PsiElement context, boolean varargs) {
        return LambdaUtil.performWithSubstitutedParameterBounds(m1.getTypeParameters(), siteSubstitutor1, () -> InferenceSession.isMoreSpecificInternal(m1, m2, siteSubstitutor1, args, context, varargs));
    }

    private static boolean isMoreSpecificInternal(PsiMethod m1, PsiMethod m2, PsiSubstitutor siteSubstitutor1, PsiExpression[] args, PsiElement context, boolean varargs) {
        ArrayList<PsiTypeParameter> params2 = new ArrayList<PsiTypeParameter>();
        for (PsiTypeParameter param2 : PsiUtil.typeParametersIterable(m2)) {
            params2.add(param2);
        }
        siteSubstitutor1 = InferenceSession.getSiteSubstitutor(siteSubstitutor1, params2);
        InferenceSession session = new InferenceSession(params2.toArray(new PsiTypeParameter[params2.size()]), siteSubstitutor1, m2.getManager(), context);
        PsiParameter[] parameters1 = m1.getParameterList().getParameters();
        PsiParameter[] parameters2 = m2.getParameterList().getParameters();
        if (!varargs) {
            LOG.assertTrue(parameters1.length == parameters2.length);
        }
        int paramsLength = !varargs ? parameters1.length : Math.max(parameters1.length, parameters2.length) - 1;
        for (int i2 = 0; i2 < paramsLength; ++i2) {
            PsiType sType = InferenceSession.getParameterType(parameters1, i2, siteSubstitutor1, false);
            PsiType tType = session.substituteWithInferenceVariables(InferenceSession.getParameterType(parameters2, i2, siteSubstitutor1, varargs));
            if (sType instanceof PsiClassType && tType instanceof PsiClassType && LambdaUtil.isFunctionalType(sType) && LambdaUtil.isFunctionalType(tType) && !InferenceSession.relates(sType, tType)) {
                if (InferenceSession.isFunctionalTypeMoreSpecific(sType, tType, session, args[i2])) continue;
                return false;
            }
            if (session.isProperType(tType) && !TypeConversionUtil.isAssignable(tType, sType)) {
                return false;
            }
            session.addConstraint(new StrictSubtypingConstraint(tType, sType));
        }
        if (varargs) {
            PsiType sType = InferenceSession.getParameterType(parameters1, paramsLength, siteSubstitutor1, true);
            PsiType tType = session.substituteWithInferenceVariables(InferenceSession.getParameterType(parameters2, paramsLength, siteSubstitutor1, true));
            session.addConstraint(new StrictSubtypingConstraint(tType, sType));
        }
        return session.repeatInferencePhases();
    }

    private static PsiSubstitutor getSiteSubstitutor(PsiSubstitutor siteSubstitutor1, List<PsiTypeParameter> params2) {
        PsiSubstitutor subst = PsiSubstitutor.EMPTY;
        for (PsiTypeParameter param2 : params2) {
            subst = subst.put(param2, siteSubstitutor1.substitute(param2));
        }
        return subst;
    }

    public static boolean isFunctionalTypeMoreSpecificOnExpression(PsiType sType, PsiType tType, PsiExpression arg) {
        return InferenceSession.isFunctionalTypeMoreSpecific(sType, tType, null, arg);
    }

    private static boolean isFunctionalTypeMoreSpecific(PsiType sType, PsiType tType, @Nullable InferenceSession session, PsiExpression ... args) {
        PsiType capturedSType = sType;
        PsiClassType.ClassResolveResult sResult = PsiUtil.resolveGenericsClassInType(capturedSType);
        PsiMethod sInterfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(sResult);
        LOG.assertTrue(sInterfaceMethod != null);
        PsiSubstitutor sSubstitutor = LambdaUtil.getSubstitutor(sInterfaceMethod, sResult);
        PsiClassType.ClassResolveResult tResult = PsiUtil.resolveGenericsClassInType(tType);
        PsiMethod tInterfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(tResult);
        LOG.assertTrue(tInterfaceMethod != null);
        PsiSubstitutor tSubstitutor = LambdaUtil.getSubstitutor(tInterfaceMethod, tResult);
        for (PsiExpression arg : args) {
            if (InferenceSession.argConstraints(arg, session, sInterfaceMethod, sSubstitutor, tInterfaceMethod, tSubstitutor)) continue;
            return false;
        }
        return true;
    }

    protected static boolean argConstraints(PsiExpression arg, @Nullable InferenceSession session, PsiMethod sInterfaceMethod, PsiSubstitutor sSubstitutor, PsiMethod tInterfaceMethod, PsiSubstitutor tSubstitutor) {
        if (arg instanceof PsiLambdaExpression && ((PsiLambdaExpression)arg).hasFormalParameterTypes()) {
            PsiType sReturnType = sSubstitutor.substitute(sInterfaceMethod.getReturnType());
            PsiType tReturnType = tSubstitutor.substitute(tInterfaceMethod.getReturnType());
            if (PsiType.VOID.equals(tReturnType)) {
                return true;
            }
            List<PsiExpression> returnExpressions = LambdaUtil.getReturnExpressions((PsiLambdaExpression)arg);
            if (sReturnType instanceof PsiClassType && tReturnType instanceof PsiClassType && LambdaUtil.isFunctionalType(sReturnType) && LambdaUtil.isFunctionalType(tReturnType) && !TypeConversionUtil.isAssignable(TypeConversionUtil.erasure(sReturnType), TypeConversionUtil.erasure(tReturnType)) && !TypeConversionUtil.isAssignable(TypeConversionUtil.erasure(tReturnType), TypeConversionUtil.erasure(sReturnType))) {
                if (!InferenceSession.isFunctionalTypeMoreSpecific(sReturnType, tReturnType, session, returnExpressions.toArray(new PsiExpression[returnExpressions.size()]))) {
                    return false;
                }
            } else {
                boolean tPrimitive;
                boolean sPrimitive = sReturnType instanceof PsiPrimitiveType && !PsiType.VOID.equals(sReturnType);
                boolean bl = tPrimitive = tReturnType instanceof PsiPrimitiveType && !PsiType.VOID.equals(tReturnType);
                if (sPrimitive ^ tPrimitive) {
                    for (PsiExpression returnExpression : returnExpressions) {
                        if (!PsiPolyExpressionUtil.isPolyExpression(returnExpression)) {
                            PsiType returnExpressionType = returnExpression.getType();
                            if (!(sPrimitive ? !(returnExpressionType instanceof PsiPrimitiveType) : !(returnExpressionType instanceof PsiClassType))) continue;
                            return false;
                        }
                        if (!sPrimitive) continue;
                        return false;
                    }
                    return true;
                }
                if (session != null) {
                    session.addConstraint(new StrictSubtypingConstraint(tReturnType, sReturnType));
                    return true;
                }
                return sReturnType != null && tReturnType != null && TypeConversionUtil.isAssignable(tReturnType, sReturnType);
            }
        }
        if (arg instanceof PsiMethodReferenceExpression && ((PsiMethodReferenceExpression)arg).isExact()) {
            boolean tPrimitive;
            PsiParameter[] tParameters;
            PsiParameter[] sParameters = sInterfaceMethod.getParameterList().getParameters();
            LOG.assertTrue(sParameters.length == (tParameters = tInterfaceMethod.getParameterList().getParameters()).length, "s: " + sInterfaceMethod.getParameterList().getText() + "; t: " + tInterfaceMethod.getParameterList().getText());
            for (int i2 = 0; i2 < tParameters.length; ++i2) {
                PsiType tSubstituted = tSubstitutor.substitute(tParameters[i2].getType());
                PsiType sSubstituted = sSubstitutor.substitute(sParameters[i2].getType());
                if (session != null) {
                    session.addConstraint(new TypeEqualityConstraint(tSubstituted, sSubstituted));
                    continue;
                }
                if (Comparing.equal(tSubstituted, sSubstituted)) continue;
                return false;
            }
            PsiType sReturnType = sSubstitutor.substitute(sInterfaceMethod.getReturnType());
            PsiType tReturnType = tSubstitutor.substitute(tInterfaceMethod.getReturnType());
            if (PsiType.VOID.equals(tReturnType)) {
                return true;
            }
            boolean sPrimitive = sReturnType instanceof PsiPrimitiveType && !PsiType.VOID.equals(sReturnType);
            boolean bl = tPrimitive = tReturnType instanceof PsiPrimitiveType && !PsiType.VOID.equals(tReturnType);
            if (sPrimitive ^ tPrimitive) {
                PsiMember member = ((PsiMethodReferenceExpression)arg).getPotentiallyApplicableMember();
                LOG.assertTrue(member != null, arg);
                if (member instanceof PsiMethod) {
                    PsiType methodReturnType = ((PsiMethod)member).getReturnType();
                    if (sPrimitive && methodReturnType instanceof PsiPrimitiveType && !PsiType.VOID.equals(methodReturnType) || tPrimitive && methodReturnType instanceof PsiClassType) {
                        return true;
                    }
                }
                return false;
            }
            if (session != null) {
                session.addConstraint(new StrictSubtypingConstraint(tReturnType, sReturnType));
                return true;
            }
            return sReturnType != null && tReturnType != null && TypeConversionUtil.isAssignable(tReturnType, sReturnType);
        }
        if (arg instanceof PsiParenthesizedExpression) {
            return InferenceSession.argConstraints(((PsiParenthesizedExpression)arg).getExpression(), session, sInterfaceMethod, sSubstitutor, tInterfaceMethod, tSubstitutor);
        }
        if (arg instanceof PsiConditionalExpression) {
            PsiExpression thenExpression = ((PsiConditionalExpression)arg).getThenExpression();
            PsiExpression elseExpression = ((PsiConditionalExpression)arg).getElseExpression();
            return InferenceSession.argConstraints(thenExpression, session, sInterfaceMethod, sSubstitutor, tInterfaceMethod, tSubstitutor) && InferenceSession.argConstraints(elseExpression, session, sInterfaceMethod, sSubstitutor, tInterfaceMethod, tSubstitutor);
        }
        return false;
    }

    private static boolean relates(PsiType sType, PsiType tType) {
        PsiType sTypeErasure;
        PsiType erasedType = TypeConversionUtil.erasure(tType);
        LOG.assertTrue(erasedType != null);
        if (sType instanceof PsiIntersectionType) {
            boolean superRelation = true;
            boolean subRelation = false;
            for (PsiType sConjunct : ((PsiIntersectionType)sType).getConjuncts()) {
                PsiType sConjunctErasure = TypeConversionUtil.erasure(sConjunct);
                if (sConjunctErasure == null) continue;
                superRelation &= TypeConversionUtil.isAssignable(sConjunctErasure, erasedType);
                subRelation |= TypeConversionUtil.isAssignable(erasedType, sConjunctErasure);
            }
            return superRelation || subRelation;
        }
        if (sType instanceof PsiClassType && (sTypeErasure = TypeConversionUtil.erasure(sType)) != null) {
            return TypeConversionUtil.isAssignable(sTypeErasure, erasedType) || TypeConversionUtil.isAssignable(erasedType, sTypeErasure);
        }
        return false;
    }

    public void collectCaptureDependencies(InferenceVariable inferenceVariable, Set<InferenceVariable> dependencies2) {
        this.myIncorporationPhase.collectCaptureDependencies(inferenceVariable, dependencies2);
    }

    public boolean hasCapture(InferenceVariable inferenceVariable) {
        return this.myIncorporationPhase.hasCaptureConstraints(Collections.singletonList(inferenceVariable));
    }

    public static boolean wasUncheckedConversionPerformed(PsiElement call2) {
        PsiExpressionList args;
        Boolean erased = call2.getUserData(ERASED);
        if (erased != null && erased.booleanValue()) {
            return true;
        }
        if (call2 instanceof PsiCallExpression && (args = ((PsiCallExpression)call2).getArgumentList()) != null) {
            for (PsiExpression expression2 : args.getExpressions()) {
                if (expression2 instanceof PsiNewExpression && !PsiDiamondType.hasDiamond((PsiNewExpression)expression2) || !InferenceSession.wasUncheckedConversionPerformed(expression2)) continue;
                return true;
            }
        }
        return false;
    }

    public PsiElement getContext() {
        return this.myContext;
    }

    public void propagateVariables(Collection<InferenceVariable> variables, PsiSubstitutor restoreNamesSubstitution) {
        this.myInferenceVariables.addAll(variables);
        this.myRestoreNameSubstitution = this.myRestoreNameSubstitution.putAll(restoreNamesSubstitution);
    }

    public PsiType substituteWithInferenceVariables(@Nullable PsiType type2) {
        return this.myInferenceSubstitution.substitute(type2);
    }

    public PsiSubstitutor getInferenceSubstitution() {
        return this.myInferenceSubstitution;
    }

    public PsiSubstitutor getRestoreNameSubstitution() {
        return this.myRestoreNameSubstitution;
    }

    public InferenceSessionContainer getInferenceSessionContainer() {
        return this.myInferenceSessionContainer;
    }

    public PsiType startWithFreshVars(PsiType type2) {
        PsiSubstitutor s = PsiSubstitutor.EMPTY;
        for (InferenceVariable variable2 : this.myInferenceVariables) {
            s = s.put(variable2, JavaPsiFacade.getElementFactory(variable2.getProject()).createType(variable2.getParameter()));
        }
        return s.substitute(type2);
    }

    public static PsiClass findParameterizationOfTheSameGenericClass(List<PsiType> upperBounds2, Processor<Pair<PsiType, PsiType>> processor) {
        for (int i2 = 0; i2 < upperBounds2.size(); ++i2) {
            PsiType sBound = upperBounds2.get(i2);
            PsiClass sClass = PsiUtil.resolveClassInClassTypeOnly(sBound);
            if (sClass == null) continue;
            LinkedHashSet<PsiClass> superClasses2 = InheritanceUtil.getSuperClasses(sClass);
            superClasses2.add(sClass);
            for (int j = i2 + 1; j < upperBounds2.size(); ++j) {
                PsiType tBound = upperBounds2.get(j);
                PsiClass tClass = PsiUtil.resolveClassInClassTypeOnly(tBound);
                if (tClass == null) continue;
                LinkedHashSet<PsiClass> tSupers = InheritanceUtil.getSuperClasses(tClass);
                tSupers.add(tClass);
                tSupers.retainAll(superClasses2);
                for (PsiClass gClass : tSupers) {
                    PsiSubstitutor sSubstitutor = TypeConversionUtil.getSuperClassSubstitutor(gClass, (PsiClassType)sBound);
                    PsiSubstitutor tSubstitutor = TypeConversionUtil.getSuperClassSubstitutor(gClass, (PsiClassType)tBound);
                    for (PsiTypeParameter typeParameter : gClass.getTypeParameters()) {
                        PsiType tType;
                        PsiType sType = sSubstitutor.substituteWithBoundsPromotion(typeParameter);
                        Pair<PsiType, PsiType> typePair = Pair.create(sType, tType = tSubstitutor.substituteWithBoundsPromotion(typeParameter));
                        if (processor.process(typePair)) continue;
                        return gClass;
                    }
                }
            }
        }
        return null;
    }

    public List<String> getIncompatibleErrorMessages() {
        return this.myErrorMessages;
    }

    public boolean isErased() {
        return this.myErased;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 3: 
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/resolve/graphInference/InferenceSession";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiSubstitutor";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialSubstitutor";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "incompatibleBoundsMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/resolve/graphInference/InferenceSession";
                break;
            }
            case 3: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "infer";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "performGuardedInference";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveSubset";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputVariables";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getUpperBound";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getLowerBound";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getTypeParameterOwner";
                break;
            }
            case 3: 
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 16: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "collectAdditionalAndInfer";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "performGuardedInference";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "doInfer";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "resolveBounds";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "registerIncompatibleErrorMessage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

