/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.URIReferenceProvider;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class XmlBaseReferenceProvider
extends PsiReferenceProvider {
    private final boolean myAcceptSelf;

    public XmlBaseReferenceProvider(boolean acceptSelf) {
        this.myAcceptSelf = acceptSelf;
    }

    @Override
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        PsiReference reference;
        if (element == null) {
            XmlBaseReferenceProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            XmlBaseReferenceProvider.$$$reportNull$$$0(1);
        }
        if ((reference = URIReferenceProvider.getUrlReference(element, ElementManipulators.getValueText(element))) != null) {
            PsiReference[] psiReferenceArray = new PsiReference[]{reference};
            if (psiReferenceArray == null) {
                XmlBaseReferenceProvider.$$$reportNull$$$0(2);
            }
            return psiReferenceArray;
        }
        FileReferenceSet referenceSet = FileReferenceSet.createSet(element, false, false, false);
        referenceSet.addCustomization(FileReferenceSet.DEFAULT_PATH_EVALUATOR_OPTION, file2 -> {
            if (element == null) {
                XmlBaseReferenceProvider.$$$reportNull$$$0(4);
            }
            return this.getContext(element, (PsiFile)file2);
        });
        PsiReference[] psiReferenceArray = referenceSet.getAllReferences();
        if (psiReferenceArray == null) {
            XmlBaseReferenceProvider.$$$reportNull$$$0(3);
        }
        return psiReferenceArray;
    }

    private Collection<PsiFileSystemItem> getContext(PsiElement element, PsiFile file2) {
        XmlTag tag = PsiTreeUtil.getParentOfType(element, XmlTag.class);
        if (!this.myAcceptSelf && tag != null) {
            tag = tag.getParentTag();
        }
        while (tag != null) {
            PsiReference reference;
            XmlAttributeValue value;
            XmlAttribute base2 = tag.getAttribute("base", "http://www.w3.org/XML/1998/namespace");
            if (base2 != null && (value = base2.getValueElement()) != null && (reference = value.getReference()) instanceof PsiPolyVariantReference) {
                ResolveResult[] results = ((PsiPolyVariantReference)reference).multiResolve(false);
                return ContainerUtil.map(results, result2 -> (PsiFileSystemItem)result2.getElement());
            }
            tag = tag.getParentTag();
        }
        PsiDirectory directory = file2.getContainingDirectory();
        return directory == null ? Collections.emptyList() : Collections.singletonList(directory);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/XmlBaseReferenceProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/XmlBaseReferenceProvider";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getReferencesByElement$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

