/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiMatcherExpression;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;

public class PsiMatchers {
    private PsiMatchers() {
    }

    @NotNull
    public static PsiMatcherExpression hasName(final @NotNull String name) {
        if (name == null) {
            PsiMatchers.$$$reportNull$$$0(0);
        }
        PsiMatcherExpression psiMatcherExpression = new PsiMatcherExpression(){

            @Override
            public Boolean match(PsiElement element) {
                if (element instanceof PsiNamedElement && name.equals(((PsiNamedElement)element).getName())) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        };
        if (psiMatcherExpression == null) {
            PsiMatchers.$$$reportNull$$$0(1);
        }
        return psiMatcherExpression;
    }

    @NotNull
    public static PsiMatcherExpression hasText(final @NotNull String text2) {
        if (text2 == null) {
            PsiMatchers.$$$reportNull$$$0(2);
        }
        PsiMatcherExpression psiMatcherExpression = new PsiMatcherExpression(){

            @Override
            public Boolean match(PsiElement element) {
                if (element.getTextLength() != text2.length()) {
                    return Boolean.FALSE;
                }
                return text2.equals(element.getText());
            }
        };
        if (psiMatcherExpression == null) {
            PsiMatchers.$$$reportNull$$$0(3);
        }
        return psiMatcherExpression;
    }

    @NotNull
    public static PsiMatcherExpression hasText(final String ... texts) {
        if (texts == null) {
            PsiMatchers.$$$reportNull$$$0(4);
        }
        PsiMatcherExpression psiMatcherExpression = new PsiMatcherExpression(){

            @Override
            public Boolean match(PsiElement element) {
                String text2 = element.getText();
                return ArrayUtil.find(texts, text2) != -1;
            }
        };
        if (psiMatcherExpression == null) {
            PsiMatchers.$$$reportNull$$$0(5);
        }
        return psiMatcherExpression;
    }

    @NotNull
    public static PsiMatcherExpression hasClass(final @NotNull Class<?> aClass2) {
        if (aClass2 == null) {
            PsiMatchers.$$$reportNull$$$0(6);
        }
        PsiMatcherExpression psiMatcherExpression = new PsiMatcherExpression(){

            @Override
            public Boolean match(PsiElement element) {
                if (aClass2.isAssignableFrom(element.getClass())) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        };
        if (psiMatcherExpression == null) {
            PsiMatchers.$$$reportNull$$$0(7);
        }
        return psiMatcherExpression;
    }

    @NotNull
    public static PsiMatcherExpression hasClass(final Class ... classes2) {
        if (classes2 == null) {
            PsiMatchers.$$$reportNull$$$0(8);
        }
        PsiMatcherExpression psiMatcherExpression = new PsiMatcherExpression(){

            @Override
            public Boolean match(PsiElement element) {
                for (Class aClass2 : classes2) {
                    if (!aClass2.isAssignableFrom(element.getClass())) continue;
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        };
        if (psiMatcherExpression == null) {
            PsiMatchers.$$$reportNull$$$0(9);
        }
        return psiMatcherExpression;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/util/PsiMatchers";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "texts";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/util/PsiMatchers";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "hasName";
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "hasText";
                break;
            }
            case 7: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "hasClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "hasName";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "hasText";
                break;
            }
            case 6: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "hasClass";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

