/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.HashSet;
import gnu.trove.THashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiSuperMethodUtil {
    private PsiSuperMethodUtil() {
    }

    public static PsiMethod findConstructorInSuper(PsiMethod constructor) {
        return PsiSuperMethodUtil.findConstructorInSuper(constructor, new HashSet<PsiMethod>());
    }

    public static PsiMethod findConstructorInSuper(PsiMethod constructor, Set<PsiMethod> visited2) {
        PsiClass superClass;
        PsiClass containingClass;
        PsiElement firstChild;
        PsiStatement[] statements;
        if (visited2.contains(constructor)) {
            return null;
        }
        visited2.add(constructor);
        PsiCodeBlock body2 = constructor.getBody();
        if (body2 != null && (statements = body2.getStatements()).length > 0 && (firstChild = statements[0].getFirstChild()) instanceof PsiMethodCallExpression) {
            PsiReferenceExpression methodExpr = ((PsiMethodCallExpression)firstChild).getMethodExpression();
            String text2 = methodExpr.getText();
            if (text2.equals("super")) {
                PsiElement superConstructor = methodExpr.resolve();
                if (superConstructor instanceof PsiMethod) {
                    return (PsiMethod)superConstructor;
                }
            } else if (text2.equals("this")) {
                PsiElement resolved = methodExpr.resolve();
                if (resolved instanceof PsiMethod) {
                    return PsiSuperMethodUtil.findConstructorInSuper((PsiMethod)resolved, visited2);
                }
                return null;
            }
        }
        if ((containingClass = constructor.getContainingClass()) != null && (superClass = containingClass.getSuperClass()) != null) {
            MethodSignature defConstructor = MethodSignatureUtil.createMethodSignature(superClass.getName(), PsiType.EMPTY_ARRAY, PsiTypeParameter.EMPTY_ARRAY, PsiSubstitutor.EMPTY, true);
            return MethodSignatureUtil.findMethodBySignature(superClass, defConstructor, false);
        }
        return null;
    }

    public static boolean isSuperMethod(@NotNull PsiMethod method, @NotNull PsiMethod superMethod) {
        if (method == null) {
            PsiSuperMethodUtil.$$$reportNull$$$0(0);
        }
        if (superMethod == null) {
            PsiSuperMethodUtil.$$$reportNull$$$0(1);
        }
        HierarchicalMethodSignature signature2 = method.getHierarchicalMethodSignature();
        List<HierarchicalMethodSignature> superSignatures = signature2.getSuperSignatures();
        int superSignaturesSize = superSignatures.size();
        for (int i2 = 0; i2 < superSignaturesSize; ++i2) {
            HierarchicalMethodSignature supsig = superSignatures.get(i2);
            PsiMethod supsigme = supsig.getMethod();
            if (!superMethod.equals(supsigme) && !PsiSuperMethodUtil.isSuperMethod(supsigme, superMethod)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static PsiSubstitutor obtainFinalSubstitutor(@NotNull PsiClass superClass, @NotNull PsiSubstitutor superSubstitutor, @NotNull PsiSubstitutor derivedSubstitutor, boolean inRawContext) {
        if (superClass == null) {
            PsiSuperMethodUtil.$$$reportNull$$$0(2);
        }
        if (superSubstitutor == null) {
            PsiSuperMethodUtil.$$$reportNull$$$0(3);
        }
        if (derivedSubstitutor == null) {
            PsiSuperMethodUtil.$$$reportNull$$$0(4);
        }
        if (inRawContext) {
            Set<PsiTypeParameter> typeParams = superSubstitutor.getSubstitutionMap().keySet();
            PsiElementFactory factory2 = JavaPsiFacade.getElementFactory(superClass.getProject());
            superSubstitutor = factory2.createRawSubstitutor(derivedSubstitutor, typeParams.toArray(new PsiTypeParameter[typeParams.size()]));
        }
        THashMap<PsiTypeParameter, PsiType> map2 = null;
        for (PsiTypeParameter typeParameter : PsiUtil.typeParametersIterable(superClass)) {
            PsiType type2 = superSubstitutor.substitute(typeParameter);
            PsiType t = derivedSubstitutor.substitute(type2);
            if (map2 == null) {
                map2 = new THashMap<PsiTypeParameter, PsiType>();
            }
            map2.put(typeParameter, t);
        }
        PsiSubstitutor psiSubstitutor = map2 == null ? PsiSubstitutor.EMPTY : JavaPsiFacade.getInstance(superClass.getProject()).getElementFactory().createSubstitutor(map2);
        if (psiSubstitutor == null) {
            PsiSuperMethodUtil.$$$reportNull$$$0(5);
        }
        return psiSubstitutor;
    }

    @NotNull
    public static Map<MethodSignature, Set<PsiMethod>> collectOverrideEquivalents(@NotNull PsiClass aClass2) {
        if (aClass2 == null) {
            PsiSuperMethodUtil.$$$reportNull$$$0(6);
        }
        THashMap<MethodSignature, Set<PsiMethod>> overrideEquivalent = new THashMap<MethodSignature, Set<PsiMethod>>(MethodSignatureUtil.METHOD_PARAMETERS_ERASURE_EQUALITY);
        GlobalSearchScope resolveScope = aClass2.getResolveScope();
        PsiClass[] supers = aClass2.getSupers();
        for (int i2 = 0; i2 < supers.length; ++i2) {
            PsiClass superClass = supers[i2];
            boolean subType = false;
            for (int j = 0; j < supers.length; ++j) {
                if (j == i2) continue;
                subType |= supers[j].isInheritor(supers[i2], true);
            }
            if (subType) continue;
            PsiSubstitutor superClassSubstitutor = TypeConversionUtil.getSuperClassSubstitutor(superClass, aClass2, PsiSubstitutor.EMPTY);
            for (HierarchicalMethodSignature hms : superClass.getVisibleSignatures()) {
                PsiSubstitutor containingClassSubstitutor;
                PsiClass containingClass;
                PsiMethod method = hms.getMethod();
                if (MethodSignatureUtil.findMethodBySignature(aClass2, method.getSignature(superClassSubstitutor), false) != null || (containingClass = PsiSuperMethodUtil.correctClassByScope(method.getContainingClass(), resolveScope)) == null || (method = containingClass.findMethodBySignature(method, false)) == null || (containingClassSubstitutor = TypeConversionUtil.getClassSubstitutor(containingClass, aClass2, PsiSubstitutor.EMPTY)) == null) continue;
                PsiSubstitutor finalSubstitutor = PsiSuperMethodUtil.obtainFinalSubstitutor(containingClass, containingClassSubstitutor, hms.getSubstitutor(), false);
                MethodSignatureBackedByPsiMethod signature2 = MethodSignatureBackedByPsiMethod.create(method, finalSubstitutor, false);
                LinkedHashSet<PsiMethod> methods2 = (LinkedHashSet<PsiMethod>)overrideEquivalent.get(signature2);
                if (methods2 == null) {
                    methods2 = new LinkedHashSet<PsiMethod>();
                    overrideEquivalent.put(signature2, methods2);
                }
                methods2.add(method);
            }
        }
        THashMap<MethodSignature, Set<PsiMethod>> tHashMap = overrideEquivalent;
        if (tHashMap == null) {
            PsiSuperMethodUtil.$$$reportNull$$$0(7);
        }
        return tHashMap;
    }

    @Nullable
    public static PsiClass correctClassByScope(PsiClass psiClass, GlobalSearchScope resolveScope) {
        if (psiClass == null) {
            return null;
        }
        String qualifiedName2 = psiClass.getQualifiedName();
        if (qualifiedName2 == null) {
            return psiClass;
        }
        PsiFile file2 = psiClass.getContainingFile();
        if (file2 == null || !file2.getViewProvider().isPhysical()) {
            return psiClass;
        }
        VirtualFile vFile = file2.getVirtualFile();
        if (vFile == null) {
            return psiClass;
        }
        FileIndexFacade index2 = FileIndexFacade.getInstance(file2.getProject());
        if (!(index2.isInSource(vFile) || index2.isInLibrarySource(vFile) || index2.isInLibraryClasses(vFile))) {
            return psiClass;
        }
        return JavaPsiFacade.getInstance(psiClass.getProject()).findClass(qualifiedName2, resolveScope);
    }

    @Contract(value="null, _ -> null")
    public static PsiMethod correctMethodByScope(PsiMethod method, GlobalSearchScope resolveScope) {
        if (method == null) {
            return null;
        }
        PsiClass aClass2 = method.getContainingClass();
        if (aClass2 == null) {
            return method;
        }
        PsiClass correctedClass = PsiSuperMethodUtil.correctClassByScope(aClass2, resolveScope);
        if (correctedClass == null || correctedClass == aClass2) {
            return method;
        }
        PsiMethod correctedClassMethodBySignature = correctedClass.findMethodBySignature(method, false);
        return correctedClassMethodBySignature == null ? method : correctedClassMethodBySignature;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superMethod";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superSubstitutor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "derivedSubstitutor";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/util/PsiSuperMethodUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/util/PsiSuperMethodUtil";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "obtainFinalSubstitutor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "collectOverrideEquivalents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isSuperMethod";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "obtainFinalSubstitutor";
                break;
            }
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "collectOverrideEquivalents";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

