/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethod;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.extractMethod.ParametersFolder;
import com.intellij.refactoring.util.VariableData;
import com.intellij.refactoring.util.duplicates.DuplicatesFinder;
import com.intellij.util.ArrayUtil;
import com.intellij.util.text.UniqueNameGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InputVariables {
    private final List<VariableData> myInputVariables;
    private List<? extends PsiVariable> myInitialParameters;
    private final Project myProject;
    private final LocalSearchScope myScope;
    private ParametersFolder myFolding;
    private boolean myFoldingAvailable;
    private Set<PsiField> myUsedInstanceFields;
    private boolean myPassFields;

    public InputVariables(List<? extends PsiVariable> inputVariables, Project project, LocalSearchScope scope, boolean foldingAvailable) {
        this.myInitialParameters = inputVariables;
        this.myProject = project;
        this.myScope = scope;
        this.myFoldingAvailable = foldingAvailable;
        this.myFolding = new ParametersFolder();
        this.myInputVariables = this.wrapInputVariables(inputVariables);
    }

    private InputVariables(List<VariableData> inputVariables, Project project, LocalSearchScope scope) {
        this.myProject = project;
        this.myScope = scope;
        this.myInputVariables = new ArrayList<VariableData>(inputVariables);
    }

    public boolean isFoldable() {
        return this.myFolding.isFoldable();
    }

    public void setUsedInstanceFields(Set<PsiField> usedInstanceFields) {
        this.myUsedInstanceFields = usedInstanceFields;
    }

    public void setPassFields(boolean passFields) {
        if (this.myUsedInstanceFields == null || this.myUsedInstanceFields.isEmpty()) {
            return;
        }
        this.myPassFields = passFields;
        this.myInputVariables.clear();
        this.myInputVariables.addAll(this.wrapInputVariables(this.myInitialParameters));
    }

    public boolean isPassFields() {
        return this.myPassFields;
    }

    /*
     * WARNING - void declaration
     */
    public ArrayList<VariableData> wrapInputVariables(List<? extends PsiVariable> inputVariables) {
        UniqueNameGenerator nameGenerator2 = new UniqueNameGenerator();
        ArrayList<VariableData> inputData = new ArrayList<VariableData>(inputVariables.size());
        for (PsiVariable psiVariable : inputVariables) {
            String defaultName = this.getParameterName(psiVariable);
            String name = nameGenerator2.generateUniqueName(defaultName);
            PsiType type2 = GenericsUtil.getVariableTypeByExpressionType(psiVariable.getType());
            if (type2 instanceof PsiEllipsisType) {
                type2 = ((PsiEllipsisType)type2).toArrayType();
            }
            HashMap<PsiCodeBlock, PsiType> casts = new HashMap<PsiCodeBlock, PsiType>();
            for (PsiReference reference : ReferencesSearch.search(psiVariable, this.myScope)) {
                PsiElement element = reference.getElement();
                PsiElement parent2 = element.getParent();
                PsiCodeBlock block = PsiTreeUtil.getParentOfType(parent2, PsiCodeBlock.class);
                if (parent2 instanceof PsiTypeCastExpression) {
                    PsiType currentType = (PsiType)casts.get(block);
                    PsiType castType = ((PsiTypeCastExpression)parent2).getType();
                    casts.put(block, casts.containsKey(block) && currentType == null ? null : InputVariables.getBroaderType(currentType, castType));
                    continue;
                }
                casts.put(block, null);
            }
            if (!casts.containsValue(null)) {
                PsiType psiType;
                PsiType currentType = null;
                Iterator iterator2 = casts.values().iterator();
                while (iterator2.hasNext() && (currentType = InputVariables.getBroaderType(currentType, psiType = (PsiType)iterator2.next())) != null) {
                }
                if (currentType != null && (currentType = this.checkTopLevelInstanceOf(currentType)) != null) {
                    type2 = currentType;
                }
            }
            VariableData data3 = new VariableData(psiVariable, type2);
            data3.name = name;
            data3.passAsParameter = true;
            inputData.add(data3);
            if (!this.myFoldingAvailable) continue;
            this.myFolding.isParameterFoldable(data3, this.myScope, inputVariables, nameGenerator2, defaultName);
        }
        if (this.myFoldingAvailable) {
            void var5_7;
            HashSet<VariableData> toDelete = new HashSet<VariableData>();
            int n = inputData.size() - 1;
            while (var5_7 >= 0) {
                VariableData data2 = inputData.get((int)var5_7);
                if (this.myFolding.isParameterSafeToDelete(data2, this.myScope)) {
                    toDelete.add(data2);
                }
                --var5_7;
            }
            inputData.removeAll(toDelete);
        }
        if (this.myPassFields && this.myUsedInstanceFields != null) {
            for (PsiField psiField : this.myUsedInstanceFields) {
                VariableData data2 = new VariableData(psiField, psiField.getType());
                data2.name = nameGenerator2.generateUniqueName(this.getParameterName(psiField));
                data2.passAsParameter = true;
                inputData.add(data2);
            }
        }
        return inputData;
    }

    private String getParameterName(PsiVariable var) {
        String name = var.getName();
        if (!(var instanceof PsiParameter)) {
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance(this.myProject);
            VariableKind kind = codeStyleManager.getVariableKind(var);
            name = codeStyleManager.variableNameToPropertyName(name, kind);
            name = codeStyleManager.propertyNameToVariableName(name, VariableKind.PARAMETER);
        }
        return name;
    }

    @Nullable
    private PsiType checkTopLevelInstanceOf(final PsiType currentType) {
        PsiExpression condition;
        PsiElement[] scope = this.myScope.getScope();
        if (scope.length == 1 && scope[0] instanceof PsiIfStatement && (condition = ((PsiIfStatement)scope[0]).getCondition()) != null) {
            class CheckInstanceOf {
                CheckInstanceOf() {
                }

                boolean check(PsiInstanceOfExpression expr) {
                    PsiTypeElement checkType2 = expr.getCheckType();
                    return checkType2 == null || !checkType2.getType().equals(currentType);
                }
            }
            CheckInstanceOf checker = new CheckInstanceOf();
            PsiInstanceOfExpression[] expressions = (PsiInstanceOfExpression[])PsiTreeUtil.getChildrenOfType((PsiElement)condition, PsiInstanceOfExpression.class);
            if (expressions != null) {
                for (PsiInstanceOfExpression instanceOfExpression : expressions) {
                    if (checker.check(instanceOfExpression)) continue;
                    return null;
                }
            } else if (condition instanceof PsiInstanceOfExpression && !checker.check((PsiInstanceOfExpression)condition)) {
                return null;
            }
        }
        return currentType;
    }

    @Nullable
    private static PsiType getBroaderType(PsiType currentType, PsiType castType) {
        if (currentType != null) {
            if (castType != null) {
                if (TypeConversionUtil.isAssignable(castType, currentType)) {
                    return castType;
                }
                if (!TypeConversionUtil.isAssignable(currentType, castType)) {
                    for (PsiType superType : castType.getSuperTypes()) {
                        if (!TypeConversionUtil.isAssignable(superType, currentType)) continue;
                        return superType;
                    }
                    return null;
                }
            }
        } else {
            return castType;
        }
        return currentType;
    }

    public List<VariableData> getInputVariables() {
        return this.myInputVariables;
    }

    public PsiExpression replaceWrappedReferences(PsiElement[] elements, PsiExpression expression2) {
        if (!this.myFoldingAvailable) {
            return expression2;
        }
        boolean update = elements[0] == expression2;
        this.myFolding.foldParameterUsagesInBody(this.myInputVariables, elements, this.myScope);
        return update ? (PsiExpression)elements[0] : expression2;
    }

    public boolean toDeclareInsideBody(PsiVariable variable2) {
        ArrayList<VariableData> knownVars = new ArrayList<VariableData>(this.myInputVariables);
        for (VariableData data2 : knownVars) {
            if (!data2.variable.equals(variable2)) continue;
            return false;
        }
        return !this.myFolding.wasExcluded(variable2);
    }

    public boolean contains(PsiVariable variable2) {
        for (VariableData data2 : this.myInputVariables) {
            if (!data2.variable.equals(variable2)) continue;
            return true;
        }
        return false;
    }

    public void removeParametersUsedInExitsOnly(PsiElement codeFragment, Collection<PsiStatement> exitStatements, ControlFlow controlFlow, int startOffset, int endOffset) {
        LocalSearchScope scope = new LocalSearchScope(codeFragment);
        Iterator<VariableData> iterator2 = this.myInputVariables.iterator();
        block0: while (iterator2.hasNext()) {
            VariableData data2 = iterator2.next();
            for (PsiReference ref : ReferencesSearch.search(data2.variable, scope)) {
                PsiElement element = ref.getElement();
                int elementOffset = controlFlow.getStartOffset(element);
                if (elementOffset < startOffset || elementOffset > endOffset || InputVariables.isInExitStatements(element, exitStatements)) continue;
                continue block0;
            }
            iterator2.remove();
        }
    }

    private static boolean isInExitStatements(PsiElement element, Collection<PsiStatement> exitStatements) {
        for (PsiStatement exitStatement : exitStatements) {
            if (!PsiTreeUtil.isAncestor(exitStatement, element, false)) continue;
            return true;
        }
        return false;
    }

    public InputVariables copy() {
        InputVariables inputVariables = new InputVariables(this.myInputVariables, this.myProject, this.myScope);
        inputVariables.myFoldingAvailable = this.myFoldingAvailable;
        inputVariables.myFolding = this.myFolding;
        inputVariables.myInitialParameters = this.myInitialParameters;
        return inputVariables;
    }

    public void appendCallArguments(VariableData data2, StringBuilder buffer) {
        if (this.myFoldingAvailable) {
            buffer.append(this.myFolding.getGeneratedCallArgument(data2));
        } else {
            if (!TypeConversionUtil.isAssignable(data2.type, data2.variable.getType())) {
                buffer.append("(").append(data2.type.getCanonicalText()).append(")");
            }
            buffer.append(data2.variable.getName());
        }
    }

    public ParametersFolder getFolding() {
        return this.myFolding;
    }

    public void setFoldingAvailable(boolean foldingAvailable) {
        this.myFoldingAvailable = foldingAvailable;
        this.myFolding.clear();
        this.myInputVariables.clear();
        this.myInputVariables.addAll(this.wrapInputVariables(this.myInitialParameters));
    }

    public void annotateWithParameter(PsiJavaCodeReferenceElement reference) {
        for (VariableData data2 : this.myInputVariables) {
            PsiMethod psiMethod;
            int idx;
            PsiElement element = reference.resolve();
            if (!data2.variable.equals(element)) continue;
            PsiType type2 = data2.variable.getType();
            PsiMethodCallExpression methodCallExpression = PsiTreeUtil.getParentOfType((PsiElement)reference, PsiMethodCallExpression.class);
            if (methodCallExpression != null && (idx = ArrayUtil.find(methodCallExpression.getArgumentList().getExpressions(), reference)) > -1 && (psiMethod = methodCallExpression.resolveMethod()) != null) {
                PsiParameter[] parameters2 = psiMethod.getParameterList().getParameters();
                if (idx >= parameters2.length && (idx = parameters2.length - 1) >= 0) {
                    type2 = parameters2[idx].getType();
                }
                if (type2 instanceof PsiEllipsisType) {
                    type2 = ((PsiEllipsisType)type2).getComponentType();
                }
            }
            if (this.myFoldingAvailable && this.myFolding.annotateWithParameter(data2, reference)) continue;
            reference.putUserData(DuplicatesFinder.PARAMETER, Pair.create(data2.variable, type2));
        }
    }

    public void foldExtractedParameter(@NotNull PsiVariable extractedParameter, @NotNull PsiExpression value) {
        if (extractedParameter == null) {
            InputVariables.$$$reportNull$$$0(0);
        }
        if (value == null) {
            InputVariables.$$$reportNull$$$0(1);
        }
        this.myFoldingAvailable = true;
        this.myFolding.putCallArgument(extractedParameter, value);
    }

    public boolean isFoldingSelectedByDefault() {
        return this.myFolding.isFoldingSelectedByDefault();
    }

    public boolean hasInstanceFields() {
        return this.myUsedInstanceFields != null && !this.myUsedInstanceFields.isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "extractedParameter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "value";
                break;
            }
        }
        objectArray[1] = "com/intellij/refactoring/extractMethod/InputVariables";
        objectArray[2] = "foldExtractedParameter";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

