/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.TypeAnnotationProvider;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CanonicalTypes {
    private CanonicalTypes() {
    }

    public static Type createTypeWrapper(@NotNull PsiType type2) {
        if (type2 == null) {
            CanonicalTypes.$$$reportNull$$$0(0);
        }
        return type2.accept(Creator.INSTANCE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/refactoring/util/CanonicalTypes", "createTypeWrapper"));
    }

    private static class Creator
    extends PsiTypeVisitor<Type> {
        public static final Creator INSTANCE = new Creator();
        private static final Logger LOG = Logger.getInstance(Creator.class);

        private Creator() {
        }

        @Override
        public Type visitPrimitiveType(PsiPrimitiveType type2) {
            return new Primitive(type2);
        }

        @Override
        public Type visitEllipsisType(PsiEllipsisType type2) {
            return new Ellipsis(type2, this.substituteComponents(type2));
        }

        @Override
        public Type visitArrayType(PsiArrayType type2) {
            return new Array(type2, this.substituteComponents(type2));
        }

        @NotNull
        private Type substituteComponents(PsiArrayType type2) {
            PsiType componentType = type2.getComponentType();
            Type substituted = componentType.accept(this);
            LOG.assertTrue(substituted != null, componentType);
            Type type3 = substituted;
            if (type3 == null) {
                Creator.$$$reportNull$$$0(0);
            }
            return type3;
        }

        @Override
        public Type visitWildcardType(PsiWildcardType type2) {
            PsiType bound = type2.getBound();
            return new WildcardType(type2, type2.isExtends(), bound == null ? null : bound.accept(this));
        }

        @Override
        public Type visitClassType(PsiClassType type2) {
            PsiClassType.ClassResolveResult resolveResult = type2.resolveGenerics();
            PsiClass aClass2 = resolveResult.getElement();
            if (aClass2 instanceof PsiAnonymousClass) {
                return this.visitClassType(((PsiAnonymousClass)aClass2).getBaseClassType());
            }
            if (aClass2 == null) {
                return new UnresolvedType(type2);
            }
            HashMap<String, Type> substitutionMap = ContainerUtil.newHashMap();
            PsiSubstitutor substitutor2 = resolveResult.getSubstitutor();
            for (PsiTypeParameter typeParameter : PsiUtil.typeParametersIterable(aClass2)) {
                PsiType substitute2 = substitutor2.substitute(typeParameter);
                substitutionMap.put(typeParameter.getName(), substitute2 != null ? substitute2.accept(this) : null);
            }
            String qualifiedName2 = ObjectUtils.notNull(aClass2.getQualifiedName(), ObjectUtils.assertNotNull(aClass2.getName()));
            return new ClassType(type2, qualifiedName2, substitutionMap);
        }

        @Override
        public Type visitDisjunctionType(PsiDisjunctionType type2) {
            List<Type> types = ContainerUtil.map(type2.getDisjunctions(), type1 -> type1.accept(this));
            return new LogicalOperationType(types, true);
        }

        @Override
        @Nullable
        public Type visitIntersectionType(PsiIntersectionType type2) {
            List<Type> types = ContainerUtil.map(type2.getConjuncts(), type1 -> type1.accept(this));
            return new LogicalOperationType(types, false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/util/CanonicalTypes$Creator", "substituteComponents"));
        }
    }

    private static class LogicalOperationType
    extends Type {
        private final List<Type> myTypes;
        private final boolean myDisjunction;

        private LogicalOperationType(List<Type> types, boolean disjunction) {
            this.myTypes = types;
            this.myDisjunction = disjunction;
        }

        @Override
        @NotNull
        public PsiType getType(PsiElement context, PsiManager manager) throws IncorrectOperationException {
            List<PsiType> types = ContainerUtil.map(this.myTypes, type2 -> type2.getType(context, manager));
            PsiType psiType = this.myDisjunction ? new PsiDisjunctionType(types, manager) : PsiIntersectionType.createIntersection(types);
            if (psiType == null) {
                LogicalOperationType.$$$reportNull$$$0(0);
            }
            return psiType;
        }

        @Override
        public String getTypeText() {
            return StringUtil.join(this.myTypes, type2 -> type2.getTypeText(), this.myDisjunction ? "|" : "&");
        }

        @Override
        public void addImportsTo(JavaCodeFragment fragment) {
            for (Type type2 : this.myTypes) {
                type2.addImportsTo(fragment);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/util/CanonicalTypes$LogicalOperationType", "getType"));
        }
    }

    private static class ClassType
    extends AnnotatedType {
        private final String myPresentableText;
        private final String myClassQName;
        private final Map<String, Type> mySubstitutor;

        private ClassType(@NotNull PsiType original, @NotNull String classQName, @NotNull Map<String, Type> substitutor2) {
            if (original == null) {
                ClassType.$$$reportNull$$$0(0);
            }
            if (classQName == null) {
                ClassType.$$$reportNull$$$0(1);
            }
            if (substitutor2 == null) {
                ClassType.$$$reportNull$$$0(2);
            }
            super(original.getAnnotationProvider());
            this.myPresentableText = original.getPresentableText();
            this.myClassQName = classQName;
            this.mySubstitutor = substitutor2;
        }

        @Override
        @NotNull
        public PsiType getType(PsiElement context, PsiManager manager) throws IncorrectOperationException {
            JavaPsiFacade facade = JavaPsiFacade.getInstance(manager.getProject());
            PsiElementFactory factory2 = facade.getElementFactory();
            PsiClass aClass2 = facade.getResolveHelper().resolveReferencedClass(this.myClassQName, context);
            if (aClass2 == null) {
                PsiType psiType = factory2.createTypeFromText(this.myClassQName, context);
                if (psiType == null) {
                    ClassType.$$$reportNull$$$0(3);
                }
                return psiType;
            }
            HashMap<PsiTypeParameter, PsiType> substitutionMap = ContainerUtil.newHashMap();
            Iterator<PsiTypeParameter> iterator2 = PsiUtil.typeParametersIterable(aClass2).iterator();
            while (iterator2.hasNext()) {
                PsiTypeParameter typeParameter;
                Type substitute2 = this.mySubstitutor.get((typeParameter = iterator2.next()).getName());
                substitutionMap.put(typeParameter, substitute2 != null ? substitute2.getType(context, manager) : null);
            }
            PsiClassType psiClassType = factory2.createType(aClass2, factory2.createSubstitutor(substitutionMap), null).annotate(this.myProvider);
            if (psiClassType == null) {
                ClassType.$$$reportNull$$$0(4);
            }
            return psiClassType;
        }

        @Override
        public String getTypeText() {
            return this.myPresentableText;
        }

        @Override
        public void addImportsTo(JavaCodeFragment fragment) {
            fragment.addImportsFromString(this.myClassQName);
            for (Type type2 : this.mySubstitutor.values()) {
                if (type2 == null) continue;
                type2.addImportsTo(fragment);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classQName";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "substitutor";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/refactoring/util/CanonicalTypes$ClassType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/refactoring/util/CanonicalTypes$ClassType";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class UnresolvedType
    extends Type {
        private final String myPresentableText;
        private final String myCanonicalText;

        private UnresolvedType(@NotNull PsiType original) {
            if (original == null) {
                UnresolvedType.$$$reportNull$$$0(0);
            }
            this.myPresentableText = original.getPresentableText();
            this.myCanonicalText = original.getCanonicalText(true);
        }

        @Override
        @NotNull
        public PsiType getType(PsiElement context, PsiManager manager) throws IncorrectOperationException {
            PsiType psiType = JavaPsiFacade.getInstance(manager.getProject()).getElementFactory().createTypeFromText(this.myCanonicalText, context);
            if (psiType == null) {
                UnresolvedType.$$$reportNull$$$0(1);
            }
            return psiType;
        }

        @Override
        public String getTypeText() {
            return this.myPresentableText;
        }

        @Override
        public boolean isValid() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/refactoring/util/CanonicalTypes$UnresolvedType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/refactoring/util/CanonicalTypes$UnresolvedType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class WildcardType
    extends AnnotatedType {
        private final boolean myIsExtending;
        private final Type myBound;

        private WildcardType(@NotNull PsiType original, boolean isExtending, @Nullable Type bound) {
            if (original == null) {
                WildcardType.$$$reportNull$$$0(0);
            }
            super(original.getAnnotationProvider());
            this.myIsExtending = isExtending;
            this.myBound = bound;
        }

        @Override
        @NotNull
        public PsiType getType(PsiElement context, PsiManager manager) throws IncorrectOperationException {
            PsiWildcardType type2 = this.myBound == null ? PsiWildcardType.createUnbounded(manager) : (this.myIsExtending ? PsiWildcardType.createExtends(manager, this.myBound.getType(context, manager)) : PsiWildcardType.createSuper(manager, this.myBound.getType(context, manager)));
            PsiType psiType = type2.annotate(this.myProvider);
            if (psiType == null) {
                WildcardType.$$$reportNull$$$0(1);
            }
            return psiType;
        }

        @Override
        public String getTypeText() {
            if (this.myBound == null) {
                return "?";
            }
            return "? " + (this.myIsExtending ? "extends " : "super ") + this.myBound.getTypeText();
        }

        @Override
        public void addImportsTo(JavaCodeFragment fragment) {
            if (this.myBound != null) {
                this.myBound.addImportsTo(fragment);
            }
        }

        @Override
        public boolean isValid() {
            return this.myBound == null || this.myBound.isValid();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/refactoring/util/CanonicalTypes$WildcardType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/refactoring/util/CanonicalTypes$WildcardType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class Ellipsis
    extends Array {
        private Ellipsis(@NotNull PsiType original, @NotNull Type componentType) {
            if (original == null) {
                Ellipsis.$$$reportNull$$$0(0);
            }
            if (componentType == null) {
                Ellipsis.$$$reportNull$$$0(1);
            }
            super(original, componentType);
        }

        @Override
        @NotNull
        public PsiType getType(PsiElement context, PsiManager manager) throws IncorrectOperationException {
            PsiType psiType = new PsiEllipsisType(this.myComponentType.getType(context, manager)).annotate(this.myProvider);
            if (psiType == null) {
                Ellipsis.$$$reportNull$$$0(2);
            }
            return psiType;
        }

        @Override
        public String getTypeText() {
            return this.myComponentType.getTypeText() + "...";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "componentType";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/refactoring/util/CanonicalTypes$Ellipsis";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/refactoring/util/CanonicalTypes$Ellipsis";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class Array
    extends AnnotatedType {
        protected final Type myComponentType;

        private Array(@NotNull PsiType original, @NotNull Type componentType) {
            if (original == null) {
                Array.$$$reportNull$$$0(0);
            }
            if (componentType == null) {
                Array.$$$reportNull$$$0(1);
            }
            super(original.getAnnotationProvider());
            this.myComponentType = componentType;
        }

        @Override
        @NotNull
        public PsiType getType(PsiElement context, PsiManager manager) throws IncorrectOperationException {
            PsiType psiType = this.myComponentType.getType(context, manager).createArrayType().annotate(this.myProvider);
            if (psiType == null) {
                Array.$$$reportNull$$$0(2);
            }
            return psiType;
        }

        @Override
        public String getTypeText() {
            return this.myComponentType.getTypeText() + "[]";
        }

        @Override
        public void addImportsTo(JavaCodeFragment fragment) {
            this.myComponentType.addImportsTo(fragment);
        }

        @Override
        public boolean isValid() {
            return this.myComponentType.isValid();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "componentType";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/refactoring/util/CanonicalTypes$Array";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/refactoring/util/CanonicalTypes$Array";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class Primitive
    extends AnnotatedType {
        private final PsiPrimitiveType myType;

        private Primitive(@NotNull PsiPrimitiveType type2) {
            if (type2 == null) {
                Primitive.$$$reportNull$$$0(0);
            }
            super(type2.getAnnotationProvider());
            this.myType = type2;
        }

        @Override
        @NotNull
        public PsiType getType(PsiElement context, PsiManager manager) {
            PsiPrimitiveType psiPrimitiveType = this.myType.annotate(this.myProvider);
            if (psiPrimitiveType == null) {
                Primitive.$$$reportNull$$$0(1);
            }
            return psiPrimitiveType;
        }

        @Override
        public String getTypeText() {
            return this.myType.getPresentableText();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/refactoring/util/CanonicalTypes$Primitive";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/refactoring/util/CanonicalTypes$Primitive";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static abstract class AnnotatedType
    extends Type {
        protected final TypeAnnotationProvider myProvider;

        public AnnotatedType(@NotNull TypeAnnotationProvider provider) {
            if (provider == null) {
                AnnotatedType.$$$reportNull$$$0(0);
            }
            PsiAnnotation[] annotations2 = ContainerUtil.map(provider.getAnnotations(), annotation2 -> (PsiAnnotation)annotation2.copy(), PsiAnnotation.EMPTY_ARRAY);
            this.myProvider = TypeAnnotationProvider.Static.create(annotations2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/refactoring/util/CanonicalTypes$AnnotatedType", "<init>"));
        }
    }

    public static abstract class Type {
        @NotNull
        public abstract PsiType getType(@Nullable PsiElement var1, PsiManager var2) throws IncorrectOperationException;

        public PsiType getType(@NotNull PsiElement context) {
            if (context == null) {
                Type.$$$reportNull$$$0(0);
            }
            return this.getType(context, context.getManager());
        }

        @NonNls
        public abstract String getTypeText();

        public void addImportsTo(JavaCodeFragment fragment) {
        }

        public boolean isValid() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/refactoring/util/CanonicalTypes$Type", "getType"));
        }
    }
}

