/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util.duplicates;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.refactoring.util.duplicates.ReturnValue;
import com.intellij.util.IncorrectOperationException;

public class ConditionalReturnStatementValue
implements ReturnValue {
    PsiExpression myReturnValue;

    public ConditionalReturnStatementValue(PsiExpression returnValue) {
        this.myReturnValue = returnValue;
    }

    @Override
    public boolean isEquivalent(ReturnValue other) {
        if (!(other instanceof ConditionalReturnStatementValue)) {
            return false;
        }
        PsiExpression otherReturnValue = ((ConditionalReturnStatementValue)other).myReturnValue;
        if (otherReturnValue == null || this.myReturnValue == null) {
            return this.myReturnValue == null && otherReturnValue == null;
        }
        return PsiEquivalenceUtil.areElementsEquivalent(this.myReturnValue, otherReturnValue);
    }

    @Override
    public PsiStatement createReplacement(PsiMethod extractedMethod, PsiMethodCallExpression methodCallExpression) throws IncorrectOperationException {
        PsiIfStatement statement2;
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance(methodCallExpression.getProject()).getElementFactory();
        if (this.myReturnValue == null) {
            statement2 = (PsiIfStatement)elementFactory.createStatementFromText("if(a) return;", null);
        } else {
            statement2 = (PsiIfStatement)elementFactory.createStatementFromText("if(a) return b;", null);
            PsiReturnStatement thenBranch = (PsiReturnStatement)statement2.getThenBranch();
            assert (thenBranch != null);
            PsiExpression returnValue = thenBranch.getReturnValue();
            assert (returnValue != null);
            returnValue.replace(this.myReturnValue);
        }
        PsiExpression condition = statement2.getCondition();
        assert (condition != null);
        condition.replace(methodCallExpression);
        return (PsiStatement)CodeStyleManager.getInstance(statement2.getManager().getProject()).reformat(statement2);
    }
}

