/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util.duplicates;

import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.refactoring.util.duplicates.ReturnValue;
import com.intellij.util.IncorrectOperationException;

public class VariableReturnValue
implements ReturnValue {
    private final PsiVariable myVariable;

    public VariableReturnValue(PsiVariable variable2) {
        this.myVariable = variable2;
    }

    @Override
    public boolean isEquivalent(ReturnValue other) {
        if (!(other instanceof VariableReturnValue)) {
            return false;
        }
        return this.myVariable == ((VariableReturnValue)other).myVariable;
    }

    public PsiVariable getVariable() {
        return this.myVariable;
    }

    @Override
    public PsiStatement createReplacement(PsiMethod extractedMethod, PsiMethodCallExpression methodCallExpression) throws IncorrectOperationException {
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance(methodCallExpression.getProject()).getElementFactory();
        CodeStyleManager styleManager = CodeStyleManager.getInstance(methodCallExpression.getProject());
        PsiDeclarationStatement statement2 = (PsiDeclarationStatement)styleManager.reformat(elementFactory.createVariableDeclarationStatement(this.myVariable.getName(), this.myVariable.getType(), methodCallExpression));
        ((PsiVariable)statement2.getDeclaredElements()[0]).getModifierList().replace(this.myVariable.getModifierList());
        return statement2;
    }
}

