/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.util.ScalableIcon;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Graphics;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class RowIcon
extends JBUI.CachingScalableJBIcon<RowIcon> {
    private final Alignment myAlignment;
    private int myWidth;
    private int myHeight;
    private final Icon[] myIcons;
    private Icon[] myScaledIcons;

    public RowIcon(int iconCount) {
        this(iconCount, Alignment.TOP);
    }

    public RowIcon(int iconCount, Alignment alignment) {
        ((JBUI.BaseScaleContext)this.getScaleContext()).addUpdateListener(() -> this.updateSize());
        this.setAutoUpdateScaleContext(false);
        this.myAlignment = alignment;
        this.myIcons = new Icon[iconCount];
    }

    public RowIcon(Icon ... icons) {
        this(icons.length);
        System.arraycopy(icons, 0, this.myIcons, 0, icons.length);
        this.updateSize();
    }

    protected RowIcon(RowIcon icon) {
        super(icon);
        ((JBUI.BaseScaleContext)this.getScaleContext()).addUpdateListener(() -> this.updateSize());
        this.setAutoUpdateScaleContext(false);
        this.myAlignment = icon.myAlignment;
        this.myWidth = icon.myWidth;
        this.myHeight = icon.myHeight;
        this.myIcons = ArrayUtil.copyOf(icon.myIcons);
        this.myScaledIcons = null;
    }

    @Override
    @NotNull
    protected RowIcon copy() {
        RowIcon rowIcon = new RowIcon(this);
        if (rowIcon == null) {
            RowIcon.$$$reportNull$$$0(0);
        }
        return rowIcon;
    }

    @NotNull
    private Icon[] myScaledIcons() {
        if (this.myScaledIcons != null) {
            if (this.myScaledIcons == null) {
                RowIcon.$$$reportNull$$$0(1);
            }
            return this.myScaledIcons;
        }
        if (this.getScale() == 1.0f) {
            this.myScaledIcons = this.myIcons;
            Icon[] iconArray = this.myScaledIcons;
            if (iconArray == null) {
                RowIcon.$$$reportNull$$$0(2);
            }
            return iconArray;
        }
        for (Icon icon : this.myIcons) {
            if (icon == null || icon instanceof ScalableIcon) continue;
            this.myScaledIcons = this.myIcons;
            Icon[] iconArray = this.myScaledIcons;
            if (iconArray == null) {
                RowIcon.$$$reportNull$$$0(3);
            }
            return iconArray;
        }
        this.myScaledIcons = new Icon[this.myIcons.length];
        for (int i2 = 0; i2 < this.myIcons.length; ++i2) {
            if (this.myIcons[i2] == null) continue;
            this.myScaledIcons[i2] = ((ScalableIcon)this.myIcons[i2]).scale(this.getScale());
        }
        if (this.myScaledIcons == null) {
            RowIcon.$$$reportNull$$$0(4);
        }
        return this.myScaledIcons;
    }

    @NotNull
    Icon[] getAllIcons() {
        List<Icon> icons = ContainerUtil.packNullables(this.myIcons);
        Icon[] iconArray = icons.toArray(new Icon[icons.size()]);
        if (iconArray == null) {
            RowIcon.$$$reportNull$$$0(5);
        }
        return iconArray;
    }

    public int hashCode() {
        return this.myIcons.length > 0 ? this.myIcons[0].hashCode() : 0;
    }

    public boolean equals(Object obj) {
        return obj instanceof RowIcon && Arrays.equals(((RowIcon)obj).myIcons, this.myIcons);
    }

    public int getIconCount() {
        return this.myIcons.length;
    }

    public void setIcon(Icon icon, int layer) {
        this.myIcons[layer] = icon;
        this.myScaledIcons = null;
        this.updateSize();
    }

    public Icon getIcon(int index2) {
        return this.myIcons[index2];
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        ((JBUI.BaseScaleContext)this.getScaleContext()).update();
        int _x = x;
        int _y = y;
        for (Icon icon : this.myScaledIcons()) {
            if (icon == null) continue;
            switch (this.myAlignment) {
                case TOP: {
                    _y = y;
                    break;
                }
                case CENTER: {
                    _y = y + (this.myHeight - icon.getIconHeight()) / 2;
                    break;
                }
                case BOTTOM: {
                    _y = y + (this.myHeight - icon.getIconHeight());
                }
            }
            icon.paintIcon(c, g, _x, _y);
            _x += icon.getIconWidth();
        }
    }

    @Override
    public int getIconWidth() {
        ((JBUI.BaseScaleContext)this.getScaleContext()).update();
        return (int)Math.ceil(this.scaleVal(this.myWidth, JBUI.ScaleType.OBJ_SCALE));
    }

    @Override
    public int getIconHeight() {
        ((JBUI.BaseScaleContext)this.getScaleContext()).update();
        return (int)Math.ceil(this.scaleVal(this.myHeight, JBUI.ScaleType.OBJ_SCALE));
    }

    private void updateSize() {
        int width = 0;
        int height = 0;
        for (Icon icon : this.myIcons) {
            if (icon == null) continue;
            width += icon.getIconWidth();
            height = Math.max(height, icon.getIconHeight());
        }
        this.myWidth = width;
        this.myHeight = height;
    }

    @Override
    public String toString() {
        return "Row icon. myIcons=" + Arrays.asList(this.myIcons);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/ui/RowIcon";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "copy";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "myScaledIcons";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllIcons";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    public static enum Alignment {
        TOP,
        CENTER,
        BOTTOM;

    }
}

