/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ItemRemovable;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TableUtil {
    private TableUtil() {
    }

    @NotNull
    public static List<Object[]> removeSelectedItems(@NotNull JTable table2) {
        if (table2 == null) {
            TableUtil.$$$reportNull$$$0(0);
        }
        List<Object[]> list2 = TableUtil.removeSelectedItems(table2, null);
        if (list2 == null) {
            TableUtil.$$$reportNull$$$0(1);
        }
        return list2;
    }

    public static void selectRows(@NotNull JTable table2, @NotNull int[] viewRows) {
        if (table2 == null) {
            TableUtil.$$$reportNull$$$0(2);
        }
        if (viewRows == null) {
            TableUtil.$$$reportNull$$$0(3);
        }
        ListSelectionModel selectionModel = table2.getSelectionModel();
        selectionModel.clearSelection();
        int count2 = table2.getRowCount();
        for (int row : viewRows) {
            if (row < 0 || row >= count2) continue;
            selectionModel.addSelectionInterval(row, row);
        }
    }

    public static void scrollSelectionToVisible(@NotNull JTable table2) {
        if (table2 == null) {
            TableUtil.$$$reportNull$$$0(4);
        }
        ListSelectionModel selectionModel = table2.getSelectionModel();
        int maxSelectionIndex = selectionModel.getMaxSelectionIndex();
        int minSelectionIndex = selectionModel.getMinSelectionIndex();
        int maxColumnSelectionIndex = Math.max(0, table2.getColumnModel().getSelectionModel().getMinSelectionIndex());
        int minColumnSelectionIndex = Math.max(0, table2.getColumnModel().getSelectionModel().getMaxSelectionIndex());
        if (maxSelectionIndex == -1) {
            return;
        }
        Rectangle minCellRect = table2.getCellRect(minSelectionIndex, minColumnSelectionIndex, false);
        Rectangle maxCellRect = table2.getCellRect(maxSelectionIndex, maxColumnSelectionIndex, false);
        Point selectPoint = minCellRect.getLocation();
        int allHeight = maxCellRect.y + maxCellRect.height - minCellRect.y;
        allHeight = Math.min(allHeight, table2.getHeight());
        table2.scrollRectToVisible(new Rectangle(selectPoint, new Dimension(minCellRect.width / 2, allHeight)));
    }

    @NotNull
    public static List<Object[]> removeSelectedItems(@NotNull JTable table2, @Nullable ItemChecker applyable) {
        TableModel model;
        if (table2 == null) {
            TableUtil.$$$reportNull$$$0(5);
        }
        if (!((model = table2.getModel()) instanceof ItemRemovable)) {
            throw new RuntimeException("model must be instance of ItemRemovable");
        }
        if (table2.getSelectionModel().isSelectionEmpty()) {
            ArrayList<Object[]> arrayList = new ArrayList<Object[]>(0);
            if (arrayList == null) {
                TableUtil.$$$reportNull$$$0(6);
            }
            return arrayList;
        }
        final SmartList removedItems = new SmartList();
        final ItemRemovable itemRemovable = (ItemRemovable)((Object)model);
        final int columnCount = model.getColumnCount();
        TableUtil.doRemoveSelectedItems(table2, new ItemRemovable(){

            @Override
            public void removeRow(int index2) {
                Object[] row = new Object[columnCount];
                for (int column = 0; column < columnCount; ++column) {
                    row[column] = model.getValueAt(index2, column);
                }
                removedItems.add(row);
                itemRemovable.removeRow(index2);
            }
        }, applyable);
        List<Object[]> list2 = ContainerUtil.reverse(removedItems);
        if (list2 == null) {
            TableUtil.$$$reportNull$$$0(7);
        }
        return list2;
    }

    public static boolean doRemoveSelectedItems(@NotNull JTable table2, @NotNull ItemRemovable itemRemovable, @Nullable ItemChecker applyable) {
        if (table2 == null) {
            TableUtil.$$$reportNull$$$0(8);
        }
        if (itemRemovable == null) {
            TableUtil.$$$reportNull$$$0(9);
        }
        if (table2.isEditing()) {
            table2.getCellEditor().stopCellEditing();
        }
        ListSelectionModel selectionModel = table2.getSelectionModel();
        int minSelectionIndex = selectionModel.getMinSelectionIndex();
        int maxSelectionIndex = selectionModel.getMaxSelectionIndex();
        if (minSelectionIndex == -1 || maxSelectionIndex == -1) {
            return false;
        }
        TableModel model = table2.getModel();
        boolean removed2 = false;
        for (int index2 = maxSelectionIndex; index2 >= 0; --index2) {
            int modelIndex = table2.convertRowIndexToModel(index2);
            if (!selectionModel.isSelectedIndex(index2) || applyable != null && !applyable.isOperationApplyable(model, modelIndex)) continue;
            itemRemovable.removeRow(modelIndex);
            removed2 = true;
        }
        if (!removed2) {
            return false;
        }
        int count2 = model.getRowCount();
        if (count2 == 0) {
            table2.clearSelection();
        } else if (selectionModel.getMinSelectionIndex() == -1) {
            if (minSelectionIndex >= model.getRowCount()) {
                selectionModel.setSelectionInterval(model.getRowCount() - 1, model.getRowCount() - 1);
            } else {
                selectionModel.setSelectionInterval(minSelectionIndex, minSelectionIndex);
            }
        }
        return true;
    }

    public static int moveSelectedItemsUp(@NotNull JTable table2) {
        if (table2 == null) {
            TableUtil.$$$reportNull$$$0(10);
        }
        if (table2.isEditing()) {
            table2.getCellEditor().stopCellEditing();
        }
        TableModel model = table2.getModel();
        ListSelectionModel selectionModel = table2.getSelectionModel();
        int counter = 0;
        for (int row = 0; row < model.getRowCount(); ++row) {
            if (!selectionModel.isSelectedIndex(row)) continue;
            ++counter;
            for (int column = 0; column < model.getColumnCount(); ++column) {
                Object temp = model.getValueAt(row, column);
                model.setValueAt(model.getValueAt(row - 1, column), row, column);
                model.setValueAt(temp, row - 1, column);
            }
            selectionModel.removeSelectionInterval(row, row);
            selectionModel.addSelectionInterval(row - 1, row - 1);
        }
        Rectangle cellRect = table2.getCellRect(selectionModel.getMinSelectionIndex(), 0, true);
        if (cellRect != null) {
            table2.scrollRectToVisible(cellRect);
        }
        table2.repaint();
        return counter;
    }

    public static int moveSelectedItemsDown(@NotNull JTable table2) {
        if (table2 == null) {
            TableUtil.$$$reportNull$$$0(11);
        }
        if (table2.isEditing()) {
            table2.getCellEditor().stopCellEditing();
        }
        TableModel model = table2.getModel();
        ListSelectionModel selectionModel = table2.getSelectionModel();
        int counter = 0;
        for (int row = model.getRowCount() - 1; row >= 0; --row) {
            if (!selectionModel.isSelectedIndex(row)) continue;
            ++counter;
            for (int column = 0; column < model.getColumnCount(); ++column) {
                Object temp = model.getValueAt(row, column);
                model.setValueAt(model.getValueAt(row + 1, column), row, column);
                model.setValueAt(temp, row + 1, column);
            }
            selectionModel.removeSelectionInterval(row, row);
            selectionModel.addSelectionInterval(row + 1, row + 1);
        }
        Rectangle cellRect = table2.getCellRect(selectionModel.getMaxSelectionIndex(), 0, true);
        if (cellRect != null) {
            table2.scrollRectToVisible(cellRect);
        }
        table2.repaint();
        return counter;
    }

    public static void editCellAt(@NotNull JTable table2, int row, int column) {
        Component component;
        if (table2 == null) {
            TableUtil.$$$reportNull$$$0(12);
        }
        if (table2.editCellAt(row, column) && (component = table2.getEditorComponent()) != null) {
            component.requestFocus();
        }
    }

    public static void stopEditing(@NotNull JTable table2) {
        if (table2 == null) {
            TableUtil.$$$reportNull$$$0(13);
        }
        if (table2.isEditing()) {
            TableCellEditor editor;
            TableCellEditor cellEditor = table2.getCellEditor();
            if (cellEditor != null) {
                cellEditor.stopCellEditing();
            }
            int row = table2.getSelectedRow();
            int column = table2.getSelectedColumn();
            if (row >= 0 && column >= 0 && (editor = table2.getCellEditor(row, column)) != null) {
                editor.stopCellEditing();
            }
        }
    }

    public static void ensureSelectionExists(@NotNull JTable table2) {
        if (table2 == null) {
            TableUtil.$$$reportNull$$$0(14);
        }
        if (table2.getSelectedRow() != -1 || table2.getRowCount() == 0) {
            return;
        }
        table2.setRowSelectionInterval(0, 0);
    }

    public static void setupCheckboxColumn(@NotNull JTable table2, int columnIndex) {
        if (table2 == null) {
            TableUtil.$$$reportNull$$$0(15);
        }
        TableUtil.setupCheckboxColumn(table2.getColumnModel().getColumn(columnIndex));
    }

    public static void setupCheckboxColumn(@NotNull TableColumn column) {
        if (column == null) {
            TableUtil.$$$reportNull$$$0(16);
        }
        TableUtil.setupCheckboxColumn(column, 0);
    }

    public static void setupCheckboxColumn(@NotNull TableColumn column, int additionalWidth) {
        if (column == null) {
            TableUtil.$$$reportNull$$$0(17);
        }
        int checkboxWidth = new JCheckBox().getPreferredSize().width + additionalWidth;
        column.setResizable(false);
        column.setPreferredWidth(checkboxWidth);
        column.setMaxWidth(checkboxWidth);
        column.setMinWidth(checkboxWidth);
    }

    public static void updateScroller(@NotNull JTable table2) {
        JScrollPane scrollPane;
        if (table2 == null) {
            TableUtil.$$$reportNull$$$0(18);
        }
        if ((scrollPane = UIUtil.getParentOfType(JScrollPane.class, table2)) != null) {
            scrollPane.revalidate();
            scrollPane.repaint();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 1: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/TableUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewRows";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "itemRemovable";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/TableUtil";
                break;
            }
            case 1: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "removeSelectedItems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "removeSelectedItems";
                break;
            }
            case 1: 
            case 6: 
            case 7: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "selectRows";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "scrollSelectionToVisible";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doRemoveSelectedItems";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "moveSelectedItemsUp";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "moveSelectedItemsDown";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "editCellAt";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "stopEditing";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "ensureSelectionExists";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setupCheckboxColumn";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "updateScroller";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface ItemChecker {
        public boolean isOperationApplyable(@NotNull TableModel var1, int var2);
    }
}

