/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

public class BloomFilterBase {
    private final int myHashFunctionCount;
    private final int myBitsCount;
    private final long[] myElementsSet;
    private static final int BITS_PER_ELEMENT = 6;

    protected BloomFilterBase(int _maxElementCount, double probability) {
        int bitsPerElementFactor = (int)Math.ceil(-Math.log(probability) / (Math.log(2.0) * Math.log(2.0)));
        this.myHashFunctionCount = (int)Math.ceil((double)bitsPerElementFactor * Math.log(2.0));
        int bitsCount = _maxElementCount * bitsPerElementFactor;
        if ((bitsCount & 1) == 0) {
            ++bitsCount;
        }
        while (!BloomFilterBase.isPrime(bitsCount)) {
            bitsCount += 2;
        }
        this.myBitsCount = bitsCount;
        this.myElementsSet = new long[(bitsCount >> 6) + 1];
    }

    private static boolean isPrime(int bits) {
        if ((bits & 1) == 0 || bits % 3 == 0) {
            return false;
        }
        int sqrt = (int)Math.sqrt(bits);
        for (int i2 = 6; i2 <= sqrt; i2 += 6) {
            if (bits % (i2 - 1) != 0 && bits % (i2 + 1) != 0) continue;
            return false;
        }
        return true;
    }

    protected final void addIt(int prime, int prime2) {
        for (int i2 = 0; i2 < this.myHashFunctionCount; ++i2) {
            int abs = Math.abs((i2 * prime + prime2 * (this.myHashFunctionCount - i2)) % this.myBitsCount);
            int n = abs >> 6;
            this.myElementsSet[n] = this.myElementsSet[n] | 1L << abs;
        }
    }

    protected final boolean maybeContains(int prime, int prime2) {
        for (int i2 = 0; i2 < this.myHashFunctionCount; ++i2) {
            int abs = Math.abs((i2 * prime + prime2 * (this.myHashFunctionCount - i2)) % this.myBitsCount);
            if ((this.myElementsSet[abs >> 6] & 1L << abs) != 0L) continue;
            return false;
        }
        return true;
    }
}

