/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.PossiblyDumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.lang.ref.WeakReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DisposeAwareRunnable
extends WeakReference<Object>
implements Runnable {
    protected final Runnable myDelegate;

    public static Runnable create(@NotNull Runnable delegate, @Nullable PsiElement disposable) {
        if (delegate == null) {
            DisposeAwareRunnable.$$$reportNull$$$0(0);
        }
        return DisposeAwareRunnable.create(delegate, (Object)disposable);
    }

    public static Runnable create(@NotNull Runnable delegate, @Nullable Project disposable) {
        if (delegate == null) {
            DisposeAwareRunnable.$$$reportNull$$$0(1);
        }
        return DisposeAwareRunnable.create(delegate, (Object)disposable);
    }

    public static Runnable create(@NotNull Runnable delegate, @Nullable Module disposable) {
        if (delegate == null) {
            DisposeAwareRunnable.$$$reportNull$$$0(2);
        }
        return DisposeAwareRunnable.create(delegate, (Object)disposable);
    }

    private static Runnable create(@NotNull Runnable delegate, @Nullable Object disposable) {
        if (delegate == null) {
            DisposeAwareRunnable.$$$reportNull$$$0(3);
        }
        if (disposable == null) {
            return delegate;
        }
        if (delegate instanceof DumbAware) {
            return new DumbAwareRunnable(delegate, disposable);
        }
        if (delegate instanceof PossiblyDumbAware) {
            return new PossiblyDumbAwareRunnable(delegate, disposable);
        }
        return new DisposeAwareRunnable(delegate, disposable);
    }

    private DisposeAwareRunnable(@NotNull Runnable delegate, @NotNull Object disposable) {
        if (delegate == null) {
            DisposeAwareRunnable.$$$reportNull$$$0(4);
        }
        if (disposable == null) {
            DisposeAwareRunnable.$$$reportNull$$$0(5);
        }
        super(disposable);
        this.myDelegate = delegate;
        assert (disposable instanceof PsiElement || disposable instanceof ComponentManager) : "Unknown type of " + disposable;
    }

    @Override
    public void run() {
        Object res2 = this.get();
        if (res2 == null) {
            return;
        }
        if (res2 instanceof PsiElement ? !((PsiElement)res2).isValid() : res2 instanceof ComponentManager && ((ComponentManager)res2).isDisposed()) {
            return;
        }
        this.myDelegate.run();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/DisposeAwareRunnable";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "create";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class PossiblyDumbAwareRunnable
    extends DisposeAwareRunnable
    implements PossiblyDumbAware {
        PossiblyDumbAwareRunnable(Runnable delegate, Object disposable) {
            super(delegate, disposable);
        }

        @Override
        public boolean isDumbAware() {
            return ((PossiblyDumbAware)((Object)this.myDelegate)).isDumbAware();
        }
    }

    private static class DumbAwareRunnable
    extends DisposeAwareRunnable
    implements DumbAware {
        DumbAwareRunnable(Runnable delegate, Object disposable) {
            super(delegate, disposable);
        }
    }
}

