/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.util.NullableFunction;
import java.util.Collection;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface Function<Param, Result> {
    public static final Function ID = new Mono(){

        public Object fun(Object o) {
            return o;
        }
    };
    public static final Function NULL = NullableFunction.NULL;
    public static final Function TO_STRING = new Function(){

        public Object fun(Object o) {
            return String.valueOf(o);
        }
    };

    public Result fun(Param var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class FirstInCollection<P, R extends P>
    implements Function<Collection<P>, R> {
        @Override
        public R fun(Collection<P> ps) {
            return (R)ps.iterator().next();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class First<P, R extends P>
    implements Function<P[], R> {
        @Override
        public R fun(P[] ps) {
            return (R)ps[0];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class InstanceOf<P, R extends P>
    implements NullableFunction<P, R> {
        private final Class<R> myResultClass;

        public InstanceOf(Class<R> resultClass) {
            this.myResultClass = resultClass;
        }

        @Override
        @Nullable
        public R fun(P p2) {
            return (R)(p2.getClass().isAssignableFrom(this.myResultClass) ? p2 : null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Mono<T>
    extends Function<T, T> {
    }
}

