/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import gnu.trove.HashFunctions;
import gnu.trove.TIntProcedure;
import java.util.Arrays;
import java.util.Random;
import org.jetbrains.annotations.NotNull;

public class ByteArrayList
implements Cloneable {
    protected transient byte[] _data;
    protected transient int _pos;
    protected static final int DEFAULT_CAPACITY = 4;

    public ByteArrayList() {
        this(4);
    }

    public ByteArrayList(int capacity) {
        this._data = new byte[capacity];
        this._pos = 0;
    }

    public ByteArrayList(byte[] values2) {
        this(Math.max(values2.length, 4));
        this.add(values2);
    }

    public void ensureCapacity(int capacity) {
        byte[] data2 = this._data;
        if (capacity > data2.length) {
            int newCap = Math.max(data2.length < 100000 ? data2.length << 1 : data2.length * 4 / 3, capacity);
            byte[] tmp = new byte[newCap];
            System.arraycopy(data2, 0, tmp, 0, data2.length);
            this._data = tmp;
        }
    }

    public int size() {
        return this._pos;
    }

    public boolean isEmpty() {
        return this._pos == 0;
    }

    public void trimToSize() {
        if (this._data.length > this.size()) {
            byte[] tmp = new byte[this.size()];
            this.toNativeArray(tmp, 0, tmp.length);
            this._data = tmp;
        }
    }

    public void add(byte val) {
        this.ensureCapacity(this._pos + 1);
        this._data[this._pos++] = val;
    }

    public void add(byte[] vals) {
        this.add(vals, 0, vals.length);
    }

    public void add(byte[] vals, int offset2, int length) {
        this.ensureCapacity(this._pos + length);
        System.arraycopy(vals, offset2, this._data, this._pos, length);
        this._pos += length;
    }

    public void insert(int offset2, byte value) {
        if (offset2 == this._pos) {
            this.add(value);
            return;
        }
        this.ensureCapacity(this._pos + 1);
        System.arraycopy(this._data, offset2, this._data, offset2 + 1, this._pos - offset2);
        this._data[offset2] = value;
        ++this._pos;
    }

    public void insert(int offset2, byte[] values2) {
        this.insert(offset2, values2, 0, values2.length);
    }

    public void insert(int offset2, byte[] values2, int valOffset, int len) {
        if (offset2 == this._pos) {
            this.add(values2, valOffset, len);
            return;
        }
        this.ensureCapacity(this._pos + len);
        System.arraycopy(this._data, offset2, this._data, offset2 + len, this._pos - offset2);
        System.arraycopy(values2, valOffset, this._data, offset2, len);
        this._pos += len;
    }

    public byte get(int offset2) {
        if (offset2 >= this._pos) {
            throw new ArrayIndexOutOfBoundsException("Index out of range: " + offset2 + "; size: " + this._pos);
        }
        return this._data[offset2];
    }

    public byte getQuick(int offset2) {
        return this._data[offset2];
    }

    public void set(int offset2, byte val) {
        if (offset2 < 0 || offset2 >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset2);
        }
        this._data[offset2] = val;
    }

    public byte getSet(int offset2, byte val) {
        if (offset2 < 0 || offset2 >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset2);
        }
        byte old = this._data[offset2];
        this._data[offset2] = val;
        return old;
    }

    public void set(int offset2, byte[] values2) {
        this.set(offset2, values2, 0, values2.length);
    }

    public void set(int offset2, byte[] values2, int valOffset, int length) {
        if (offset2 < 0 || offset2 + length > this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset2);
        }
        System.arraycopy(this._data, offset2, values2, valOffset, length);
    }

    public void copy(int source2, int destination, int length) {
        if (source2 < 0 || source2 + length > this._pos) {
            throw new ArrayIndexOutOfBoundsException(source2);
        }
        if (destination < 0 || destination + length > this._pos) {
            throw new ArrayIndexOutOfBoundsException(destination);
        }
        System.arraycopy(this._data, source2, this._data, destination, length);
    }

    public void setQuick(int offset2, byte val) {
        this._data[offset2] = val;
    }

    public void clear() {
        this.clear(4);
    }

    public void clear(int capacity) {
        this._data = new byte[capacity];
        this._pos = 0;
    }

    public void reset() {
        this._pos = 0;
        this.fill((byte)0);
    }

    public void resetQuick() {
        this._pos = 0;
    }

    public byte remove(int offset2) {
        byte old = this.get(offset2);
        this.remove(offset2, 1);
        return old;
    }

    public void remove(int offset2, int length) {
        if (offset2 < 0 || offset2 >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset2);
        }
        if (offset2 == 0) {
            System.arraycopy(this._data, length, this._data, 0, this._pos - length);
        } else if (this._pos - length != offset2) {
            System.arraycopy(this._data, offset2 + length, this._data, offset2, this._pos - (offset2 + length));
        }
        this._pos -= length;
    }

    public void reverse() {
        this.reverse(0, this._pos);
    }

    public void reverse(int from, int to) {
        if (from == to) {
            return;
        }
        if (from > to) {
            throw new IllegalArgumentException("from cannot be greater than to");
        }
        int i2 = from;
        for (int j = to - 1; i2 < j; ++i2, --j) {
            this.swap(i2, j);
        }
    }

    public void shuffle(Random rand) {
        int i2 = this._pos;
        while (i2-- > 1) {
            this.swap(i2, rand.nextInt(i2));
        }
    }

    private final void swap(int i2, int j) {
        byte tmp = this._data[i2];
        this._data[i2] = this._data[j];
        this._data[j] = tmp;
    }

    public Object clone() {
        ByteArrayList clone = null;
        try {
            clone = (ByteArrayList)super.clone();
            clone._data = (byte[])this._data.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return clone;
    }

    @NotNull
    public byte[] toNativeArray() {
        byte[] byArray = this.toNativeArray(0, this._pos);
        if (byArray == null) {
            ByteArrayList.$$$reportNull$$$0(0);
        }
        return byArray;
    }

    @NotNull
    public byte[] toNativeArray(int offset2, int len) {
        byte[] rv = new byte[len];
        this.toNativeArray(rv, offset2, len);
        if (rv == null) {
            ByteArrayList.$$$reportNull$$$0(1);
        }
        return rv;
    }

    public void toNativeArray(byte[] dest, int offset2, int len) {
        if (len == 0) {
            return;
        }
        if (offset2 < 0 || offset2 >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset2);
        }
        System.arraycopy(this._data, offset2, dest, 0, len);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof ByteArrayList) {
            ByteArrayList that = (ByteArrayList)other;
            if (that.size() != this.size()) {
                return false;
            }
            int i2 = this._pos;
            while (i2-- > 0) {
                if (this._data[i2] == that._data[i2]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int h = 0;
        int i2 = this._pos;
        while (i2-- > 0) {
            h += HashFunctions.hash(this._data[i2]);
        }
        return h;
    }

    public boolean forEach(TIntProcedure procedure) {
        for (int i2 = 0; i2 < this._pos; ++i2) {
            if (procedure.execute(this._data[i2])) continue;
            return false;
        }
        return true;
    }

    public boolean forEachDescending(TIntProcedure procedure) {
        int i2 = this._pos;
        while (i2-- > 0) {
            if (procedure.execute(this._data[i2])) continue;
            return false;
        }
        return true;
    }

    public void sort() {
        Arrays.sort(this._data, 0, this._pos);
    }

    public void sort(int fromIndex, int toIndex) {
        Arrays.sort(this._data, fromIndex, toIndex);
    }

    public void fill(byte val) {
        Arrays.fill(this._data, 0, this._pos, val);
    }

    public void fill(int fromIndex, int toIndex, byte val) {
        if (toIndex > this._pos) {
            this.ensureCapacity(toIndex);
            this._pos = toIndex;
        }
        Arrays.fill(this._data, fromIndex, toIndex, val);
    }

    public int binarySearch(byte value) {
        return this.binarySearch(value, 0, this._pos);
    }

    public int binarySearch(byte value, int fromIndex, int toIndex) {
        if (fromIndex < 0) {
            throw new ArrayIndexOutOfBoundsException(fromIndex);
        }
        if (toIndex > this._pos) {
            throw new ArrayIndexOutOfBoundsException(toIndex);
        }
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            byte midVal = this._data[mid];
            if (midVal < value) {
                low = mid + 1;
                continue;
            }
            if (midVal > value) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public int indexOf(byte value) {
        return this.indexOf(0, value);
    }

    public int indexOf(int offset2, byte value) {
        for (int i2 = offset2; i2 < this._pos; ++i2) {
            if (this._data[i2] != value) continue;
            return i2;
        }
        return -1;
    }

    public int lastIndexOf(byte value) {
        return this.lastIndexOf(this._pos, value);
    }

    public int lastIndexOf(int offset2, byte value) {
        int i2 = offset2;
        while (i2-- > 0) {
            if (this._data[i2] != value) continue;
            return i2;
        }
        return -1;
    }

    public boolean contains(byte value) {
        return this.lastIndexOf(value) >= 0;
    }

    public ByteArrayList grep(TIntProcedure condition) {
        ByteArrayList list2 = new ByteArrayList();
        for (int i2 = 0; i2 < this._pos; ++i2) {
            if (!condition.execute(this._data[i2])) continue;
            list2.add(this._data[i2]);
        }
        return list2;
    }

    public ByteArrayList inverseGrep(TIntProcedure condition) {
        ByteArrayList list2 = new ByteArrayList();
        for (int i2 = 0; i2 < this._pos; ++i2) {
            if (condition.execute(this._data[i2])) continue;
            list2.add(this._data[i2]);
        }
        return list2;
    }

    public int max() {
        if (this.size() == 0) {
            throw new IllegalStateException("cannot find maximum of an empty list");
        }
        int max = this._data[this._pos - 1];
        int i2 = this._pos - 1;
        while (i2-- > 0) {
            max = Math.max(max, this._data[this._pos]);
        }
        return max;
    }

    public int min() {
        if (this.size() == 0) {
            throw new IllegalStateException("cannot find minimum of an empty list");
        }
        int min = this._data[this._pos - 1];
        int i2 = this._pos - 1;
        while (i2-- > 0) {
            min = Math.min(min, this._data[this._pos]);
        }
        return min;
    }

    public String toString() {
        final StringBuffer buf = new StringBuffer("{");
        this.forEach(new TIntProcedure(){

            @Override
            public boolean execute(int val) {
                buf.append(val);
                buf.append(", ");
                return true;
            }
        });
        buf.append("}");
        return buf.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ByteArrayList", "toNativeArray"));
    }
}

