/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.Condition;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.FilteringIterator;
import java.util.Collection;
import java.util.Map;

public interface InternalIterator<T> {
    public boolean visit(T var1);

    public static class Converting<Dom, Rng>
    implements InternalIterator<Dom> {
        private final Convertor<Dom, Rng> myConvertor;
        private final InternalIterator<Rng> myIterator;

        public Converting(InternalIterator<Rng> iterator2, Convertor<Dom, Rng> convertor) {
            this.myIterator = iterator2;
            this.myConvertor = convertor;
        }

        @Override
        public boolean visit(Dom element) {
            return this.myIterator.visit(this.myConvertor.convert(element));
        }

        public static <Dom, Rng> InternalIterator<Dom> create(Convertor<Dom, Rng> convertor, InternalIterator<Rng> iterator2) {
            return new Converting<Dom, Rng>(iterator2, convertor);
        }
    }

    public static class Filtering<T>
    implements InternalIterator<T> {
        private final Condition<? super T> myFilter;
        private final InternalIterator<T> myIterator;

        public Filtering(InternalIterator<T> iterator2, Condition<? super T> filter2) {
            this.myIterator = iterator2;
            this.myFilter = filter2;
        }

        @Override
        public boolean visit(T value) {
            return !this.myFilter.value(value) || this.myIterator.visit(value);
        }

        public static <T> InternalIterator<T> create(InternalIterator<T> iterator2, Condition<T> filter2) {
            return new Filtering<T>(iterator2, filter2);
        }

        public static <T, V extends T> InternalIterator<T> createInstanceOf(InternalIterator<V> iterator2, FilteringIterator.InstanceOf<V> filter2) {
            return new Filtering<Object>(iterator2, filter2);
        }

        public static <T> InternalIterator createInstanceOf(InternalIterator<T> iterator2, Class<T> aClass2) {
            return Filtering.createInstanceOf(iterator2, FilteringIterator.instanceOf(aClass2));
        }
    }

    public static class MapFromValues<K, Dom, V extends Dom>
    implements InternalIterator<V> {
        private final Map<K, V> myMap;
        private final Convertor<Dom, K> myToKeyConvertor;

        public MapFromValues(Map<K, V> map2, Convertor<Dom, K> toKeyConvertor) {
            this.myMap = map2;
            this.myToKeyConvertor = toKeyConvertor;
        }

        @Override
        public boolean visit(V value) {
            this.myMap.put(this.myToKeyConvertor.convert(value), value);
            return true;
        }

        public static <Dom, K, V extends Dom> InternalIterator<V> create(Convertor<Dom, K> toKey, Map<K, V> map2) {
            return new MapFromValues<K, Dom, V>(map2, toKey);
        }
    }

    public static class Collector<T>
    implements InternalIterator<T> {
        private final Collection<T> myCollection;

        public Collector(Collection<T> collection) {
            this.myCollection = collection;
        }

        @Override
        public boolean visit(T value) {
            return this.myCollection.add(value);
        }

        public static <T> InternalIterator<T> create(Collection<T> collection) {
            return new Collector<T>(collection);
        }
    }
}

