/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.diff;

import gnu.trove.TIntIntHashMap;

class UniqueLCS {
    private final int[] myFirst;
    private final int[] mySecond;
    private final int myStart1;
    private final int myStart2;
    private final int myCount1;
    private final int myCount2;

    public UniqueLCS(int[] first2, int[] second) {
        this(first2, second, 0, first2.length, 0, second.length);
    }

    public UniqueLCS(int[] first2, int[] second, int start1, int count1, int start2, int count2) {
        this.myFirst = first2;
        this.mySecond = second;
        this.myStart1 = start1;
        this.myStart2 = start2;
        this.myCount1 = count1;
        this.myCount2 = count2;
    }

    public int[][] execute() {
        TIntIntHashMap map2 = new TIntIntHashMap(this.myCount1 + this.myCount2);
        int[] match2 = new int[this.myCount1];
        for (int i2 = 0; i2 < this.myCount1; ++i2) {
            int index2 = this.myStart1 + i2;
            int val = map2.get(this.myFirst[index2]);
            if (val == -1) continue;
            if (val == 0) {
                map2.put(this.myFirst[index2], i2 + 1);
                continue;
            }
            map2.put(this.myFirst[index2], -1);
        }
        int count2 = 0;
        for (int i3 = 0; i3 < this.myCount2; ++i3) {
            int index3 = this.myStart2 + i3;
            int val = map2.get(this.mySecond[index3]);
            if (val == 0 || val == -1) continue;
            if (match2[val - 1] == 0) {
                match2[val - 1] = i3 + 1;
                ++count2;
                continue;
            }
            match2[val - 1] = 0;
            map2.put(this.mySecond[index3], -1);
            --count2;
        }
        if (count2 == 0) {
            return null;
        }
        int[] sequence2 = new int[count2];
        int[] lastElement = new int[count2];
        int[] predecessor = new int[this.myCount1];
        int length = 0;
        for (int i4 = 0; i4 < this.myCount1; ++i4) {
            int j;
            if (match2[i4] == 0 || (j = UniqueLCS.binarySearch(sequence2, match2[i4], length)) != length && match2[i4] >= sequence2[j]) continue;
            sequence2[j] = match2[i4];
            lastElement[j] = i4;
            int n = predecessor[i4] = j > 0 ? lastElement[j - 1] : -1;
            if (j != length) continue;
            ++length;
        }
        int[][] ret = new int[][]{new int[length], new int[length]};
        int i5 = length - 1;
        int curr = lastElement[length - 1];
        while (curr != -1) {
            ret[0][i5] = curr;
            ret[1][i5] = match2[curr] - 1;
            --i5;
            curr = predecessor[curr];
        }
        return ret;
    }

    private static int binarySearch(int[] sequence2, int val, int length) {
        int left = -1;
        int right = length;
        while (right - left > 1) {
            int middle = (left + right) / 2;
            if (sequence2[middle] > val) {
                right = middle;
                continue;
            }
            left = middle;
        }
        return left + 1;
    }
}

