/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.util.indexing.IndexableFileSet;
import com.intellij.util.indexing.IndexableSetContributor;
import gnu.trove.THashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class AdditionalIndexableFileSet
implements IndexableFileSet {
    private final Project myProject;
    private volatile Set<VirtualFile> cachedFiles;
    private volatile Set<VirtualFile> cachedDirectories;
    private volatile IndexableSetContributor[] myExtensions;

    public AdditionalIndexableFileSet(Project project, IndexableSetContributor ... extensions) {
        this.myProject = project;
        this.myExtensions = extensions;
    }

    public AdditionalIndexableFileSet(Project project) {
        this.myProject = project;
    }

    public AdditionalIndexableFileSet(IndexableSetContributor ... extensions) {
        this.myProject = null;
        this.myExtensions = extensions;
    }

    public AdditionalIndexableFileSet() {
        this.myProject = null;
    }

    private Set<VirtualFile> getDirectories() {
        Set<VirtualFile> directories = this.cachedDirectories;
        if (directories == null || VfsUtilCore.hasInvalidFiles(directories) || VfsUtilCore.hasInvalidFiles(this.cachedFiles)) {
            directories = this.collectFilesAndDirectories();
        }
        return directories;
    }

    private THashSet<VirtualFile> collectFilesAndDirectories() {
        THashSet<VirtualFile> files2 = new THashSet<VirtualFile>();
        THashSet<VirtualFile> directories = new THashSet<VirtualFile>();
        if (this.myExtensions == null) {
            this.myExtensions = Extensions.getExtensions(IndexableSetContributor.EP_NAME);
        }
        for (IndexableSetContributor contributor : this.myExtensions) {
            for (VirtualFile root2 : IndexableSetContributor.getRootsToIndex(contributor)) {
                (root2.isDirectory() ? directories : files2).add(root2);
            }
            if (this.myProject == null) continue;
            Set<VirtualFile> projectRoots = IndexableSetContributor.getProjectRootsToIndex(contributor, this.myProject);
            for (VirtualFile root3 : projectRoots) {
                (root3.isDirectory() ? directories : files2).add(root3);
            }
        }
        this.cachedFiles = files2;
        this.cachedDirectories = directories;
        return directories;
    }

    @Override
    public boolean isInSet(@NotNull VirtualFile file2) {
        if (file2 == null) {
            AdditionalIndexableFileSet.$$$reportNull$$$0(0);
        }
        return VfsUtilCore.isUnder(file2, this.getDirectories()) || this.cachedFiles.contains(file2);
    }

    @Override
    public void iterateIndexableFilesIn(@NotNull VirtualFile file2, final @NotNull ContentIterator iterator2) {
        if (file2 == null) {
            AdditionalIndexableFileSet.$$$reportNull$$$0(1);
        }
        if (iterator2 == null) {
            AdditionalIndexableFileSet.$$$reportNull$$$0(2);
        }
        VfsUtilCore.visitChildrenRecursively(file2, new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

            @Override
            public boolean visitFile(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!AdditionalIndexableFileSet.this.isInSet(file2)) {
                    return false;
                }
                if (!file2.isDirectory()) {
                    iterator2.processFile(file2);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/indexing/AdditionalIndexableFileSet$1", "visitFile"));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterator";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/indexing/AdditionalIndexableFileSet";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isInSet";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "iterateIndexableFilesIn";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

