/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.containers.SLRUMap;
import com.intellij.util.io.DataEnumerator;
import com.intellij.util.io.KeyDescriptor;
import java.io.IOException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.Nullable;

public class CachingEnumerator<Data>
implements DataEnumerator<Data> {
    private static final int STRIPE_POWER = 4;
    private static final int STRIPE_COUNT = 16;
    private static final int STRIPE_MASK = 15;
    private final SLRUMap<Integer, Integer>[] myHashcodeToIdCache = new SLRUMap[16];
    private final SLRUMap<Integer, Data>[] myIdToStringCache = new SLRUMap[16];
    private final Lock[] myStripeLocks = new Lock[16];
    private final DataEnumerator<Data> myBase;
    private final KeyDescriptor<Data> myDataDescriptor;

    public CachingEnumerator(DataEnumerator<Data> base2, KeyDescriptor<Data> dataDescriptor) {
        this.myBase = base2;
        this.myDataDescriptor = dataDescriptor;
        int protectedSize = 8192;
        int probationalSize = 8192;
        for (int i2 = 0; i2 < 16; ++i2) {
            this.myHashcodeToIdCache[i2] = new SLRUMap(protectedSize / 16, probationalSize / 16);
            this.myIdToStringCache[i2] = new SLRUMap(protectedSize / 16, probationalSize / 16);
            this.myStripeLocks[i2] = new ReentrantLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int enumerate(@Nullable Data value) throws IOException {
        int valueHashCode = -1;
        int stripe = -1;
        if (value != null) {
            Integer cachedId;
            valueHashCode = this.myDataDescriptor.getHashCode(value);
            stripe = Math.abs(valueHashCode) & 0xF;
            this.myStripeLocks[stripe].lock();
            try {
                cachedId = this.myHashcodeToIdCache[stripe].get(valueHashCode);
            }
            finally {
                this.myStripeLocks[stripe].unlock();
            }
            if (cachedId != null) {
                int stripe2 = CachingEnumerator.idStripe(cachedId);
                this.myStripeLocks[stripe2].lock();
                try {
                    Data s = this.myIdToStringCache[stripe2].get(cachedId);
                    if (s != null && this.myDataDescriptor.isEqual(value, s)) {
                        int n = cachedId;
                        return n;
                    }
                }
                finally {
                    this.myStripeLocks[stripe2].unlock();
                }
            }
        }
        int enumerate = this.myBase.enumerate(value);
        if (stripe != -1) {
            Integer enumeratedInteger;
            this.myStripeLocks[stripe].lock();
            try {
                enumeratedInteger = enumerate;
                this.myHashcodeToIdCache[stripe].put(valueHashCode, enumeratedInteger);
            }
            finally {
                this.myStripeLocks[stripe].unlock();
            }
            int stripe2 = CachingEnumerator.idStripe(enumerate);
            this.myStripeLocks[stripe2].lock();
            try {
                this.myIdToStringCache[stripe2].put(enumeratedInteger, value);
            }
            finally {
                this.myStripeLocks[stripe2].unlock();
            }
        }
        return enumerate;
    }

    private static int idStripe(int h) {
        h ^= h >>> 20 ^ h >>> 12;
        return Math.abs(h ^ h >>> 7 ^ h >>> 4) & 0xF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Data valueOf(int idx) throws IOException {
        Data s;
        int stripe = CachingEnumerator.idStripe(idx);
        this.myStripeLocks[stripe].lock();
        try {
            s = this.myIdToStringCache[stripe].get(idx);
            if (s != null) {
                Data Data2 = s;
                return Data2;
            }
        }
        finally {
            this.myStripeLocks[stripe].unlock();
        }
        s = this.myBase.valueOf(idx);
        if (s != null) {
            this.myStripeLocks[stripe].lock();
            try {
                this.myIdToStringCache[stripe].put(idx, s);
            }
            finally {
                this.myStripeLocks[stripe].unlock();
            }
        }
        return s;
    }

    public void close() {
        this.clear();
    }

    public void clear() {
        for (int i2 = 0; i2 < this.myIdToStringCache.length; ++i2) {
            this.myStripeLocks[i2].lock();
            this.myIdToStringCache[i2].clear();
            this.myHashcodeToIdCache[i2].clear();
            this.myStripeLocks[i2].unlock();
        }
    }
}

