/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class LimitedInputStream
extends FilterInputStream {
    private final int myReadLimit;
    private int myBytesRead;

    public LimitedInputStream(InputStream in, int readLimit) {
        super(in);
        this.myReadLimit = readLimit;
        this.myBytesRead = 0;
    }

    public boolean markSupported() {
        return false;
    }

    public int read() throws IOException {
        if (this.myBytesRead == this.myReadLimit) {
            return -1;
        }
        int r = super.read();
        if (r >= 0) {
            ++this.myBytesRead;
        }
        return r;
    }

    public int read(byte[] b2) throws IOException {
        return this.read(b2, 0, b2.length);
    }

    public int read(byte[] b2, int off, int len) throws IOException {
        if (this.myBytesRead >= this.myReadLimit) {
            return -1;
        }
        if ((len = Math.min(len, this.myReadLimit - this.myBytesRead)) <= 0) {
            return -1;
        }
        int actuallyRead = super.read(b2, off, len);
        if (actuallyRead >= 0) {
            this.myBytesRead += actuallyRead;
        }
        return actuallyRead;
    }

    public long skip(long n) throws IOException {
        if ((n = Math.min(n, (long)(this.myReadLimit - this.myBytesRead))) <= 0L) {
            return 0L;
        }
        long skipped = super.skip(n);
        this.myBytesRead = (int)((long)this.myBytesRead + skipped);
        return skipped;
    }

    public int available() throws IOException {
        return Math.min(super.available(), this.myReadLimit - this.myBytesRead);
    }

    protected int remainingLimit() {
        return this.myReadLimit - this.myBytesRead;
    }

    public synchronized void mark(int readLimit) {
        throw new UnsupportedOperationException();
    }

    public synchronized void reset() throws IOException {
        throw new UnsupportedOperationException();
    }
}

