/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.storage;

import com.intellij.util.io.PagePool;
import com.intellij.util.io.storage.AbstractRecordsTable;
import java.io.File;
import java.io.IOException;

class RefCountingRecordsTable
extends AbstractRecordsTable {
    private static final int VERSION = 1;
    private static final int REF_COUNT_OFFSET = 16;
    private static final int RECORD_SIZE = 20;
    private static final byte[] ZEROES = new byte[20];

    public RefCountingRecordsTable(File recordsFile, PagePool pool) throws IOException {
        super(recordsFile, pool);
    }

    @Override
    protected int getImplVersion() {
        return 1;
    }

    @Override
    protected int getRecordSize() {
        return 20;
    }

    @Override
    protected byte[] getZeros() {
        return ZEROES;
    }

    public void incRefCount(int record2) {
        this.markDirty();
        int offset2 = this.getOffset(record2, 16);
        this.myStorage.putInt(offset2, this.myStorage.getInt(offset2) + 1);
    }

    public boolean decRefCount(int record2) {
        this.markDirty();
        int offset2 = this.getOffset(record2, 16);
        int count2 = this.myStorage.getInt(offset2);
        assert (count2 > 0);
        this.myStorage.putInt(offset2, --count2);
        return count2 == 0;
    }

    public int getRefCount(int record2) {
        return this.myStorage.getInt(this.getOffset(record2, 16));
    }
}

